// third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data* object = static_cast<const RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream_provider_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream_provider_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->session_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams device_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  return true;
}

RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data* object = static_cast<const RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::OutputDeviceStatus_Data
        ::Validate(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->matched_device_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams matched_device_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->matched_device_id, validation_context,
                                         &matched_device_id_validate_params)) {
    return false;
  }

  return true;
}

RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
