// third_party/blink/public/mojom/memory_usage_monitor_linux.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/memory_usage_monitor_linux.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/memory_usage_monitor_linux.mojom-params-data.h"
#include "third_party/blink/public/mojom/memory_usage_monitor_linux.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/memory_usage_monitor_linux.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEMORY_USAGE_MONITOR_LINUX_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEMORY_USAGE_MONITOR_LINUX_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char MemoryUsageMonitorLinux::Name_[] = "blink.mojom.MemoryUsageMonitorLinux";

MemoryUsageMonitorLinuxProxy::MemoryUsageMonitorLinuxProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MemoryUsageMonitorLinuxProxy::SetProcFiles(
    ::base::File in_statm_file, ::base::File in_status_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MemoryUsageMonitorLinux::SetProcFiles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("statm_file"), in_statm_file, 
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status_file"), in_status_file, 
                        "<value of type ::base::File>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMemoryUsageMonitorLinux_SetProcFiles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MemoryUsageMonitorLinux_SetProcFiles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->statm_file)::BaseType> statm_file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_statm_file, statm_file_fragment);
  params->statm_file.Set(
      statm_file_fragment.is_null() ? nullptr : statm_file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->statm_file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null statm_file in MemoryUsageMonitorLinux.SetProcFiles request");
  mojo::internal::MessageFragment<
      typename decltype(params->status_file)::BaseType> status_file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_status_file, status_file_fragment);
  params->status_file.Set(
      status_file_fragment.is_null() ? nullptr : status_file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status_file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status_file in MemoryUsageMonitorLinux.SetProcFiles request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MemoryUsageMonitorLinux::Name_);
  message.set_method_name("SetProcFiles");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MemoryUsageMonitorLinuxStubDispatch::Accept(
    MemoryUsageMonitorLinux* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMemoryUsageMonitorLinux_SetProcFiles_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MemoryUsageMonitorLinux::SetProcFiles",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MemoryUsageMonitorLinux::SetProcFiles");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MemoryUsageMonitorLinux_SetProcFiles_Params_Data* params =
          reinterpret_cast<internal::MemoryUsageMonitorLinux_SetProcFiles_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::File p_statm_file{};
      ::base::File p_status_file{};
      MemoryUsageMonitorLinux_SetProcFiles_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatmFile(&p_statm_file))
        success = false;
      if (success && !input_data_view.ReadStatusFile(&p_status_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MemoryUsageMonitorLinux::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetProcFiles(
std::move(p_statm_file), 
std::move(p_status_file));
      return true;
    }
  }
  return false;
}

// static
bool MemoryUsageMonitorLinuxStubDispatch::AcceptWithResponder(
    MemoryUsageMonitorLinux* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMemoryUsageMonitorLinux_SetProcFiles_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMemoryUsageMonitorLinuxValidationInfo[] = {
    {internal::kMemoryUsageMonitorLinux_SetProcFiles_Name,
     {&internal::MemoryUsageMonitorLinux_SetProcFiles_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MemoryUsageMonitorLinuxRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::MemoryUsageMonitorLinux::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMemoryUsageMonitorLinuxValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif