// third_party/blink/public/mojom/native_io/native_io.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/native_io/native_io.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/native_io/native_io.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string NativeIOErrorTypeToString(NativeIOErrorType value) {
  switch(value) {
    case NativeIOErrorType::kSuccess:
      return "NativeIOErrorType::kSuccess";
    case NativeIOErrorType::kUnknown:
      return "NativeIOErrorType::kUnknown";
    case NativeIOErrorType::kInvalidState:
      return "NativeIOErrorType::kInvalidState";
    case NativeIOErrorType::kNotFound:
      return "NativeIOErrorType::kNotFound";
    case NativeIOErrorType::kNoModificationAllowed:
      return "NativeIOErrorType::kNoModificationAllowed";
    case NativeIOErrorType::kNoSpace:
      return "NativeIOErrorType::kNoSpace";
    default:
      return base::StringPrintf("Unknown NativeIOErrorType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, NativeIOErrorType value) {
  return os << NativeIOErrorTypeToString(value);
}

namespace internal {


// static
bool NativeIOError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOError_Data* object = static_cast<const NativeIOError_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::NativeIOErrorType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

NativeIOError_Data::NativeIOError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOFileHost_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOFileHost_Close_Params_Data* object = static_cast<const NativeIOFileHost_Close_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NativeIOFileHost_Close_Params_Data::NativeIOFileHost_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOFileHost_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOFileHost_Close_ResponseParams_Data* object = static_cast<const NativeIOFileHost_Close_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NativeIOFileHost_Close_ResponseParams_Data::NativeIOFileHost_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOHost_RequestCapacityChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOHost_RequestCapacityChange_Params_Data* object = static_cast<const NativeIOHost_RequestCapacityChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NativeIOHost_RequestCapacityChange_Params_Data::NativeIOHost_RequestCapacityChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOHost_RequestCapacityChange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOHost_RequestCapacityChange_ResponseParams_Data* object = static_cast<const NativeIOHost_RequestCapacityChange_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NativeIOHost_RequestCapacityChange_ResponseParams_Data::NativeIOHost_RequestCapacityChange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOHost_OpenFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOHost_OpenFile_Params_Data* object = static_cast<const NativeIOHost_OpenFile_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->file_host_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->file_host_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NativeIOHost_OpenFile_Params_Data::NativeIOHost_OpenFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOHost_OpenFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOHost_OpenFile_ResponseParams_Data* object = static_cast<const NativeIOHost_OpenFile_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->backing_file, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->open_error, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->open_error, validation_context))
    return false;

  return true;
}

NativeIOHost_OpenFile_ResponseParams_Data::NativeIOHost_OpenFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOHost_DeleteFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOHost_DeleteFile_Params_Data* object = static_cast<const NativeIOHost_DeleteFile_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

NativeIOHost_DeleteFile_Params_Data::NativeIOHost_DeleteFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOHost_DeleteFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOHost_DeleteFile_ResponseParams_Data* object = static_cast<const NativeIOHost_DeleteFile_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->delete_error, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->delete_error, validation_context))
    return false;

  return true;
}

NativeIOHost_DeleteFile_ResponseParams_Data::NativeIOHost_DeleteFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOHost_GetAllFileNames_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOHost_GetAllFileNames_Params_Data* object = static_cast<const NativeIOHost_GetAllFileNames_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NativeIOHost_GetAllFileNames_Params_Data::NativeIOHost_GetAllFileNames_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOHost_GetAllFileNames_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOHost_GetAllFileNames_ResponseParams_Data* object = static_cast<const NativeIOHost_GetAllFileNames_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->names, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams names_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->names, validation_context,
                                         &names_validate_params)) {
    return false;
  }

  return true;
}

NativeIOHost_GetAllFileNames_ResponseParams_Data::NativeIOHost_GetAllFileNames_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOHost_RenameFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOHost_RenameFile_Params_Data* object = static_cast<const NativeIOHost_RenameFile_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->old_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams old_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->old_name, validation_context,
                                         &old_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams new_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->new_name, validation_context,
                                         &new_name_validate_params)) {
    return false;
  }

  return true;
}

NativeIOHost_RenameFile_Params_Data::NativeIOHost_RenameFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeIOHost_RenameFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeIOHost_RenameFile_ResponseParams_Data* object = static_cast<const NativeIOHost_RenameFile_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rename_error, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rename_error, validation_context))
    return false;

  return true;
}

NativeIOHost_RenameFile_ResponseParams_Data::NativeIOHost_RenameFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::NativeIOErrorType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::NativeIOErrorType value) {
  return std::move(context).WriteString(::blink::mojom::NativeIOErrorTypeToString(value));
}

} // namespace perfetto
