// third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom-params-data.h"
#include "third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_OOM_INTERVENTION_OOM_INTERVENTION_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_OOM_INTERVENTION_OOM_INTERVENTION_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
DetectionArgs::DetectionArgs()
    : blink_workload_threshold(),
      private_footprint_threshold(),
      swap_threshold(),
      virtual_memory_thresold() {}

DetectionArgs::DetectionArgs(
    uint64_t blink_workload_threshold_in,
    uint64_t private_footprint_threshold_in,
    uint64_t swap_threshold_in,
    uint64_t virtual_memory_thresold_in)
    : blink_workload_threshold(std::move(blink_workload_threshold_in)),
      private_footprint_threshold(std::move(private_footprint_threshold_in)),
      swap_threshold(std::move(swap_threshold_in)),
      virtual_memory_thresold(std::move(virtual_memory_thresold_in)) {}

DetectionArgs::~DetectionArgs() = default;
size_t DetectionArgs::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->blink_workload_threshold);
  seed = mojo::internal::Hash(seed, this->private_footprint_threshold);
  seed = mojo::internal::Hash(seed, this->swap_threshold);
  seed = mojo::internal::Hash(seed, this->virtual_memory_thresold);
  return seed;
}

void DetectionArgs::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blink_workload_threshold"), this->blink_workload_threshold, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_footprint_threshold"), this->private_footprint_threshold, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_threshold"), this->swap_threshold, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "virtual_memory_thresold"), this->virtual_memory_thresold, 
      "<value of type uint64_t>");
}

bool DetectionArgs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char OomInterventionHost::Name_[] = "blink.mojom.OomInterventionHost";

OomInterventionHostProxy::OomInterventionHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OomInterventionHostProxy::OnHighMemoryUsage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::OomInterventionHost::OnHighMemoryUsage");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOomInterventionHost_OnHighMemoryUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OomInterventionHost_OnHighMemoryUsage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OomInterventionHost::Name_);
  message.set_method_name("OnHighMemoryUsage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool OomInterventionHostStubDispatch::Accept(
    OomInterventionHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kOomInterventionHost_OnHighMemoryUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::OomInterventionHost::OnHighMemoryUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::OomInterventionHost::OnHighMemoryUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::OomInterventionHost_OnHighMemoryUsage_Params_Data* params =
          reinterpret_cast<internal::OomInterventionHost_OnHighMemoryUsage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      OomInterventionHost_OnHighMemoryUsage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OomInterventionHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHighMemoryUsage();
      return true;
    }
  }
  return false;
}

// static
bool OomInterventionHostStubDispatch::AcceptWithResponder(
    OomInterventionHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kOomInterventionHost_OnHighMemoryUsage_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kOomInterventionHostValidationInfo[] = {
    {&internal::OomInterventionHost_OnHighMemoryUsage_Params_Data::Validate,
     nullptr /* no response */},
};

bool OomInterventionHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::OomInterventionHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kOomInterventionHostValidationInfo);
}

const char OomIntervention::Name_[] = "blink.mojom.OomIntervention";

OomInterventionProxy::OomInterventionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OomInterventionProxy::StartDetection(
    ::mojo::PendingRemote<OomInterventionHost> in_host, DetectionArgsPtr in_detection_args, bool in_renderer_pause_enabled, bool in_navigate_ads_enabled, bool in_purge_v8_memory_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::OomIntervention::StartDetection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host, 
                        "<value of type ::mojo::PendingRemote<OomInterventionHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("detection_args"), in_detection_args, 
                        "<value of type DetectionArgsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("renderer_pause_enabled"), in_renderer_pause_enabled, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigate_ads_enabled"), in_navigate_ads_enabled, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("purge_v8_memory_enabled"), in_purge_v8_memory_enabled, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOomIntervention_StartDetection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OomIntervention_StartDetection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::OomInterventionHostInterfaceBase>>(
      in_host, &params->host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host in OomIntervention.StartDetection request");
  mojo::internal::MessageFragment<
      typename decltype(params->detection_args)::BaseType> detection_args_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DetectionArgsDataView>(
      in_detection_args, detection_args_fragment);
  params->detection_args.Set(
      detection_args_fragment.is_null() ? nullptr : detection_args_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->detection_args.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null detection_args in OomIntervention.StartDetection request");
  params->renderer_pause_enabled = in_renderer_pause_enabled;
  params->navigate_ads_enabled = in_navigate_ads_enabled;
  params->purge_v8_memory_enabled = in_purge_v8_memory_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OomIntervention::Name_);
  message.set_method_name("StartDetection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool OomInterventionStubDispatch::Accept(
    OomIntervention* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kOomIntervention_StartDetection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::OomIntervention::StartDetection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::OomIntervention::StartDetection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::OomIntervention_StartDetection_Params_Data* params =
          reinterpret_cast<internal::OomIntervention_StartDetection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<OomInterventionHost> p_host{};
      DetectionArgsPtr p_detection_args{};
      bool p_renderer_pause_enabled{};
      bool p_navigate_ads_enabled{};
      bool p_purge_v8_memory_enabled{};
      OomIntervention_StartDetection_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success && !input_data_view.ReadDetectionArgs(&p_detection_args))
        success = false;
      if (success)
        p_renderer_pause_enabled = input_data_view.renderer_pause_enabled();
      if (success)
        p_navigate_ads_enabled = input_data_view.navigate_ads_enabled();
      if (success)
        p_purge_v8_memory_enabled = input_data_view.purge_v8_memory_enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OomIntervention::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDetection(
std::move(p_host), 
std::move(p_detection_args), 
std::move(p_renderer_pause_enabled), 
std::move(p_navigate_ads_enabled), 
std::move(p_purge_v8_memory_enabled));
      return true;
    }
  }
  return false;
}

// static
bool OomInterventionStubDispatch::AcceptWithResponder(
    OomIntervention* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kOomIntervention_StartDetection_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kOomInterventionValidationInfo[] = {
    {&internal::OomIntervention_StartDetection_Params_Data::Validate,
     nullptr /* no response */},
};

bool OomInterventionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::OomIntervention::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kOomInterventionValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::DetectionArgs::DataView, ::blink::mojom::DetectionArgsPtr>::Read(
    ::blink::mojom::DetectionArgs::DataView input,
    ::blink::mojom::DetectionArgsPtr* output) {
  bool success = true;
  ::blink::mojom::DetectionArgsPtr result(::blink::mojom::DetectionArgs::New());
  
      if (success)
        result->blink_workload_threshold = input.blink_workload_threshold();
      if (success)
        result->private_footprint_threshold = input.private_footprint_threshold();
      if (success)
        result->swap_threshold = input.swap_threshold();
      if (success)
        result->virtual_memory_thresold = input.virtual_memory_thresold();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif