// third_party/blink/public/mojom/optimization_guide/optimization_guide.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/optimization_guide/optimization_guide.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/optimization_guide/optimization_guide.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string DelayAsyncScriptExecutionDelayTypeToString(DelayAsyncScriptExecutionDelayType value) {
  switch(value) {
    case DelayAsyncScriptExecutionDelayType::kUnknown:
      return "DelayAsyncScriptExecutionDelayType::kUnknown";
    case DelayAsyncScriptExecutionDelayType::kFinishedParsing:
      return "DelayAsyncScriptExecutionDelayType::kFinishedParsing";
    case DelayAsyncScriptExecutionDelayType::kFirstPaintOrFinishedParsing:
      return "DelayAsyncScriptExecutionDelayType::kFirstPaintOrFinishedParsing";
    default:
      return base::StringPrintf("Unknown DelayAsyncScriptExecutionDelayType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DelayAsyncScriptExecutionDelayType value) {
  return os << DelayAsyncScriptExecutionDelayTypeToString(value);
}

std::string DelayCompetingLowPriorityRequestsDelayTypeToString(DelayCompetingLowPriorityRequestsDelayType value) {
  switch(value) {
    case DelayCompetingLowPriorityRequestsDelayType::kUnknown:
      return "DelayCompetingLowPriorityRequestsDelayType::kUnknown";
    case DelayCompetingLowPriorityRequestsDelayType::kFirstPaint:
      return "DelayCompetingLowPriorityRequestsDelayType::kFirstPaint";
    case DelayCompetingLowPriorityRequestsDelayType::kFirstContentfulPaint:
      return "DelayCompetingLowPriorityRequestsDelayType::kFirstContentfulPaint";
    default:
      return base::StringPrintf("Unknown DelayCompetingLowPriorityRequestsDelayType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DelayCompetingLowPriorityRequestsDelayType value) {
  return os << DelayCompetingLowPriorityRequestsDelayTypeToString(value);
}

std::string DelayCompetingLowPriorityRequestsPriorityThresholdToString(DelayCompetingLowPriorityRequestsPriorityThreshold value) {
  switch(value) {
    case DelayCompetingLowPriorityRequestsPriorityThreshold::kUnknown:
      return "DelayCompetingLowPriorityRequestsPriorityThreshold::kUnknown";
    case DelayCompetingLowPriorityRequestsPriorityThreshold::kMedium:
      return "DelayCompetingLowPriorityRequestsPriorityThreshold::kMedium";
    case DelayCompetingLowPriorityRequestsPriorityThreshold::kHigh:
      return "DelayCompetingLowPriorityRequestsPriorityThreshold::kHigh";
    default:
      return base::StringPrintf("Unknown DelayCompetingLowPriorityRequestsPriorityThreshold value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DelayCompetingLowPriorityRequestsPriorityThreshold value) {
  return os << DelayCompetingLowPriorityRequestsPriorityThresholdToString(value);
}

namespace internal {


// static
bool DelayAsyncScriptExecutionHints_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DelayAsyncScriptExecutionHints_Data* object = static_cast<const DelayAsyncScriptExecutionHints_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::DelayAsyncScriptExecutionDelayType_Data
        ::Validate(object->delay_type, validation_context))
    return false;

  return true;
}

DelayAsyncScriptExecutionHints_Data::DelayAsyncScriptExecutionHints_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DelayCompetingLowPriorityRequestsHints_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DelayCompetingLowPriorityRequestsHints_Data* object = static_cast<const DelayCompetingLowPriorityRequestsHints_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::DelayCompetingLowPriorityRequestsDelayType_Data
        ::Validate(object->delay_type, validation_context))
    return false;


  if (!::blink::mojom::internal::DelayCompetingLowPriorityRequestsPriorityThreshold_Data
        ::Validate(object->priority_threshold, validation_context))
    return false;

  return true;
}

DelayCompetingLowPriorityRequestsHints_Data::DelayCompetingLowPriorityRequestsHints_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlinkOptimizationGuideHints_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BlinkOptimizationGuideHints_Data* object = static_cast<const BlinkOptimizationGuideHints_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->delay_async_script_execution_hints, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->delay_competing_low_priority_requests_hints, validation_context))
    return false;

  return true;
}

BlinkOptimizationGuideHints_Data::BlinkOptimizationGuideHints_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DelayAsyncScriptExecutionDelayType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::DelayAsyncScriptExecutionDelayType value) {
  return std::move(context).WriteString(::blink::mojom::DelayAsyncScriptExecutionDelayTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DelayCompetingLowPriorityRequestsDelayType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::DelayCompetingLowPriorityRequestsDelayType value) {
  return std::move(context).WriteString(::blink::mojom::DelayCompetingLowPriorityRequestsDelayTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold value) {
  return std::move(context).WriteString(::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThresholdToString(value));
}

} // namespace perfetto
