// third_party/blink/public/mojom/page/drag.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/page/drag.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/page/drag.mojom-params-data.h"
#include "third_party/blink/public/mojom/page/drag.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/page/drag.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
AllowedDragOperations::AllowedDragOperations()
    : allow_copy(),
      allow_link(),
      allow_move() {}

AllowedDragOperations::AllowedDragOperations(
    bool allow_copy_in,
    bool allow_link_in,
    bool allow_move_in)
    : allow_copy(std::move(allow_copy_in)),
      allow_link(std::move(allow_link_in)),
      allow_move(std::move(allow_move_in)) {}

AllowedDragOperations::~AllowedDragOperations() = default;

void AllowedDragOperations::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_copy"), this->allow_copy, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_link"), this->allow_link, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_move"), this->allow_move, 
      "<value of type bool>");
}

bool AllowedDragOperations::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemString::DragItemString()
    : string_type(),
      string_data(),
      title(),
      base_url() {}

DragItemString::DragItemString(
    const std::string& string_type_in,
    const ::base::string16& string_data_in,
    const base::Optional<::base::string16>& title_in,
    const base::Optional<::GURL>& base_url_in)
    : string_type(std::move(string_type_in)),
      string_data(std::move(string_data_in)),
      title(std::move(title_in)),
      base_url(std::move(base_url_in)) {}

DragItemString::~DragItemString() = default;

void DragItemString::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "string_type"), this->string_type, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "string_data"), this->string_data, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title, 
      "<value of type const base::Optional<::base::string16>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_url"), this->base_url, 
      "<value of type const base::Optional<::GURL>&>");
}

bool DragItemString::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemBinary::DragItemBinary()
    : data(),
      source_url(),
      filename_extension(),
      content_disposition() {}

DragItemBinary::DragItemBinary(
    ::mojo_base::BigBuffer data_in,
    const ::GURL& source_url_in,
    const ::base::FilePath& filename_extension_in,
    const base::Optional<std::string>& content_disposition_in)
    : data(std::move(data_in)),
      source_url(std::move(source_url_in)),
      filename_extension(std::move(filename_extension_in)),
      content_disposition(std::move(content_disposition_in)) {}

DragItemBinary::~DragItemBinary() = default;

void DragItemBinary::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data, 
      "<value of type ::mojo_base::BigBuffer>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_url"), this->source_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filename_extension"), this->filename_extension, 
      "<value of type const ::base::FilePath&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_disposition"), this->content_disposition, 
      "<value of type const base::Optional<std::string>&>");
}

bool DragItemBinary::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemFileSystemFile::DragItemFileSystemFile()
    : url(),
      size(),
      file_system_id() {}

DragItemFileSystemFile::DragItemFileSystemFile(
    const ::GURL& url_in,
    int64_t size_in,
    const base::Optional<std::string>& file_system_id_in)
    : url(std::move(url_in)),
      size(std::move(size_in)),
      file_system_id(std::move(file_system_id_in)) {}

DragItemFileSystemFile::~DragItemFileSystemFile() = default;

void DragItemFileSystemFile::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_system_id"), this->file_system_id, 
      "<value of type const base::Optional<std::string>&>");
}

bool DragItemFileSystemFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragData::DragData()
    : items(),
      file_system_id(),
      referrer_policy(::network::mojom::ReferrerPolicy::kDefault) {}

DragData::DragData(
    std::vector<DragItemPtr> items_in,
    const base::Optional<std::string>& file_system_id_in,
    ::network::mojom::ReferrerPolicy referrer_policy_in)
    : items(std::move(items_in)),
      file_system_id(std::move(file_system_id_in)),
      referrer_policy(std::move(referrer_policy_in)) {}

DragData::~DragData() = default;

void DragData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "items"), this->items, 
      "<value of type std::vector<DragItemPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_system_id"), this->file_system_id, 
      "<value of type const base::Optional<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy, 
      "<value of type ::network::mojom::ReferrerPolicy>");
}

bool DragData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragEventSourceInfo::DragEventSourceInfo()
    : location(),
      source() {}

DragEventSourceInfo::DragEventSourceInfo(
    const ::gfx::Point& location_in,
    ::ui::mojom::DragEventSource source_in)
    : location(std::move(location_in)),
      source(std::move(source_in)) {}

DragEventSourceInfo::~DragEventSourceInfo() = default;

void DragEventSourceInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location, 
      "<value of type const ::gfx::Point&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source, 
      "<value of type ::ui::mojom::DragEventSource>");
}

bool DragEventSourceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItem::DragItem() : tag_(Tag::STRING) {
  data_.string = new DragItemStringPtr;
}

DragItem::~DragItem() {
  DestroyActive();
}


void DragItem::set_string(
    DragItemStringPtr string) {
  if (tag_ == Tag::STRING) {
    *(data_.string) = std::move(string);
  } else {
    DestroyActive();
    tag_ = Tag::STRING;
    data_.string = new DragItemStringPtr(
        std::move(string));
  }
}
void DragItem::set_file(
    ::blink::mojom::DataTransferFilePtr file) {
  if (tag_ == Tag::FILE) {
    *(data_.file) = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::FILE;
    data_.file = new ::blink::mojom::DataTransferFilePtr(
        std::move(file));
  }
}
void DragItem::set_binary(
    DragItemBinaryPtr binary) {
  if (tag_ == Tag::BINARY) {
    *(data_.binary) = std::move(binary);
  } else {
    DestroyActive();
    tag_ = Tag::BINARY;
    data_.binary = new DragItemBinaryPtr(
        std::move(binary));
  }
}
void DragItem::set_file_system_file(
    DragItemFileSystemFilePtr file_system_file) {
  if (tag_ == Tag::FILE_SYSTEM_FILE) {
    *(data_.file_system_file) = std::move(file_system_file);
  } else {
    DestroyActive();
    tag_ = Tag::FILE_SYSTEM_FILE;
    data_.file_system_file = new DragItemFileSystemFilePtr(
        std::move(file_system_file));
  }
}

void DragItem::DestroyActive() {
  switch (tag_) {

    case Tag::STRING:

      delete data_.string;
      break;
    case Tag::FILE:

      delete data_.file;
      break;
    case Tag::BINARY:

      delete data_.binary;
      break;
    case Tag::FILE_SYSTEM_FILE:

      delete data_.file_system_file;
      break;
  }
}

bool DragItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::AllowedDragOperations::DataView, ::blink::mojom::AllowedDragOperationsPtr>::Read(
    ::blink::mojom::AllowedDragOperations::DataView input,
    ::blink::mojom::AllowedDragOperationsPtr* output) {
  bool success = true;
  ::blink::mojom::AllowedDragOperationsPtr result(::blink::mojom::AllowedDragOperations::New());
  
      if (success)
        result->allow_copy = input.allow_copy();
      if (success)
        result->allow_link = input.allow_link();
      if (success)
        result->allow_move = input.allow_move();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DragItemString::DataView, ::blink::mojom::DragItemStringPtr>::Read(
    ::blink::mojom::DragItemString::DataView input,
    ::blink::mojom::DragItemStringPtr* output) {
  bool success = true;
  ::blink::mojom::DragItemStringPtr result(::blink::mojom::DragItemString::New());
  
      if (success && !input.ReadStringType(&result->string_type))
        success = false;
      if (success && !input.ReadStringData(&result->string_data))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadBaseUrl(&result->base_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DragItemBinary::DataView, ::blink::mojom::DragItemBinaryPtr>::Read(
    ::blink::mojom::DragItemBinary::DataView input,
    ::blink::mojom::DragItemBinaryPtr* output) {
  bool success = true;
  ::blink::mojom::DragItemBinaryPtr result(::blink::mojom::DragItemBinary::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadSourceUrl(&result->source_url))
        success = false;
      if (success && !input.ReadFilenameExtension(&result->filename_extension))
        success = false;
      if (success && !input.ReadContentDisposition(&result->content_disposition))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DragItemFileSystemFile::DataView, ::blink::mojom::DragItemFileSystemFilePtr>::Read(
    ::blink::mojom::DragItemFileSystemFile::DataView input,
    ::blink::mojom::DragItemFileSystemFilePtr* output) {
  bool success = true;
  ::blink::mojom::DragItemFileSystemFilePtr result(::blink::mojom::DragItemFileSystemFile::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->size = input.size();
      if (success && !input.ReadFileSystemId(&result->file_system_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DragData::DataView, ::blink::mojom::DragDataPtr>::Read(
    ::blink::mojom::DragData::DataView input,
    ::blink::mojom::DragDataPtr* output) {
  bool success = true;
  ::blink::mojom::DragDataPtr result(::blink::mojom::DragData::New());
  
      if (success && !input.ReadItems(&result->items))
        success = false;
      if (success && !input.ReadFileSystemId(&result->file_system_id))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DragEventSourceInfo::DataView, ::blink::mojom::DragEventSourceInfoPtr>::Read(
    ::blink::mojom::DragEventSourceInfo::DataView input,
    ::blink::mojom::DragEventSourceInfoPtr* output) {
  bool success = true;
  ::blink::mojom::DragEventSourceInfoPtr result(::blink::mojom::DragEventSourceInfo::New());
  
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::DragItem::DataView, ::blink::mojom::DragItemPtr>::Read(
    ::blink::mojom::DragItem::DataView input,
    ::blink::mojom::DragItemPtr* output) {
  using UnionType = ::blink::mojom::DragItem;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::STRING: {
      ::blink::mojom::DragItemStringPtr result_string;
      if (!input.ReadString(&result_string))
        return false;

      *output = UnionType::NewString(
          std::move(result_string));
      break;
    }
    case Tag::FILE: {
      ::blink::mojom::DataTransferFilePtr result_file;
      if (!input.ReadFile(&result_file))
        return false;

      *output = UnionType::NewFile(
          std::move(result_file));
      break;
    }
    case Tag::BINARY: {
      ::blink::mojom::DragItemBinaryPtr result_binary;
      if (!input.ReadBinary(&result_binary))
        return false;

      *output = UnionType::NewBinary(
          std::move(result_binary));
      break;
    }
    case Tag::FILE_SYSTEM_FILE: {
      ::blink::mojom::DragItemFileSystemFilePtr result_file_system_file;
      if (!input.ReadFileSystemFile(&result_file_system_file))
        return false;

      *output = UnionType::NewFileSystemFile(
          std::move(result_file_system_file));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif