// third_party/blink/public/mojom/payments/payment_credential.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/payments/payment_credential.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/payments/payment_credential.mojom-params-data.h"
#include "third_party/blink/public/mojom/payments/payment_credential.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/payments/payment_credential.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_CREDENTIAL_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_CREDENTIAL_MOJOM_BLINK_JUMBO_H_
#endif
namespace payments {
namespace mojom {
namespace blink {
PaymentCredentialInstrument::PaymentCredentialInstrument()
    : display_name(),
      icon() {}

PaymentCredentialInstrument::PaymentCredentialInstrument(
    const WTF::String& display_name_in,
    const ::blink::KURL& icon_in)
    : display_name(std::move(display_name_in)),
      icon(std::move(icon_in)) {}

PaymentCredentialInstrument::~PaymentCredentialInstrument() = default;

void PaymentCredentialInstrument::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon, 
      "<value of type const ::blink::KURL&>");
}

bool PaymentCredentialInstrument::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PaymentCredential::Name_[] = "payments.mojom.PaymentCredential";

class PaymentCredential_DownloadIconAndShowUserPrompt_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentCredential_DownloadIconAndShowUserPrompt_ForwardToCallback(
      PaymentCredential::DownloadIconAndShowUserPromptCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentCredential::DownloadIconAndShowUserPromptCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentCredential_DownloadIconAndShowUserPrompt_ForwardToCallback);
};

class PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ForwardToCallback(
      PaymentCredential::StorePaymentCredentialAndHideUserPromptCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentCredential::StorePaymentCredentialAndHideUserPromptCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ForwardToCallback);
};

class PaymentCredential_HideUserPrompt_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentCredential_HideUserPrompt_ForwardToCallback(
      PaymentCredential::HideUserPromptCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentCredential::HideUserPromptCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentCredential_HideUserPrompt_ForwardToCallback);
};

PaymentCredentialProxy::PaymentCredentialProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentCredentialProxy::DownloadIconAndShowUserPrompt(
    PaymentCredentialInstrumentPtr in_instrument, DownloadIconAndShowUserPromptCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentCredential::DownloadIconAndShowUserPrompt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instrument"), in_instrument, 
                        "<value of type PaymentCredentialInstrumentPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentCredential_DownloadIconAndShowUserPrompt_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentCredential_DownloadIconAndShowUserPrompt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->instrument)::BaseType> instrument_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentCredentialInstrumentDataView>(
      in_instrument, instrument_fragment);
  params->instrument.Set(
      instrument_fragment.is_null() ? nullptr : instrument_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->instrument.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument in PaymentCredential.DownloadIconAndShowUserPrompt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentCredential::Name_);
  message.set_method_name("DownloadIconAndShowUserPrompt");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentCredential_DownloadIconAndShowUserPrompt_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PaymentCredentialProxy::StorePaymentCredentialAndHideUserPrompt(
    PaymentCredentialInstrumentPtr in_instrument, const WTF::Vector<uint8_t>& in_credential_id, const WTF::String& in_rp_id, StorePaymentCredentialAndHideUserPromptCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentCredential::StorePaymentCredentialAndHideUserPrompt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instrument"), in_instrument, 
                        "<value of type PaymentCredentialInstrumentPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credential_id"), in_credential_id, 
                        "<value of type const WTF::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rp_id"), in_rp_id, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentCredential_StorePaymentCredentialAndHideUserPrompt_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentCredential_StorePaymentCredentialAndHideUserPrompt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->instrument)::BaseType> instrument_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentCredentialInstrumentDataView>(
      in_instrument, instrument_fragment);
  params->instrument.Set(
      instrument_fragment.is_null() ? nullptr : instrument_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->instrument.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument in PaymentCredential.StorePaymentCredentialAndHideUserPrompt request");
  mojo::internal::MessageFragment<
      typename decltype(params->credential_id)::BaseType>
      credential_id_fragment(params.message());
  const mojo::internal::ContainerValidateParams credential_id_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_credential_id, credential_id_fragment, &credential_id_validate_params);
  params->credential_id.Set(
      credential_id_fragment.is_null() ? nullptr : credential_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->credential_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credential_id in PaymentCredential.StorePaymentCredentialAndHideUserPrompt request");
  mojo::internal::MessageFragment<
      typename decltype(params->rp_id)::BaseType> rp_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_rp_id, rp_id_fragment);
  params->rp_id.Set(
      rp_id_fragment.is_null() ? nullptr : rp_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rp_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rp_id in PaymentCredential.StorePaymentCredentialAndHideUserPrompt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentCredential::Name_);
  message.set_method_name("StorePaymentCredentialAndHideUserPrompt");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PaymentCredentialProxy::HideUserPrompt(
    HideUserPromptCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentCredential::HideUserPrompt");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentCredential_HideUserPrompt_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentCredential_HideUserPrompt_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentCredential::Name_);
  message.set_method_name("HideUserPrompt");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentCredential_HideUserPrompt_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PaymentCredential_DownloadIconAndShowUserPrompt_ProxyToResponder {
 public:
  static PaymentCredential::DownloadIconAndShowUserPromptCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentCredential_DownloadIconAndShowUserPrompt_ProxyToResponder> proxy(
        new PaymentCredential_DownloadIconAndShowUserPrompt_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentCredential_DownloadIconAndShowUserPrompt_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentCredential_DownloadIconAndShowUserPrompt_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentCredential_DownloadIconAndShowUserPrompt_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentCredential::DownloadIconAndShowUserPromptCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentCredentialUserPromptStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentCredential_DownloadIconAndShowUserPrompt_ProxyToResponder);
};

bool PaymentCredential_DownloadIconAndShowUserPrompt_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentCredential::DownloadIconAndShowUserPromptCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaymentCredential_DownloadIconAndShowUserPrompt_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentCredential_DownloadIconAndShowUserPrompt_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PaymentCredentialUserPromptStatus p_status{};
  PaymentCredential_DownloadIconAndShowUserPrompt_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentCredential::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void PaymentCredential_DownloadIconAndShowUserPrompt_ProxyToResponder::Run(
    PaymentCredentialUserPromptStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentCredential::DownloadIconAndShowUserPromptCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type PaymentCredentialUserPromptStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentCredential_DownloadIconAndShowUserPrompt_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentCredential_DownloadIconAndShowUserPrompt_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentCredentialUserPromptStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentCredential::DownloadIconAndShowUserPromptCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentCredential::Name_);
  message.set_method_name("DownloadIconAndShowUserPrompt");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ProxyToResponder {
 public:
  static PaymentCredential::StorePaymentCredentialAndHideUserPromptCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ProxyToResponder> proxy(
        new PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentCredential::StorePaymentCredentialAndHideUserPromptCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentCredentialStorageStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ProxyToResponder);
};

bool PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentCredential::StorePaymentCredentialAndHideUserPromptCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PaymentCredentialStorageStatus p_status{};
  PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentCredential::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ProxyToResponder::Run(
    PaymentCredentialStorageStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentCredential::StorePaymentCredentialAndHideUserPromptCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type PaymentCredentialStorageStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentCredential_StorePaymentCredentialAndHideUserPrompt_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentCredentialStorageStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentCredential::StorePaymentCredentialAndHideUserPromptCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentCredential::Name_);
  message.set_method_name("StorePaymentCredentialAndHideUserPrompt");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentCredential_HideUserPrompt_ProxyToResponder {
 public:
  static PaymentCredential::HideUserPromptCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentCredential_HideUserPrompt_ProxyToResponder> proxy(
        new PaymentCredential_HideUserPrompt_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentCredential_HideUserPrompt_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentCredential_HideUserPrompt_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentCredential_HideUserPrompt_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentCredential::HideUserPromptCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentCredential_HideUserPrompt_ProxyToResponder);
};

bool PaymentCredential_HideUserPrompt_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentCredential::HideUserPromptCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaymentCredential_HideUserPrompt_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentCredential_HideUserPrompt_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PaymentCredential_HideUserPrompt_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentCredential::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PaymentCredential_HideUserPrompt_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)payments::mojom::PaymentCredential::HideUserPromptCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentCredential_HideUserPrompt_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentCredential_HideUserPrompt_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentCredential::HideUserPromptCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentCredential::Name_);
  message.set_method_name("HideUserPrompt");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaymentCredentialStubDispatch::Accept(
    PaymentCredential* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPaymentCredential_DownloadIconAndShowUserPrompt_Name: {
      break;
    }
    case internal::kPaymentCredential_StorePaymentCredentialAndHideUserPrompt_Name: {
      break;
    }
    case internal::kPaymentCredential_HideUserPrompt_Name: {
      break;
    }
  }
  return false;
}

// static
bool PaymentCredentialStubDispatch::AcceptWithResponder(
    PaymentCredential* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaymentCredential_DownloadIconAndShowUserPrompt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentCredential::DownloadIconAndShowUserPrompt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentCredential::DownloadIconAndShowUserPrompt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentCredential_DownloadIconAndShowUserPrompt_Params_Data* params =
          reinterpret_cast<
              internal::PaymentCredential_DownloadIconAndShowUserPrompt_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PaymentCredentialInstrumentPtr p_instrument{};
      PaymentCredential_DownloadIconAndShowUserPrompt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInstrument(&p_instrument))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentCredential::Name_, 0, false);
        return false;
      }
      PaymentCredential::DownloadIconAndShowUserPromptCallback callback =
          PaymentCredential_DownloadIconAndShowUserPrompt_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadIconAndShowUserPrompt(
std::move(p_instrument), std::move(callback));
      return true;
    }
    case internal::kPaymentCredential_StorePaymentCredentialAndHideUserPrompt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentCredential::StorePaymentCredentialAndHideUserPrompt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentCredential::StorePaymentCredentialAndHideUserPrompt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentCredential_StorePaymentCredentialAndHideUserPrompt_Params_Data* params =
          reinterpret_cast<
              internal::PaymentCredential_StorePaymentCredentialAndHideUserPrompt_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PaymentCredentialInstrumentPtr p_instrument{};
      WTF::Vector<uint8_t> p_credential_id{};
      WTF::String p_rp_id{};
      PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInstrument(&p_instrument))
        success = false;
      if (success && !input_data_view.ReadCredentialId(&p_credential_id))
        success = false;
      if (success && !input_data_view.ReadRpId(&p_rp_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentCredential::Name_, 1, false);
        return false;
      }
      PaymentCredential::StorePaymentCredentialAndHideUserPromptCallback callback =
          PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StorePaymentCredentialAndHideUserPrompt(
std::move(p_instrument), 
std::move(p_credential_id), 
std::move(p_rp_id), std::move(callback));
      return true;
    }
    case internal::kPaymentCredential_HideUserPrompt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentCredential::HideUserPrompt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentCredential::HideUserPrompt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentCredential_HideUserPrompt_Params_Data* params =
          reinterpret_cast<
              internal::PaymentCredential_HideUserPrompt_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PaymentCredential_HideUserPrompt_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentCredential::Name_, 2, false);
        return false;
      }
      PaymentCredential::HideUserPromptCallback callback =
          PaymentCredential_HideUserPrompt_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HideUserPrompt(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPaymentCredentialValidationInfo[] = {
    {&internal::PaymentCredential_DownloadIconAndShowUserPrompt_Params_Data::Validate,
     &internal::PaymentCredential_DownloadIconAndShowUserPrompt_ResponseParams_Data::Validate},
    {&internal::PaymentCredential_StorePaymentCredentialAndHideUserPrompt_Params_Data::Validate,
     &internal::PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ResponseParams_Data::Validate},
    {&internal::PaymentCredential_HideUserPrompt_Params_Data::Validate,
     &internal::PaymentCredential_HideUserPrompt_ResponseParams_Data::Validate},
};

bool PaymentCredentialRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::PaymentCredential::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentCredentialValidationInfo);
}

bool PaymentCredentialResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::PaymentCredential::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPaymentCredentialValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace payments

namespace mojo {


// static
bool StructTraits<::payments::mojom::blink::PaymentCredentialInstrument::DataView, ::payments::mojom::blink::PaymentCredentialInstrumentPtr>::Read(
    ::payments::mojom::blink::PaymentCredentialInstrument::DataView input,
    ::payments::mojom::blink::PaymentCredentialInstrumentPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentCredentialInstrumentPtr result(::payments::mojom::blink::PaymentCredentialInstrument::New());
  
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif