// third_party/blink/public/mojom/payments/payment_credential.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/payments/payment_credential.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/payments/payment_credential.mojom-params-data.h"
namespace payments {
namespace mojom {

std::string PaymentCredentialStorageStatusToString(PaymentCredentialStorageStatus value) {
  switch(value) {
    case PaymentCredentialStorageStatus::SUCCESS:
      return "PaymentCredentialStorageStatus::SUCCESS";
    case PaymentCredentialStorageStatus::FAILED_TO_STORE_INSTRUMENT:
      return "PaymentCredentialStorageStatus::FAILED_TO_STORE_INSTRUMENT";
    default:
      return base::StringPrintf("Unknown PaymentCredentialStorageStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PaymentCredentialStorageStatus value) {
  return os << PaymentCredentialStorageStatusToString(value);
}

std::string PaymentCredentialUserPromptStatusToString(PaymentCredentialUserPromptStatus value) {
  switch(value) {
    case PaymentCredentialUserPromptStatus::FAILED_TO_DOWNLOAD_ICON:
      return "PaymentCredentialUserPromptStatus::FAILED_TO_DOWNLOAD_ICON";
    case PaymentCredentialUserPromptStatus::USER_CONFIRM_FROM_UI:
      return "PaymentCredentialUserPromptStatus::USER_CONFIRM_FROM_UI";
    case PaymentCredentialUserPromptStatus::USER_CANCEL_FROM_UI:
      return "PaymentCredentialUserPromptStatus::USER_CANCEL_FROM_UI";
    default:
      return base::StringPrintf("Unknown PaymentCredentialUserPromptStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PaymentCredentialUserPromptStatus value) {
  return os << PaymentCredentialUserPromptStatusToString(value);
}

namespace internal {


// static
bool PaymentCredentialInstrument_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentCredentialInstrument_Data* object = static_cast<const PaymentCredentialInstrument_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams display_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  return true;
}

PaymentCredentialInstrument_Data::PaymentCredentialInstrument_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentCredential_DownloadIconAndShowUserPrompt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentCredential_DownloadIconAndShowUserPrompt_Params_Data* object = static_cast<const PaymentCredential_DownloadIconAndShowUserPrompt_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instrument, validation_context))
    return false;

  return true;
}

PaymentCredential_DownloadIconAndShowUserPrompt_Params_Data::PaymentCredential_DownloadIconAndShowUserPrompt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentCredential_DownloadIconAndShowUserPrompt_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentCredential_DownloadIconAndShowUserPrompt_ResponseParams_Data* object = static_cast<const PaymentCredential_DownloadIconAndShowUserPrompt_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::PaymentCredentialUserPromptStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PaymentCredential_DownloadIconAndShowUserPrompt_ResponseParams_Data::PaymentCredential_DownloadIconAndShowUserPrompt_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentCredential_StorePaymentCredentialAndHideUserPrompt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentCredential_StorePaymentCredentialAndHideUserPrompt_Params_Data* object = static_cast<const PaymentCredential_StorePaymentCredentialAndHideUserPrompt_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instrument, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credential_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams credential_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->credential_id, validation_context,
                                         &credential_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rp_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams rp_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->rp_id, validation_context,
                                         &rp_id_validate_params)) {
    return false;
  }

  return true;
}

PaymentCredential_StorePaymentCredentialAndHideUserPrompt_Params_Data::PaymentCredential_StorePaymentCredentialAndHideUserPrompt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ResponseParams_Data* object = static_cast<const PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::PaymentCredentialStorageStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ResponseParams_Data::PaymentCredential_StorePaymentCredentialAndHideUserPrompt_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentCredential_HideUserPrompt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentCredential_HideUserPrompt_Params_Data* object = static_cast<const PaymentCredential_HideUserPrompt_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PaymentCredential_HideUserPrompt_Params_Data::PaymentCredential_HideUserPrompt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentCredential_HideUserPrompt_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentCredential_HideUserPrompt_ResponseParams_Data* object = static_cast<const PaymentCredential_HideUserPrompt_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PaymentCredential_HideUserPrompt_ResponseParams_Data::PaymentCredential_HideUserPrompt_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace payments

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::PaymentCredentialStorageStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::payments::mojom::PaymentCredentialStorageStatus value) {
  return std::move(context).WriteString(::payments::mojom::PaymentCredentialStorageStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::PaymentCredentialUserPromptStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::payments::mojom::PaymentCredentialUserPromptStatus value) {
  return std::move(context).WriteString(::payments::mojom::PaymentCredentialUserPromptStatusToString(value));
}

} // namespace perfetto
