// third_party/blink/public/mojom/payments/payment_request.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/payments/payment_request.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-params-data.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_JUMBO_H_
#endif
namespace payments {
namespace mojom {
PaymentResponse::PaymentResponse()
    : method_name(),
      stringified_details(),
      shipping_address(),
      shipping_option(),
      payer() {}

PaymentResponse::PaymentResponse(
    const std::string& method_name_in,
    const std::string& stringified_details_in,
    ::payments::mojom::PaymentAddressPtr shipping_address_in,
    const base::Optional<std::string>& shipping_option_in,
    PayerDetailPtr payer_in)
    : method_name(std::move(method_name_in)),
      stringified_details(std::move(stringified_details_in)),
      shipping_address(std::move(shipping_address_in)),
      shipping_option(std::move(shipping_option_in)),
      payer(std::move(payer_in)) {}

PaymentResponse::~PaymentResponse() = default;

void PaymentResponse::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method_name"), this->method_name, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_details"), this->stringified_details, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_address"), this->shipping_address, 
      "<value of type ::payments::mojom::PaymentAddressPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_option"), this->shipping_option, 
      "<value of type const base::Optional<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payer"), this->payer, 
      "<value of type PayerDetailPtr>");
}

bool PaymentResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PayerDetail::PayerDetail()
    : email(),
      name(),
      phone() {}

PayerDetail::PayerDetail(
    const base::Optional<std::string>& email_in,
    const base::Optional<std::string>& name_in,
    const base::Optional<std::string>& phone_in)
    : email(std::move(email_in)),
      name(std::move(name_in)),
      phone(std::move(phone_in)) {}

PayerDetail::~PayerDetail() = default;

void PayerDetail::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "email"), this->email, 
      "<value of type const base::Optional<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name, 
      "<value of type const base::Optional<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "phone"), this->phone, 
      "<value of type const base::Optional<std::string>&>");
}

bool PayerDetail::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentItem::PaymentItem()
    : label(),
      amount(),
      pending() {}

PaymentItem::PaymentItem(
    const std::string& label_in,
    ::payments::mojom::PaymentCurrencyAmountPtr amount_in,
    bool pending_in)
    : label(std::move(label_in)),
      amount(std::move(amount_in)),
      pending(std::move(pending_in)) {}

PaymentItem::~PaymentItem() = default;
size_t PaymentItem::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->label);
  seed = mojo::internal::Hash(seed, this->amount);
  seed = mojo::internal::Hash(seed, this->pending);
  return seed;
}

void PaymentItem::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "amount"), this->amount, 
      "<value of type ::payments::mojom::PaymentCurrencyAmountPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pending"), this->pending, 
      "<value of type bool>");
}

bool PaymentItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentShippingOption::PaymentShippingOption()
    : id(),
      label(),
      amount(),
      selected() {}

PaymentShippingOption::PaymentShippingOption(
    const std::string& id_in,
    const std::string& label_in,
    ::payments::mojom::PaymentCurrencyAmountPtr amount_in,
    bool selected_in)
    : id(std::move(id_in)),
      label(std::move(label_in)),
      amount(std::move(amount_in)),
      selected(std::move(selected_in)) {}

PaymentShippingOption::~PaymentShippingOption() = default;
size_t PaymentShippingOption::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->label);
  seed = mojo::internal::Hash(seed, this->amount);
  seed = mojo::internal::Hash(seed, this->selected);
  return seed;
}

void PaymentShippingOption::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "amount"), this->amount, 
      "<value of type ::payments::mojom::PaymentCurrencyAmountPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected"), this->selected, 
      "<value of type bool>");
}

bool PaymentShippingOption::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GooglePaymentMethodData::GooglePaymentMethodData()
    : stringified_data(),
      phone_requested(),
      name_requested(),
      email_requested(),
      shipping_requested() {}

GooglePaymentMethodData::GooglePaymentMethodData(
    const std::string& stringified_data_in,
    bool phone_requested_in,
    bool name_requested_in,
    bool email_requested_in,
    bool shipping_requested_in)
    : stringified_data(std::move(stringified_data_in)),
      phone_requested(std::move(phone_requested_in)),
      name_requested(std::move(name_requested_in)),
      email_requested(std::move(email_requested_in)),
      shipping_requested(std::move(shipping_requested_in)) {}

GooglePaymentMethodData::~GooglePaymentMethodData() = default;
size_t GooglePaymentMethodData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->stringified_data);
  seed = mojo::internal::Hash(seed, this->phone_requested);
  seed = mojo::internal::Hash(seed, this->name_requested);
  seed = mojo::internal::Hash(seed, this->email_requested);
  seed = mojo::internal::Hash(seed, this->shipping_requested);
  return seed;
}

void GooglePaymentMethodData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_data"), this->stringified_data, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "phone_requested"), this->phone_requested, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name_requested"), this->name_requested, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "email_requested"), this->email_requested, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_requested"), this->shipping_requested, 
      "<value of type bool>");
}

bool GooglePaymentMethodData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SecurePaymentConfirmationRequest::SecurePaymentConfirmationRequest()
    : credential_ids(),
      network_data(),
      timeout() {}

SecurePaymentConfirmationRequest::SecurePaymentConfirmationRequest(
    std::vector<std::vector<uint8_t>> credential_ids_in,
    std::vector<uint8_t> network_data_in,
    base::Optional<::base::TimeDelta> timeout_in)
    : credential_ids(std::move(credential_ids_in)),
      network_data(std::move(network_data_in)),
      timeout(std::move(timeout_in)) {}

SecurePaymentConfirmationRequest::~SecurePaymentConfirmationRequest() = default;

void SecurePaymentConfirmationRequest::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credential_ids"), this->credential_ids, 
      "<value of type const std::vector<std::vector<uint8_t>>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "network_data"), this->network_data, 
      "<value of type const std::vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout"), this->timeout, 
      "<value of type base::Optional<::base::TimeDelta>>");
}

bool SecurePaymentConfirmationRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentMethodData::PaymentMethodData()
    : supported_method(),
      stringified_data(),
      environment(),
      min_google_play_services_version(),
      api_version(),
      supported_networks(),
      secure_payment_confirmation() {}

PaymentMethodData::PaymentMethodData(
    const std::string& supported_method_in,
    const std::string& stringified_data_in,
    AndroidPayEnvironment environment_in,
    int32_t min_google_play_services_version_in,
    int32_t api_version_in,
    std::vector<BasicCardNetwork> supported_networks_in,
    SecurePaymentConfirmationRequestPtr secure_payment_confirmation_in)
    : supported_method(std::move(supported_method_in)),
      stringified_data(std::move(stringified_data_in)),
      environment(std::move(environment_in)),
      min_google_play_services_version(std::move(min_google_play_services_version_in)),
      api_version(std::move(api_version_in)),
      supported_networks(std::move(supported_networks_in)),
      secure_payment_confirmation(std::move(secure_payment_confirmation_in)) {}

PaymentMethodData::~PaymentMethodData() = default;

void PaymentMethodData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_method"), this->supported_method, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_data"), this->stringified_data, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "environment"), this->environment, 
      "<value of type AndroidPayEnvironment>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_google_play_services_version"), this->min_google_play_services_version, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "api_version"), this->api_version, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_networks"), this->supported_networks, 
      "<value of type const std::vector<BasicCardNetwork>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_payment_confirmation"), this->secure_payment_confirmation, 
      "<value of type SecurePaymentConfirmationRequestPtr>");
}

bool PaymentMethodData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentDetailsModifier::PaymentDetailsModifier()
    : total(),
      additional_display_items(),
      method_data() {}

PaymentDetailsModifier::PaymentDetailsModifier(
    PaymentItemPtr total_in,
    std::vector<PaymentItemPtr> additional_display_items_in,
    PaymentMethodDataPtr method_data_in)
    : total(std::move(total_in)),
      additional_display_items(std::move(additional_display_items_in)),
      method_data(std::move(method_data_in)) {}

PaymentDetailsModifier::~PaymentDetailsModifier() = default;

void PaymentDetailsModifier::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total, 
      "<value of type PaymentItemPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_display_items"), this->additional_display_items, 
      "<value of type std::vector<PaymentItemPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method_data"), this->method_data, 
      "<value of type PaymentMethodDataPtr>");
}

bool PaymentDetailsModifier::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentDetails::PaymentDetails()
    : total(),
      display_items(),
      shipping_options(),
      modifiers(),
      error(""),
      shipping_address_errors(),
      id(),
      stringified_payment_method_errors() {}

PaymentDetails::PaymentDetails(
    PaymentItemPtr total_in,
    base::Optional<std::vector<PaymentItemPtr>> display_items_in,
    base::Optional<std::vector<PaymentShippingOptionPtr>> shipping_options_in,
    base::Optional<std::vector<PaymentDetailsModifierPtr>> modifiers_in,
    const std::string& error_in,
    ::payments::mojom::AddressErrorsPtr shipping_address_errors_in,
    const base::Optional<std::string>& id_in,
    const base::Optional<std::string>& stringified_payment_method_errors_in)
    : total(std::move(total_in)),
      display_items(std::move(display_items_in)),
      shipping_options(std::move(shipping_options_in)),
      modifiers(std::move(modifiers_in)),
      error(std::move(error_in)),
      shipping_address_errors(std::move(shipping_address_errors_in)),
      id(std::move(id_in)),
      stringified_payment_method_errors(std::move(stringified_payment_method_errors_in)) {}

PaymentDetails::~PaymentDetails() = default;

void PaymentDetails::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total, 
      "<value of type PaymentItemPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_items"), this->display_items, 
      "<value of type base::Optional<std::vector<PaymentItemPtr>>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_options"), this->shipping_options, 
      "<value of type base::Optional<std::vector<PaymentShippingOptionPtr>>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers, 
      "<value of type base::Optional<std::vector<PaymentDetailsModifierPtr>>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_address_errors"), this->shipping_address_errors, 
      "<value of type ::payments::mojom::AddressErrorsPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type const base::Optional<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_payment_method_errors"), this->stringified_payment_method_errors, 
      "<value of type const base::Optional<std::string>&>");
}

bool PaymentDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentOptions::PaymentOptions()
    : request_payer_name(),
      request_payer_email(),
      request_payer_phone(),
      request_shipping(),
      shipping_type() {}

PaymentOptions::PaymentOptions(
    bool request_payer_name_in,
    bool request_payer_email_in,
    bool request_payer_phone_in,
    bool request_shipping_in,
    PaymentShippingType shipping_type_in)
    : request_payer_name(std::move(request_payer_name_in)),
      request_payer_email(std::move(request_payer_email_in)),
      request_payer_phone(std::move(request_payer_phone_in)),
      request_shipping(std::move(request_shipping_in)),
      shipping_type(std::move(shipping_type_in)) {}

PaymentOptions::~PaymentOptions() = default;
size_t PaymentOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->request_payer_name);
  seed = mojo::internal::Hash(seed, this->request_payer_email);
  seed = mojo::internal::Hash(seed, this->request_payer_phone);
  seed = mojo::internal::Hash(seed, this->request_shipping);
  seed = mojo::internal::Hash(seed, this->shipping_type);
  return seed;
}

void PaymentOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_payer_name"), this->request_payer_name, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_payer_email"), this->request_payer_email, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_payer_phone"), this->request_payer_phone, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_shipping"), this->request_shipping, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_type"), this->shipping_type, 
      "<value of type PaymentShippingType>");
}

bool PaymentOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PaymentRequestClient::Name_[] = "payments.mojom.PaymentRequestClient";

PaymentRequestClientProxy::PaymentRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentRequestClientProxy::OnPaymentMethodChange(
    const std::string& in_method_name, const std::string& in_stringified_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnPaymentMethodChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_name"), in_method_name, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stringified_details"), in_stringified_details, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnPaymentMethodChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->method_name)::BaseType> method_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_method_name, method_name_fragment);
  params->method_name.Set(
      method_name_fragment.is_null() ? nullptr : method_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_name in PaymentRequestClient.OnPaymentMethodChange request");
  mojo::internal::MessageFragment<
      typename decltype(params->stringified_details)::BaseType> stringified_details_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_stringified_details, stringified_details_fragment);
  params->stringified_details.Set(
      stringified_details_fragment.is_null() ? nullptr : stringified_details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->stringified_details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stringified_details in PaymentRequestClient.OnPaymentMethodChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnPaymentMethodChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnShippingAddressChange(
    ::payments::mojom::PaymentAddressPtr in_address) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnShippingAddressChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address, 
                        "<value of type ::payments::mojom::PaymentAddressPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnShippingAddressChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnShippingAddressChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentAddressDataView>(
      in_address, address_fragment);
  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null address in PaymentRequestClient.OnShippingAddressChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnShippingAddressChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnShippingOptionChange(
    const std::string& in_shipping_option_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnShippingOptionChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shipping_option_id"), in_shipping_option_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnShippingOptionChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnShippingOptionChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->shipping_option_id)::BaseType> shipping_option_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_shipping_option_id, shipping_option_id_fragment);
  params->shipping_option_id.Set(
      shipping_option_id_fragment.is_null() ? nullptr : shipping_option_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shipping_option_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shipping_option_id in PaymentRequestClient.OnShippingOptionChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnShippingOptionChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnPayerDetailChange(
    PayerDetailPtr in_detail) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnPayerDetailChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("detail"), in_detail, 
                        "<value of type PayerDetailPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnPayerDetailChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnPayerDetailChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->detail)::BaseType> detail_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PayerDetailDataView>(
      in_detail, detail_fragment);
  params->detail.Set(
      detail_fragment.is_null() ? nullptr : detail_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->detail.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null detail in PaymentRequestClient.OnPayerDetailChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnPayerDetailChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnPaymentResponse(
    PaymentResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnPaymentResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response, 
                        "<value of type PaymentResponsePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnPaymentResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnPaymentResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentResponseDataView>(
      in_response, response_fragment);
  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in PaymentRequestClient.OnPaymentResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnPaymentResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnError(
    PaymentErrorReason in_error, const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type PaymentErrorReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentErrorReason>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in PaymentRequestClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnComplete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequestClient::OnComplete");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnComplete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnAbort(
    bool in_aborted_successfully) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnAbort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("aborted_successfully"), in_aborted_successfully, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnAbort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnAbort_Params_Data> params(
          message);
  params.Allocate();
  params->aborted_successfully = in_aborted_successfully;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnAbort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnCanMakePayment(
    CanMakePaymentQueryResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnCanMakePayment", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type CanMakePaymentQueryResult>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnCanMakePayment_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnCanMakePayment_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::CanMakePaymentQueryResult>(
      in_result, &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnCanMakePayment");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnHasEnrolledInstrument(
    HasEnrolledInstrumentQueryResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnHasEnrolledInstrument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type HasEnrolledInstrumentQueryResult>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnHasEnrolledInstrument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::HasEnrolledInstrumentQueryResult>(
      in_result, &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnHasEnrolledInstrument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::WarnNoFavicon(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequestClient::WarnNoFavicon");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_WarnNoFavicon_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_WarnNoFavicon_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("WarnNoFavicon");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PaymentRequestClientStubDispatch::Accept(
    PaymentRequestClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPaymentRequestClient_OnPaymentMethodChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnPaymentMethodChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnPaymentMethodChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_method_name{};
      std::string p_stringified_details{};
      PaymentRequestClient_OnPaymentMethodChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMethodName(&p_method_name))
        success = false;
      if (success && !input_data_view.ReadStringifiedDetails(&p_stringified_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaymentMethodChange(
std::move(p_method_name), 
std::move(p_stringified_details));
      return true;
    }
    case internal::kPaymentRequestClient_OnShippingAddressChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnShippingAddressChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnShippingAddressChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnShippingAddressChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnShippingAddressChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::payments::mojom::PaymentAddressPtr p_address{};
      PaymentRequestClient_OnShippingAddressChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShippingAddressChange(
std::move(p_address));
      return true;
    }
    case internal::kPaymentRequestClient_OnShippingOptionChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnShippingOptionChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnShippingOptionChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnShippingOptionChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnShippingOptionChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_shipping_option_id{};
      PaymentRequestClient_OnShippingOptionChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadShippingOptionId(&p_shipping_option_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShippingOptionChange(
std::move(p_shipping_option_id));
      return true;
    }
    case internal::kPaymentRequestClient_OnPayerDetailChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnPayerDetailChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnPayerDetailChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnPayerDetailChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnPayerDetailChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PayerDetailPtr p_detail{};
      PaymentRequestClient_OnPayerDetailChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetail(&p_detail))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPayerDetailChange(
std::move(p_detail));
      return true;
    }
    case internal::kPaymentRequestClient_OnPaymentResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnPaymentResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnPaymentResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnPaymentResponse_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnPaymentResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentResponsePtr p_response{};
      PaymentRequestClient_OnPaymentResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaymentResponse(
std::move(p_response));
      return true;
    }
    case internal::kPaymentRequestClient_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnError_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentErrorReason p_error{};
      std::string p_error_message{};
      PaymentRequestClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_error), 
std::move(p_error_message));
      return true;
    }
    case internal::kPaymentRequestClient_OnComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequestClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete();
      return true;
    }
    case internal::kPaymentRequestClient_OnAbort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnAbort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnAbort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnAbort_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnAbort_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_aborted_successfully{};
      PaymentRequestClient_OnAbort_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_aborted_successfully = input_data_view.aborted_successfully();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAbort(
std::move(p_aborted_successfully));
      return true;
    }
    case internal::kPaymentRequestClient_OnCanMakePayment_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnCanMakePayment",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnCanMakePayment");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnCanMakePayment_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnCanMakePayment_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CanMakePaymentQueryResult p_result{};
      PaymentRequestClient_OnCanMakePayment_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCanMakePayment(
std::move(p_result));
      return true;
    }
    case internal::kPaymentRequestClient_OnHasEnrolledInstrument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnHasEnrolledInstrument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnHasEnrolledInstrument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      HasEnrolledInstrumentQueryResult p_result{};
      PaymentRequestClient_OnHasEnrolledInstrument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHasEnrolledInstrument(
std::move(p_result));
      return true;
    }
    case internal::kPaymentRequestClient_WarnNoFavicon_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::WarnNoFavicon",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::WarnNoFavicon");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_WarnNoFavicon_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_WarnNoFavicon_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequestClient_WarnNoFavicon_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WarnNoFavicon();
      return true;
    }
  }
  return false;
}

// static
bool PaymentRequestClientStubDispatch::AcceptWithResponder(
    PaymentRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaymentRequestClient_OnPaymentMethodChange_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnShippingAddressChange_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnShippingOptionChange_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnPayerDetailChange_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnPaymentResponse_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnError_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnComplete_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnAbort_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnCanMakePayment_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnHasEnrolledInstrument_Name: {
      break;
    }
    case internal::kPaymentRequestClient_WarnNoFavicon_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPaymentRequestClientValidationInfo[] = {
    {&internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnShippingAddressChange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnShippingOptionChange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnPayerDetailChange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnPaymentResponse_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnError_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnComplete_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnAbort_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnCanMakePayment_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_WarnNoFavicon_Params_Data::Validate,
     nullptr /* no response */},
};

bool PaymentRequestClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::PaymentRequestClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentRequestClientValidationInfo);
}

const char PaymentRequest::Name_[] = "payments.mojom.PaymentRequest";

PaymentRequestProxy::PaymentRequestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentRequestProxy::Init(
    ::mojo::PendingRemote<PaymentRequestClient> in_client, std::vector<PaymentMethodDataPtr> in_method_data, PaymentDetailsPtr in_details, PaymentOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequest::Init", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<PaymentRequestClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_data"), in_method_data, 
                        "<value of type std::vector<PaymentMethodDataPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details, 
                        "<value of type PaymentDetailsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type PaymentOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_Init_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_Init_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in PaymentRequest.Init request");
  mojo::internal::MessageFragment<
      typename decltype(params->method_data)::BaseType>
      method_data_fragment(params.message());
  const mojo::internal::ContainerValidateParams method_data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>>(
      in_method_data, method_data_fragment, &method_data_validate_params);
  params->method_data.Set(
      method_data_fragment.is_null() ? nullptr : method_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_data in PaymentRequest.Init request");
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentDetailsDataView>(
      in_details, details_fragment);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in PaymentRequest.Init request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in PaymentRequest.Init request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Init");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::Show(
    bool in_is_user_gesture, bool in_wait_for_updated_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequest::Show", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_user_gesture"), in_is_user_gesture, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wait_for_updated_details"), in_wait_for_updated_details, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_Show_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_Show_Params_Data> params(
          message);
  params.Allocate();
  params->is_user_gesture = in_is_user_gesture;
  params->wait_for_updated_details = in_wait_for_updated_details;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Show");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::UpdateWith(
    PaymentDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequest::UpdateWith", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details, 
                        "<value of type PaymentDetailsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_UpdateWith_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_UpdateWith_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentDetailsDataView>(
      in_details, details_fragment);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in PaymentRequest.UpdateWith request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("UpdateWith");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::OnPaymentDetailsNotUpdated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequest::OnPaymentDetailsNotUpdated");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_OnPaymentDetailsNotUpdated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("OnPaymentDetailsNotUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::Abort(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequest::Abort");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_Abort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_Abort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::Complete(
    PaymentComplete in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequest::Complete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type PaymentComplete>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_Complete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_Complete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentComplete>(
      in_result, &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Complete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::Retry(
    ::payments::mojom::PaymentValidationErrorsPtr in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequest::Retry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("errors"), in_errors, 
                        "<value of type ::payments::mojom::PaymentValidationErrorsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_Retry_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_Retry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->errors)::BaseType> errors_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentValidationErrorsDataView>(
      in_errors, errors_fragment);
  params->errors.Set(
      errors_fragment.is_null() ? nullptr : errors_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->errors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null errors in PaymentRequest.Retry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Retry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::CanMakePayment(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequest::CanMakePayment");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_CanMakePayment_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_CanMakePayment_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("CanMakePayment");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::HasEnrolledInstrument(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequest::HasEnrolledInstrument");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_HasEnrolledInstrument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_HasEnrolledInstrument_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("HasEnrolledInstrument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PaymentRequestStubDispatch::Accept(
    PaymentRequest* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPaymentRequest_Init_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::Init",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::Init");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_Init_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Init_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<PaymentRequestClient> p_client{};
      std::vector<PaymentMethodDataPtr> p_method_data{};
      PaymentDetailsPtr p_details{};
      PaymentOptionsPtr p_options{};
      PaymentRequest_Init_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadMethodData(&p_method_data))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Init(
std::move(p_client), 
std::move(p_method_data), 
std::move(p_details), 
std::move(p_options));
      return true;
    }
    case internal::kPaymentRequest_Show_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::Show",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::Show");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_Show_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Show_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_user_gesture{};
      bool p_wait_for_updated_details{};
      PaymentRequest_Show_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_user_gesture = input_data_view.is_user_gesture();
      if (success)
        p_wait_for_updated_details = input_data_view.wait_for_updated_details();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Show(
std::move(p_is_user_gesture), 
std::move(p_wait_for_updated_details));
      return true;
    }
    case internal::kPaymentRequest_UpdateWith_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::UpdateWith",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::UpdateWith");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_UpdateWith_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_UpdateWith_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentDetailsPtr p_details{};
      PaymentRequest_UpdateWith_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateWith(
std::move(p_details));
      return true;
    }
    case internal::kPaymentRequest_OnPaymentDetailsNotUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::OnPaymentDetailsNotUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::OnPaymentDetailsNotUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequest_OnPaymentDetailsNotUpdated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaymentDetailsNotUpdated();
      return true;
    }
    case internal::kPaymentRequest_Abort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::Abort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::Abort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_Abort_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Abort_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequest_Abort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort();
      return true;
    }
    case internal::kPaymentRequest_Complete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::Complete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::Complete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_Complete_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Complete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentComplete p_result{};
      PaymentRequest_Complete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Complete(
std::move(p_result));
      return true;
    }
    case internal::kPaymentRequest_Retry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::Retry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::Retry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_Retry_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Retry_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::payments::mojom::PaymentValidationErrorsPtr p_errors{};
      PaymentRequest_Retry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrors(&p_errors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Retry(
std::move(p_errors));
      return true;
    }
    case internal::kPaymentRequest_CanMakePayment_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::CanMakePayment",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::CanMakePayment");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_CanMakePayment_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_CanMakePayment_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequest_CanMakePayment_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanMakePayment();
      return true;
    }
    case internal::kPaymentRequest_HasEnrolledInstrument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::HasEnrolledInstrument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::HasEnrolledInstrument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_HasEnrolledInstrument_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_HasEnrolledInstrument_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequest_HasEnrolledInstrument_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasEnrolledInstrument();
      return true;
    }
  }
  return false;
}

// static
bool PaymentRequestStubDispatch::AcceptWithResponder(
    PaymentRequest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaymentRequest_Init_Name: {
      break;
    }
    case internal::kPaymentRequest_Show_Name: {
      break;
    }
    case internal::kPaymentRequest_UpdateWith_Name: {
      break;
    }
    case internal::kPaymentRequest_OnPaymentDetailsNotUpdated_Name: {
      break;
    }
    case internal::kPaymentRequest_Abort_Name: {
      break;
    }
    case internal::kPaymentRequest_Complete_Name: {
      break;
    }
    case internal::kPaymentRequest_Retry_Name: {
      break;
    }
    case internal::kPaymentRequest_CanMakePayment_Name: {
      break;
    }
    case internal::kPaymentRequest_HasEnrolledInstrument_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPaymentRequestValidationInfo[] = {
    {&internal::PaymentRequest_Init_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_Show_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_UpdateWith_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_Abort_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_Complete_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_Retry_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_CanMakePayment_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_HasEnrolledInstrument_Params_Data::Validate,
     nullptr /* no response */},
};

bool PaymentRequestRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::PaymentRequest::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentRequestValidationInfo);
}

}  // namespace mojom
}  // namespace payments

namespace mojo {


// static
bool StructTraits<::payments::mojom::PaymentResponse::DataView, ::payments::mojom::PaymentResponsePtr>::Read(
    ::payments::mojom::PaymentResponse::DataView input,
    ::payments::mojom::PaymentResponsePtr* output) {
  bool success = true;
  ::payments::mojom::PaymentResponsePtr result(::payments::mojom::PaymentResponse::New());
  
      if (success && !input.ReadMethodName(&result->method_name))
        success = false;
      if (success && !input.ReadStringifiedDetails(&result->stringified_details))
        success = false;
      if (success && !input.ReadShippingAddress(&result->shipping_address))
        success = false;
      if (success && !input.ReadShippingOption(&result->shipping_option))
        success = false;
      if (success && !input.ReadPayer(&result->payer))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PayerDetail::DataView, ::payments::mojom::PayerDetailPtr>::Read(
    ::payments::mojom::PayerDetail::DataView input,
    ::payments::mojom::PayerDetailPtr* output) {
  bool success = true;
  ::payments::mojom::PayerDetailPtr result(::payments::mojom::PayerDetail::New());
  
      if (success && !input.ReadEmail(&result->email))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadPhone(&result->phone))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentItem::DataView, ::payments::mojom::PaymentItemPtr>::Read(
    ::payments::mojom::PaymentItem::DataView input,
    ::payments::mojom::PaymentItemPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentItemPtr result(::payments::mojom::PaymentItem::New());
  
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadAmount(&result->amount))
        success = false;
      if (success)
        result->pending = input.pending();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentShippingOption::DataView, ::payments::mojom::PaymentShippingOptionPtr>::Read(
    ::payments::mojom::PaymentShippingOption::DataView input,
    ::payments::mojom::PaymentShippingOptionPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentShippingOptionPtr result(::payments::mojom::PaymentShippingOption::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadAmount(&result->amount))
        success = false;
      if (success)
        result->selected = input.selected();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::GooglePaymentMethodData::DataView, ::payments::mojom::GooglePaymentMethodDataPtr>::Read(
    ::payments::mojom::GooglePaymentMethodData::DataView input,
    ::payments::mojom::GooglePaymentMethodDataPtr* output) {
  bool success = true;
  ::payments::mojom::GooglePaymentMethodDataPtr result(::payments::mojom::GooglePaymentMethodData::New());
  
      if (success && !input.ReadStringifiedData(&result->stringified_data))
        success = false;
      if (success)
        result->phone_requested = input.phone_requested();
      if (success)
        result->name_requested = input.name_requested();
      if (success)
        result->email_requested = input.email_requested();
      if (success)
        result->shipping_requested = input.shipping_requested();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::SecurePaymentConfirmationRequest::DataView, ::payments::mojom::SecurePaymentConfirmationRequestPtr>::Read(
    ::payments::mojom::SecurePaymentConfirmationRequest::DataView input,
    ::payments::mojom::SecurePaymentConfirmationRequestPtr* output) {
  bool success = true;
  ::payments::mojom::SecurePaymentConfirmationRequestPtr result(::payments::mojom::SecurePaymentConfirmationRequest::New());
  
      if (success && !input.ReadCredentialIds(&result->credential_ids))
        success = false;
      if (success && !input.ReadNetworkData(&result->network_data))
        success = false;
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentMethodData::DataView, ::payments::mojom::PaymentMethodDataPtr>::Read(
    ::payments::mojom::PaymentMethodData::DataView input,
    ::payments::mojom::PaymentMethodDataPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentMethodDataPtr result(::payments::mojom::PaymentMethodData::New());
  
      if (success && !input.ReadSupportedMethod(&result->supported_method))
        success = false;
      if (success && !input.ReadStringifiedData(&result->stringified_data))
        success = false;
      if (success && !input.ReadEnvironment(&result->environment))
        success = false;
      if (success)
        result->min_google_play_services_version = input.min_google_play_services_version();
      if (success)
        result->api_version = input.api_version();
      if (success && !input.ReadSupportedNetworks(&result->supported_networks))
        success = false;
      if (success && !input.ReadSecurePaymentConfirmation(&result->secure_payment_confirmation))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentDetailsModifier::DataView, ::payments::mojom::PaymentDetailsModifierPtr>::Read(
    ::payments::mojom::PaymentDetailsModifier::DataView input,
    ::payments::mojom::PaymentDetailsModifierPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentDetailsModifierPtr result(::payments::mojom::PaymentDetailsModifier::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadAdditionalDisplayItems(&result->additional_display_items))
        success = false;
      if (success && !input.ReadMethodData(&result->method_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentDetails::DataView, ::payments::mojom::PaymentDetailsPtr>::Read(
    ::payments::mojom::PaymentDetails::DataView input,
    ::payments::mojom::PaymentDetailsPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentDetailsPtr result(::payments::mojom::PaymentDetails::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadDisplayItems(&result->display_items))
        success = false;
      if (success && !input.ReadShippingOptions(&result->shipping_options))
        success = false;
      if (success && !input.ReadModifiers(&result->modifiers))
        success = false;
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadShippingAddressErrors(&result->shipping_address_errors))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadStringifiedPaymentMethodErrors(&result->stringified_payment_method_errors))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentOptions::DataView, ::payments::mojom::PaymentOptionsPtr>::Read(
    ::payments::mojom::PaymentOptions::DataView input,
    ::payments::mojom::PaymentOptionsPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentOptionsPtr result(::payments::mojom::PaymentOptions::New());
  
      if (success)
        result->request_payer_name = input.request_payer_name();
      if (success)
        result->request_payer_email = input.request_payer_email();
      if (success)
        result->request_payer_phone = input.request_payer_phone();
      if (success)
        result->request_shipping = input.request_shipping();
      if (success && !input.ReadShippingType(&result->shipping_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif