// third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string DeviceThermalStateToString(DeviceThermalState value) {
  switch(value) {
    case DeviceThermalState::kUnknown:
      return "DeviceThermalState::kUnknown";
    case DeviceThermalState::kNominal:
      return "DeviceThermalState::kNominal";
    case DeviceThermalState::kFair:
      return "DeviceThermalState::kFair";
    case DeviceThermalState::kSerious:
      return "DeviceThermalState::kSerious";
    case DeviceThermalState::kCritical:
      return "DeviceThermalState::kCritical";
    default:
      return base::StringPrintf("Unknown DeviceThermalState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DeviceThermalState value) {
  return os << DeviceThermalStateToString(value);
}

namespace internal {


// static
bool PeerConnectionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionInfo_Data* object = static_cast<const PeerConnectionInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rtc_configuration, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams rtc_configuration_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->rtc_configuration, validation_context,
                                         &rtc_configuration_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->constraints, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams constraints_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->constraints, validation_context,
                                         &constraints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionInfo_Data::PeerConnectionInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_OnSuspend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionManager_OnSuspend_Params_Data* object = static_cast<const PeerConnectionManager_OnSuspend_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PeerConnectionManager_OnSuspend_Params_Data::PeerConnectionManager_OnSuspend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_OnThermalStateChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionManager_OnThermalStateChange_Params_Data* object = static_cast<const PeerConnectionManager_OnThermalStateChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::DeviceThermalState_Data
        ::Validate(object->thermal_state, validation_context))
    return false;

  return true;
}

PeerConnectionManager_OnThermalStateChange_Params_Data::PeerConnectionManager_OnThermalStateChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_StartEventLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionManager_StartEventLog_Params_Data* object = static_cast<const PeerConnectionManager_StartEventLog_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PeerConnectionManager_StartEventLog_Params_Data::PeerConnectionManager_StartEventLog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_StopEventLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionManager_StopEventLog_Params_Data* object = static_cast<const PeerConnectionManager_StopEventLog_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PeerConnectionManager_StopEventLog_Params_Data::PeerConnectionManager_StopEventLog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_GetStandardStats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionManager_GetStandardStats_Params_Data* object = static_cast<const PeerConnectionManager_GetStandardStats_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PeerConnectionManager_GetStandardStats_Params_Data::PeerConnectionManager_GetStandardStats_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_GetLegacyStats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionManager_GetLegacyStats_Params_Data* object = static_cast<const PeerConnectionManager_GetLegacyStats_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PeerConnectionManager_GetLegacyStats_Params_Data::PeerConnectionManager_GetLegacyStats_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_AddPeerConnection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionTrackerHost_AddPeerConnection_Params_Data* object = static_cast<const PeerConnectionTrackerHost_AddPeerConnection_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

PeerConnectionTrackerHost_AddPeerConnection_Params_Data::PeerConnectionTrackerHost_AddPeerConnection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_RemovePeerConnection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionTrackerHost_RemovePeerConnection_Params_Data* object = static_cast<const PeerConnectionTrackerHost_RemovePeerConnection_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PeerConnectionTrackerHost_RemovePeerConnection_Params_Data::PeerConnectionTrackerHost_RemovePeerConnection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data* object = static_cast<const PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data::PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data* object = static_cast<const PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams session_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data::PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_GetUserMedia_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionTrackerHost_GetUserMedia_Params_Data* object = static_cast<const PeerConnectionTrackerHost_GetUserMedia_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams origin_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->origin, validation_context,
                                         &origin_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_constraints, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams audio_constraints_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->audio_constraints, validation_context,
                                         &audio_constraints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->video_constraints, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams video_constraints_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->video_constraints, validation_context,
                                         &video_constraints_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_GetUserMedia_Params_Data::PeerConnectionTrackerHost_GetUserMedia_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data* object = static_cast<const PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams output_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->output, validation_context,
                                         &output_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data::PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_AddStandardStats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionTrackerHost_AddStandardStats_Params_Data* object = static_cast<const PeerConnectionTrackerHost_AddStandardStats_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

PeerConnectionTrackerHost_AddStandardStats_Params_Data::PeerConnectionTrackerHost_AddStandardStats_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_AddLegacyStats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerConnectionTrackerHost_AddLegacyStats_Params_Data* object = static_cast<const PeerConnectionTrackerHost_AddLegacyStats_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

PeerConnectionTrackerHost_AddLegacyStats_Params_Data::PeerConnectionTrackerHost_AddLegacyStats_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DeviceThermalState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::DeviceThermalState value) {
  return std::move(context).WriteString(::blink::mojom::DeviceThermalStateToString(value));
}

} // namespace perfetto
