// third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-params-data.h"
#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
PeerConnectionInfo::PeerConnectionInfo()
    : lid(),
      rtc_configuration(),
      constraints(),
      url() {}

PeerConnectionInfo::PeerConnectionInfo(
    int32_t lid_in,
    const std::string& rtc_configuration_in,
    const std::string& constraints_in,
    const std::string& url_in)
    : lid(std::move(lid_in)),
      rtc_configuration(std::move(rtc_configuration_in)),
      constraints(std::move(constraints_in)),
      url(std::move(url_in)) {}

PeerConnectionInfo::~PeerConnectionInfo() = default;
size_t PeerConnectionInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->lid);
  seed = mojo::internal::Hash(seed, this->rtc_configuration);
  seed = mojo::internal::Hash(seed, this->constraints);
  seed = mojo::internal::Hash(seed, this->url);
  return seed;
}

void PeerConnectionInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lid"), this->lid, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rtc_configuration"), this->rtc_configuration, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "constraints"), this->constraints, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url, 
      "<value of type const std::string&>");
}

bool PeerConnectionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PeerConnectionManager::Name_[] = "blink.mojom.PeerConnectionManager";

PeerConnectionManagerProxy::PeerConnectionManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PeerConnectionManagerProxy::OnSuspend(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PeerConnectionManager::OnSuspend");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionManager_OnSuspend_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_OnSuspend_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("OnSuspend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionManagerProxy::OnThermalStateChange(
    DeviceThermalState in_thermal_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionManager::OnThermalStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thermal_state"), in_thermal_state, 
                        "<value of type DeviceThermalState>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionManager_OnThermalStateChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_OnThermalStateChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::DeviceThermalState>(
      in_thermal_state, &params->thermal_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("OnThermalStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionManagerProxy::StartEventLog(
    int32_t in_peer_connection_local_id, int32_t in_output_period_ms) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionManager::StartEventLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_connection_local_id"), in_peer_connection_local_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_period_ms"), in_output_period_ms, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionManager_StartEventLog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_StartEventLog_Params_Data> params(
          message);
  params.Allocate();
  params->peer_connection_local_id = in_peer_connection_local_id;
  params->output_period_ms = in_output_period_ms;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("StartEventLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionManagerProxy::StopEventLog(
    int32_t in_peer_connection_local_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionManager::StopEventLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_connection_local_id"), in_peer_connection_local_id, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionManager_StopEventLog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_StopEventLog_Params_Data> params(
          message);
  params.Allocate();
  params->peer_connection_local_id = in_peer_connection_local_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("StopEventLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionManagerProxy::GetStandardStats(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PeerConnectionManager::GetStandardStats");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionManager_GetStandardStats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_GetStandardStats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("GetStandardStats");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionManagerProxy::GetLegacyStats(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PeerConnectionManager::GetLegacyStats");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionManager_GetLegacyStats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_GetLegacyStats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("GetLegacyStats");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PeerConnectionManagerStubDispatch::Accept(
    PeerConnectionManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPeerConnectionManager_OnSuspend_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionManager::OnSuspend",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionManager::OnSuspend");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_OnSuspend_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_OnSuspend_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PeerConnectionManager_OnSuspend_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSuspend();
      return true;
    }
    case internal::kPeerConnectionManager_OnThermalStateChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionManager::OnThermalStateChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionManager::OnThermalStateChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_OnThermalStateChange_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_OnThermalStateChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DeviceThermalState p_thermal_state{};
      PeerConnectionManager_OnThermalStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadThermalState(&p_thermal_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnThermalStateChange(
std::move(p_thermal_state));
      return true;
    }
    case internal::kPeerConnectionManager_StartEventLog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionManager::StartEventLog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionManager::StartEventLog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_StartEventLog_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_StartEventLog_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_peer_connection_local_id{};
      int32_t p_output_period_ms{};
      PeerConnectionManager_StartEventLog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_peer_connection_local_id = input_data_view.peer_connection_local_id();
      if (success)
        p_output_period_ms = input_data_view.output_period_ms();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartEventLog(
std::move(p_peer_connection_local_id), 
std::move(p_output_period_ms));
      return true;
    }
    case internal::kPeerConnectionManager_StopEventLog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionManager::StopEventLog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionManager::StopEventLog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_StopEventLog_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_StopEventLog_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_peer_connection_local_id{};
      PeerConnectionManager_StopEventLog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_peer_connection_local_id = input_data_view.peer_connection_local_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopEventLog(
std::move(p_peer_connection_local_id));
      return true;
    }
    case internal::kPeerConnectionManager_GetStandardStats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionManager::GetStandardStats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionManager::GetStandardStats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_GetStandardStats_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_GetStandardStats_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PeerConnectionManager_GetStandardStats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStandardStats();
      return true;
    }
    case internal::kPeerConnectionManager_GetLegacyStats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionManager::GetLegacyStats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionManager::GetLegacyStats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_GetLegacyStats_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_GetLegacyStats_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PeerConnectionManager_GetLegacyStats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLegacyStats();
      return true;
    }
  }
  return false;
}

// static
bool PeerConnectionManagerStubDispatch::AcceptWithResponder(
    PeerConnectionManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPeerConnectionManager_OnSuspend_Name: {
      break;
    }
    case internal::kPeerConnectionManager_OnThermalStateChange_Name: {
      break;
    }
    case internal::kPeerConnectionManager_StartEventLog_Name: {
      break;
    }
    case internal::kPeerConnectionManager_StopEventLog_Name: {
      break;
    }
    case internal::kPeerConnectionManager_GetStandardStats_Name: {
      break;
    }
    case internal::kPeerConnectionManager_GetLegacyStats_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPeerConnectionManagerValidationInfo[] = {
    {&internal::PeerConnectionManager_OnSuspend_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionManager_OnThermalStateChange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionManager_StartEventLog_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionManager_StopEventLog_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionManager_GetStandardStats_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionManager_GetLegacyStats_Params_Data::Validate,
     nullptr /* no response */},
};

bool PeerConnectionManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PeerConnectionManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPeerConnectionManagerValidationInfo);
}

const char PeerConnectionTrackerHost::Name_[] = "blink.mojom.PeerConnectionTrackerHost";

PeerConnectionTrackerHostProxy::PeerConnectionTrackerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PeerConnectionTrackerHostProxy::AddPeerConnection(
    PeerConnectionInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionTrackerHost::AddPeerConnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info, 
                        "<value of type PeerConnectionInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionTrackerHost_AddPeerConnection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_AddPeerConnection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PeerConnectionInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in PeerConnectionTrackerHost.AddPeerConnection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("AddPeerConnection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionTrackerHostProxy::RemovePeerConnection(
    int32_t in_lid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionTrackerHost::RemovePeerConnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionTrackerHost_RemovePeerConnection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_RemovePeerConnection_Params_Data> params(
          message);
  params.Allocate();
  params->lid = in_lid;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("RemovePeerConnection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionTrackerHostProxy::UpdatePeerConnection(
    int32_t in_lid, const std::string& in_type, const std::string& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionTrackerHost::UpdatePeerConnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionTrackerHost_UpdatePeerConnection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data> params(
          message);
  params.Allocate();
  params->lid = in_lid;
  mojo::internal::MessageFragment<
      typename decltype(params->type)::BaseType> type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_type, type_fragment);
  params->type.Set(
      type_fragment.is_null() ? nullptr : type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null type in PeerConnectionTrackerHost.UpdatePeerConnection request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_value, value_fragment);
  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in PeerConnectionTrackerHost.UpdatePeerConnection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("UpdatePeerConnection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionTrackerHostProxy::OnPeerConnectionSessionIdSet(
    int32_t in_lid, const std::string& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionTrackerHost::OnPeerConnectionSessionIdSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data> params(
          message);
  params.Allocate();
  params->lid = in_lid;
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, session_id_fragment);
  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in PeerConnectionTrackerHost.OnPeerConnectionSessionIdSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("OnPeerConnectionSessionIdSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionTrackerHostProxy::GetUserMedia(
    const std::string& in_origin, bool in_audio, bool in_video, const std::string& in_audio_constraints, const std::string& in_video_constraints) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionTrackerHost::GetUserMedia", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio"), in_audio, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video"), in_video, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_constraints"), in_audio_constraints, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_constraints"), in_video_constraints, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionTrackerHost_GetUserMedia_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_GetUserMedia_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in PeerConnectionTrackerHost.GetUserMedia request");
  params->audio = in_audio;
  params->video = in_video;
  mojo::internal::MessageFragment<
      typename decltype(params->audio_constraints)::BaseType> audio_constraints_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_audio_constraints, audio_constraints_fragment);
  params->audio_constraints.Set(
      audio_constraints_fragment.is_null() ? nullptr : audio_constraints_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->audio_constraints.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio_constraints in PeerConnectionTrackerHost.GetUserMedia request");
  mojo::internal::MessageFragment<
      typename decltype(params->video_constraints)::BaseType> video_constraints_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_video_constraints, video_constraints_fragment);
  params->video_constraints.Set(
      video_constraints_fragment.is_null() ? nullptr : video_constraints_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->video_constraints.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null video_constraints in PeerConnectionTrackerHost.GetUserMedia request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("GetUserMedia");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionTrackerHostProxy::WebRtcEventLogWrite(
    int32_t in_lid, const std::vector<uint8_t>& in_output) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionTrackerHost::WebRtcEventLogWrite", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output"), in_output, 
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionTrackerHost_WebRtcEventLogWrite_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data> params(
          message);
  params.Allocate();
  params->lid = in_lid;
  mojo::internal::MessageFragment<
      typename decltype(params->output)::BaseType>
      output_fragment(params.message());
  const mojo::internal::ContainerValidateParams output_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_output, output_fragment, &output_validate_params);
  params->output.Set(
      output_fragment.is_null() ? nullptr : output_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->output.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output in PeerConnectionTrackerHost.WebRtcEventLogWrite request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("WebRtcEventLogWrite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionTrackerHostProxy::AddStandardStats(
    int32_t in_lid, ::base::Value in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionTrackerHost::AddStandardStats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value, 
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionTrackerHost_AddStandardStats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_AddStandardStats_Params_Data> params(
          message);
  params.Allocate();
  params->lid = in_lid;
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_value, value_fragment);
  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in PeerConnectionTrackerHost.AddStandardStats request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("AddStandardStats");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PeerConnectionTrackerHostProxy::AddLegacyStats(
    int32_t in_lid, ::base::Value in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeerConnectionTrackerHost::AddLegacyStats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value, 
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeerConnectionTrackerHost_AddLegacyStats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_AddLegacyStats_Params_Data> params(
          message);
  params.Allocate();
  params->lid = in_lid;
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_value, value_fragment);
  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in PeerConnectionTrackerHost.AddLegacyStats request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("AddLegacyStats");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PeerConnectionTrackerHostStubDispatch::Accept(
    PeerConnectionTrackerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPeerConnectionTrackerHost_AddPeerConnection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionTrackerHost::AddPeerConnection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionTrackerHost::AddPeerConnection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_AddPeerConnection_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_AddPeerConnection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PeerConnectionInfoPtr p_info{};
      PeerConnectionTrackerHost_AddPeerConnection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddPeerConnection(
std::move(p_info));
      return true;
    }
    case internal::kPeerConnectionTrackerHost_RemovePeerConnection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionTrackerHost::RemovePeerConnection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionTrackerHost::RemovePeerConnection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_RemovePeerConnection_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_RemovePeerConnection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_lid{};
      PeerConnectionTrackerHost_RemovePeerConnection_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemovePeerConnection(
std::move(p_lid));
      return true;
    }
    case internal::kPeerConnectionTrackerHost_UpdatePeerConnection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionTrackerHost::UpdatePeerConnection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionTrackerHost::UpdatePeerConnection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_lid{};
      std::string p_type{};
      std::string p_value{};
      PeerConnectionTrackerHost_UpdatePeerConnection_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePeerConnection(
std::move(p_lid), 
std::move(p_type), 
std::move(p_value));
      return true;
    }
    case internal::kPeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionTrackerHost::OnPeerConnectionSessionIdSet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionTrackerHost::OnPeerConnectionSessionIdSet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_lid{};
      std::string p_session_id{};
      PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPeerConnectionSessionIdSet(
std::move(p_lid), 
std::move(p_session_id));
      return true;
    }
    case internal::kPeerConnectionTrackerHost_GetUserMedia_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionTrackerHost::GetUserMedia",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionTrackerHost::GetUserMedia");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_GetUserMedia_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_GetUserMedia_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_origin{};
      bool p_audio{};
      bool p_video{};
      std::string p_audio_constraints{};
      std::string p_video_constraints{};
      PeerConnectionTrackerHost_GetUserMedia_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_audio = input_data_view.audio();
      if (success)
        p_video = input_data_view.video();
      if (success && !input_data_view.ReadAudioConstraints(&p_audio_constraints))
        success = false;
      if (success && !input_data_view.ReadVideoConstraints(&p_video_constraints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserMedia(
std::move(p_origin), 
std::move(p_audio), 
std::move(p_video), 
std::move(p_audio_constraints), 
std::move(p_video_constraints));
      return true;
    }
    case internal::kPeerConnectionTrackerHost_WebRtcEventLogWrite_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionTrackerHost::WebRtcEventLogWrite",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionTrackerHost::WebRtcEventLogWrite");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_lid{};
      std::vector<uint8_t> p_output{};
      PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (success && !input_data_view.ReadOutput(&p_output))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WebRtcEventLogWrite(
std::move(p_lid), 
std::move(p_output));
      return true;
    }
    case internal::kPeerConnectionTrackerHost_AddStandardStats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionTrackerHost::AddStandardStats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionTrackerHost::AddStandardStats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_AddStandardStats_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_AddStandardStats_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_lid{};
      ::base::Value p_value{};
      PeerConnectionTrackerHost_AddStandardStats_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddStandardStats(
std::move(p_lid), 
std::move(p_value));
      return true;
    }
    case internal::kPeerConnectionTrackerHost_AddLegacyStats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeerConnectionTrackerHost::AddLegacyStats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeerConnectionTrackerHost::AddLegacyStats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_AddLegacyStats_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_AddLegacyStats_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_lid{};
      ::base::Value p_value{};
      PeerConnectionTrackerHost_AddLegacyStats_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddLegacyStats(
std::move(p_lid), 
std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool PeerConnectionTrackerHostStubDispatch::AcceptWithResponder(
    PeerConnectionTrackerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPeerConnectionTrackerHost_AddPeerConnection_Name: {
      break;
    }
    case internal::kPeerConnectionTrackerHost_RemovePeerConnection_Name: {
      break;
    }
    case internal::kPeerConnectionTrackerHost_UpdatePeerConnection_Name: {
      break;
    }
    case internal::kPeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Name: {
      break;
    }
    case internal::kPeerConnectionTrackerHost_GetUserMedia_Name: {
      break;
    }
    case internal::kPeerConnectionTrackerHost_WebRtcEventLogWrite_Name: {
      break;
    }
    case internal::kPeerConnectionTrackerHost_AddStandardStats_Name: {
      break;
    }
    case internal::kPeerConnectionTrackerHost_AddLegacyStats_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPeerConnectionTrackerHostValidationInfo[] = {
    {&internal::PeerConnectionTrackerHost_AddPeerConnection_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionTrackerHost_RemovePeerConnection_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionTrackerHost_GetUserMedia_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionTrackerHost_AddStandardStats_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PeerConnectionTrackerHost_AddLegacyStats_Params_Data::Validate,
     nullptr /* no response */},
};

bool PeerConnectionTrackerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PeerConnectionTrackerHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPeerConnectionTrackerHostValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::PeerConnectionInfo::DataView, ::blink::mojom::PeerConnectionInfoPtr>::Read(
    ::blink::mojom::PeerConnectionInfo::DataView input,
    ::blink::mojom::PeerConnectionInfoPtr* output) {
  bool success = true;
  ::blink::mojom::PeerConnectionInfoPtr result(::blink::mojom::PeerConnectionInfo::New());
  
      if (success)
        result->lid = input.lid();
      if (success && !input.ReadRtcConfiguration(&result->rtc_configuration))
        success = false;
      if (success && !input.ReadConstraints(&result->constraints))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif