// third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string V8DetailedMemoryReporter_ModeToString(V8DetailedMemoryReporter_Mode value) {
  switch(value) {
    case V8DetailedMemoryReporter_Mode::DEFAULT:
      return "V8DetailedMemoryReporter_Mode::DEFAULT";
    case V8DetailedMemoryReporter_Mode::EAGER:
      return "V8DetailedMemoryReporter_Mode::EAGER";
    case V8DetailedMemoryReporter_Mode::LAZY:
      return "V8DetailedMemoryReporter_Mode::LAZY";
    default:
      return base::StringPrintf("Unknown V8DetailedMemoryReporter_Mode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, V8DetailedMemoryReporter_Mode value) {
  return os << V8DetailedMemoryReporter_ModeToString(value);
}

namespace internal {


// static
bool PerContextV8MemoryUsage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PerContextV8MemoryUsage_Data* object = static_cast<const PerContextV8MemoryUsage_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->token, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  return true;
}

PerContextV8MemoryUsage_Data::PerContextV8MemoryUsage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PerIsolateV8MemoryUsage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PerIsolateV8MemoryUsage_Data* object = static_cast<const PerIsolateV8MemoryUsage_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contexts, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams contexts_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->contexts, validation_context,
                                         &contexts_validate_params)) {
    return false;
  }

  return true;
}

PerIsolateV8MemoryUsage_Data::PerIsolateV8MemoryUsage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PerProcessV8MemoryUsage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PerProcessV8MemoryUsage_Data* object = static_cast<const PerProcessV8MemoryUsage_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolates, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams isolates_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->isolates, validation_context,
                                         &isolates_validate_params)) {
    return false;
  }

  return true;
}

PerProcessV8MemoryUsage_Data::PerProcessV8MemoryUsage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data* object = static_cast<const V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::V8DetailedMemoryReporter_Mode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data::V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data* object = static_cast<const V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->memory_usage, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->memory_usage, validation_context))
    return false;

  return true;
}

V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data::V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::V8DetailedMemoryReporter_Mode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::V8DetailedMemoryReporter_Mode value) {
  return std::move(context).WriteString(::blink::mojom::V8DetailedMemoryReporter_ModeToString(value));
}

} // namespace perfetto
