// third_party/blink/public/mojom/prerender/prerender.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/prerender/prerender.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/prerender/prerender.mojom-params-data.h"
#include "third_party/blink/public/mojom/prerender/prerender.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/prerender/prerender.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
PrerenderAttributes::PrerenderAttributes()
    : url(),
      rel_type(),
      referrer(),
      view_size() {}

PrerenderAttributes::PrerenderAttributes(
    const ::blink::KURL& url_in,
    PrerenderRelType rel_type_in,
    ::blink::mojom::blink::ReferrerPtr referrer_in,
    const ::gfx::Size& view_size_in)
    : url(std::move(url_in)),
      rel_type(std::move(rel_type_in)),
      referrer(std::move(referrer_in)),
      view_size(std::move(view_size_in)) {}

PrerenderAttributes::~PrerenderAttributes() = default;

void PrerenderAttributes::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url, 
      "<value of type const ::blink::KURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rel_type"), this->rel_type, 
      "<value of type PrerenderRelType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer, 
      "<value of type ::blink::mojom::blink::ReferrerPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_size"), this->view_size, 
      "<value of type const ::gfx::Size&>");
}

bool PrerenderAttributes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char NoStatePrefetchProcessor::Name_[] = "blink.mojom.NoStatePrefetchProcessor";

NoStatePrefetchProcessorProxy::NoStatePrefetchProcessorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NoStatePrefetchProcessorProxy::Start(
    PrerenderAttributesPtr in_prerender_attribute) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NoStatePrefetchProcessor::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prerender_attribute"), in_prerender_attribute, 
                        "<value of type PrerenderAttributesPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNoStatePrefetchProcessor_Start_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NoStatePrefetchProcessor_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prerender_attribute)::BaseType> prerender_attribute_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PrerenderAttributesDataView>(
      in_prerender_attribute, prerender_attribute_fragment);
  params->prerender_attribute.Set(
      prerender_attribute_fragment.is_null() ? nullptr : prerender_attribute_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->prerender_attribute.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null prerender_attribute in NoStatePrefetchProcessor.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NoStatePrefetchProcessor::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NoStatePrefetchProcessorProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::NoStatePrefetchProcessor::Cancel");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNoStatePrefetchProcessor_Cancel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NoStatePrefetchProcessor_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NoStatePrefetchProcessor::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NoStatePrefetchProcessorStubDispatch::Accept(
    NoStatePrefetchProcessor* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNoStatePrefetchProcessor_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NoStatePrefetchProcessor::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NoStatePrefetchProcessor::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NoStatePrefetchProcessor_Start_Params_Data* params =
          reinterpret_cast<internal::NoStatePrefetchProcessor_Start_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrerenderAttributesPtr p_prerender_attribute{};
      NoStatePrefetchProcessor_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrerenderAttribute(&p_prerender_attribute))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NoStatePrefetchProcessor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(
std::move(p_prerender_attribute));
      return true;
    }
    case internal::kNoStatePrefetchProcessor_Cancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NoStatePrefetchProcessor::Cancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NoStatePrefetchProcessor::Cancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NoStatePrefetchProcessor_Cancel_Params_Data* params =
          reinterpret_cast<internal::NoStatePrefetchProcessor_Cancel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NoStatePrefetchProcessor_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NoStatePrefetchProcessor::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel();
      return true;
    }
  }
  return false;
}

// static
bool NoStatePrefetchProcessorStubDispatch::AcceptWithResponder(
    NoStatePrefetchProcessor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNoStatePrefetchProcessor_Start_Name: {
      break;
    }
    case internal::kNoStatePrefetchProcessor_Cancel_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNoStatePrefetchProcessorValidationInfo[] = {
    {&internal::NoStatePrefetchProcessor_Start_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::NoStatePrefetchProcessor_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool NoStatePrefetchProcessorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NoStatePrefetchProcessor::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNoStatePrefetchProcessorValidationInfo);
}

const char PrerenderProcessor::Name_[] = "blink.mojom.PrerenderProcessor";

PrerenderProcessorProxy::PrerenderProcessorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrerenderProcessorProxy::Start(
    PrerenderAttributesPtr in_prerender_attribute) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PrerenderProcessor::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prerender_attribute"), in_prerender_attribute, 
                        "<value of type PrerenderAttributesPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrerenderProcessor_Start_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PrerenderProcessor_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prerender_attribute)::BaseType> prerender_attribute_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PrerenderAttributesDataView>(
      in_prerender_attribute, prerender_attribute_fragment);
  params->prerender_attribute.Set(
      prerender_attribute_fragment.is_null() ? nullptr : prerender_attribute_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->prerender_attribute.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null prerender_attribute in PrerenderProcessor.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrerenderProcessor::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrerenderProcessorProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PrerenderProcessor::Cancel");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrerenderProcessor_Cancel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PrerenderProcessor_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrerenderProcessor::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PrerenderProcessorStubDispatch::Accept(
    PrerenderProcessor* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPrerenderProcessor_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PrerenderProcessor::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PrerenderProcessor::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrerenderProcessor_Start_Params_Data* params =
          reinterpret_cast<internal::PrerenderProcessor_Start_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrerenderAttributesPtr p_prerender_attribute{};
      PrerenderProcessor_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrerenderAttribute(&p_prerender_attribute))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrerenderProcessor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(
std::move(p_prerender_attribute));
      return true;
    }
    case internal::kPrerenderProcessor_Cancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PrerenderProcessor::Cancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PrerenderProcessor::Cancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrerenderProcessor_Cancel_Params_Data* params =
          reinterpret_cast<internal::PrerenderProcessor_Cancel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrerenderProcessor_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrerenderProcessor::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel();
      return true;
    }
  }
  return false;
}

// static
bool PrerenderProcessorStubDispatch::AcceptWithResponder(
    PrerenderProcessor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPrerenderProcessor_Start_Name: {
      break;
    }
    case internal::kPrerenderProcessor_Cancel_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPrerenderProcessorValidationInfo[] = {
    {&internal::PrerenderProcessor_Start_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PrerenderProcessor_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool PrerenderProcessorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PrerenderProcessor::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPrerenderProcessorValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::PrerenderAttributes::DataView, ::blink::mojom::blink::PrerenderAttributesPtr>::Read(
    ::blink::mojom::blink::PrerenderAttributes::DataView input,
    ::blink::mojom::blink::PrerenderAttributesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PrerenderAttributesPtr result(::blink::mojom::blink::PrerenderAttributes::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadRelType(&result->rel_type))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadViewSize(&result->view_size))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif