// third_party/blink/public/mojom/push_messaging/push_messaging_status.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/push_messaging/push_messaging_status.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/push_messaging/push_messaging_status.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string PushEventStatusToString(PushEventStatus value) {
  switch(value) {
    case PushEventStatus::SUCCESS:
      return "PushEventStatus::SUCCESS";
    case PushEventStatus::UNKNOWN_APP_ID:
      return "PushEventStatus::UNKNOWN_APP_ID";
    case PushEventStatus::PERMISSION_DENIED:
      return "PushEventStatus::PERMISSION_DENIED";
    case PushEventStatus::NO_SERVICE_WORKER:
      return "PushEventStatus::NO_SERVICE_WORKER";
    case PushEventStatus::SERVICE_WORKER_ERROR:
      return "PushEventStatus::SERVICE_WORKER_ERROR";
    case PushEventStatus::EVENT_WAITUNTIL_REJECTED:
      return "PushEventStatus::EVENT_WAITUNTIL_REJECTED";
    case PushEventStatus::TIMEOUT:
      return "PushEventStatus::TIMEOUT";
    case PushEventStatus::PERMISSION_REVOKED_ABUSIVE:
      return "PushEventStatus::PERMISSION_REVOKED_ABUSIVE";
    default:
      return base::StringPrintf("Unknown PushEventStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PushEventStatus value) {
  return os << PushEventStatusToString(value);
}

std::string PushGetRegistrationStatusToString(PushGetRegistrationStatus value) {
  switch(value) {
    case PushGetRegistrationStatus::SUCCESS:
      return "PushGetRegistrationStatus::SUCCESS";
    case PushGetRegistrationStatus::SERVICE_NOT_AVAILABLE:
      return "PushGetRegistrationStatus::SERVICE_NOT_AVAILABLE";
    case PushGetRegistrationStatus::STORAGE_ERROR:
      return "PushGetRegistrationStatus::STORAGE_ERROR";
    case PushGetRegistrationStatus::REGISTRATION_NOT_FOUND:
      return "PushGetRegistrationStatus::REGISTRATION_NOT_FOUND";
    case PushGetRegistrationStatus::INCOGNITO_REGISTRATION_NOT_FOUND:
      return "PushGetRegistrationStatus::INCOGNITO_REGISTRATION_NOT_FOUND";
    case PushGetRegistrationStatus::STORAGE_CORRUPT:
      return "PushGetRegistrationStatus::STORAGE_CORRUPT";
    case PushGetRegistrationStatus::RENDERER_SHUTDOWN:
      return "PushGetRegistrationStatus::RENDERER_SHUTDOWN";
    case PushGetRegistrationStatus::NO_LIVE_SERVICE_WORKER:
      return "PushGetRegistrationStatus::NO_LIVE_SERVICE_WORKER";
    default:
      return base::StringPrintf("Unknown PushGetRegistrationStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PushGetRegistrationStatus value) {
  return os << PushGetRegistrationStatusToString(value);
}

std::string PushRegistrationStatusToString(PushRegistrationStatus value) {
  switch(value) {
    case PushRegistrationStatus::SUCCESS_FROM_PUSH_SERVICE:
      return "PushRegistrationStatus::SUCCESS_FROM_PUSH_SERVICE";
    case PushRegistrationStatus::NO_SERVICE_WORKER:
      return "PushRegistrationStatus::NO_SERVICE_WORKER";
    case PushRegistrationStatus::SERVICE_NOT_AVAILABLE:
      return "PushRegistrationStatus::SERVICE_NOT_AVAILABLE";
    case PushRegistrationStatus::LIMIT_REACHED:
      return "PushRegistrationStatus::LIMIT_REACHED";
    case PushRegistrationStatus::PERMISSION_DENIED:
      return "PushRegistrationStatus::PERMISSION_DENIED";
    case PushRegistrationStatus::SERVICE_ERROR:
      return "PushRegistrationStatus::SERVICE_ERROR";
    case PushRegistrationStatus::NO_SENDER_ID:
      return "PushRegistrationStatus::NO_SENDER_ID";
    case PushRegistrationStatus::STORAGE_ERROR:
      return "PushRegistrationStatus::STORAGE_ERROR";
    case PushRegistrationStatus::SUCCESS_FROM_CACHE:
      return "PushRegistrationStatus::SUCCESS_FROM_CACHE";
    case PushRegistrationStatus::NETWORK_ERROR:
      return "PushRegistrationStatus::NETWORK_ERROR";
    case PushRegistrationStatus::INCOGNITO_PERMISSION_DENIED:
      return "PushRegistrationStatus::INCOGNITO_PERMISSION_DENIED";
    case PushRegistrationStatus::PUBLIC_KEY_UNAVAILABLE:
      return "PushRegistrationStatus::PUBLIC_KEY_UNAVAILABLE";
    case PushRegistrationStatus::MANIFEST_EMPTY_OR_MISSING:
      return "PushRegistrationStatus::MANIFEST_EMPTY_OR_MISSING";
    case PushRegistrationStatus::SENDER_ID_MISMATCH:
      return "PushRegistrationStatus::SENDER_ID_MISMATCH";
    case PushRegistrationStatus::STORAGE_CORRUPT:
      return "PushRegistrationStatus::STORAGE_CORRUPT";
    case PushRegistrationStatus::RENDERER_SHUTDOWN:
      return "PushRegistrationStatus::RENDERER_SHUTDOWN";
    case PushRegistrationStatus::SUCCESS_NEW_SUBSCRIPTION_FROM_PUSH_SERVICE:
      return "PushRegistrationStatus::SUCCESS_NEW_SUBSCRIPTION_FROM_PUSH_SERVICE";
    case PushRegistrationStatus::UNSUPPORTED_GCM_SENDER_ID:
      return "PushRegistrationStatus::UNSUPPORTED_GCM_SENDER_ID";
    default:
      return base::StringPrintf("Unknown PushRegistrationStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PushRegistrationStatus value) {
  return os << PushRegistrationStatusToString(value);
}

std::string PushUnregistrationReasonToString(PushUnregistrationReason value) {
  switch(value) {
    case PushUnregistrationReason::UNKNOWN:
      return "PushUnregistrationReason::UNKNOWN";
    case PushUnregistrationReason::JAVASCRIPT_API:
      return "PushUnregistrationReason::JAVASCRIPT_API";
    case PushUnregistrationReason::PERMISSION_REVOKED:
      return "PushUnregistrationReason::PERMISSION_REVOKED";
    case PushUnregistrationReason::DELIVERY_UNKNOWN_APP_ID:
      return "PushUnregistrationReason::DELIVERY_UNKNOWN_APP_ID";
    case PushUnregistrationReason::DELIVERY_PERMISSION_DENIED:
      return "PushUnregistrationReason::DELIVERY_PERMISSION_DENIED";
    case PushUnregistrationReason::DELIVERY_NO_SERVICE_WORKER:
      return "PushUnregistrationReason::DELIVERY_NO_SERVICE_WORKER";
    case PushUnregistrationReason::GCM_STORE_RESET:
      return "PushUnregistrationReason::GCM_STORE_RESET";
    case PushUnregistrationReason::SERVICE_WORKER_UNREGISTERED:
      return "PushUnregistrationReason::SERVICE_WORKER_UNREGISTERED";
    case PushUnregistrationReason::SUBSCRIBE_STORAGE_CORRUPT:
      return "PushUnregistrationReason::SUBSCRIBE_STORAGE_CORRUPT";
    case PushUnregistrationReason::GET_SUBSCRIPTION_STORAGE_CORRUPT:
      return "PushUnregistrationReason::GET_SUBSCRIPTION_STORAGE_CORRUPT";
    case PushUnregistrationReason::SERVICE_WORKER_DATABASE_WIPED:
      return "PushUnregistrationReason::SERVICE_WORKER_DATABASE_WIPED";
    case PushUnregistrationReason::SUBSCRIPTION_EXPIRED:
      return "PushUnregistrationReason::SUBSCRIPTION_EXPIRED";
    case PushUnregistrationReason::REFRESH_FINISHED:
      return "PushUnregistrationReason::REFRESH_FINISHED";
    case PushUnregistrationReason::PERMISSION_REVOKED_ABUSIVE:
      return "PushUnregistrationReason::PERMISSION_REVOKED_ABUSIVE";
    default:
      return base::StringPrintf("Unknown PushUnregistrationReason value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PushUnregistrationReason value) {
  return os << PushUnregistrationReasonToString(value);
}

std::string PushUnregistrationStatusToString(PushUnregistrationStatus value) {
  switch(value) {
    case PushUnregistrationStatus::SUCCESS_UNREGISTERED:
      return "PushUnregistrationStatus::SUCCESS_UNREGISTERED";
    case PushUnregistrationStatus::SUCCESS_WAS_NOT_REGISTERED:
      return "PushUnregistrationStatus::SUCCESS_WAS_NOT_REGISTERED";
    case PushUnregistrationStatus::PENDING_NETWORK_ERROR:
      return "PushUnregistrationStatus::PENDING_NETWORK_ERROR";
    case PushUnregistrationStatus::NO_SERVICE_WORKER:
      return "PushUnregistrationStatus::NO_SERVICE_WORKER";
    case PushUnregistrationStatus::SERVICE_NOT_AVAILABLE:
      return "PushUnregistrationStatus::SERVICE_NOT_AVAILABLE";
    case PushUnregistrationStatus::PENDING_SERVICE_ERROR:
      return "PushUnregistrationStatus::PENDING_SERVICE_ERROR";
    case PushUnregistrationStatus::STORAGE_ERROR:
      return "PushUnregistrationStatus::STORAGE_ERROR";
    case PushUnregistrationStatus::NETWORK_ERROR:
      return "PushUnregistrationStatus::NETWORK_ERROR";
    default:
      return base::StringPrintf("Unknown PushUnregistrationStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PushUnregistrationStatus value) {
  return os << PushUnregistrationStatusToString(value);
}

std::string PushUserVisibleStatusToString(PushUserVisibleStatus value) {
  switch(value) {
    case PushUserVisibleStatus::REQUIRED_AND_SHOWN:
      return "PushUserVisibleStatus::REQUIRED_AND_SHOWN";
    case PushUserVisibleStatus::NOT_REQUIRED_BUT_SHOWN:
      return "PushUserVisibleStatus::NOT_REQUIRED_BUT_SHOWN";
    case PushUserVisibleStatus::NOT_REQUIRED_AND_NOT_SHOWN:
      return "PushUserVisibleStatus::NOT_REQUIRED_AND_NOT_SHOWN";
    case PushUserVisibleStatus::REQUIRED_BUT_NOT_SHOWN_USED_GRACE:
      return "PushUserVisibleStatus::REQUIRED_BUT_NOT_SHOWN_USED_GRACE";
    case PushUserVisibleStatus::REQUIRED_BUT_NOT_SHOWN_GRACE_EXCEEDED:
      return "PushUserVisibleStatus::REQUIRED_BUT_NOT_SHOWN_GRACE_EXCEEDED";
    default:
      return base::StringPrintf("Unknown PushUserVisibleStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PushUserVisibleStatus value) {
  return os << PushUserVisibleStatusToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PushEventStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::PushEventStatus value) {
  return std::move(context).WriteString(::blink::mojom::PushEventStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PushGetRegistrationStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::PushGetRegistrationStatus value) {
  return std::move(context).WriteString(::blink::mojom::PushGetRegistrationStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PushRegistrationStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::PushRegistrationStatus value) {
  return std::move(context).WriteString(::blink::mojom::PushRegistrationStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PushUnregistrationReason>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::PushUnregistrationReason value) {
  return std::move(context).WriteString(::blink::mojom::PushUnregistrationReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PushUnregistrationStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::PushUnregistrationStatus value) {
  return std::move(context).WriteString(::blink::mojom::PushUnregistrationStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PushUserVisibleStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::PushUserVisibleStatus value) {
  return std::move(context).WriteString(::blink::mojom::PushUserVisibleStatusToString(value));
}

} // namespace perfetto
