// third_party/blink/public/mojom/quota/quota_manager_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/quota/quota_manager_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/quota/quota_manager_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/quota/quota_manager_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/quota/quota_manager_host.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_QUOTA_QUOTA_MANAGER_HOST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_QUOTA_QUOTA_MANAGER_HOST_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char QuotaChangeListener::Name_[] = "blink.mojom.QuotaChangeListener";

QuotaChangeListenerProxy::QuotaChangeListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuotaChangeListenerProxy::OnQuotaChange(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::QuotaChangeListener::OnQuotaChange");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaChangeListener_OnQuotaChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::QuotaChangeListener_OnQuotaChange_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaChangeListener::Name_);
  message.set_method_name("OnQuotaChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool QuotaChangeListenerStubDispatch::Accept(
    QuotaChangeListener* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kQuotaChangeListener_OnQuotaChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::QuotaChangeListener::OnQuotaChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::QuotaChangeListener::OnQuotaChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::QuotaChangeListener_OnQuotaChange_Params_Data* params =
          reinterpret_cast<internal::QuotaChangeListener_OnQuotaChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      QuotaChangeListener_OnQuotaChange_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaChangeListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnQuotaChange();
      return true;
    }
  }
  return false;
}

// static
bool QuotaChangeListenerStubDispatch::AcceptWithResponder(
    QuotaChangeListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kQuotaChangeListener_OnQuotaChange_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kQuotaChangeListenerValidationInfo[] = {
    {&internal::QuotaChangeListener_OnQuotaChange_Params_Data::Validate,
     nullptr /* no response */},
};

bool QuotaChangeListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::QuotaChangeListener::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kQuotaChangeListenerValidationInfo);
}

const char QuotaManagerHost::Name_[] = "blink.mojom.QuotaManagerHost";

class QuotaManagerHost_AddChangeListener_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaManagerHost_AddChangeListener_ForwardToCallback(
      QuotaManagerHost::AddChangeListenerCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaManagerHost::AddChangeListenerCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaManagerHost_AddChangeListener_ForwardToCallback);
};

class QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback(
      QuotaManagerHost::QueryStorageUsageAndQuotaCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaManagerHost::QueryStorageUsageAndQuotaCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback);
};

class QuotaManagerHost_RequestStorageQuota_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaManagerHost_RequestStorageQuota_ForwardToCallback(
      QuotaManagerHost::RequestStorageQuotaCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaManagerHost::RequestStorageQuotaCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaManagerHost_RequestStorageQuota_ForwardToCallback);
};

QuotaManagerHostProxy::QuotaManagerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuotaManagerHostProxy::AddChangeListener(
    ::mojo::PendingRemote<QuotaChangeListener> in_listener, AddChangeListenerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::QuotaManagerHost::AddChangeListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener, 
                        "<value of type ::mojo::PendingRemote<QuotaChangeListener>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaManagerHost_AddChangeListener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::QuotaManagerHost_AddChangeListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::QuotaChangeListenerInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in QuotaManagerHost.AddChangeListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaManagerHost::Name_);
  message.set_method_name("AddChangeListener");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaManagerHost_AddChangeListener_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuotaManagerHostProxy::QueryStorageUsageAndQuota(
    ::blink::mojom::StorageType in_storage_type, QueryStorageUsageAndQuotaCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuota", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_type"), in_storage_type, 
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaManagerHost_QueryStorageUsageAndQuota_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::QuotaManagerHost_QueryStorageUsageAndQuota_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_storage_type, &params->storage_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaManagerHost::Name_);
  message.set_method_name("QueryStorageUsageAndQuota");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuotaManagerHostProxy::RequestStorageQuota(
    ::blink::mojom::StorageType in_storage_type, uint64_t in_requested_size, RequestStorageQuotaCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::QuotaManagerHost::RequestStorageQuota", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_type"), in_storage_type, 
                        "<value of type ::blink::mojom::StorageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_size"), in_requested_size, 
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaManagerHost_RequestStorageQuota_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::QuotaManagerHost_RequestStorageQuota_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_storage_type, &params->storage_type);
  params->requested_size = in_requested_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaManagerHost::Name_);
  message.set_method_name("RequestStorageQuota");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaManagerHost_RequestStorageQuota_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class QuotaManagerHost_AddChangeListener_ProxyToResponder {
 public:
  static QuotaManagerHost::AddChangeListenerCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaManagerHost_AddChangeListener_ProxyToResponder> proxy(
        new QuotaManagerHost_AddChangeListener_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaManagerHost_AddChangeListener_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaManagerHost_AddChangeListener_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaManagerHost_AddChangeListener_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaManagerHost::AddChangeListenerCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaManagerHost_AddChangeListener_ProxyToResponder);
};

bool QuotaManagerHost_AddChangeListener_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::QuotaManagerHost::AddChangeListenerCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaManagerHost_AddChangeListener_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaManagerHost_AddChangeListener_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  QuotaManagerHost_AddChangeListener_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaManagerHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void QuotaManagerHost_AddChangeListener_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::QuotaManagerHost::AddChangeListenerCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaManagerHost_AddChangeListener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::QuotaManagerHost_AddChangeListener_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::QuotaManagerHost::AddChangeListenerCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaManagerHost::Name_);
  message.set_method_name("AddChangeListener");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder {
 public:
  static QuotaManagerHost::QueryStorageUsageAndQuotaCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder> proxy(
        new QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaManagerHost::QueryStorageUsageAndQuotaCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::QuotaStatusCode in_error, int64_t in_current_usage, int64_t in_current_quota, ::blink::mojom::UsageBreakdownPtr in_usage_breakdown);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder);
};

bool QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuotaCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::QuotaStatusCode p_error{};
  int64_t p_current_usage{};
  int64_t p_current_quota{};
  ::blink::mojom::UsageBreakdownPtr p_usage_breakdown{};
  QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_current_usage = input_data_view.current_usage();
  if (success)
    p_current_quota = input_data_view.current_quota();
  if (success && !input_data_view.ReadUsageBreakdown(&p_usage_breakdown))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaManagerHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_current_usage), 
std::move(p_current_quota), 
std::move(p_usage_breakdown));
  return true;
}

void QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder::Run(
    ::blink::mojom::QuotaStatusCode in_error, int64_t in_current_usage, int64_t in_current_quota, ::blink::mojom::UsageBreakdownPtr in_usage_breakdown) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuotaCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type ::blink::mojom::QuotaStatusCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_usage"), in_current_usage, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_quota"), in_current_quota, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage_breakdown"), in_usage_breakdown, 
                        "<value of type ::blink::mojom::UsageBreakdownPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaManagerHost_QueryStorageUsageAndQuota_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::QuotaStatusCode>(
      in_error, &params->error);
  params->current_usage = in_current_usage;
  params->current_quota = in_current_quota;
  mojo::internal::MessageFragment<
      typename decltype(params->usage_breakdown)::BaseType> usage_breakdown_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::UsageBreakdownDataView>(
      in_usage_breakdown, usage_breakdown_fragment);
  params->usage_breakdown.Set(
      usage_breakdown_fragment.is_null() ? nullptr : usage_breakdown_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->usage_breakdown.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null usage_breakdown in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuotaCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaManagerHost::Name_);
  message.set_method_name("QueryStorageUsageAndQuota");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaManagerHost_RequestStorageQuota_ProxyToResponder {
 public:
  static QuotaManagerHost::RequestStorageQuotaCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaManagerHost_RequestStorageQuota_ProxyToResponder> proxy(
        new QuotaManagerHost_RequestStorageQuota_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaManagerHost_RequestStorageQuota_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaManagerHost_RequestStorageQuota_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaManagerHost_RequestStorageQuota_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaManagerHost::RequestStorageQuotaCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::QuotaStatusCode in_error, int64_t in_current_usage, int64_t in_granted_quota);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaManagerHost_RequestStorageQuota_ProxyToResponder);
};

bool QuotaManagerHost_RequestStorageQuota_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::QuotaManagerHost::RequestStorageQuotaCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaManagerHost_RequestStorageQuota_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaManagerHost_RequestStorageQuota_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::QuotaStatusCode p_error{};
  int64_t p_current_usage{};
  int64_t p_granted_quota{};
  QuotaManagerHost_RequestStorageQuota_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_current_usage = input_data_view.current_usage();
  if (success)
    p_granted_quota = input_data_view.granted_quota();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaManagerHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_current_usage), 
std::move(p_granted_quota));
  return true;
}

void QuotaManagerHost_RequestStorageQuota_ProxyToResponder::Run(
    ::blink::mojom::QuotaStatusCode in_error, int64_t in_current_usage, int64_t in_granted_quota) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::QuotaManagerHost::RequestStorageQuotaCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type ::blink::mojom::QuotaStatusCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_usage"), in_current_usage, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted_quota"), in_granted_quota, 
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaManagerHost_RequestStorageQuota_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::QuotaManagerHost_RequestStorageQuota_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::QuotaStatusCode>(
      in_error, &params->error);
  params->current_usage = in_current_usage;
  params->granted_quota = in_granted_quota;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::QuotaManagerHost::RequestStorageQuotaCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaManagerHost::Name_);
  message.set_method_name("RequestStorageQuota");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool QuotaManagerHostStubDispatch::Accept(
    QuotaManagerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kQuotaManagerHost_AddChangeListener_Name: {
      break;
    }
    case internal::kQuotaManagerHost_QueryStorageUsageAndQuota_Name: {
      break;
    }
    case internal::kQuotaManagerHost_RequestStorageQuota_Name: {
      break;
    }
  }
  return false;
}

// static
bool QuotaManagerHostStubDispatch::AcceptWithResponder(
    QuotaManagerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kQuotaManagerHost_AddChangeListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::QuotaManagerHost::AddChangeListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::QuotaManagerHost::AddChangeListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaManagerHost_AddChangeListener_Params_Data* params =
          reinterpret_cast<
              internal::QuotaManagerHost_AddChangeListener_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<QuotaChangeListener> p_listener{};
      QuotaManagerHost_AddChangeListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaManagerHost::Name_, 0, false);
        return false;
      }
      QuotaManagerHost::AddChangeListenerCallback callback =
          QuotaManagerHost_AddChangeListener_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddChangeListener(
std::move(p_listener), std::move(callback));
      return true;
    }
    case internal::kQuotaManagerHost_QueryStorageUsageAndQuota_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuota",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuota");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaManagerHost_QueryStorageUsageAndQuota_Params_Data* params =
          reinterpret_cast<
              internal::QuotaManagerHost_QueryStorageUsageAndQuota_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::StorageType p_storage_type{};
      QuotaManagerHost_QueryStorageUsageAndQuota_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageType(&p_storage_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaManagerHost::Name_, 1, false);
        return false;
      }
      QuotaManagerHost::QueryStorageUsageAndQuotaCallback callback =
          QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryStorageUsageAndQuota(
std::move(p_storage_type), std::move(callback));
      return true;
    }
    case internal::kQuotaManagerHost_RequestStorageQuota_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::QuotaManagerHost::RequestStorageQuota",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::QuotaManagerHost::RequestStorageQuota");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaManagerHost_RequestStorageQuota_Params_Data* params =
          reinterpret_cast<
              internal::QuotaManagerHost_RequestStorageQuota_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::StorageType p_storage_type{};
      uint64_t p_requested_size{};
      QuotaManagerHost_RequestStorageQuota_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageType(&p_storage_type))
        success = false;
      if (success)
        p_requested_size = input_data_view.requested_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaManagerHost::Name_, 2, false);
        return false;
      }
      QuotaManagerHost::RequestStorageQuotaCallback callback =
          QuotaManagerHost_RequestStorageQuota_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestStorageQuota(
std::move(p_storage_type), 
std::move(p_requested_size), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kQuotaManagerHostValidationInfo[] = {
    {&internal::QuotaManagerHost_AddChangeListener_Params_Data::Validate,
     &internal::QuotaManagerHost_AddChangeListener_ResponseParams_Data::Validate},
    {&internal::QuotaManagerHost_QueryStorageUsageAndQuota_Params_Data::Validate,
     &internal::QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams_Data::Validate},
    {&internal::QuotaManagerHost_RequestStorageQuota_Params_Data::Validate,
     &internal::QuotaManagerHost_RequestStorageQuota_ResponseParams_Data::Validate},
};

bool QuotaManagerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::QuotaManagerHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kQuotaManagerHostValidationInfo);
}

bool QuotaManagerHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::QuotaManagerHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kQuotaManagerHostValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif