// third_party/blink/public/mojom/quota/quota_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/quota/quota_types.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/quota/quota_types.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string StorageTypeToString(StorageType value) {
  switch(value) {
    case StorageType::kTemporary:
      return "StorageType::kTemporary";
    case StorageType::kPersistent:
      return "StorageType::kPersistent";
    case StorageType::kSyncable:
      return "StorageType::kSyncable";
    case StorageType::kQuotaNotManaged:
      return "StorageType::kQuotaNotManaged";
    case StorageType::kUnknown:
      return "StorageType::kUnknown";
    default:
      return base::StringPrintf("Unknown StorageType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, StorageType value) {
  return os << StorageTypeToString(value);
}

std::string QuotaStatusCodeToString(QuotaStatusCode value) {
  switch(value) {
    case QuotaStatusCode::kUnknown:
      return "QuotaStatusCode::kUnknown";
    case QuotaStatusCode::kOk:
      return "QuotaStatusCode::kOk";
    case QuotaStatusCode::kErrorNotSupported:
      return "QuotaStatusCode::kErrorNotSupported";
    case QuotaStatusCode::kErrorInvalidModification:
      return "QuotaStatusCode::kErrorInvalidModification";
    case QuotaStatusCode::kErrorInvalidAccess:
      return "QuotaStatusCode::kErrorInvalidAccess";
    case QuotaStatusCode::kErrorAbort:
      return "QuotaStatusCode::kErrorAbort";
    default:
      return base::StringPrintf("Unknown QuotaStatusCode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, QuotaStatusCode value) {
  return os << QuotaStatusCodeToString(value);
}

namespace internal {


// static
bool UsageBreakdown_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsageBreakdown_Data* object = static_cast<const UsageBreakdown_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsageBreakdown_Data::UsageBreakdown_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::StorageType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::StorageType value) {
  return std::move(context).WriteString(::blink::mojom::StorageTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::QuotaStatusCode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::QuotaStatusCode value) {
  return std::move(context).WriteString(::blink::mojom::QuotaStatusCodeToString(value));
}

} // namespace perfetto
