// third_party/blink/public/mojom/reporting/reporting.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/reporting/reporting.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/reporting/reporting.mojom-params-data.h"
#include "third_party/blink/public/mojom/reporting/reporting.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/reporting/reporting.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_REPORTING_REPORTING_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_REPORTING_REPORTING_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char ReportingServiceProxy::Name_[] = "blink.mojom.ReportingServiceProxy";

ReportingServiceProxyProxy::ReportingServiceProxyProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ReportingServiceProxyProxy::QueueInterventionReport(
    const ::blink::KURL& in_url, const WTF::String& in_id, const WTF::String& in_message, const WTF::String& in_source_file, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ReportingServiceProxy::QueueInterventionReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kReportingServiceProxy_QueueInterventionReport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueInterventionReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ReportingServiceProxy.QueueInterventionReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ReportingServiceProxy.QueueInterventionReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ReportingServiceProxy.QueueInterventionReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source_file, source_file_fragment);
  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());
  params->line_number = in_line_number;
  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueInterventionReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ReportingServiceProxyProxy::QueueDeprecationReport(
    const ::blink::KURL& in_url, const WTF::String& in_id, base::Optional<::base::Time> in_anticipatedRemoval, const WTF::String& in_message, const WTF::String& in_source_file, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ReportingServiceProxy::QueueDeprecationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anticipatedRemoval"), in_anticipatedRemoval, 
                        "<value of type base::Optional<::base::Time>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kReportingServiceProxy_QueueDeprecationReport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueDeprecationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ReportingServiceProxy.QueueDeprecationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ReportingServiceProxy.QueueDeprecationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->anticipatedRemoval)::BaseType> anticipatedRemoval_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_anticipatedRemoval, anticipatedRemoval_fragment);
  params->anticipatedRemoval.Set(
      anticipatedRemoval_fragment.is_null() ? nullptr : anticipatedRemoval_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ReportingServiceProxy.QueueDeprecationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source_file, source_file_fragment);
  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());
  params->line_number = in_line_number;
  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueDeprecationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ReportingServiceProxyProxy::QueueCspViolationReport(
    const ::blink::KURL& in_url, const WTF::String& in_group, const WTF::String& in_document_url, const WTF::String& in_referrer, const WTF::String& in_blocked_url, const WTF::String& in_effective_directive, const WTF::String& in_original_policy, const WTF::String& in_source_file, const WTF::String& in_script_sample, const WTF::String& in_disposition, uint16_t in_status_code, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ReportingServiceProxy::QueueCspViolationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group"), in_group, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_url"), in_document_url, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("referrer"), in_referrer, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked_url"), in_blocked_url, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("effective_directive"), in_effective_directive, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("original_policy"), in_original_policy, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_sample"), in_script_sample, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status_code"), in_status_code, 
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kReportingServiceProxy_QueueCspViolationReport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueCspViolationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ReportingServiceProxy.QueueCspViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->group)::BaseType> group_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_group, group_fragment);
  params->group.Set(
      group_fragment.is_null() ? nullptr : group_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group in ReportingServiceProxy.QueueCspViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->document_url)::BaseType> document_url_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_document_url, document_url_fragment);
  params->document_url.Set(
      document_url_fragment.is_null() ? nullptr : document_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->document_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_url in ReportingServiceProxy.QueueCspViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->referrer)::BaseType> referrer_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_referrer, referrer_fragment);
  params->referrer.Set(
      referrer_fragment.is_null() ? nullptr : referrer_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->blocked_url)::BaseType> blocked_url_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_blocked_url, blocked_url_fragment);
  params->blocked_url.Set(
      blocked_url_fragment.is_null() ? nullptr : blocked_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->effective_directive)::BaseType> effective_directive_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_effective_directive, effective_directive_fragment);
  params->effective_directive.Set(
      effective_directive_fragment.is_null() ? nullptr : effective_directive_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->effective_directive.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null effective_directive in ReportingServiceProxy.QueueCspViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->original_policy)::BaseType> original_policy_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_original_policy, original_policy_fragment);
  params->original_policy.Set(
      original_policy_fragment.is_null() ? nullptr : original_policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->original_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null original_policy in ReportingServiceProxy.QueueCspViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source_file, source_file_fragment);
  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->script_sample)::BaseType> script_sample_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_script_sample, script_sample_fragment);
  params->script_sample.Set(
      script_sample_fragment.is_null() ? nullptr : script_sample_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->disposition)::BaseType> disposition_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_disposition, disposition_fragment);
  params->disposition.Set(
      disposition_fragment.is_null() ? nullptr : disposition_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->disposition.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null disposition in ReportingServiceProxy.QueueCspViolationReport request");
  params->status_code = in_status_code;
  params->line_number = in_line_number;
  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueCspViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ReportingServiceProxyProxy::QueueFeaturePolicyViolationReport(
    const ::blink::KURL& in_url, const WTF::String& in_policy_id, const WTF::String& in_disposition, const WTF::String& in_message, const WTF::String& in_source_file, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ReportingServiceProxy::QueueFeaturePolicyViolationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_id"), in_policy_id, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kReportingServiceProxy_QueueFeaturePolicyViolationReport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueFeaturePolicyViolationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ReportingServiceProxy.QueueFeaturePolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_id)::BaseType> policy_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_policy_id, policy_id_fragment);
  params->policy_id.Set(
      policy_id_fragment.is_null() ? nullptr : policy_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_id in ReportingServiceProxy.QueueFeaturePolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->disposition)::BaseType> disposition_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_disposition, disposition_fragment);
  params->disposition.Set(
      disposition_fragment.is_null() ? nullptr : disposition_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->disposition.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null disposition in ReportingServiceProxy.QueueFeaturePolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source_file, source_file_fragment);
  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());
  params->line_number = in_line_number;
  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueFeaturePolicyViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ReportingServiceProxyProxy::QueueDocumentPolicyViolationReport(
    const ::blink::KURL& in_url, const WTF::String& in_group, const WTF::String& in_policy_id, const WTF::String& in_disposition, const WTF::String& in_message, const WTF::String& in_source_file, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ReportingServiceProxy::QueueDocumentPolicyViolationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group"), in_group, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_id"), in_policy_id, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kReportingServiceProxy_QueueDocumentPolicyViolationReport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ReportingServiceProxy.QueueDocumentPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->group)::BaseType> group_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_group, group_fragment);
  params->group.Set(
      group_fragment.is_null() ? nullptr : group_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group in ReportingServiceProxy.QueueDocumentPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_id)::BaseType> policy_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_policy_id, policy_id_fragment);
  params->policy_id.Set(
      policy_id_fragment.is_null() ? nullptr : policy_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_id in ReportingServiceProxy.QueueDocumentPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->disposition)::BaseType> disposition_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_disposition, disposition_fragment);
  params->disposition.Set(
      disposition_fragment.is_null() ? nullptr : disposition_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->disposition.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null disposition in ReportingServiceProxy.QueueDocumentPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source_file, source_file_fragment);
  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());
  params->line_number = in_line_number;
  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueDocumentPolicyViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ReportingServiceProxyStubDispatch::Accept(
    ReportingServiceProxy* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kReportingServiceProxy_QueueInterventionReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ReportingServiceProxy::QueueInterventionReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ReportingServiceProxy::QueueInterventionReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueInterventionReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueInterventionReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      WTF::String p_id{};
      WTF::String p_message{};
      WTF::String p_source_file{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueueInterventionReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueInterventionReport(
std::move(p_url), 
std::move(p_id), 
std::move(p_message), 
std::move(p_source_file), 
std::move(p_line_number), 
std::move(p_column_number));
      return true;
    }
    case internal::kReportingServiceProxy_QueueDeprecationReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ReportingServiceProxy::QueueDeprecationReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ReportingServiceProxy::QueueDeprecationReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueDeprecationReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueDeprecationReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      WTF::String p_id{};
      base::Optional<::base::Time> p_anticipatedRemoval{};
      WTF::String p_message{};
      WTF::String p_source_file{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueueDeprecationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadAnticipatedRemoval(&p_anticipatedRemoval))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueDeprecationReport(
std::move(p_url), 
std::move(p_id), 
std::move(p_anticipatedRemoval), 
std::move(p_message), 
std::move(p_source_file), 
std::move(p_line_number), 
std::move(p_column_number));
      return true;
    }
    case internal::kReportingServiceProxy_QueueCspViolationReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ReportingServiceProxy::QueueCspViolationReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ReportingServiceProxy::QueueCspViolationReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueCspViolationReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueCspViolationReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      WTF::String p_group{};
      WTF::String p_document_url{};
      WTF::String p_referrer{};
      WTF::String p_blocked_url{};
      WTF::String p_effective_directive{};
      WTF::String p_original_policy{};
      WTF::String p_source_file{};
      WTF::String p_script_sample{};
      WTF::String p_disposition{};
      uint16_t p_status_code{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueueCspViolationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadGroup(&p_group))
        success = false;
      if (success && !input_data_view.ReadDocumentUrl(&p_document_url))
        success = false;
      if (success && !input_data_view.ReadReferrer(&p_referrer))
        success = false;
      if (success && !input_data_view.ReadBlockedUrl(&p_blocked_url))
        success = false;
      if (success && !input_data_view.ReadEffectiveDirective(&p_effective_directive))
        success = false;
      if (success && !input_data_view.ReadOriginalPolicy(&p_original_policy))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success && !input_data_view.ReadScriptSample(&p_script_sample))
        success = false;
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success)
        p_status_code = input_data_view.status_code();
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueCspViolationReport(
std::move(p_url), 
std::move(p_group), 
std::move(p_document_url), 
std::move(p_referrer), 
std::move(p_blocked_url), 
std::move(p_effective_directive), 
std::move(p_original_policy), 
std::move(p_source_file), 
std::move(p_script_sample), 
std::move(p_disposition), 
std::move(p_status_code), 
std::move(p_line_number), 
std::move(p_column_number));
      return true;
    }
    case internal::kReportingServiceProxy_QueueFeaturePolicyViolationReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ReportingServiceProxy::QueueFeaturePolicyViolationReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ReportingServiceProxy::QueueFeaturePolicyViolationReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueFeaturePolicyViolationReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueFeaturePolicyViolationReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      WTF::String p_policy_id{};
      WTF::String p_disposition{};
      WTF::String p_message{};
      WTF::String p_source_file{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueueFeaturePolicyViolationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadPolicyId(&p_policy_id))
        success = false;
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueFeaturePolicyViolationReport(
std::move(p_url), 
std::move(p_policy_id), 
std::move(p_disposition), 
std::move(p_message), 
std::move(p_source_file), 
std::move(p_line_number), 
std::move(p_column_number));
      return true;
    }
    case internal::kReportingServiceProxy_QueueDocumentPolicyViolationReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ReportingServiceProxy::QueueDocumentPolicyViolationReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ReportingServiceProxy::QueueDocumentPolicyViolationReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      WTF::String p_group{};
      WTF::String p_policy_id{};
      WTF::String p_disposition{};
      WTF::String p_message{};
      WTF::String p_source_file{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadGroup(&p_group))
        success = false;
      if (success && !input_data_view.ReadPolicyId(&p_policy_id))
        success = false;
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueDocumentPolicyViolationReport(
std::move(p_url), 
std::move(p_group), 
std::move(p_policy_id), 
std::move(p_disposition), 
std::move(p_message), 
std::move(p_source_file), 
std::move(p_line_number), 
std::move(p_column_number));
      return true;
    }
  }
  return false;
}

// static
bool ReportingServiceProxyStubDispatch::AcceptWithResponder(
    ReportingServiceProxy* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kReportingServiceProxy_QueueInterventionReport_Name: {
      break;
    }
    case internal::kReportingServiceProxy_QueueDeprecationReport_Name: {
      break;
    }
    case internal::kReportingServiceProxy_QueueCspViolationReport_Name: {
      break;
    }
    case internal::kReportingServiceProxy_QueueFeaturePolicyViolationReport_Name: {
      break;
    }
    case internal::kReportingServiceProxy_QueueDocumentPolicyViolationReport_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kReportingServiceProxyValidationInfo[] = {
    {&internal::ReportingServiceProxy_QueueInterventionReport_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ReportingServiceProxy_QueueDeprecationReport_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ReportingServiceProxy_QueueCspViolationReport_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ReportingServiceProxy_QueueFeaturePolicyViolationReport_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params_Data::Validate,
     nullptr /* no response */},
};

bool ReportingServiceProxyRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ReportingServiceProxy::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kReportingServiceProxyValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif