// third_party/blink/public/mojom/scroll/scroll_enums.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/scroll/scroll_enums.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/scroll/scroll_enums.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string ScrollTypeToString(ScrollType value) {
  switch(value) {
    case ScrollType::kUser:
      return "ScrollType::kUser";
    case ScrollType::kProgrammatic:
      return "ScrollType::kProgrammatic";
    case ScrollType::kClamping:
      return "ScrollType::kClamping";
    case ScrollType::kCompositor:
      return "ScrollType::kCompositor";
    case ScrollType::kAnchoring:
      return "ScrollType::kAnchoring";
    case ScrollType::kSequenced:
      return "ScrollType::kSequenced";
    default:
      return base::StringPrintf("Unknown ScrollType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ScrollType value) {
  return os << ScrollTypeToString(value);
}

std::string ScrollBehaviorToString(ScrollBehavior value) {
  switch(value) {
    case ScrollBehavior::kAuto:
      return "ScrollBehavior::kAuto";
    case ScrollBehavior::kInstant:
      return "ScrollBehavior::kInstant";
    case ScrollBehavior::kSmooth:
      return "ScrollBehavior::kSmooth";
    default:
      return base::StringPrintf("Unknown ScrollBehavior value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ScrollBehavior value) {
  return os << ScrollBehaviorToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ScrollType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ScrollType value) {
  return std::move(context).WriteString(::blink::mojom::ScrollTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ScrollBehavior>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ScrollBehavior value) {
  return std::move(context).WriteString(::blink::mojom::ScrollBehaviorToString(value));
}

} // namespace perfetto
