// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string ScrollAlignment_BehaviorToString(ScrollAlignment_Behavior value) {
  switch(value) {
    case ScrollAlignment_Behavior::kNoScroll:
      return "ScrollAlignment_Behavior::kNoScroll";
    case ScrollAlignment_Behavior::kCenter:
      return "ScrollAlignment_Behavior::kCenter";
    case ScrollAlignment_Behavior::kTop:
      return "ScrollAlignment_Behavior::kTop";
    case ScrollAlignment_Behavior::kBottom:
      return "ScrollAlignment_Behavior::kBottom";
    case ScrollAlignment_Behavior::kLeft:
      return "ScrollAlignment_Behavior::kLeft";
    case ScrollAlignment_Behavior::kRight:
      return "ScrollAlignment_Behavior::kRight";
    case ScrollAlignment_Behavior::kClosestEdge:
      return "ScrollAlignment_Behavior::kClosestEdge";
    default:
      return base::StringPrintf("Unknown ScrollAlignment_Behavior value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ScrollAlignment_Behavior value) {
  return os << ScrollAlignment_BehaviorToString(value);
}

namespace internal {


// static
bool ScrollAlignment_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ScrollAlignment_Data* object = static_cast<const ScrollAlignment_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ScrollAlignment_Behavior_Data
        ::Validate(object->rect_visible, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollAlignment_Behavior_Data
        ::Validate(object->rect_hidden, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollAlignment_Behavior_Data
        ::Validate(object->rect_partial, validation_context))
    return false;

  return true;
}

ScrollAlignment_Data::ScrollAlignment_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollIntoViewParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ScrollIntoViewParams_Data* object = static_cast<const ScrollIntoViewParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->align_x, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->align_x, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->align_y, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->align_y, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollBehavior_Data
        ::Validate(object->behavior, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_element_bounds, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_element_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_caret_bounds, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_caret_bounds, validation_context))
    return false;

  return true;
}

ScrollIntoViewParams_Data::ScrollIntoViewParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ScrollAlignment_Behavior>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ScrollAlignment_Behavior value) {
  return std::move(context).WriteString(::blink::mojom::ScrollAlignment_BehaviorToString(value));
}

} // namespace perfetto
