// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-params-data.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ScrollAlignment::ScrollAlignment()
    : rect_visible(ScrollAlignment_Behavior::kNoScroll),
      rect_hidden(ScrollAlignment_Behavior::kCenter),
      rect_partial(ScrollAlignment_Behavior::kClosestEdge) {}

ScrollAlignment::ScrollAlignment(
    ScrollAlignment::Behavior rect_visible_in,
    ScrollAlignment::Behavior rect_hidden_in,
    ScrollAlignment::Behavior rect_partial_in)
    : rect_visible(std::move(rect_visible_in)),
      rect_hidden(std::move(rect_hidden_in)),
      rect_partial(std::move(rect_partial_in)) {}

ScrollAlignment::~ScrollAlignment() = default;
size_t ScrollAlignment::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->rect_visible);
  seed = mojo::internal::Hash(seed, this->rect_hidden);
  seed = mojo::internal::Hash(seed, this->rect_partial);
  return seed;
}

void ScrollAlignment::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect_visible"), this->rect_visible, 
      "<value of type ScrollAlignment::Behavior>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect_hidden"), this->rect_hidden, 
      "<value of type ScrollAlignment::Behavior>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect_partial"), this->rect_partial, 
      "<value of type ScrollAlignment::Behavior>");
}

bool ScrollAlignment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollIntoViewParams::ScrollIntoViewParams()
    : align_x(),
      align_y(),
      type(::blink::mojom::ScrollType::kProgrammatic),
      make_visible_in_visual_viewport(true),
      behavior(::blink::mojom::ScrollBehavior::kAuto),
      is_for_scroll_sequence(false),
      zoom_into_rect(false),
      relative_element_bounds(),
      relative_caret_bounds(),
      stop_at_main_frame_layout_viewport(false) {}

ScrollIntoViewParams::ScrollIntoViewParams(
    ScrollAlignmentPtr align_x_in,
    ScrollAlignmentPtr align_y_in,
    ::blink::mojom::ScrollType type_in,
    bool make_visible_in_visual_viewport_in,
    ::blink::mojom::ScrollBehavior behavior_in,
    bool is_for_scroll_sequence_in,
    bool zoom_into_rect_in,
    const ::gfx::RectF& relative_element_bounds_in,
    const ::gfx::RectF& relative_caret_bounds_in,
    bool stop_at_main_frame_layout_viewport_in)
    : align_x(std::move(align_x_in)),
      align_y(std::move(align_y_in)),
      type(std::move(type_in)),
      make_visible_in_visual_viewport(std::move(make_visible_in_visual_viewport_in)),
      behavior(std::move(behavior_in)),
      is_for_scroll_sequence(std::move(is_for_scroll_sequence_in)),
      zoom_into_rect(std::move(zoom_into_rect_in)),
      relative_element_bounds(std::move(relative_element_bounds_in)),
      relative_caret_bounds(std::move(relative_caret_bounds_in)),
      stop_at_main_frame_layout_viewport(std::move(stop_at_main_frame_layout_viewport_in)) {}

ScrollIntoViewParams::~ScrollIntoViewParams() = default;

void ScrollIntoViewParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "align_x"), this->align_x, 
      "<value of type ScrollAlignmentPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "align_y"), this->align_y, 
      "<value of type ScrollAlignmentPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type ::blink::mojom::ScrollType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "make_visible_in_visual_viewport"), this->make_visible_in_visual_viewport, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "behavior"), this->behavior, 
      "<value of type ::blink::mojom::ScrollBehavior>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_for_scroll_sequence"), this->is_for_scroll_sequence, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "zoom_into_rect"), this->zoom_into_rect, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_element_bounds"), this->relative_element_bounds, 
      "<value of type const ::gfx::RectF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_caret_bounds"), this->relative_caret_bounds, 
      "<value of type const ::gfx::RectF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stop_at_main_frame_layout_viewport"), this->stop_at_main_frame_layout_viewport, 
      "<value of type bool>");
}

bool ScrollIntoViewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ScrollAlignment::DataView, ::blink::mojom::ScrollAlignmentPtr>::Read(
    ::blink::mojom::ScrollAlignment::DataView input,
    ::blink::mojom::ScrollAlignmentPtr* output) {
  bool success = true;
  ::blink::mojom::ScrollAlignmentPtr result(::blink::mojom::ScrollAlignment::New());
  
      if (success && !input.ReadRectVisible(&result->rect_visible))
        success = false;
      if (success && !input.ReadRectHidden(&result->rect_hidden))
        success = false;
      if (success && !input.ReadRectPartial(&result->rect_partial))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ScrollIntoViewParams::DataView, ::blink::mojom::ScrollIntoViewParamsPtr>::Read(
    ::blink::mojom::ScrollIntoViewParams::DataView input,
    ::blink::mojom::ScrollIntoViewParamsPtr* output) {
  bool success = true;
  ::blink::mojom::ScrollIntoViewParamsPtr result(::blink::mojom::ScrollIntoViewParams::New());
  
      if (success && !input.ReadAlignX(&result->align_x))
        success = false;
      if (success && !input.ReadAlignY(&result->align_y))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->make_visible_in_visual_viewport = input.make_visible_in_visual_viewport();
      if (success && !input.ReadBehavior(&result->behavior))
        success = false;
      if (success)
        result->is_for_scroll_sequence = input.is_for_scroll_sequence();
      if (success)
        result->zoom_into_rect = input.zoom_into_rect();
      if (success && !input.ReadRelativeElementBounds(&result->relative_element_bounds))
        success = false;
      if (success && !input.ReadRelativeCaretBounds(&result->relative_caret_bounds))
        success = false;
      if (success)
        result->stop_at_main_frame_layout_viewport = input.stop_at_main_frame_layout_viewport();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif