// third_party/blink/public/mojom/serial/serial.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/serial/serial.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/serial/serial.mojom-params-data.h"
#include "third_party/blink/public/mojom/serial/serial.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/serial/serial.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERIAL_SERIAL_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERIAL_SERIAL_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
SerialPortInfo::SerialPortInfo()
    : token(),
      usb_vendor_id(),
      has_usb_vendor_id(false),
      usb_product_id(),
      has_usb_product_id(false) {}

SerialPortInfo::SerialPortInfo(
    const ::base::UnguessableToken& token_in,
    uint16_t usb_vendor_id_in,
    bool has_usb_vendor_id_in,
    uint16_t usb_product_id_in,
    bool has_usb_product_id_in)
    : token(std::move(token_in)),
      usb_vendor_id(std::move(usb_vendor_id_in)),
      has_usb_vendor_id(std::move(has_usb_vendor_id_in)),
      usb_product_id(std::move(usb_product_id_in)),
      has_usb_product_id(std::move(has_usb_product_id_in)) {}

SerialPortInfo::~SerialPortInfo() = default;

void SerialPortInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token, 
      "<value of type const ::base::UnguessableToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usb_vendor_id"), this->usb_vendor_id, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_usb_vendor_id"), this->has_usb_vendor_id, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usb_product_id"), this->usb_product_id, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_usb_product_id"), this->has_usb_product_id, 
      "<value of type bool>");
}

bool SerialPortInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SerialPortFilter::SerialPortFilter()
    : vendor_id(),
      has_vendor_id(),
      product_id(),
      has_product_id() {}

SerialPortFilter::SerialPortFilter(
    uint32_t vendor_id_in,
    bool has_vendor_id_in,
    uint16_t product_id_in,
    bool has_product_id_in)
    : vendor_id(std::move(vendor_id_in)),
      has_vendor_id(std::move(has_vendor_id_in)),
      product_id(std::move(product_id_in)),
      has_product_id(std::move(has_product_id_in)) {}

SerialPortFilter::~SerialPortFilter() = default;
size_t SerialPortFilter::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->vendor_id);
  seed = mojo::internal::Hash(seed, this->has_vendor_id);
  seed = mojo::internal::Hash(seed, this->product_id);
  seed = mojo::internal::Hash(seed, this->has_product_id);
  return seed;
}

void SerialPortFilter::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_id"), this->vendor_id, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_vendor_id"), this->has_vendor_id, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_id"), this->product_id, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_product_id"), this->has_product_id, 
      "<value of type bool>");
}

bool SerialPortFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SerialService::Name_[] = "blink.mojom.SerialService";

class SerialService_GetPorts_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialService_GetPorts_ForwardToCallback(
      SerialService::GetPortsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialService::GetPortsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialService_GetPorts_ForwardToCallback);
};

class SerialService_RequestPort_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialService_RequestPort_ForwardToCallback(
      SerialService::RequestPortCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialService::RequestPortCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialService_RequestPort_ForwardToCallback);
};

class SerialService_OpenPort_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialService_OpenPort_ForwardToCallback(
      SerialService::OpenPortCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialService::OpenPortCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialService_OpenPort_ForwardToCallback);
};

SerialServiceProxy::SerialServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SerialServiceProxy::SetClient(
    ::mojo::PendingRemote<SerialServiceClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SerialService::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<SerialServiceClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialService_SetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_SetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SerialServiceClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SerialService.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SerialServiceProxy::GetPorts(
    GetPortsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SerialService::GetPorts");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialService_GetPorts_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_GetPorts_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("GetPorts");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialService_GetPorts_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SerialServiceProxy::RequestPort(
    std::vector<SerialPortFilterPtr> in_filters, RequestPortCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SerialService::RequestPort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filters"), in_filters, 
                        "<value of type std::vector<SerialPortFilterPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialService_RequestPort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_RequestPort_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filters)::BaseType>
      filters_fragment(params.message());
  const mojo::internal::ContainerValidateParams filters_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SerialPortFilterDataView>>(
      in_filters, filters_fragment, &filters_validate_params);
  params->filters.Set(
      filters_fragment.is_null() ? nullptr : filters_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->filters.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filters in SerialService.RequestPort request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("RequestPort");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialService_RequestPort_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SerialServiceProxy::OpenPort(
    const ::base::UnguessableToken& in_token, ::device::mojom::SerialConnectionOptionsPtr in_options, ::mojo::PendingRemote<::device::mojom::SerialPortClient> in_client, OpenPortCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SerialService::OpenPort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type ::device::mojom::SerialConnectionOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<::device::mojom::SerialPortClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialService_OpenPort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_OpenPort_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in SerialService.OpenPort request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SerialConnectionOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in SerialService.OpenPort request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SerialPortClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SerialService.OpenPort request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("OpenPort");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialService_OpenPort_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SerialService_GetPorts_ProxyToResponder {
 public:
  static SerialService::GetPortsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialService_GetPorts_ProxyToResponder> proxy(
        new SerialService_GetPorts_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialService_GetPorts_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialService_GetPorts_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialService_GetPorts_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialService::GetPortsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<SerialPortInfoPtr> in_ports);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialService_GetPorts_ProxyToResponder);
};

bool SerialService_GetPorts_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::SerialService::GetPortsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialService_GetPorts_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialService_GetPorts_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<SerialPortInfoPtr> p_ports{};
  SerialService_GetPorts_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPorts(&p_ports))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_ports));
  return true;
}

void SerialService_GetPorts_ProxyToResponder::Run(
    std::vector<SerialPortInfoPtr> in_ports) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::SerialService::GetPortsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ports"), in_ports, 
                        "<value of type std::vector<SerialPortInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialService_GetPorts_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_GetPorts_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ports)::BaseType>
      ports_fragment(params.message());
  const mojo::internal::ContainerValidateParams ports_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SerialPortInfoDataView>>(
      in_ports, ports_fragment, &ports_validate_params);
  params->ports.Set(
      ports_fragment.is_null() ? nullptr : ports_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ports.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ports in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::SerialService::GetPortsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("GetPorts");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialService_RequestPort_ProxyToResponder {
 public:
  static SerialService::RequestPortCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialService_RequestPort_ProxyToResponder> proxy(
        new SerialService_RequestPort_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialService_RequestPort_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialService_RequestPort_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialService_RequestPort_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialService::RequestPortCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SerialPortInfoPtr in_port);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialService_RequestPort_ProxyToResponder);
};

bool SerialService_RequestPort_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::SerialService::RequestPortCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialService_RequestPort_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialService_RequestPort_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SerialPortInfoPtr p_port{};
  SerialService_RequestPort_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPort(&p_port))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_port));
  return true;
}

void SerialService_RequestPort_ProxyToResponder::Run(
    SerialPortInfoPtr in_port) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::SerialService::RequestPortCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port, 
                        "<value of type SerialPortInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialService_RequestPort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_RequestPort_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->port)::BaseType> port_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SerialPortInfoDataView>(
      in_port, port_fragment);
  params->port.Set(
      port_fragment.is_null() ? nullptr : port_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::SerialService::RequestPortCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("RequestPort");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialService_OpenPort_ProxyToResponder {
 public:
  static SerialService::OpenPortCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialService_OpenPort_ProxyToResponder> proxy(
        new SerialService_OpenPort_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialService_OpenPort_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialService_OpenPort_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialService_OpenPort_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialService::OpenPortCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::device::mojom::SerialPort> in_port);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialService_OpenPort_ProxyToResponder);
};

bool SerialService_OpenPort_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::SerialService::OpenPortCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialService_OpenPort_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialService_OpenPort_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::PendingRemote<::device::mojom::SerialPort> p_port{};
  SerialService_OpenPort_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_port =
        input_data_view.TakePort<decltype(p_port)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_port));
  return true;
}

void SerialService_OpenPort_ProxyToResponder::Run(
    ::mojo::PendingRemote<::device::mojom::SerialPort> in_port) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::SerialService::OpenPortCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port, 
                        "<value of type ::mojo::PendingRemote<::device::mojom::SerialPort>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialService_OpenPort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_OpenPort_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SerialPortInterfaceBase>>(
      in_port, &params->port, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::SerialService::OpenPortCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("OpenPort");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SerialServiceStubDispatch::Accept(
    SerialService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSerialService_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SerialService::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SerialService::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SerialService_SetClient_Params_Data* params =
          reinterpret_cast<internal::SerialService_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<SerialServiceClient> p_client{};
      SerialService_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
    case internal::kSerialService_GetPorts_Name: {
      break;
    }
    case internal::kSerialService_RequestPort_Name: {
      break;
    }
    case internal::kSerialService_OpenPort_Name: {
      break;
    }
  }
  return false;
}

// static
bool SerialServiceStubDispatch::AcceptWithResponder(
    SerialService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSerialService_SetClient_Name: {
      break;
    }
    case internal::kSerialService_GetPorts_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SerialService::GetPorts",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SerialService::GetPorts");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialService_GetPorts_Params_Data* params =
          reinterpret_cast<
              internal::SerialService_GetPorts_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SerialService_GetPorts_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialService::Name_, 1, false);
        return false;
      }
      SerialService::GetPortsCallback callback =
          SerialService_GetPorts_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPorts(std::move(callback));
      return true;
    }
    case internal::kSerialService_RequestPort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SerialService::RequestPort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SerialService::RequestPort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialService_RequestPort_Params_Data* params =
          reinterpret_cast<
              internal::SerialService_RequestPort_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<SerialPortFilterPtr> p_filters{};
      SerialService_RequestPort_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilters(&p_filters))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialService::Name_, 2, false);
        return false;
      }
      SerialService::RequestPortCallback callback =
          SerialService_RequestPort_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPort(
std::move(p_filters), std::move(callback));
      return true;
    }
    case internal::kSerialService_OpenPort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SerialService::OpenPort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SerialService::OpenPort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialService_OpenPort_Params_Data* params =
          reinterpret_cast<
              internal::SerialService_OpenPort_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_token{};
      ::device::mojom::SerialConnectionOptionsPtr p_options{};
      ::mojo::PendingRemote<::device::mojom::SerialPortClient> p_client{};
      SerialService_OpenPort_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialService::Name_, 3, false);
        return false;
      }
      SerialService::OpenPortCallback callback =
          SerialService_OpenPort_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenPort(
std::move(p_token), 
std::move(p_options), 
std::move(p_client), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSerialServiceValidationInfo[] = {
    {&internal::SerialService_SetClient_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SerialService_GetPorts_Params_Data::Validate,
     &internal::SerialService_GetPorts_ResponseParams_Data::Validate},
    {&internal::SerialService_RequestPort_Params_Data::Validate,
     &internal::SerialService_RequestPort_ResponseParams_Data::Validate},
    {&internal::SerialService_OpenPort_Params_Data::Validate,
     &internal::SerialService_OpenPort_ResponseParams_Data::Validate},
};

bool SerialServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SerialService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSerialServiceValidationInfo);
}

bool SerialServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SerialService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kSerialServiceValidationInfo);
}
const char SerialServiceClient::Name_[] = "blink.mojom.SerialServiceClient";

SerialServiceClientProxy::SerialServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SerialServiceClientProxy::OnPortAdded(
    SerialPortInfoPtr in_port_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SerialServiceClient::OnPortAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_info"), in_port_info, 
                        "<value of type SerialPortInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialServiceClient_OnPortAdded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialServiceClient_OnPortAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->port_info)::BaseType> port_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SerialPortInfoDataView>(
      in_port_info, port_info_fragment);
  params->port_info.Set(
      port_info_fragment.is_null() ? nullptr : port_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->port_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null port_info in SerialServiceClient.OnPortAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialServiceClient::Name_);
  message.set_method_name("OnPortAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SerialServiceClientProxy::OnPortRemoved(
    SerialPortInfoPtr in_port_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SerialServiceClient::OnPortRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_info"), in_port_info, 
                        "<value of type SerialPortInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialServiceClient_OnPortRemoved_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialServiceClient_OnPortRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->port_info)::BaseType> port_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SerialPortInfoDataView>(
      in_port_info, port_info_fragment);
  params->port_info.Set(
      port_info_fragment.is_null() ? nullptr : port_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->port_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null port_info in SerialServiceClient.OnPortRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialServiceClient::Name_);
  message.set_method_name("OnPortRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SerialServiceClientStubDispatch::Accept(
    SerialServiceClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSerialServiceClient_OnPortAdded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SerialServiceClient::OnPortAdded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SerialServiceClient::OnPortAdded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SerialServiceClient_OnPortAdded_Params_Data* params =
          reinterpret_cast<internal::SerialServiceClient_OnPortAdded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SerialPortInfoPtr p_port_info{};
      SerialServiceClient_OnPortAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPortInfo(&p_port_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPortAdded(
std::move(p_port_info));
      return true;
    }
    case internal::kSerialServiceClient_OnPortRemoved_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SerialServiceClient::OnPortRemoved",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SerialServiceClient::OnPortRemoved");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SerialServiceClient_OnPortRemoved_Params_Data* params =
          reinterpret_cast<internal::SerialServiceClient_OnPortRemoved_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SerialPortInfoPtr p_port_info{};
      SerialServiceClient_OnPortRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPortInfo(&p_port_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialServiceClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPortRemoved(
std::move(p_port_info));
      return true;
    }
  }
  return false;
}

// static
bool SerialServiceClientStubDispatch::AcceptWithResponder(
    SerialServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSerialServiceClient_OnPortAdded_Name: {
      break;
    }
    case internal::kSerialServiceClient_OnPortRemoved_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSerialServiceClientValidationInfo[] = {
    {&internal::SerialServiceClient_OnPortAdded_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SerialServiceClient_OnPortRemoved_Params_Data::Validate,
     nullptr /* no response */},
};

bool SerialServiceClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SerialServiceClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSerialServiceClientValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::SerialPortInfo::DataView, ::blink::mojom::SerialPortInfoPtr>::Read(
    ::blink::mojom::SerialPortInfo::DataView input,
    ::blink::mojom::SerialPortInfoPtr* output) {
  bool success = true;
  ::blink::mojom::SerialPortInfoPtr result(::blink::mojom::SerialPortInfo::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success)
        result->usb_vendor_id = input.usb_vendor_id();
      if (success)
        result->has_usb_vendor_id = input.has_usb_vendor_id();
      if (success)
        result->usb_product_id = input.usb_product_id();
      if (success)
        result->has_usb_product_id = input.has_usb_product_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SerialPortFilter::DataView, ::blink::mojom::SerialPortFilterPtr>::Read(
    ::blink::mojom::SerialPortFilter::DataView input,
    ::blink::mojom::SerialPortFilterPtr* output) {
  bool success = true;
  ::blink::mojom::SerialPortFilterPtr result(::blink::mojom::SerialPortFilter::New());
  
      if (success)
        result->vendor_id = input.vendor_id();
      if (success)
        result->has_vendor_id = input.has_vendor_id();
      if (success)
        result->product_id = input.product_id();
      if (success)
        result->has_product_id = input.has_product_id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif