// third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ControllerServiceWorkerInfo::ControllerServiceWorkerInfo()
    : mode(::blink::mojom::ControllerServiceWorkerMode::kNoController),
      remote_controller(),
      client_id(),
      fetch_request_window_id(),
      object_info(),
      used_features() {}

ControllerServiceWorkerInfo::ControllerServiceWorkerInfo(
    ::blink::mojom::ControllerServiceWorkerMode mode_in,
    ::mojo::PendingRemote<ControllerServiceWorker> remote_controller_in,
    const std::string& client_id_in,
    const base::Optional<::base::UnguessableToken>& fetch_request_window_id_in,
    ::blink::mojom::ServiceWorkerObjectInfoPtr object_info_in,
    std::vector<::blink::mojom::WebFeature> used_features_in)
    : mode(std::move(mode_in)),
      remote_controller(std::move(remote_controller_in)),
      client_id(std::move(client_id_in)),
      fetch_request_window_id(std::move(fetch_request_window_id_in)),
      object_info(std::move(object_info_in)),
      used_features(std::move(used_features_in)) {}

ControllerServiceWorkerInfo::~ControllerServiceWorkerInfo() = default;

void ControllerServiceWorkerInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode, 
      "<value of type ::blink::mojom::ControllerServiceWorkerMode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_controller"), this->remote_controller, 
      "<value of type ::mojo::PendingRemote<ControllerServiceWorker>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_id"), this->client_id, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_request_window_id"), this->fetch_request_window_id, 
      "<value of type const base::Optional<::base::UnguessableToken>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "object_info"), this->object_info, 
      "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "used_features"), this->used_features, 
      "<value of type const std::vector<::blink::mojom::WebFeature>&>");
}

bool ControllerServiceWorkerInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ControllerServiceWorker::Name_[] = "blink.mojom.ControllerServiceWorker";

class ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback(
      ControllerServiceWorker::DispatchFetchEventForSubresourceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ControllerServiceWorker::DispatchFetchEventForSubresourceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback);
};

ControllerServiceWorkerProxy::ControllerServiceWorkerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ControllerServiceWorkerProxy::DispatchFetchEventForSubresource(
    ::blink::mojom::DispatchFetchEventParamsPtr in_params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> in_response_callback, DispatchFetchEventForSubresourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type ::blink::mojom::DispatchFetchEventParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_callback"), in_response_callback, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kControllerServiceWorker_DispatchFetchEventForSubresource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DispatchFetchEventParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in ControllerServiceWorker.DispatchFetchEventForSubresource request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ServiceWorkerFetchResponseCallbackInterfaceBase>>(
      in_response_callback, &params->response_callback, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->response_callback),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid response_callback in ControllerServiceWorker.DispatchFetchEventForSubresource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ControllerServiceWorker::Name_);
  message.set_method_name("DispatchFetchEventForSubresource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ControllerServiceWorkerProxy::Clone(
    ::mojo::PendingReceiver<ControllerServiceWorker> in_receiver, const ::network::CrossOriginEmbedderPolicy& in_cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> in_coep_reporter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ControllerServiceWorker::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<ControllerServiceWorker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cross_origin_embedder_policy"), in_cross_origin_embedder_policy, 
                        "<value of type const ::network::CrossOriginEmbedderPolicy&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("coep_reporter"), in_coep_reporter, 
                        "<value of type ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kControllerServiceWorker_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ControllerServiceWorker_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in ControllerServiceWorker.Clone request");
  mojo::internal::MessageFragment<
      typename decltype(params->cross_origin_embedder_policy)::BaseType> cross_origin_embedder_policy_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
      in_cross_origin_embedder_policy, cross_origin_embedder_policy_fragment);
  params->cross_origin_embedder_policy.Set(
      cross_origin_embedder_policy_fragment.is_null() ? nullptr : cross_origin_embedder_policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cross_origin_embedder_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cross_origin_embedder_policy in ControllerServiceWorker.Clone request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
      in_coep_reporter, &params->coep_reporter, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ControllerServiceWorker::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder {
 public:
  static ControllerServiceWorker::DispatchFetchEventForSubresourceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder> proxy(
        new ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ControllerServiceWorker::DispatchFetchEventForSubresourceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder);
};

bool ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresourceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ControllerServiceWorker::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresourceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kControllerServiceWorker_DispatchFetchEventForSubresource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresourceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ControllerServiceWorker::Name_);
  message.set_method_name("DispatchFetchEventForSubresource");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ControllerServiceWorkerStubDispatch::Accept(
    ControllerServiceWorker* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kControllerServiceWorker_DispatchFetchEventForSubresource_Name: {
      break;
    }
    case internal::kControllerServiceWorker_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ControllerServiceWorker::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ControllerServiceWorker::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ControllerServiceWorker_Clone_Params_Data* params =
          reinterpret_cast<internal::ControllerServiceWorker_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<ControllerServiceWorker> p_receiver{};
      ::network::CrossOriginEmbedderPolicy p_cross_origin_embedder_policy{};
      ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> p_coep_reporter{};
      ControllerServiceWorker_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadCrossOriginEmbedderPolicy(&p_cross_origin_embedder_policy))
        success = false;
      if (success) {
        p_coep_reporter =
            input_data_view.TakeCoepReporter<decltype(p_coep_reporter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ControllerServiceWorker::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_receiver), 
std::move(p_cross_origin_embedder_policy), 
std::move(p_coep_reporter));
      return true;
    }
  }
  return false;
}

// static
bool ControllerServiceWorkerStubDispatch::AcceptWithResponder(
    ControllerServiceWorker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kControllerServiceWorker_DispatchFetchEventForSubresource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data* params =
          reinterpret_cast<
              internal::ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::DispatchFetchEventParamsPtr p_params{};
      ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> p_response_callback{};
      ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_response_callback =
            input_data_view.TakeResponseCallback<decltype(p_response_callback)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ControllerServiceWorker::Name_, 0, false);
        return false;
      }
      ControllerServiceWorker::DispatchFetchEventForSubresourceCallback callback =
          ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchFetchEventForSubresource(
std::move(p_params), 
std::move(p_response_callback), std::move(callback));
      return true;
    }
    case internal::kControllerServiceWorker_Clone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kControllerServiceWorkerValidationInfo[] = {
    {internal::kControllerServiceWorker_DispatchFetchEventForSubresource_Name,
     {&internal::ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data::Validate,
      &internal::ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data::Validate}},
    {internal::kControllerServiceWorker_Clone_Name,
     {&internal::ControllerServiceWorker_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ControllerServiceWorkerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ControllerServiceWorker::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kControllerServiceWorkerValidationInfo);
}

bool ControllerServiceWorkerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ControllerServiceWorker::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kControllerServiceWorkerValidationInfo);

}
const char ControllerServiceWorkerConnector::Name_[] = "blink.mojom.ControllerServiceWorkerConnector";

ControllerServiceWorkerConnectorProxy::ControllerServiceWorkerConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ControllerServiceWorkerConnectorProxy::UpdateController(
    ::mojo::PendingRemote<ControllerServiceWorker> in_controller) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ControllerServiceWorkerConnector::UpdateController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller"), in_controller, 
                        "<value of type ::mojo::PendingRemote<ControllerServiceWorker>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kControllerServiceWorkerConnector_UpdateController_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ControllerServiceWorkerConnector_UpdateController_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
      in_controller, &params->controller, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ControllerServiceWorkerConnector::Name_);
  message.set_method_name("UpdateController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ControllerServiceWorkerConnectorStubDispatch::Accept(
    ControllerServiceWorkerConnector* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kControllerServiceWorkerConnector_UpdateController_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ControllerServiceWorkerConnector::UpdateController",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ControllerServiceWorkerConnector::UpdateController");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ControllerServiceWorkerConnector_UpdateController_Params_Data* params =
          reinterpret_cast<internal::ControllerServiceWorkerConnector_UpdateController_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<ControllerServiceWorker> p_controller{};
      ControllerServiceWorkerConnector_UpdateController_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_controller =
            input_data_view.TakeController<decltype(p_controller)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ControllerServiceWorkerConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateController(
std::move(p_controller));
      return true;
    }
  }
  return false;
}

// static
bool ControllerServiceWorkerConnectorStubDispatch::AcceptWithResponder(
    ControllerServiceWorkerConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kControllerServiceWorkerConnector_UpdateController_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kControllerServiceWorkerConnectorValidationInfo[] = {
    {internal::kControllerServiceWorkerConnector_UpdateController_Name,
     {&internal::ControllerServiceWorkerConnector_UpdateController_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ControllerServiceWorkerConnectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ControllerServiceWorkerConnector::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kControllerServiceWorkerConnectorValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ControllerServiceWorkerInfo::DataView, ::blink::mojom::ControllerServiceWorkerInfoPtr>::Read(
    ::blink::mojom::ControllerServiceWorkerInfo::DataView input,
    ::blink::mojom::ControllerServiceWorkerInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ControllerServiceWorkerInfoPtr result(::blink::mojom::ControllerServiceWorkerInfo::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success) {
        result->remote_controller =
            input.TakeRemoteController<decltype(result->remote_controller)>();
      }
      if (success && !input.ReadClientId(&result->client_id))
        success = false;
      if (success && !input.ReadFetchRequestWindowId(&result->fetch_request_window_id))
        success = false;
      if (success && !input.ReadObjectInfo(&result->object_info))
        success = false;
      if (success && !input.ReadUsedFeatures(&result->used_features))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif