// third_party/blink/public/mojom/service_worker/embedded_worker.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool EmbeddedWorkerStartParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 176, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerStartParams_Data* object = static_cast<const EmbeddedWorkerStartParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scope, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scope, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_url, validation_context))
    return false;


  if (!::blink::mojom::internal::ScriptType_Data
        ::Validate(object->script_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->outside_fetch_client_settings_object, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->outside_fetch_client_settings_object, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_agent, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams user_agent_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->user_agent, validation_context,
                                         &user_agent_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ua_metadata, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ua_metadata, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_worker_token, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_worker_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_url_to_skip_throttling, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_url_to_skip_throttling, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->renderer_preferences, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->renderer_preferences, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->service_worker_receiver, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->service_worker_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->controller_receiver, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->controller_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->installed_scripts_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->instance_host, 17, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->instance_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->provider_info, 18, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->provider_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->content_settings_proxy, 19, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->content_settings_proxy,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->preference_watcher_receiver, 20, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->preference_watcher_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subresource_loader_factories, 21, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->subresource_loader_factories, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->subresource_loader_updater, 22, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->subresource_loader_updater,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_worker_token, 23, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service_worker_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->main_script_load_params, validation_context))
    return false;

  return true;
}

EmbeddedWorkerStartParams_Data::EmbeddedWorkerStartParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerStartTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerStartTiming_Data* object = static_cast<const EmbeddedWorkerStartTiming_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_worker_received_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_worker_received_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_evaluation_start_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_evaluation_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_evaluation_end_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_evaluation_end_time, validation_context))
    return false;

  return true;
}

EmbeddedWorkerStartTiming_Data::EmbeddedWorkerStartTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceClient_StartWorker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceClient_StartWorker_Params_Data* object = static_cast<const EmbeddedWorkerInstanceClient_StartWorker_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

EmbeddedWorkerInstanceClient_StartWorker_Params_Data::EmbeddedWorkerInstanceClient_StartWorker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceClient_StopWorker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceClient_StopWorker_Params_Data* object = static_cast<const EmbeddedWorkerInstanceClient_StopWorker_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

EmbeddedWorkerInstanceClient_StopWorker_Params_Data::EmbeddedWorkerInstanceClient_StopWorker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceHost_RequestTermination_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceHost_RequestTermination_Params_Data* object = static_cast<const EmbeddedWorkerInstanceHost_RequestTermination_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

EmbeddedWorkerInstanceHost_RequestTermination_Params_Data::EmbeddedWorkerInstanceHost_RequestTermination_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data* object = static_cast<const EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data::EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceHost_CountFeature_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceHost_CountFeature_Params_Data* object = static_cast<const EmbeddedWorkerInstanceHost_CountFeature_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::WebFeature_Data
        ::Validate(object->feature, validation_context))
    return false;

  return true;
}

EmbeddedWorkerInstanceHost_CountFeature_Params_Data::EmbeddedWorkerInstanceHost_CountFeature_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data* object = static_cast<const EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->agent, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->agent,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->agent_host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->agent_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data::EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data* object = static_cast<const EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data::EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data* object = static_cast<const EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data::EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceHost_OnStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceHost_OnStarted_Params_Data* object = static_cast<const EmbeddedWorkerInstanceHost_OnStarted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ServiceWorkerStartStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_timing, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_timing, validation_context))
    return false;

  return true;
}

EmbeddedWorkerInstanceHost_OnStarted_Params_Data::EmbeddedWorkerInstanceHost_OnStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceHost_OnReportException_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceHost_OnReportException_Params_Data* object = static_cast<const EmbeddedWorkerInstanceHost_OnReportException_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->error_message, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_url, validation_context))
    return false;

  return true;
}

EmbeddedWorkerInstanceHost_OnReportException_Params_Data::EmbeddedWorkerInstanceHost_OnReportException_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data* object = static_cast<const EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ConsoleMessageSource_Data
        ::Validate(object->source, validation_context))
    return false;


  if (!::blink::mojom::internal::ConsoleMessageLevel_Data
        ::Validate(object->message_level, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_url, validation_context))
    return false;

  return true;
}

EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data::EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedWorkerInstanceHost_OnStopped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EmbeddedWorkerInstanceHost_OnStopped_Params_Data* object = static_cast<const EmbeddedWorkerInstanceHost_OnStopped_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

EmbeddedWorkerInstanceHost_OnStopped_Params_Data::EmbeddedWorkerInstanceHost_OnStopped_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
