// third_party/blink/public/mojom/service_worker/embedded_worker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
EmbeddedWorkerStartParams::EmbeddedWorkerStartParams()
    : service_worker_version_id(),
      scope(),
      script_url(),
      script_type(),
      outside_fetch_client_settings_object(),
      user_agent(),
      ua_metadata(),
      service_worker_route_id(),
      devtools_worker_token(),
      script_url_to_skip_throttling(),
      wait_for_debugger(),
      is_installed(),
      renderer_preferences(),
      service_worker_receiver(),
      controller_receiver(),
      installed_scripts_info(),
      instance_host(),
      provider_info(),
      content_settings_proxy(),
      preference_watcher_receiver(),
      subresource_loader_factories(),
      subresource_loader_updater(),
      service_worker_token(),
      ukm_source_id(),
      main_script_load_params() {}

EmbeddedWorkerStartParams::EmbeddedWorkerStartParams(
    int64_t service_worker_version_id_in,
    const ::GURL& scope_in,
    const ::GURL& script_url_in,
    ::blink::mojom::ScriptType script_type_in,
    ::blink::mojom::FetchClientSettingsObjectPtr outside_fetch_client_settings_object_in,
    const std::string& user_agent_in,
    const ::blink::UserAgentMetadata& ua_metadata_in,
    int32_t service_worker_route_id_in,
    const ::base::UnguessableToken& devtools_worker_token_in,
    const ::GURL& script_url_to_skip_throttling_in,
    bool wait_for_debugger_in,
    bool is_installed_in,
    const ::blink::RendererPreferences& renderer_preferences_in,
    ::mojo::PendingReceiver<::blink::mojom::ServiceWorker> service_worker_receiver_in,
    ::mojo::PendingReceiver<::blink::mojom::ControllerServiceWorker> controller_receiver_in,
    ::blink::mojom::ServiceWorkerInstalledScriptsInfoPtr installed_scripts_info_in,
    ::mojo::PendingAssociatedRemote<EmbeddedWorkerInstanceHost> instance_host_in,
    ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr provider_info_in,
    ::mojo::PendingRemote<::blink::mojom::WorkerContentSettingsProxy> content_settings_proxy_in,
    ::mojo::PendingReceiver<::blink::mojom::RendererPreferenceWatcher> preference_watcher_receiver_in,
    ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories_in,
    ::mojo::PendingReceiver<::blink::mojom::SubresourceLoaderUpdater> subresource_loader_updater_in,
    const ::blink::ServiceWorkerToken& service_worker_token_in,
    int64_t ukm_source_id_in,
    ::blink::mojom::WorkerMainScriptLoadParamsPtr main_script_load_params_in)
    : service_worker_version_id(std::move(service_worker_version_id_in)),
      scope(std::move(scope_in)),
      script_url(std::move(script_url_in)),
      script_type(std::move(script_type_in)),
      outside_fetch_client_settings_object(std::move(outside_fetch_client_settings_object_in)),
      user_agent(std::move(user_agent_in)),
      ua_metadata(std::move(ua_metadata_in)),
      service_worker_route_id(std::move(service_worker_route_id_in)),
      devtools_worker_token(std::move(devtools_worker_token_in)),
      script_url_to_skip_throttling(std::move(script_url_to_skip_throttling_in)),
      wait_for_debugger(std::move(wait_for_debugger_in)),
      is_installed(std::move(is_installed_in)),
      renderer_preferences(std::move(renderer_preferences_in)),
      service_worker_receiver(std::move(service_worker_receiver_in)),
      controller_receiver(std::move(controller_receiver_in)),
      installed_scripts_info(std::move(installed_scripts_info_in)),
      instance_host(std::move(instance_host_in)),
      provider_info(std::move(provider_info_in)),
      content_settings_proxy(std::move(content_settings_proxy_in)),
      preference_watcher_receiver(std::move(preference_watcher_receiver_in)),
      subresource_loader_factories(std::move(subresource_loader_factories_in)),
      subresource_loader_updater(std::move(subresource_loader_updater_in)),
      service_worker_token(std::move(service_worker_token_in)),
      ukm_source_id(std::move(ukm_source_id_in)),
      main_script_load_params(std::move(main_script_load_params_in)) {}

EmbeddedWorkerStartParams::~EmbeddedWorkerStartParams() = default;

void EmbeddedWorkerStartParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_version_id"), this->service_worker_version_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope"), this->scope, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_url"), this->script_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_type"), this->script_type, 
      "<value of type ::blink::mojom::ScriptType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outside_fetch_client_settings_object"), this->outside_fetch_client_settings_object, 
      "<value of type ::blink::mojom::FetchClientSettingsObjectPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_agent"), this->user_agent, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ua_metadata"), this->ua_metadata, 
      "<value of type const ::blink::UserAgentMetadata&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_route_id"), this->service_worker_route_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_worker_token"), this->devtools_worker_token, 
      "<value of type const ::base::UnguessableToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_url_to_skip_throttling"), this->script_url_to_skip_throttling, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_debugger"), this->wait_for_debugger, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_installed"), this->is_installed, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_preferences"), this->renderer_preferences, 
      "<value of type const ::blink::RendererPreferences&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_receiver"), this->service_worker_receiver, 
      "<value of type ::mojo::PendingReceiver<::blink::mojom::ServiceWorker>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "controller_receiver"), this->controller_receiver, 
      "<value of type ::mojo::PendingReceiver<::blink::mojom::ControllerServiceWorker>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "installed_scripts_info"), this->installed_scripts_info, 
      "<value of type ::blink::mojom::ServiceWorkerInstalledScriptsInfoPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_host"), this->instance_host, 
      "<value of type ::mojo::PendingAssociatedRemote<EmbeddedWorkerInstanceHost>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider_info"), this->provider_info, 
      "<value of type ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_settings_proxy"), this->content_settings_proxy, 
      "<value of type ::mojo::PendingRemote<::blink::mojom::WorkerContentSettingsProxy>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preference_watcher_receiver"), this->preference_watcher_receiver, 
      "<value of type ::mojo::PendingReceiver<::blink::mojom::RendererPreferenceWatcher>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subresource_loader_factories"), this->subresource_loader_factories, 
      "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subresource_loader_updater"), this->subresource_loader_updater, 
      "<value of type ::mojo::PendingReceiver<::blink::mojom::SubresourceLoaderUpdater>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_token"), this->service_worker_token, 
      "<value of type const ::blink::ServiceWorkerToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ukm_source_id"), this->ukm_source_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_script_load_params"), this->main_script_load_params, 
      "<value of type ::blink::mojom::WorkerMainScriptLoadParamsPtr>");
}

bool EmbeddedWorkerStartParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EmbeddedWorkerStartTiming::EmbeddedWorkerStartTiming()
    : start_worker_received_time(),
      script_evaluation_start_time(),
      script_evaluation_end_time() {}

EmbeddedWorkerStartTiming::EmbeddedWorkerStartTiming(
    ::base::TimeTicks start_worker_received_time_in,
    ::base::TimeTicks script_evaluation_start_time_in,
    ::base::TimeTicks script_evaluation_end_time_in)
    : start_worker_received_time(std::move(start_worker_received_time_in)),
      script_evaluation_start_time(std::move(script_evaluation_start_time_in)),
      script_evaluation_end_time(std::move(script_evaluation_end_time_in)) {}

EmbeddedWorkerStartTiming::~EmbeddedWorkerStartTiming() = default;

void EmbeddedWorkerStartTiming::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_worker_received_time"), this->start_worker_received_time, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_evaluation_start_time"), this->script_evaluation_start_time, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_evaluation_end_time"), this->script_evaluation_end_time, 
      "<value of type ::base::TimeTicks>");
}

bool EmbeddedWorkerStartTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char EmbeddedWorkerInstanceClient::Name_[] = "blink.mojom.EmbeddedWorkerInstanceClient";

EmbeddedWorkerInstanceClientProxy::EmbeddedWorkerInstanceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedWorkerInstanceClientProxy::StartWorker(
    EmbeddedWorkerStartParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedWorkerInstanceClient::StartWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type EmbeddedWorkerStartParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceClient_StartWorker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceClient_StartWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::EmbeddedWorkerStartParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in EmbeddedWorkerInstanceClient.StartWorker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceClient::Name_);
  message.set_method_name("StartWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedWorkerInstanceClientProxy::StopWorker(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::EmbeddedWorkerInstanceClient::StopWorker");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceClient_StopWorker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceClient_StopWorker_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceClient::Name_);
  message.set_method_name("StopWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool EmbeddedWorkerInstanceClientStubDispatch::Accept(
    EmbeddedWorkerInstanceClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kEmbeddedWorkerInstanceClient_StartWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceClient::StartWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceClient::StartWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceClient_StartWorker_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceClient_StartWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      EmbeddedWorkerStartParamsPtr p_params{};
      EmbeddedWorkerInstanceClient_StartWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartWorker(
std::move(p_params));
      return true;
    }
    case internal::kEmbeddedWorkerInstanceClient_StopWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceClient::StopWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceClient::StopWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceClient_StopWorker_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceClient_StopWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      EmbeddedWorkerInstanceClient_StopWorker_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopWorker();
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedWorkerInstanceClientStubDispatch::AcceptWithResponder(
    EmbeddedWorkerInstanceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kEmbeddedWorkerInstanceClient_StartWorker_Name: {
      break;
    }
    case internal::kEmbeddedWorkerInstanceClient_StopWorker_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kEmbeddedWorkerInstanceClientValidationInfo[] = {
    {internal::kEmbeddedWorkerInstanceClient_StartWorker_Name,
     {&internal::EmbeddedWorkerInstanceClient_StartWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedWorkerInstanceClient_StopWorker_Name,
     {&internal::EmbeddedWorkerInstanceClient_StopWorker_Params_Data::Validate,
      nullptr /* no response */}},
};

bool EmbeddedWorkerInstanceClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::EmbeddedWorkerInstanceClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kEmbeddedWorkerInstanceClientValidationInfo);
}

const char EmbeddedWorkerInstanceHost::Name_[] = "blink.mojom.EmbeddedWorkerInstanceHost";

class EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback(
      EmbeddedWorkerInstanceHost::RequestTerminationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  EmbeddedWorkerInstanceHost::RequestTerminationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback);
};

EmbeddedWorkerInstanceHostProxy::EmbeddedWorkerInstanceHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedWorkerInstanceHostProxy::RequestTermination(
    RequestTerminationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::EmbeddedWorkerInstanceHost::RequestTermination");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceHost_RequestTermination_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_RequestTermination_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("RequestTermination");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void EmbeddedWorkerInstanceHostProxy::CountFeature(
    ::blink::mojom::WebFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedWorkerInstanceHost::CountFeature", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature, 
                        "<value of type ::blink::mojom::WebFeature>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceHost_CountFeature_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_CountFeature_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::WebFeature>(
      in_feature, &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("CountFeature");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedWorkerInstanceHostProxy::OnReadyForInspection(
    ::mojo::PendingRemote<::blink::mojom::DevToolsAgent> in_agent, ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> in_agent_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedWorkerInstanceHost::OnReadyForInspection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::DevToolsAgent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_host"), in_agent_host, 
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceHost_OnReadyForInspection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DevToolsAgentInterfaceBase>>(
      in_agent, &params->agent, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid agent in EmbeddedWorkerInstanceHost.OnReadyForInspection request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::DevToolsAgentHostInterfaceBase>>(
      in_agent_host, &params->agent_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid agent_host in EmbeddedWorkerInstanceHost.OnReadyForInspection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnReadyForInspection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedWorkerInstanceHostProxy::OnScriptLoaded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::EmbeddedWorkerInstanceHost::OnScriptLoaded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceHost_OnScriptLoaded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnScriptLoaded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedWorkerInstanceHostProxy::OnScriptEvaluationStart(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::EmbeddedWorkerInstanceHost::OnScriptEvaluationStart");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnScriptEvaluationStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedWorkerInstanceHostProxy::OnStarted(
    ::blink::mojom::ServiceWorkerStartStatus in_status, bool in_has_fetch_handler, int32_t in_thread_id, EmbeddedWorkerStartTimingPtr in_start_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedWorkerInstanceHost::OnStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::blink::mojom::ServiceWorkerStartStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_fetch_handler"), in_has_fetch_handler, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thread_id"), in_thread_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_timing"), in_start_timing, 
                        "<value of type EmbeddedWorkerStartTimingPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceHost_OnStarted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerStartStatus>(
      in_status, &params->status);
  params->has_fetch_handler = in_has_fetch_handler;
  params->thread_id = in_thread_id;
  mojo::internal::MessageFragment<
      typename decltype(params->start_timing)::BaseType> start_timing_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::EmbeddedWorkerStartTimingDataView>(
      in_start_timing, start_timing_fragment);
  params->start_timing.Set(
      start_timing_fragment.is_null() ? nullptr : start_timing_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->start_timing.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_timing in EmbeddedWorkerInstanceHost.OnStarted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedWorkerInstanceHostProxy::OnReportException(
    const ::base::string16& in_error_message, int32_t in_line_number, int32_t in_column_number, const ::GURL& in_source_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedWorkerInstanceHost::OnReportException", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message, 
                        "<value of type const ::base::string16&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_url"), in_source_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceHost_OnReportException_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnReportException_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in EmbeddedWorkerInstanceHost.OnReportException request");
  params->line_number = in_line_number;
  params->column_number = in_column_number;
  mojo::internal::MessageFragment<
      typename decltype(params->source_url)::BaseType> source_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_source_url, source_url_fragment);
  params->source_url.Set(
      source_url_fragment.is_null() ? nullptr : source_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_url in EmbeddedWorkerInstanceHost.OnReportException request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnReportException");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedWorkerInstanceHostProxy::OnReportConsoleMessage(
    ::blink::mojom::ConsoleMessageSource in_source, ::blink::mojom::ConsoleMessageLevel in_message_level, const ::base::string16& in_message, int32_t in_line_number, const ::GURL& in_source_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedWorkerInstanceHost::OnReportConsoleMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source, 
                        "<value of type ::blink::mojom::ConsoleMessageSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message_level"), in_message_level, 
                        "<value of type ::blink::mojom::ConsoleMessageLevel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type const ::base::string16&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_url"), in_source_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceHost_OnReportConsoleMessage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageSource>(
      in_source, &params->source);
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
      in_message_level, &params->message_level);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in EmbeddedWorkerInstanceHost.OnReportConsoleMessage request");
  params->line_number = in_line_number;
  mojo::internal::MessageFragment<
      typename decltype(params->source_url)::BaseType> source_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_source_url, source_url_fragment);
  params->source_url.Set(
      source_url_fragment.is_null() ? nullptr : source_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_url in EmbeddedWorkerInstanceHost.OnReportConsoleMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnReportConsoleMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedWorkerInstanceHostProxy::OnStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::EmbeddedWorkerInstanceHost::OnStopped");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceHost_OnStopped_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnStopped_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder {
 public:
  static EmbeddedWorkerInstanceHost::RequestTerminationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder> proxy(
        new EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "EmbeddedWorkerInstanceHost::RequestTerminationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_will_be_terminated);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder);
};

bool EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::EmbeddedWorkerInstanceHost::RequestTerminationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data* params =
      reinterpret_cast<
          internal::EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_will_be_terminated{};
  EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_will_be_terminated = input_data_view.will_be_terminated();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        EmbeddedWorkerInstanceHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_will_be_terminated));
  return true;
}

void EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder::Run(
    bool in_will_be_terminated) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::RequestTerminationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("will_be_terminated"), in_will_be_terminated, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedWorkerInstanceHost_RequestTermination_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->will_be_terminated = in_will_be_terminated;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::RequestTerminationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("RequestTermination");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool EmbeddedWorkerInstanceHostStubDispatch::Accept(
    EmbeddedWorkerInstanceHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kEmbeddedWorkerInstanceHost_RequestTermination_Name: {
      break;
    }
    case internal::kEmbeddedWorkerInstanceHost_CountFeature_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::CountFeature",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::CountFeature");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_CountFeature_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_CountFeature_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::WebFeature p_feature{};
      EmbeddedWorkerInstanceHost_CountFeature_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CountFeature(
std::move(p_feature));
      return true;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnReadyForInspection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnReadyForInspection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnReadyForInspection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::DevToolsAgent> p_agent{};
      ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> p_agent_host{};
      EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (success) {
        p_agent_host =
            input_data_view.TakeAgentHost<decltype(p_agent_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReadyForInspection(
std::move(p_agent), 
std::move(p_agent_host));
      return true;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnScriptLoaded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnScriptLoaded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnScriptLoaded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoaded();
      return true;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnScriptEvaluationStart",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnScriptEvaluationStart");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptEvaluationStart();
      return true;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnStarted_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ServiceWorkerStartStatus p_status{};
      bool p_has_fetch_handler{};
      int32_t p_thread_id{};
      EmbeddedWorkerStartTimingPtr p_start_timing{};
      EmbeddedWorkerInstanceHost_OnStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (success)
        p_has_fetch_handler = input_data_view.has_fetch_handler();
      if (success)
        p_thread_id = input_data_view.thread_id();
      if (success && !input_data_view.ReadStartTiming(&p_start_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStarted(
std::move(p_status), 
std::move(p_has_fetch_handler), 
std::move(p_thread_id), 
std::move(p_start_timing));
      return true;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnReportException_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnReportException",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnReportException");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnReportException_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnReportException_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_error_message{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ::GURL p_source_url{};
      EmbeddedWorkerInstanceHost_OnReportException_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (success && !input_data_view.ReadSourceUrl(&p_source_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportException(
std::move(p_error_message), 
std::move(p_line_number), 
std::move(p_column_number), 
std::move(p_source_url));
      return true;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnReportConsoleMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnReportConsoleMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnReportConsoleMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ConsoleMessageSource p_source{};
      ::blink::mojom::ConsoleMessageLevel p_message_level{};
      ::base::string16 p_message{};
      int32_t p_line_number{};
      ::GURL p_source_url{};
      EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadMessageLevel(&p_message_level))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadSourceUrl(&p_source_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportConsoleMessage(
std::move(p_source), 
std::move(p_message_level), 
std::move(p_message), 
std::move(p_line_number), 
std::move(p_source_url));
      return true;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnStopped_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnStopped",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::OnStopped");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnStopped_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnStopped_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      EmbeddedWorkerInstanceHost_OnStopped_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped();
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedWorkerInstanceHostStubDispatch::AcceptWithResponder(
    EmbeddedWorkerInstanceHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kEmbeddedWorkerInstanceHost_RequestTermination_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::RequestTermination",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedWorkerInstanceHost::RequestTermination");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::EmbeddedWorkerInstanceHost_RequestTermination_Params_Data* params =
          reinterpret_cast<
              internal::EmbeddedWorkerInstanceHost_RequestTermination_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      EmbeddedWorkerInstanceHost_RequestTermination_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 0, false);
        return false;
      }
      EmbeddedWorkerInstanceHost::RequestTerminationCallback callback =
          EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestTermination(std::move(callback));
      return true;
    }
    case internal::kEmbeddedWorkerInstanceHost_CountFeature_Name: {
      break;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnReadyForInspection_Name: {
      break;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnScriptLoaded_Name: {
      break;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Name: {
      break;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnStarted_Name: {
      break;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnReportException_Name: {
      break;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnReportConsoleMessage_Name: {
      break;
    }
    case internal::kEmbeddedWorkerInstanceHost_OnStopped_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kEmbeddedWorkerInstanceHostValidationInfo[] = {
    {internal::kEmbeddedWorkerInstanceHost_RequestTermination_Name,
     {&internal::EmbeddedWorkerInstanceHost_RequestTermination_Params_Data::Validate,
      &internal::EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data::Validate}},
    {internal::kEmbeddedWorkerInstanceHost_CountFeature_Name,
     {&internal::EmbeddedWorkerInstanceHost_CountFeature_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedWorkerInstanceHost_OnReadyForInspection_Name,
     {&internal::EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedWorkerInstanceHost_OnScriptLoaded_Name,
     {&internal::EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Name,
     {&internal::EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedWorkerInstanceHost_OnStarted_Name,
     {&internal::EmbeddedWorkerInstanceHost_OnStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedWorkerInstanceHost_OnReportException_Name,
     {&internal::EmbeddedWorkerInstanceHost_OnReportException_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedWorkerInstanceHost_OnReportConsoleMessage_Name,
     {&internal::EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedWorkerInstanceHost_OnStopped_Name,
     {&internal::EmbeddedWorkerInstanceHost_OnStopped_Params_Data::Validate,
      nullptr /* no response */}},
};

bool EmbeddedWorkerInstanceHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::EmbeddedWorkerInstanceHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kEmbeddedWorkerInstanceHostValidationInfo);
}

bool EmbeddedWorkerInstanceHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::EmbeddedWorkerInstanceHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kEmbeddedWorkerInstanceHostValidationInfo);

}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::EmbeddedWorkerStartParams::DataView, ::blink::mojom::EmbeddedWorkerStartParamsPtr>::Read(
    ::blink::mojom::EmbeddedWorkerStartParams::DataView input,
    ::blink::mojom::EmbeddedWorkerStartParamsPtr* output) {
  bool success = true;
  ::blink::mojom::EmbeddedWorkerStartParamsPtr result(::blink::mojom::EmbeddedWorkerStartParams::New());
  
      if (success)
        result->service_worker_version_id = input.service_worker_version_id();
      if (success && !input.ReadScope(&result->scope))
        success = false;
      if (success && !input.ReadScriptUrl(&result->script_url))
        success = false;
      if (success && !input.ReadScriptType(&result->script_type))
        success = false;
      if (success && !input.ReadOutsideFetchClientSettingsObject(&result->outside_fetch_client_settings_object))
        success = false;
      if (success && !input.ReadUserAgent(&result->user_agent))
        success = false;
      if (success && !input.ReadUaMetadata(&result->ua_metadata))
        success = false;
      if (success)
        result->service_worker_route_id = input.service_worker_route_id();
      if (success && !input.ReadDevtoolsWorkerToken(&result->devtools_worker_token))
        success = false;
      if (success && !input.ReadScriptUrlToSkipThrottling(&result->script_url_to_skip_throttling))
        success = false;
      if (success)
        result->wait_for_debugger = input.wait_for_debugger();
      if (success)
        result->is_installed = input.is_installed();
      if (success && !input.ReadRendererPreferences(&result->renderer_preferences))
        success = false;
      if (success) {
        result->service_worker_receiver =
            input.TakeServiceWorkerReceiver<decltype(result->service_worker_receiver)>();
      }
      if (success) {
        result->controller_receiver =
            input.TakeControllerReceiver<decltype(result->controller_receiver)>();
      }
      if (success && !input.ReadInstalledScriptsInfo(&result->installed_scripts_info))
        success = false;
      if (success) {
        result->instance_host =
            input.TakeInstanceHost<decltype(result->instance_host)>();
      }
      if (success && !input.ReadProviderInfo(&result->provider_info))
        success = false;
      if (success) {
        result->content_settings_proxy =
            input.TakeContentSettingsProxy<decltype(result->content_settings_proxy)>();
      }
      if (success) {
        result->preference_watcher_receiver =
            input.TakePreferenceWatcherReceiver<decltype(result->preference_watcher_receiver)>();
      }
      if (success && !input.ReadSubresourceLoaderFactories(&result->subresource_loader_factories))
        success = false;
      if (success) {
        result->subresource_loader_updater =
            input.TakeSubresourceLoaderUpdater<decltype(result->subresource_loader_updater)>();
      }
      if (success && !input.ReadServiceWorkerToken(&result->service_worker_token))
        success = false;
      if (success)
        result->ukm_source_id = input.ukm_source_id();
      if (success && !input.ReadMainScriptLoadParams(&result->main_script_load_params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::EmbeddedWorkerStartTiming::DataView, ::blink::mojom::EmbeddedWorkerStartTimingPtr>::Read(
    ::blink::mojom::EmbeddedWorkerStartTiming::DataView input,
    ::blink::mojom::EmbeddedWorkerStartTimingPtr* output) {
  bool success = true;
  ::blink::mojom::EmbeddedWorkerStartTimingPtr result(::blink::mojom::EmbeddedWorkerStartTiming::New());
  
      if (success && !input.ReadStartWorkerReceivedTime(&result->start_worker_received_time))
        success = false;
      if (success && !input.ReadScriptEvaluationStartTime(&result->script_evaluation_start_time))
        success = false;
      if (success && !input.ReadScriptEvaluationEndTime(&result->script_evaluation_end_time))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif