// third_party/blink/public/mojom/service_worker/service_worker_client.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string ServiceWorkerClientTypeToString(ServiceWorkerClientType value) {
  switch(value) {
    case ServiceWorkerClientType::kWindow:
      return "ServiceWorkerClientType::kWindow";
    case ServiceWorkerClientType::kDedicatedWorker:
      return "ServiceWorkerClientType::kDedicatedWorker";
    case ServiceWorkerClientType::kSharedWorker:
      return "ServiceWorkerClientType::kSharedWorker";
    case ServiceWorkerClientType::kAll:
      return "ServiceWorkerClientType::kAll";
    default:
      return base::StringPrintf("Unknown ServiceWorkerClientType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ServiceWorkerClientType value) {
  return os << ServiceWorkerClientTypeToString(value);
}

std::string ServiceWorkerClientLifecycleStateToString(ServiceWorkerClientLifecycleState value) {
  switch(value) {
    case ServiceWorkerClientLifecycleState::kActive:
      return "ServiceWorkerClientLifecycleState::kActive";
    case ServiceWorkerClientLifecycleState::kFrozen:
      return "ServiceWorkerClientLifecycleState::kFrozen";
    default:
      return base::StringPrintf("Unknown ServiceWorkerClientLifecycleState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ServiceWorkerClientLifecycleState value) {
  return os << ServiceWorkerClientLifecycleStateToString(value);
}

namespace internal {


// static
bool ServiceWorkerClientQueryOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerClientQueryOptions_Data* object = static_cast<const ServiceWorkerClientQueryOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ServiceWorkerClientType_Data
        ::Validate(object->client_type, validation_context))
    return false;

  return true;
}

ServiceWorkerClientQueryOptions_Data::ServiceWorkerClientQueryOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerClientInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerClientInfo_Data* object = static_cast<const ServiceWorkerClientInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::blink::mojom::internal::RequestContextFrameType_Data
        ::Validate(object->frame_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_uuid, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams client_uuid_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->client_uuid, validation_context,
                                         &client_uuid_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::ServiceWorkerClientType_Data
        ::Validate(object->client_type, validation_context))
    return false;


  if (!::blink::mojom::internal::ServiceWorkerClientLifecycleState_Data
        ::Validate(object->lifecycle_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_focus_time, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_focus_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->creation_time, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->creation_time, validation_context))
    return false;

  return true;
}

ServiceWorkerClientInfo_Data::ServiceWorkerClientInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ServiceWorkerClientType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ServiceWorkerClientType value) {
  return std::move(context).WriteString(::blink::mojom::ServiceWorkerClientTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ServiceWorkerClientLifecycleState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ServiceWorkerClientLifecycleState value) {
  return std::move(context).WriteString(::blink::mojom::ServiceWorkerClientLifecycleStateToString(value));
}

} // namespace perfetto
