// third_party/blink/public/mojom/service_worker/service_worker_container.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CONTAINER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CONTAINER_MOJOM_JUMBO_H_
#include "third_party/blink/public/common/messaging/cloneable_message_mojom_traits.h"
#include "third_party/blink/public/common/messaging/transferable_message_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
ServiceWorkerContainerInfoForClient::ServiceWorkerContainerInfoForClient()
    : host_remote(),
      client_receiver() {}

ServiceWorkerContainerInfoForClient::ServiceWorkerContainerInfoForClient(
    ::mojo::PendingAssociatedRemote<ServiceWorkerContainerHost> host_remote_in,
    ::mojo::PendingAssociatedReceiver<ServiceWorkerContainer> client_receiver_in)
    : host_remote(std::move(host_remote_in)),
      client_receiver(std::move(client_receiver_in)) {}

ServiceWorkerContainerInfoForClient::~ServiceWorkerContainerInfoForClient() = default;

void ServiceWorkerContainerInfoForClient::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_remote"), this->host_remote, 
      "<value of type ::mojo::PendingAssociatedRemote<ServiceWorkerContainerHost>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver, 
      "<value of type ::mojo::PendingAssociatedReceiver<ServiceWorkerContainer>>");
}

bool ServiceWorkerContainerInfoForClient::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ServiceWorkerContainerHost::Name_[] = "blink.mojom.ServiceWorkerContainerHost";

class ServiceWorkerContainerHost_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerContainerHost_Register_ForwardToCallback(
      ServiceWorkerContainerHost::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerContainerHost::RegisterCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerContainerHost_Register_ForwardToCallback);
};

class ServiceWorkerContainerHost_GetRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerContainerHost_GetRegistration_ForwardToCallback(
      ServiceWorkerContainerHost::GetRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerContainerHost::GetRegistrationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerContainerHost_GetRegistration_ForwardToCallback);
};

class ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback(
      ServiceWorkerContainerHost::GetRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerContainerHost::GetRegistrationsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback);
};

class ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback(
      ServiceWorkerContainerHost::GetRegistrationForReadyCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerContainerHost::GetRegistrationForReadyCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback);
};

class ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback(
      ServiceWorkerContainerHost::EnsureFileAccessCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerContainerHost::EnsureFileAccessCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback);
};

ServiceWorkerContainerHostProxy::ServiceWorkerContainerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerContainerHostProxy::Register(
    const ::GURL& in_script_url, ::blink::mojom::ServiceWorkerRegistrationOptionsPtr in_options, ::blink::mojom::FetchClientSettingsObjectPtr in_outside_fetch_client_settings_object, RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerContainerHost::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_url"), in_script_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type ::blink::mojom::ServiceWorkerRegistrationOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("outside_fetch_client_settings_object"), in_outside_fetch_client_settings_object, 
                        "<value of type ::blink::mojom::FetchClientSettingsObjectPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script_url)::BaseType> script_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script_url, script_url_fragment);
  params->script_url.Set(
      script_url_fragment.is_null() ? nullptr : script_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_url in ServiceWorkerContainerHost.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRegistrationOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in ServiceWorkerContainerHost.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->outside_fetch_client_settings_object)::BaseType> outside_fetch_client_settings_object_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FetchClientSettingsObjectDataView>(
      in_outside_fetch_client_settings_object, outside_fetch_client_settings_object_fragment);
  params->outside_fetch_client_settings_object.Set(
      outside_fetch_client_settings_object_fragment.is_null() ? nullptr : outside_fetch_client_settings_object_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->outside_fetch_client_settings_object.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null outside_fetch_client_settings_object in ServiceWorkerContainerHost.Register request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerContainerHost_Register_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerContainerHostProxy::GetRegistration(
    const ::GURL& in_client_url, GetRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerContainerHost::GetRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_url"), in_client_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_GetRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_url)::BaseType> client_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_client_url, client_url_fragment);
  params->client_url.Set(
      client_url_fragment.is_null() ? nullptr : client_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_url in ServiceWorkerContainerHost.GetRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerContainerHost_GetRegistration_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerContainerHostProxy::GetRegistrations(
    GetRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerContainerHost::GetRegistrations");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_GetRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistrations_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerContainerHostProxy::GetRegistrationForReady(
    GetRegistrationForReadyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReady");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_GetRegistrationForReady_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistrationForReady_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistrationForReady");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerContainerHostProxy::EnsureControllerServiceWorker(
    ::mojo::PendingReceiver<::blink::mojom::ControllerServiceWorker> in_receiver, ControllerServiceWorkerPurpose in_purpose) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerContainerHost::EnsureControllerServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::ControllerServiceWorker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("purpose"), in_purpose, 
                        "<value of type ControllerServiceWorkerPurpose>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_EnsureControllerServiceWorker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in ServiceWorkerContainerHost.EnsureControllerServiceWorker request");
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerPurpose>(
      in_purpose, &params->purpose);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("EnsureControllerServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerContainerHostProxy::CloneContainerHost(
    ::mojo::PendingReceiver<ServiceWorkerContainerHost> in_container_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerContainerHost::CloneContainerHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("container_host"), in_container_host, 
                        "<value of type ::mojo::PendingReceiver<ServiceWorkerContainerHost>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_CloneContainerHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_CloneContainerHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ServiceWorkerContainerHostInterfaceBase>>(
      in_container_host, &params->container_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->container_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid container_host in ServiceWorkerContainerHost.CloneContainerHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("CloneContainerHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerContainerHostProxy::HintToUpdateServiceWorker(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerContainerHost::HintToUpdateServiceWorker");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_HintToUpdateServiceWorker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("HintToUpdateServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerContainerHostProxy::EnsureFileAccess(
    const std::vector<::base::FilePath>& in_files, EnsureFileAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerContainerHost::EnsureFileAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), in_files, 
                        "<value of type const std::vector<::base::FilePath>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_EnsureFileAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_EnsureFileAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  const mojo::internal::ContainerValidateParams files_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
      in_files, files_fragment, &files_validate_params);
  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->files.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null files in ServiceWorkerContainerHost.EnsureFileAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("EnsureFileAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerContainerHostProxy::OnExecutionReady(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerContainerHost::OnExecutionReady");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_OnExecutionReady_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_OnExecutionReady_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("OnExecutionReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class ServiceWorkerContainerHost_Register_ProxyToResponder {
 public:
  static ServiceWorkerContainerHost::RegisterCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerContainerHost_Register_ProxyToResponder> proxy(
        new ServiceWorkerContainerHost_Register_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerContainerHost_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerContainerHost_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerContainerHost_Register_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerContainerHost::RegisterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr in_registration);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerContainerHost_Register_ProxyToResponder);
};

bool ServiceWorkerContainerHost_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerContainerHost::RegisterCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerContainerHost_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerContainerHost_Register_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  base::Optional<std::string> p_error_msg{};
  ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr p_registration{};
  ServiceWorkerContainerHost_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (success && !input_data_view.ReadRegistration(&p_registration))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerContainerHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg), 
std::move(p_registration));
  return true;
}

void ServiceWorkerContainerHost_Register_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr in_registration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerContainerHost::RegisterCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type ::blink::mojom::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg, 
                        "<value of type const base::Optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration, 
                        "<value of type ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_Register_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, error_msg_fragment);
  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRegistrationObjectInfoDataView>(
      in_registration, registration_fragment);
  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerContainerHost::RegisterCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerContainerHost_GetRegistration_ProxyToResponder {
 public:
  static ServiceWorkerContainerHost::GetRegistrationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerContainerHost_GetRegistration_ProxyToResponder> proxy(
        new ServiceWorkerContainerHost_GetRegistration_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerContainerHost_GetRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerContainerHost_GetRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerContainerHost_GetRegistration_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerContainerHost::GetRegistrationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr in_registration);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerContainerHost_GetRegistration_ProxyToResponder);
};

bool ServiceWorkerContainerHost_GetRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerContainerHost::GetRegistrationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerContainerHost_GetRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerContainerHost_GetRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  base::Optional<std::string> p_error_msg{};
  ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr p_registration{};
  ServiceWorkerContainerHost_GetRegistration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (success && !input_data_view.ReadRegistration(&p_registration))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerContainerHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg), 
std::move(p_registration));
  return true;
}

void ServiceWorkerContainerHost_GetRegistration_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr in_registration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistrationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type ::blink::mojom::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg, 
                        "<value of type const base::Optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration, 
                        "<value of type ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_GetRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistration_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, error_msg_fragment);
  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRegistrationObjectInfoDataView>(
      in_registration, registration_fragment);
  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistrationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistration");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder {
 public:
  static ServiceWorkerContainerHost::GetRegistrationsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder> proxy(
        new ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerContainerHost::GetRegistrationsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg, base::Optional<std::vector<::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr>> in_infos);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder);
};

bool ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerContainerHost::GetRegistrationsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerContainerHost_GetRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerContainerHost_GetRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  base::Optional<std::string> p_error_msg{};
  base::Optional<std::vector<::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr>> p_infos{};
  ServiceWorkerContainerHost_GetRegistrations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (success && !input_data_view.ReadInfos(&p_infos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerContainerHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg), 
std::move(p_infos));
  return true;
}

void ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg, base::Optional<std::vector<::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr>> in_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistrationsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type ::blink::mojom::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg, 
                        "<value of type const base::Optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("infos"), in_infos, 
                        "<value of type base::Optional<std::vector<::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr>>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_GetRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistrations_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, error_msg_fragment);
  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->infos)::BaseType>
      infos_fragment(params.message());
  const mojo::internal::ContainerValidateParams infos_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ServiceWorkerRegistrationObjectInfoDataView>>(
      in_infos, infos_fragment, &infos_validate_params);
  params->infos.Set(
      infos_fragment.is_null() ? nullptr : infos_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistrationsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistrations");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder {
 public:
  static ServiceWorkerContainerHost::GetRegistrationForReadyCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder> proxy(
        new ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerContainerHost::GetRegistrationForReadyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr in_registration);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder);
};

bool ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReadyCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr p_registration{};
  ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRegistration(&p_registration))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerContainerHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_registration));
  return true;
}

void ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr in_registration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReadyCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration, 
                        "<value of type ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_GetRegistrationForReady_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRegistrationObjectInfoDataView>(
      in_registration, registration_fragment);
  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReadyCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistrationForReady");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder {
 public:
  static ServiceWorkerContainerHost::EnsureFileAccessCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder> proxy(
        new ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerContainerHost::EnsureFileAccessCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder);
};

bool ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerContainerHost::EnsureFileAccessCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerContainerHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::ServiceWorkerContainerHost::EnsureFileAccessCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainerHost_EnsureFileAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerContainerHost::EnsureFileAccessCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("EnsureFileAccess");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerContainerHostStubDispatch::Accept(
    ServiceWorkerContainerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerContainerHost_Register_Name: {
      break;
    }
    case internal::kServiceWorkerContainerHost_GetRegistration_Name: {
      break;
    }
    case internal::kServiceWorkerContainerHost_GetRegistrations_Name: {
      break;
    }
    case internal::kServiceWorkerContainerHost_GetRegistrationForReady_Name: {
      break;
    }
    case internal::kServiceWorkerContainerHost_EnsureControllerServiceWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainerHost::EnsureControllerServiceWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainerHost::EnsureControllerServiceWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::ControllerServiceWorker> p_receiver{};
      ControllerServiceWorkerPurpose p_purpose{};
      ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadPurpose(&p_purpose))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnsureControllerServiceWorker(
std::move(p_receiver), 
std::move(p_purpose));
      return true;
    }
    case internal::kServiceWorkerContainerHost_CloneContainerHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainerHost::CloneContainerHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainerHost::CloneContainerHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainerHost_CloneContainerHost_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainerHost_CloneContainerHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<ServiceWorkerContainerHost> p_container_host{};
      ServiceWorkerContainerHost_CloneContainerHost_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_container_host =
            input_data_view.TakeContainerHost<decltype(p_container_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloneContainerHost(
std::move(p_container_host));
      return true;
    }
    case internal::kServiceWorkerContainerHost_HintToUpdateServiceWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainerHost::HintToUpdateServiceWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainerHost::HintToUpdateServiceWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HintToUpdateServiceWorker();
      return true;
    }
    case internal::kServiceWorkerContainerHost_EnsureFileAccess_Name: {
      break;
    }
    case internal::kServiceWorkerContainerHost_OnExecutionReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainerHost::OnExecutionReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainerHost::OnExecutionReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainerHost_OnExecutionReady_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainerHost_OnExecutionReady_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ServiceWorkerContainerHost_OnExecutionReady_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExecutionReady();
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerContainerHostStubDispatch::AcceptWithResponder(
    ServiceWorkerContainerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerContainerHost_Register_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainerHost::Register",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainerHost::Register");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerContainerHost_Register_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerContainerHost_Register_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_script_url{};
      ::blink::mojom::ServiceWorkerRegistrationOptionsPtr p_options{};
      ::blink::mojom::FetchClientSettingsObjectPtr p_outside_fetch_client_settings_object{};
      ServiceWorkerContainerHost_Register_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScriptUrl(&p_script_url))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success && !input_data_view.ReadOutsideFetchClientSettingsObject(&p_outside_fetch_client_settings_object))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 0, false);
        return false;
      }
      ServiceWorkerContainerHost::RegisterCallback callback =
          ServiceWorkerContainerHost_Register_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(
std::move(p_script_url), 
std::move(p_options), 
std::move(p_outside_fetch_client_settings_object), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerContainerHost_GetRegistration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerContainerHost_GetRegistration_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerContainerHost_GetRegistration_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_client_url{};
      ServiceWorkerContainerHost_GetRegistration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUrl(&p_client_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 1, false);
        return false;
      }
      ServiceWorkerContainerHost::GetRegistrationCallback callback =
          ServiceWorkerContainerHost_GetRegistration_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistration(
std::move(p_client_url), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerContainerHost_GetRegistrations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistrations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistrations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerContainerHost_GetRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerContainerHost_GetRegistrations_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerContainerHost_GetRegistrations_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 2, false);
        return false;
      }
      ServiceWorkerContainerHost::GetRegistrationsCallback callback =
          ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrations(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerContainerHost_GetRegistrationForReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerContainerHost_GetRegistrationForReady_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerContainerHost_GetRegistrationForReady_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerContainerHost_GetRegistrationForReady_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 3, false);
        return false;
      }
      ServiceWorkerContainerHost::GetRegistrationForReadyCallback callback =
          ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrationForReady(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerContainerHost_EnsureControllerServiceWorker_Name: {
      break;
    }
    case internal::kServiceWorkerContainerHost_CloneContainerHost_Name: {
      break;
    }
    case internal::kServiceWorkerContainerHost_HintToUpdateServiceWorker_Name: {
      break;
    }
    case internal::kServiceWorkerContainerHost_EnsureFileAccess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainerHost::EnsureFileAccess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainerHost::EnsureFileAccess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerContainerHost_EnsureFileAccess_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerContainerHost_EnsureFileAccess_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<::base::FilePath> p_files{};
      ServiceWorkerContainerHost_EnsureFileAccess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFiles(&p_files))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 7, false);
        return false;
      }
      ServiceWorkerContainerHost::EnsureFileAccessCallback callback =
          ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnsureFileAccess(
std::move(p_files), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerContainerHost_OnExecutionReady_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerContainerHostValidationInfo[] = {
    {internal::kServiceWorkerContainerHost_Register_Name,
     {&internal::ServiceWorkerContainerHost_Register_Params_Data::Validate,
      &internal::ServiceWorkerContainerHost_Register_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerContainerHost_GetRegistration_Name,
     {&internal::ServiceWorkerContainerHost_GetRegistration_Params_Data::Validate,
      &internal::ServiceWorkerContainerHost_GetRegistration_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerContainerHost_GetRegistrations_Name,
     {&internal::ServiceWorkerContainerHost_GetRegistrations_Params_Data::Validate,
      &internal::ServiceWorkerContainerHost_GetRegistrations_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerContainerHost_GetRegistrationForReady_Name,
     {&internal::ServiceWorkerContainerHost_GetRegistrationForReady_Params_Data::Validate,
      &internal::ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerContainerHost_EnsureControllerServiceWorker_Name,
     {&internal::ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerContainerHost_CloneContainerHost_Name,
     {&internal::ServiceWorkerContainerHost_CloneContainerHost_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerContainerHost_HintToUpdateServiceWorker_Name,
     {&internal::ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerContainerHost_EnsureFileAccess_Name,
     {&internal::ServiceWorkerContainerHost_EnsureFileAccess_Params_Data::Validate,
      &internal::ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerContainerHost_OnExecutionReady_Name,
     {&internal::ServiceWorkerContainerHost_OnExecutionReady_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ServiceWorkerContainerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerContainerHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerContainerHostValidationInfo);
}

bool ServiceWorkerContainerHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerContainerHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceWorkerContainerHostValidationInfo);

}
const char ServiceWorkerContainer::Name_[] = "blink.mojom.ServiceWorkerContainer";

ServiceWorkerContainerProxy::ServiceWorkerContainerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerContainerProxy::SetController(
    ::blink::mojom::ControllerServiceWorkerInfoPtr in_controller_info, bool in_should_notify_controllerchange) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerContainer::SetController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller_info"), in_controller_info, 
                        "<value of type ::blink::mojom::ControllerServiceWorkerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_notify_controllerchange"), in_should_notify_controllerchange, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainer_SetController_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainer_SetController_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->controller_info)::BaseType> controller_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
      in_controller_info, controller_info_fragment);
  params->controller_info.Set(
      controller_info_fragment.is_null() ? nullptr : controller_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->controller_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null controller_info in ServiceWorkerContainer.SetController request");
  params->should_notify_controllerchange = in_should_notify_controllerchange;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainer::Name_);
  message.set_method_name("SetController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerContainerProxy::PostMessageToClient(
    ::blink::mojom::ServiceWorkerObjectInfoPtr in_source, ::blink::TransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerContainer::PostMessageToClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source, 
                        "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type ::blink::TransferableMessage>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainer_PostMessageToClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainer_PostMessageToClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
      in_source, source_fragment);
  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source in ServiceWorkerContainer.PostMessageToClient request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ServiceWorkerContainer.PostMessageToClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainer::Name_);
  message.set_method_name("PostMessageToClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerContainerProxy::CountFeature(
    ::blink::mojom::WebFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerContainer::CountFeature", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature, 
                        "<value of type ::blink::mojom::WebFeature>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerContainer_CountFeature_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainer_CountFeature_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::WebFeature>(
      in_feature, &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainer::Name_);
  message.set_method_name("CountFeature");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ServiceWorkerContainerStubDispatch::Accept(
    ServiceWorkerContainer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerContainer_SetController_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainer::SetController",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainer::SetController");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainer_SetController_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainer_SetController_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ControllerServiceWorkerInfoPtr p_controller_info{};
      bool p_should_notify_controllerchange{};
      ServiceWorkerContainer_SetController_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadControllerInfo(&p_controller_info))
        success = false;
      if (success)
        p_should_notify_controllerchange = input_data_view.should_notify_controllerchange();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetController(
std::move(p_controller_info), 
std::move(p_should_notify_controllerchange));
      return true;
    }
    case internal::kServiceWorkerContainer_PostMessageToClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainer::PostMessageToClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainer::PostMessageToClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainer_PostMessageToClient_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainer_PostMessageToClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ServiceWorkerObjectInfoPtr p_source{};
      ::blink::TransferableMessage p_message{};
      ServiceWorkerContainer_PostMessageToClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageToClient(
std::move(p_source), 
std::move(p_message));
      return true;
    }
    case internal::kServiceWorkerContainer_CountFeature_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerContainer::CountFeature",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerContainer::CountFeature");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainer_CountFeature_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainer_CountFeature_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::WebFeature p_feature{};
      ServiceWorkerContainer_CountFeature_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CountFeature(
std::move(p_feature));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerContainerStubDispatch::AcceptWithResponder(
    ServiceWorkerContainer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerContainer_SetController_Name: {
      break;
    }
    case internal::kServiceWorkerContainer_PostMessageToClient_Name: {
      break;
    }
    case internal::kServiceWorkerContainer_CountFeature_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerContainerValidationInfo[] = {
    {internal::kServiceWorkerContainer_SetController_Name,
     {&internal::ServiceWorkerContainer_SetController_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerContainer_PostMessageToClient_Name,
     {&internal::ServiceWorkerContainer_PostMessageToClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerContainer_CountFeature_Name,
     {&internal::ServiceWorkerContainer_CountFeature_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ServiceWorkerContainerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerContainer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerContainerValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ServiceWorkerContainerInfoForClient::DataView, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr>::Read(
    ::blink::mojom::ServiceWorkerContainerInfoForClient::DataView input,
    ::blink::mojom::ServiceWorkerContainerInfoForClientPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerContainerInfoForClientPtr result(::blink::mojom::ServiceWorkerContainerInfoForClient::New());
  
      if (success) {
        result->host_remote =
            input.TakeHostRemote<decltype(result->host_remote)>();
      }
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif