// third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_INSTALLED_SCRIPTS_MANAGER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_INSTALLED_SCRIPTS_MANAGER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ServiceWorkerInstalledScriptsInfo::ServiceWorkerInstalledScriptsInfo()
    : manager_receiver(),
      manager_host_remote(),
      installed_urls() {}

ServiceWorkerInstalledScriptsInfo::ServiceWorkerInstalledScriptsInfo(
    ::mojo::PendingReceiver<ServiceWorkerInstalledScriptsManager> manager_receiver_in,
    ::mojo::PendingRemote<ServiceWorkerInstalledScriptsManagerHost> manager_host_remote_in,
    std::vector<::GURL> installed_urls_in)
    : manager_receiver(std::move(manager_receiver_in)),
      manager_host_remote(std::move(manager_host_remote_in)),
      installed_urls(std::move(installed_urls_in)) {}

ServiceWorkerInstalledScriptsInfo::~ServiceWorkerInstalledScriptsInfo() = default;

void ServiceWorkerInstalledScriptsInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manager_receiver"), this->manager_receiver, 
      "<value of type ::mojo::PendingReceiver<ServiceWorkerInstalledScriptsManager>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manager_host_remote"), this->manager_host_remote, 
      "<value of type ::mojo::PendingRemote<ServiceWorkerInstalledScriptsManagerHost>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "installed_urls"), this->installed_urls, 
      "<value of type const std::vector<::GURL>&>");
}

bool ServiceWorkerInstalledScriptsInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerScriptInfo::ServiceWorkerScriptInfo()
    : script_url(),
      encoding(),
      headers(),
      body(),
      body_size(),
      meta_data(),
      meta_data_size() {}

ServiceWorkerScriptInfo::ServiceWorkerScriptInfo(
    const ::GURL& script_url_in,
    const std::string& encoding_in,
    const base::flat_map<std::string, std::string>& headers_in,
    ::mojo::ScopedDataPipeConsumerHandle body_in,
    uint64_t body_size_in,
    ::mojo::ScopedDataPipeConsumerHandle meta_data_in,
    uint64_t meta_data_size_in)
    : script_url(std::move(script_url_in)),
      encoding(std::move(encoding_in)),
      headers(std::move(headers_in)),
      body(std::move(body_in)),
      body_size(std::move(body_size_in)),
      meta_data(std::move(meta_data_in)),
      meta_data_size(std::move(meta_data_size_in)) {}

ServiceWorkerScriptInfo::~ServiceWorkerScriptInfo() = default;

void ServiceWorkerScriptInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_url"), this->script_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoding"), this->encoding, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers, 
      "<value of type const base::flat_map<std::string, std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body, 
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body_size"), this->body_size, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meta_data"), this->meta_data, 
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meta_data_size"), this->meta_data_size, 
      "<value of type uint64_t>");
}

bool ServiceWorkerScriptInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ServiceWorkerInstalledScriptsManagerHost::Name_[] = "blink.mojom.ServiceWorkerInstalledScriptsManagerHost";

ServiceWorkerInstalledScriptsManagerHostProxy::ServiceWorkerInstalledScriptsManagerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerInstalledScriptsManagerHostProxy::RequestInstalledScript(
    const ::GURL& in_script_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerInstalledScriptsManagerHost::RequestInstalledScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_url"), in_script_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script_url)::BaseType> script_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script_url, script_url_fragment);
  params->script_url.Set(
      script_url_fragment.is_null() ? nullptr : script_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_url in ServiceWorkerInstalledScriptsManagerHost.RequestInstalledScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerInstalledScriptsManagerHost::Name_);
  message.set_method_name("RequestInstalledScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ServiceWorkerInstalledScriptsManagerHostStubDispatch::Accept(
    ServiceWorkerInstalledScriptsManagerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerInstalledScriptsManagerHost::RequestInstalledScript",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerInstalledScriptsManagerHost::RequestInstalledScript");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_script_url{};
      ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScriptUrl(&p_script_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerInstalledScriptsManagerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestInstalledScript(
std::move(p_script_url));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerInstalledScriptsManagerHostStubDispatch::AcceptWithResponder(
    ServiceWorkerInstalledScriptsManagerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kServiceWorkerInstalledScriptsManagerHostValidationInfo[] = {
    {&internal::ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerInstalledScriptsManagerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerInstalledScriptsManagerHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kServiceWorkerInstalledScriptsManagerHostValidationInfo);
}

const char ServiceWorkerInstalledScriptsManager::Name_[] = "blink.mojom.ServiceWorkerInstalledScriptsManager";

ServiceWorkerInstalledScriptsManagerProxy::ServiceWorkerInstalledScriptsManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerInstalledScriptsManagerProxy::TransferInstalledScript(
    ServiceWorkerScriptInfoPtr in_script_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerInstalledScriptsManager::TransferInstalledScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_info"), in_script_info, 
                        "<value of type ServiceWorkerScriptInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerInstalledScriptsManager_TransferInstalledScript_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script_info)::BaseType> script_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerScriptInfoDataView>(
      in_script_info, script_info_fragment);
  params->script_info.Set(
      script_info_fragment.is_null() ? nullptr : script_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_info in ServiceWorkerInstalledScriptsManager.TransferInstalledScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerInstalledScriptsManager::Name_);
  message.set_method_name("TransferInstalledScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ServiceWorkerInstalledScriptsManagerStubDispatch::Accept(
    ServiceWorkerInstalledScriptsManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerInstalledScriptsManager_TransferInstalledScript_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerInstalledScriptsManager::TransferInstalledScript",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerInstalledScriptsManager::TransferInstalledScript");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ServiceWorkerScriptInfoPtr p_script_info{};
      ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScriptInfo(&p_script_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerInstalledScriptsManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TransferInstalledScript(
std::move(p_script_info));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerInstalledScriptsManagerStubDispatch::AcceptWithResponder(
    ServiceWorkerInstalledScriptsManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerInstalledScriptsManager_TransferInstalledScript_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kServiceWorkerInstalledScriptsManagerValidationInfo[] = {
    {&internal::ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerInstalledScriptsManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerInstalledScriptsManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kServiceWorkerInstalledScriptsManagerValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ServiceWorkerInstalledScriptsInfo::DataView, ::blink::mojom::ServiceWorkerInstalledScriptsInfoPtr>::Read(
    ::blink::mojom::ServiceWorkerInstalledScriptsInfo::DataView input,
    ::blink::mojom::ServiceWorkerInstalledScriptsInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerInstalledScriptsInfoPtr result(::blink::mojom::ServiceWorkerInstalledScriptsInfo::New());
  
      if (success) {
        result->manager_receiver =
            input.TakeManagerReceiver<decltype(result->manager_receiver)>();
      }
      if (success) {
        result->manager_host_remote =
            input.TakeManagerHostRemote<decltype(result->manager_host_remote)>();
      }
      if (success && !input.ReadInstalledUrls(&result->installed_urls))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerScriptInfo::DataView, ::blink::mojom::ServiceWorkerScriptInfoPtr>::Read(
    ::blink::mojom::ServiceWorkerScriptInfo::DataView input,
    ::blink::mojom::ServiceWorkerScriptInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerScriptInfoPtr result(::blink::mojom::ServiceWorkerScriptInfo::New());
  
      if (success && !input.ReadScriptUrl(&result->script_url))
        success = false;
      if (success && !input.ReadEncoding(&result->encoding))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success)
        result->body = input.TakeBody();
      if (success)
        result->body_size = input.body_size();
      if (success)
        result->meta_data = input.TakeMetaData();
      if (success)
        result->meta_data_size = input.meta_data_size();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif