// third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_STREAM_HANDLE_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_STREAM_HANDLE_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
ServiceWorkerStreamHandle::ServiceWorkerStreamHandle()
    : stream(),
      callback_receiver() {}

ServiceWorkerStreamHandle::ServiceWorkerStreamHandle(
    ::mojo::ScopedDataPipeConsumerHandle stream_in,
    ::mojo::PendingReceiver<ServiceWorkerStreamCallback> callback_receiver_in)
    : stream(std::move(stream_in)),
      callback_receiver(std::move(callback_receiver_in)) {}

ServiceWorkerStreamHandle::~ServiceWorkerStreamHandle() = default;

void ServiceWorkerStreamHandle::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream"), this->stream, 
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "callback_receiver"), this->callback_receiver, 
      "<value of type ::mojo::PendingReceiver<ServiceWorkerStreamCallback>>");
}

bool ServiceWorkerStreamHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ServiceWorkerStreamCallback::Name_[] = "blink.mojom.ServiceWorkerStreamCallback";

ServiceWorkerStreamCallbackProxy::ServiceWorkerStreamCallbackProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerStreamCallbackProxy::OnCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerStreamCallback::OnCompleted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStreamCallback_OnCompleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerStreamCallback_OnCompleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStreamCallback::Name_);
  message.set_method_name("OnCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerStreamCallbackProxy::OnAborted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerStreamCallback::OnAborted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStreamCallback_OnAborted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerStreamCallback_OnAborted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStreamCallback::Name_);
  message.set_method_name("OnAborted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ServiceWorkerStreamCallbackStubDispatch::Accept(
    ServiceWorkerStreamCallback* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerStreamCallback_OnCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerStreamCallback::OnCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerStreamCallback::OnCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerStreamCallback_OnCompleted_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerStreamCallback_OnCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStreamCallback_OnCompleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStreamCallback::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCompleted();
      return true;
    }
    case internal::kServiceWorkerStreamCallback_OnAborted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerStreamCallback::OnAborted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerStreamCallback::OnAborted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerStreamCallback_OnAborted_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerStreamCallback_OnAborted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStreamCallback_OnAborted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStreamCallback::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAborted();
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerStreamCallbackStubDispatch::AcceptWithResponder(
    ServiceWorkerStreamCallback* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerStreamCallback_OnCompleted_Name: {
      break;
    }
    case internal::kServiceWorkerStreamCallback_OnAborted_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kServiceWorkerStreamCallbackValidationInfo[] = {
    {&internal::ServiceWorkerStreamCallback_OnCompleted_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ServiceWorkerStreamCallback_OnAborted_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerStreamCallbackRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ServiceWorkerStreamCallback::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kServiceWorkerStreamCallbackValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ServiceWorkerStreamHandle::DataView, ::blink::mojom::blink::ServiceWorkerStreamHandlePtr>::Read(
    ::blink::mojom::blink::ServiceWorkerStreamHandle::DataView input,
    ::blink::mojom::blink::ServiceWorkerStreamHandlePtr* output) {
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerStreamHandlePtr result(::blink::mojom::blink::ServiceWorkerStreamHandle::New());
  
      if (success)
        result->stream = input.TakeStream();
      if (success) {
        result->callback_receiver =
            input.TakeCallbackReceiver<decltype(result->callback_receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif