// third_party/blink/public/mojom/sms/webotp_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/sms/webotp_service.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/sms/webotp_service.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string SmsStatusToString(SmsStatus value) {
  switch(value) {
    case SmsStatus::kSuccess:
      return "SmsStatus::kSuccess";
    case SmsStatus::kUnhandledRequest:
      return "SmsStatus::kUnhandledRequest";
    case SmsStatus::kCancelled:
      return "SmsStatus::kCancelled";
    case SmsStatus::kAborted:
      return "SmsStatus::kAborted";
    case SmsStatus::kTimeout:
      return "SmsStatus::kTimeout";
    case SmsStatus::kBackendNotAvailable:
      return "SmsStatus::kBackendNotAvailable";
    default:
      return base::StringPrintf("Unknown SmsStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SmsStatus value) {
  return os << SmsStatusToString(value);
}

namespace internal {


// static
bool WebOTPService_Receive_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebOTPService_Receive_Params_Data* object = static_cast<const WebOTPService_Receive_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WebOTPService_Receive_Params_Data::WebOTPService_Receive_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebOTPService_Receive_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebOTPService_Receive_ResponseParams_Data* object = static_cast<const WebOTPService_Receive_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::SmsStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams otp_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->otp, validation_context,
                                         &otp_validate_params)) {
    return false;
  }

  return true;
}

WebOTPService_Receive_ResponseParams_Data::WebOTPService_Receive_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebOTPService_Abort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebOTPService_Abort_Params_Data* object = static_cast<const WebOTPService_Abort_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WebOTPService_Abort_Params_Data::WebOTPService_Abort_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SmsStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::SmsStatus value) {
  return std::move(context).WriteString(::blink::mojom::SmsStatusToString(value));
}

} // namespace perfetto
