// third_party/blink/public/mojom/speech/speech_synthesis.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-params-data.h"
#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
SpeechSynthesisUtterance::SpeechSynthesisUtterance()
    : text(),
      lang(),
      voice(),
      volume(),
      rate(),
      pitch() {}

SpeechSynthesisUtterance::SpeechSynthesisUtterance(
    const std::string& text_in,
    const std::string& lang_in,
    const std::string& voice_in,
    double volume_in,
    double rate_in,
    double pitch_in)
    : text(std::move(text_in)),
      lang(std::move(lang_in)),
      voice(std::move(voice_in)),
      volume(std::move(volume_in)),
      rate(std::move(rate_in)),
      pitch(std::move(pitch_in)) {}

SpeechSynthesisUtterance::~SpeechSynthesisUtterance() = default;
size_t SpeechSynthesisUtterance::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->text);
  seed = mojo::internal::Hash(seed, this->lang);
  seed = mojo::internal::Hash(seed, this->voice);
  seed = mojo::internal::Hash(seed, this->volume);
  seed = mojo::internal::Hash(seed, this->rate);
  seed = mojo::internal::Hash(seed, this->pitch);
  return seed;
}

void SpeechSynthesisUtterance::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lang"), this->lang, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "voice"), this->voice, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "volume"), this->volume, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rate"), this->rate, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pitch"), this->pitch, 
      "<value of type double>");
}

bool SpeechSynthesisUtterance::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpeechSynthesisVoice::SpeechSynthesisVoice()
    : voice_uri(),
      name(),
      lang(),
      is_local_service(),
      is_default() {}

SpeechSynthesisVoice::SpeechSynthesisVoice(
    const std::string& voice_uri_in,
    const std::string& name_in,
    const std::string& lang_in,
    bool is_local_service_in,
    bool is_default_in)
    : voice_uri(std::move(voice_uri_in)),
      name(std::move(name_in)),
      lang(std::move(lang_in)),
      is_local_service(std::move(is_local_service_in)),
      is_default(std::move(is_default_in)) {}

SpeechSynthesisVoice::~SpeechSynthesisVoice() = default;
size_t SpeechSynthesisVoice::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->voice_uri);
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->lang);
  seed = mojo::internal::Hash(seed, this->is_local_service);
  seed = mojo::internal::Hash(seed, this->is_default);
  return seed;
}

void SpeechSynthesisVoice::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "voice_uri"), this->voice_uri, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lang"), this->lang, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_local_service"), this->is_local_service, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_default"), this->is_default, 
      "<value of type bool>");
}

bool SpeechSynthesisVoice::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SpeechSynthesisVoiceListObserver::Name_[] = "blink.mojom.SpeechSynthesisVoiceListObserver";

SpeechSynthesisVoiceListObserverProxy::SpeechSynthesisVoiceListObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechSynthesisVoiceListObserverProxy::OnSetVoiceList(
    std::vector<SpeechSynthesisVoicePtr> in_voice_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SpeechSynthesisVoiceListObserver::OnSetVoiceList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("voice_list"), in_voice_list, 
                        "<value of type std::vector<SpeechSynthesisVoicePtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesisVoiceListObserver_OnSetVoiceList_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->voice_list)::BaseType>
      voice_list_fragment(params.message());
  const mojo::internal::ContainerValidateParams voice_list_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SpeechSynthesisVoiceDataView>>(
      in_voice_list, voice_list_fragment, &voice_list_validate_params);
  params->voice_list.Set(
      voice_list_fragment.is_null() ? nullptr : voice_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->voice_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null voice_list in SpeechSynthesisVoiceListObserver.OnSetVoiceList request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisVoiceListObserver::Name_);
  message.set_method_name("OnSetVoiceList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechSynthesisVoiceListObserverStubDispatch::Accept(
    SpeechSynthesisVoiceListObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechSynthesisVoiceListObserver_OnSetVoiceList_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesisVoiceListObserver::OnSetVoiceList",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesisVoiceListObserver::OnSetVoiceList");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<SpeechSynthesisVoicePtr> p_voice_list{};
      SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVoiceList(&p_voice_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisVoiceListObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSetVoiceList(
std::move(p_voice_list));
      return true;
    }
  }
  return false;
}

// static
bool SpeechSynthesisVoiceListObserverStubDispatch::AcceptWithResponder(
    SpeechSynthesisVoiceListObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechSynthesisVoiceListObserver_OnSetVoiceList_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSpeechSynthesisVoiceListObserverValidationInfo[] = {
    {&internal::SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechSynthesisVoiceListObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SpeechSynthesisVoiceListObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSpeechSynthesisVoiceListObserverValidationInfo);
}

const char SpeechSynthesisClient::Name_[] = "blink.mojom.SpeechSynthesisClient";

SpeechSynthesisClientProxy::SpeechSynthesisClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechSynthesisClientProxy::OnStartedSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechSynthesisClient::OnStartedSpeaking");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesisClient_OnStartedSpeaking_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnStartedSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnStartedSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechSynthesisClientProxy::OnFinishedSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechSynthesisClient::OnFinishedSpeaking");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesisClient_OnFinishedSpeaking_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnFinishedSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnFinishedSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechSynthesisClientProxy::OnPausedSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechSynthesisClient::OnPausedSpeaking");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesisClient_OnPausedSpeaking_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnPausedSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnPausedSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechSynthesisClientProxy::OnResumedSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechSynthesisClient::OnResumedSpeaking");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesisClient_OnResumedSpeaking_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnResumedSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnResumedSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechSynthesisClientProxy::OnEncounteredWordBoundary(
    uint32_t in_char_index, uint32_t in_char_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SpeechSynthesisClient::OnEncounteredWordBoundary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("char_index"), in_char_index, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("char_length"), in_char_length, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesisClient_OnEncounteredWordBoundary_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnEncounteredWordBoundary_Params_Data> params(
          message);
  params.Allocate();
  params->char_index = in_char_index;
  params->char_length = in_char_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnEncounteredWordBoundary");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechSynthesisClientProxy::OnEncounteredSentenceBoundary(
    uint32_t in_char_index, uint32_t in_char_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SpeechSynthesisClient::OnEncounteredSentenceBoundary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("char_index"), in_char_index, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("char_length"), in_char_length, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesisClient_OnEncounteredSentenceBoundary_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params_Data> params(
          message);
  params.Allocate();
  params->char_index = in_char_index;
  params->char_length = in_char_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnEncounteredSentenceBoundary");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechSynthesisClientProxy::OnEncounteredSpeakingError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechSynthesisClient::OnEncounteredSpeakingError");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesisClient_OnEncounteredSpeakingError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnEncounteredSpeakingError_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnEncounteredSpeakingError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechSynthesisClientStubDispatch::Accept(
    SpeechSynthesisClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechSynthesisClient_OnStartedSpeaking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesisClient::OnStartedSpeaking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesisClient::OnStartedSpeaking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnStartedSpeaking_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnStartedSpeaking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechSynthesisClient_OnStartedSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartedSpeaking();
      return true;
    }
    case internal::kSpeechSynthesisClient_OnFinishedSpeaking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesisClient::OnFinishedSpeaking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesisClient::OnFinishedSpeaking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnFinishedSpeaking_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnFinishedSpeaking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechSynthesisClient_OnFinishedSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFinishedSpeaking();
      return true;
    }
    case internal::kSpeechSynthesisClient_OnPausedSpeaking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesisClient::OnPausedSpeaking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesisClient::OnPausedSpeaking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnPausedSpeaking_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnPausedSpeaking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechSynthesisClient_OnPausedSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPausedSpeaking();
      return true;
    }
    case internal::kSpeechSynthesisClient_OnResumedSpeaking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesisClient::OnResumedSpeaking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesisClient::OnResumedSpeaking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnResumedSpeaking_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnResumedSpeaking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechSynthesisClient_OnResumedSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResumedSpeaking();
      return true;
    }
    case internal::kSpeechSynthesisClient_OnEncounteredWordBoundary_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesisClient::OnEncounteredWordBoundary",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesisClient::OnEncounteredWordBoundary");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnEncounteredWordBoundary_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnEncounteredWordBoundary_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_char_index{};
      uint32_t p_char_length{};
      SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_char_index = input_data_view.char_index();
      if (success)
        p_char_length = input_data_view.char_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEncounteredWordBoundary(
std::move(p_char_index), 
std::move(p_char_length));
      return true;
    }
    case internal::kSpeechSynthesisClient_OnEncounteredSentenceBoundary_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesisClient::OnEncounteredSentenceBoundary",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesisClient::OnEncounteredSentenceBoundary");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_char_index{};
      uint32_t p_char_length{};
      SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_char_index = input_data_view.char_index();
      if (success)
        p_char_length = input_data_view.char_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEncounteredSentenceBoundary(
std::move(p_char_index), 
std::move(p_char_length));
      return true;
    }
    case internal::kSpeechSynthesisClient_OnEncounteredSpeakingError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesisClient::OnEncounteredSpeakingError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesisClient::OnEncounteredSpeakingError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnEncounteredSpeakingError_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnEncounteredSpeakingError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEncounteredSpeakingError();
      return true;
    }
  }
  return false;
}

// static
bool SpeechSynthesisClientStubDispatch::AcceptWithResponder(
    SpeechSynthesisClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechSynthesisClient_OnStartedSpeaking_Name: {
      break;
    }
    case internal::kSpeechSynthesisClient_OnFinishedSpeaking_Name: {
      break;
    }
    case internal::kSpeechSynthesisClient_OnPausedSpeaking_Name: {
      break;
    }
    case internal::kSpeechSynthesisClient_OnResumedSpeaking_Name: {
      break;
    }
    case internal::kSpeechSynthesisClient_OnEncounteredWordBoundary_Name: {
      break;
    }
    case internal::kSpeechSynthesisClient_OnEncounteredSentenceBoundary_Name: {
      break;
    }
    case internal::kSpeechSynthesisClient_OnEncounteredSpeakingError_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSpeechSynthesisClientValidationInfo[] = {
    {&internal::SpeechSynthesisClient_OnStartedSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechSynthesisClient_OnFinishedSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechSynthesisClient_OnPausedSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechSynthesisClient_OnResumedSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechSynthesisClient_OnEncounteredWordBoundary_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechSynthesisClient_OnEncounteredSpeakingError_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechSynthesisClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SpeechSynthesisClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSpeechSynthesisClientValidationInfo);
}

const char SpeechSynthesis::Name_[] = "blink.mojom.SpeechSynthesis";

SpeechSynthesisProxy::SpeechSynthesisProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechSynthesisProxy::AddVoiceListObserver(
    ::mojo::PendingRemote<SpeechSynthesisVoiceListObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SpeechSynthesis::AddVoiceListObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<SpeechSynthesisVoiceListObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesis_AddVoiceListObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesis_AddVoiceListObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SpeechSynthesisVoiceListObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in SpeechSynthesis.AddVoiceListObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesis::Name_);
  message.set_method_name("AddVoiceListObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechSynthesisProxy::Speak(
    SpeechSynthesisUtterancePtr in_utterance, ::mojo::PendingRemote<SpeechSynthesisClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SpeechSynthesis::Speak", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("utterance"), in_utterance, 
                        "<value of type SpeechSynthesisUtterancePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<SpeechSynthesisClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesis_Speak_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesis_Speak_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->utterance)::BaseType> utterance_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SpeechSynthesisUtteranceDataView>(
      in_utterance, utterance_fragment);
  params->utterance.Set(
      utterance_fragment.is_null() ? nullptr : utterance_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->utterance.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null utterance in SpeechSynthesis.Speak request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SpeechSynthesisClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SpeechSynthesis.Speak request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesis::Name_);
  message.set_method_name("Speak");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechSynthesisProxy::Pause(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechSynthesis::Pause");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesis_Pause_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesis_Pause_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesis::Name_);
  message.set_method_name("Pause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechSynthesisProxy::Resume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechSynthesis::Resume");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesis_Resume_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesis_Resume_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesis::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechSynthesisProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechSynthesis::Cancel");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechSynthesis_Cancel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesis_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesis::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechSynthesisStubDispatch::Accept(
    SpeechSynthesis* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechSynthesis_AddVoiceListObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesis::AddVoiceListObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesis::AddVoiceListObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesis_AddVoiceListObserver_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesis_AddVoiceListObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<SpeechSynthesisVoiceListObserver> p_observer{};
      SpeechSynthesis_AddVoiceListObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesis::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddVoiceListObserver(
std::move(p_observer));
      return true;
    }
    case internal::kSpeechSynthesis_Speak_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesis::Speak",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesis::Speak");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesis_Speak_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesis_Speak_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechSynthesisUtterancePtr p_utterance{};
      ::mojo::PendingRemote<SpeechSynthesisClient> p_client{};
      SpeechSynthesis_Speak_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUtterance(&p_utterance))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesis::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Speak(
std::move(p_utterance), 
std::move(p_client));
      return true;
    }
    case internal::kSpeechSynthesis_Pause_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesis::Pause",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesis::Pause");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesis_Pause_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesis_Pause_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechSynthesis_Pause_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesis::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Pause();
      return true;
    }
    case internal::kSpeechSynthesis_Resume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesis::Resume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesis::Resume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesis_Resume_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesis_Resume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechSynthesis_Resume_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesis::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume();
      return true;
    }
    case internal::kSpeechSynthesis_Cancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechSynthesis::Cancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechSynthesis::Cancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechSynthesis_Cancel_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesis_Cancel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechSynthesis_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesis::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel();
      return true;
    }
  }
  return false;
}

// static
bool SpeechSynthesisStubDispatch::AcceptWithResponder(
    SpeechSynthesis* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechSynthesis_AddVoiceListObserver_Name: {
      break;
    }
    case internal::kSpeechSynthesis_Speak_Name: {
      break;
    }
    case internal::kSpeechSynthesis_Pause_Name: {
      break;
    }
    case internal::kSpeechSynthesis_Resume_Name: {
      break;
    }
    case internal::kSpeechSynthesis_Cancel_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSpeechSynthesisValidationInfo[] = {
    {&internal::SpeechSynthesis_AddVoiceListObserver_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechSynthesis_Speak_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechSynthesis_Pause_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechSynthesis_Resume_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechSynthesis_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechSynthesisRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SpeechSynthesis::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSpeechSynthesisValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::SpeechSynthesisUtterance::DataView, ::blink::mojom::SpeechSynthesisUtterancePtr>::Read(
    ::blink::mojom::SpeechSynthesisUtterance::DataView input,
    ::blink::mojom::SpeechSynthesisUtterancePtr* output) {
  bool success = true;
  ::blink::mojom::SpeechSynthesisUtterancePtr result(::blink::mojom::SpeechSynthesisUtterance::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadLang(&result->lang))
        success = false;
      if (success && !input.ReadVoice(&result->voice))
        success = false;
      if (success)
        result->volume = input.volume();
      if (success)
        result->rate = input.rate();
      if (success)
        result->pitch = input.pitch();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SpeechSynthesisVoice::DataView, ::blink::mojom::SpeechSynthesisVoicePtr>::Read(
    ::blink::mojom::SpeechSynthesisVoice::DataView input,
    ::blink::mojom::SpeechSynthesisVoicePtr* output) {
  bool success = true;
  ::blink::mojom::SpeechSynthesisVoicePtr result(::blink::mojom::SpeechSynthesisVoice::New());
  
      if (success && !input.ReadVoiceUri(&result->voice_uri))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadLang(&result->lang))
        success = false;
      if (success)
        result->is_local_service = input.is_local_service();
      if (success)
        result->is_default = input.is_default();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif