// third_party/blink/public/mojom/timing/resource_timing.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string CacheStateToString(CacheState value) {
  switch(value) {
    case CacheState::kNone:
      return "CacheState::kNone";
    case CacheState::kLocal:
      return "CacheState::kLocal";
    case CacheState::kValidated:
      return "CacheState::kValidated";
    default:
      return base::StringPrintf("Unknown CacheState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CacheState value) {
  return os << CacheStateToString(value);
}

namespace internal {


// static
bool ServerTimingInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServerTimingInfo_Data* object = static_cast<const ServerTimingInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams description_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  return true;
}

ServerTimingInfo_Data::ServerTimingInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResourceTimingInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResourceTimingInfo_Data* object = static_cast<const ResourceTimingInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alpn_negotiated_protocol, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams alpn_negotiated_protocol_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->alpn_negotiated_protocol, validation_context,
                                         &alpn_negotiated_protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->connection_info, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams connection_info_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->connection_info, validation_context,
                                         &connection_info_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_redirect_end_time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_redirect_end_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_end, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_end, validation_context))
    return false;


  if (!::blink::mojom::internal::RequestContextType_Data
        ::Validate(object->context_type, validation_context))
    return false;


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->request_destination, validation_context))
    return false;


  if (!::blink::mojom::internal::CacheState_Data
        ::Validate(object->cache_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_timing, 18, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams server_timing_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->server_timing, validation_context,
                                         &server_timing_validate_params)) {
    return false;
  }

  return true;
}

ResourceTimingInfo_Data::ResourceTimingInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CacheState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::CacheState value) {
  return std::move(context).WriteString(::blink::mojom::CacheStateToString(value));
}

} // namespace perfetto
