// third_party/blink/public/mojom/tokens/tokens.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/tokens/tokens.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool FrameToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const FrameToken_Data* object = static_cast<const FrameToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case FrameToken_Tag::LOCAL_FRAME_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_local_frame_token, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_local_frame_token, validation_context))
        return false;
      return true;
    }
    case FrameToken_Tag::REMOTE_FRAME_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_remote_frame_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_remote_frame_token, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in FrameToken");
      return false;
    }
  }
}
// static
bool WorkerToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WorkerToken_Data* object = static_cast<const WorkerToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WorkerToken_Tag::DEDICATED_WORKER_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dedicated_worker_token, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dedicated_worker_token, validation_context))
        return false;
      return true;
    }
    case WorkerToken_Tag::SERVICE_WORKER_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_service_worker_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_service_worker_token, validation_context))
        return false;
      return true;
    }
    case WorkerToken_Tag::SHARED_WORKER_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_worker_token, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_worker_token, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WorkerToken");
      return false;
    }
  }
}
// static
bool WorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WorkletToken_Data* object = static_cast<const WorkletToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WorkletToken_Tag::ANIMATION_WORKLET_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_animation_worklet_token, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_animation_worklet_token, validation_context))
        return false;
      return true;
    }
    case WorkletToken_Tag::AUDIO_WORKLET_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_audio_worklet_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_audio_worklet_token, validation_context))
        return false;
      return true;
    }
    case WorkletToken_Tag::LAYOUT_WORKLET_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_layout_worklet_token, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_layout_worklet_token, validation_context))
        return false;
      return true;
    }
    case WorkletToken_Tag::PAINT_WORKLET_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_paint_worklet_token, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_paint_worklet_token, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WorkletToken");
      return false;
    }
  }
}
// static
bool ExecutionContextToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ExecutionContextToken_Data* object = static_cast<const ExecutionContextToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ExecutionContextToken_Tag::LOCAL_FRAME_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_local_frame_token, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_local_frame_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::DEDICATED_WORKER_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dedicated_worker_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dedicated_worker_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::SERVICE_WORKER_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_service_worker_token, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_service_worker_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::SHARED_WORKER_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_worker_token, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_worker_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::ANIMATION_WORKLET_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_animation_worklet_token, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_animation_worklet_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::AUDIO_WORKLET_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_audio_worklet_token, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_audio_worklet_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::LAYOUT_WORKLET_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_layout_worklet_token, 7, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_layout_worklet_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::PAINT_WORKLET_TOKEN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_paint_worklet_token, 8, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_paint_worklet_token, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ExecutionContextToken");
      return false;
    }
  }
}


// static
bool LocalFrameToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameToken_Data* object = static_cast<const LocalFrameToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

LocalFrameToken_Data::LocalFrameToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameToken_Data* object = static_cast<const RemoteFrameToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

RemoteFrameToken_Data::RemoteFrameToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DedicatedWorkerToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DedicatedWorkerToken_Data* object = static_cast<const DedicatedWorkerToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

DedicatedWorkerToken_Data::DedicatedWorkerToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerToken_Data* object = static_cast<const ServiceWorkerToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

ServiceWorkerToken_Data::ServiceWorkerToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedWorkerToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SharedWorkerToken_Data* object = static_cast<const SharedWorkerToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

SharedWorkerToken_Data::SharedWorkerToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AnimationWorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AnimationWorkletToken_Data* object = static_cast<const AnimationWorkletToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

AnimationWorkletToken_Data::AnimationWorkletToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioWorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AudioWorkletToken_Data* object = static_cast<const AudioWorkletToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

AudioWorkletToken_Data::AudioWorkletToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayoutWorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LayoutWorkletToken_Data* object = static_cast<const LayoutWorkletToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

LayoutWorkletToken_Data::LayoutWorkletToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintWorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaintWorkletToken_Data* object = static_cast<const PaintWorkletToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

PaintWorkletToken_Data::PaintWorkletToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PortalToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PortalToken_Data* object = static_cast<const PortalToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

PortalToken_Data::PortalToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool V8ContextToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const V8ContextToken_Data* object = static_cast<const V8ContextToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

V8ContextToken_Data::V8ContextToken_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
