// third_party/blink/public/mojom/usb/web_usb_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/usb/web_usb_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char WebUsbService::Name_[] = "blink.mojom.WebUsbService";

class WebUsbService_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebUsbService_GetDevices_ForwardToCallback(
      WebUsbService::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebUsbService::GetDevicesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebUsbService_GetDevices_ForwardToCallback);
};

class WebUsbService_GetPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebUsbService_GetPermission_ForwardToCallback(
      WebUsbService::GetPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebUsbService::GetPermissionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebUsbService_GetPermission_ForwardToCallback);
};

WebUsbServiceProxy::WebUsbServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebUsbServiceProxy::GetDevices(
    GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::WebUsbService::GetDevices");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebUsbService_GetDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_GetDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebUsbService_GetDevices_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebUsbServiceProxy::GetDevice(
    const std::string& in_guid, ::mojo::PendingReceiver<::device::mojom::UsbDevice> in_device_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebUsbService::GetDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_receiver"), in_device_receiver, 
                        "<value of type ::mojo::PendingReceiver<::device::mojom::UsbDevice>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebUsbService_GetDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_GetDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_guid, guid_fragment);
  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->guid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in WebUsbService.GetDevice request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::UsbDeviceInterfaceBase>>(
      in_device_receiver, &params->device_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->device_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid device_receiver in WebUsbService.GetDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("GetDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebUsbServiceProxy::GetPermission(
    std::vector<::device::mojom::UsbDeviceFilterPtr> in_device_filters, GetPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebUsbService::GetPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_filters"), in_device_filters, 
                        "<value of type std::vector<::device::mojom::UsbDeviceFilterPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebUsbService_GetPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_GetPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_filters)::BaseType>
      device_filters_fragment(params.message());
  const mojo::internal::ContainerValidateParams device_filters_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>>(
      in_device_filters, device_filters_fragment, &device_filters_validate_params);
  params->device_filters.Set(
      device_filters_fragment.is_null() ? nullptr : device_filters_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_filters.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_filters in WebUsbService.GetPermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("GetPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebUsbService_GetPermission_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebUsbServiceProxy::SetClient(
    ::mojo::PendingAssociatedRemote<::device::mojom::UsbDeviceManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebUsbService::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingAssociatedRemote<::device::mojom::UsbDeviceManagerClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebUsbService_SetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_SetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::UsbDeviceManagerClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in WebUsbService.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class WebUsbService_GetDevices_ProxyToResponder {
 public:
  static WebUsbService::GetDevicesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebUsbService_GetDevices_ProxyToResponder> proxy(
        new WebUsbService_GetDevices_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebUsbService_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebUsbService_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebUsbService_GetDevices_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebUsbService::GetDevicesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::device::mojom::UsbDeviceInfoPtr> in_results);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebUsbService_GetDevices_ProxyToResponder);
};

bool WebUsbService_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WebUsbService::GetDevicesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebUsbService_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebUsbService_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::device::mojom::UsbDeviceInfoPtr> p_results{};
  WebUsbService_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebUsbService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_results));
  return true;
}

void WebUsbService_GetDevices_ProxyToResponder::Run(
    std::vector<::device::mojom::UsbDeviceInfoPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WebUsbService::GetDevicesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results, 
                        "<value of type std::vector<::device::mojom::UsbDeviceInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebUsbService_GetDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  const mojo::internal::ContainerValidateParams results_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbDeviceInfoDataView>>(
      in_results, results_fragment, &results_validate_params);
  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WebUsbService::GetDevicesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebUsbService_GetPermission_ProxyToResponder {
 public:
  static WebUsbService::GetPermissionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebUsbService_GetPermission_ProxyToResponder> proxy(
        new WebUsbService_GetPermission_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebUsbService_GetPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebUsbService_GetPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebUsbService_GetPermission_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebUsbService::GetPermissionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::UsbDeviceInfoPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebUsbService_GetPermission_ProxyToResponder);
};

bool WebUsbService_GetPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WebUsbService::GetPermissionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebUsbService_GetPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebUsbService_GetPermission_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::device::mojom::UsbDeviceInfoPtr p_result{};
  WebUsbService_GetPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebUsbService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void WebUsbService_GetPermission_ProxyToResponder::Run(
    ::device::mojom::UsbDeviceInfoPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WebUsbService::GetPermissionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::device::mojom::UsbDeviceInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebUsbService_GetPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_GetPermission_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::UsbDeviceInfoDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WebUsbService::GetPermissionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("GetPermission");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebUsbServiceStubDispatch::Accept(
    WebUsbService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebUsbService_GetDevices_Name: {
      break;
    }
    case internal::kWebUsbService_GetDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebUsbService::GetDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebUsbService::GetDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebUsbService_GetDevice_Params_Data* params =
          reinterpret_cast<internal::WebUsbService_GetDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_guid{};
      ::mojo::PendingReceiver<::device::mojom::UsbDevice> p_device_receiver{};
      WebUsbService_GetDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (success) {
        p_device_receiver =
            input_data_view.TakeDeviceReceiver<decltype(p_device_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebUsbService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevice(
std::move(p_guid), 
std::move(p_device_receiver));
      return true;
    }
    case internal::kWebUsbService_GetPermission_Name: {
      break;
    }
    case internal::kWebUsbService_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebUsbService::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebUsbService::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebUsbService_SetClient_Params_Data* params =
          reinterpret_cast<internal::WebUsbService_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<::device::mojom::UsbDeviceManagerClient> p_client{};
      WebUsbService_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebUsbService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool WebUsbServiceStubDispatch::AcceptWithResponder(
    WebUsbService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebUsbService_GetDevices_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebUsbService::GetDevices",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebUsbService::GetDevices");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebUsbService_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::WebUsbService_GetDevices_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WebUsbService_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebUsbService::Name_, 0, false);
        return false;
      }
      WebUsbService::GetDevicesCallback callback =
          WebUsbService_GetDevices_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(std::move(callback));
      return true;
    }
    case internal::kWebUsbService_GetDevice_Name: {
      break;
    }
    case internal::kWebUsbService_GetPermission_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebUsbService::GetPermission",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebUsbService::GetPermission");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebUsbService_GetPermission_Params_Data* params =
          reinterpret_cast<
              internal::WebUsbService_GetPermission_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<::device::mojom::UsbDeviceFilterPtr> p_device_filters{};
      WebUsbService_GetPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceFilters(&p_device_filters))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebUsbService::Name_, 2, false);
        return false;
      }
      WebUsbService::GetPermissionCallback callback =
          WebUsbService_GetPermission_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPermission(
std::move(p_device_filters), std::move(callback));
      return true;
    }
    case internal::kWebUsbService_SetClient_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWebUsbServiceValidationInfo[] = {
    {&internal::WebUsbService_GetDevices_Params_Data::Validate,
     &internal::WebUsbService_GetDevices_ResponseParams_Data::Validate},
    {&internal::WebUsbService_GetDevice_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WebUsbService_GetPermission_Params_Data::Validate,
     &internal::WebUsbService_GetPermission_ResponseParams_Data::Validate},
    {&internal::WebUsbService_SetClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebUsbServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WebUsbService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWebUsbServiceValidationInfo);
}

bool WebUsbServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WebUsbService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kWebUsbServiceValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif