// third_party/blink/public/mojom/webauthn/authenticator.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_BLINK_JUMBO_H_
#endif


namespace blink {
namespace mojom {
namespace blink {


void AuthenticatorInterceptorForTesting::MakeCredential(PublicKeyCredentialCreationOptionsPtr options, MakeCredentialCallback callback) {
  GetForwardingInterface()->MakeCredential(std::move(options), std::move(callback));
}
void AuthenticatorInterceptorForTesting::GetAssertion(PublicKeyCredentialRequestOptionsPtr options, GetAssertionCallback callback) {
  GetForwardingInterface()->GetAssertion(std::move(options), std::move(callback));
}
void AuthenticatorInterceptorForTesting::IsUserVerifyingPlatformAuthenticatorAvailable(IsUserVerifyingPlatformAuthenticatorAvailableCallback callback) {
  GetForwardingInterface()->IsUserVerifyingPlatformAuthenticatorAvailable(std::move(callback));
}
void AuthenticatorInterceptorForTesting::Cancel() {
  GetForwardingInterface()->Cancel();
}
AuthenticatorAsyncWaiter::AuthenticatorAsyncWaiter(
    Authenticator* proxy) : proxy_(proxy) {}

AuthenticatorAsyncWaiter::~AuthenticatorAsyncWaiter() = default;

void AuthenticatorAsyncWaiter::MakeCredential(
    PublicKeyCredentialCreationOptionsPtr options, AuthenticatorStatus* out_status, MakeCredentialAuthenticatorResponsePtr* out_credential) {
  base::RunLoop loop;
  proxy_->MakeCredential(std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             AuthenticatorStatus* out_status
,
             MakeCredentialAuthenticatorResponsePtr* out_credential
,
             AuthenticatorStatus status,
             MakeCredentialAuthenticatorResponsePtr credential) {*out_status = std::move(status);*out_credential = std::move(credential);
            loop->Quit();
          },
          &loop,
          out_status,
          out_credential));
  loop.Run();
}
void AuthenticatorAsyncWaiter::GetAssertion(
    PublicKeyCredentialRequestOptionsPtr options, AuthenticatorStatus* out_status, GetAssertionAuthenticatorResponsePtr* out_credential) {
  base::RunLoop loop;
  proxy_->GetAssertion(std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             AuthenticatorStatus* out_status
,
             GetAssertionAuthenticatorResponsePtr* out_credential
,
             AuthenticatorStatus status,
             GetAssertionAuthenticatorResponsePtr credential) {*out_status = std::move(status);*out_credential = std::move(credential);
            loop->Quit();
          },
          &loop,
          out_status,
          out_credential));
  loop.Run();
}
void AuthenticatorAsyncWaiter::IsUserVerifyingPlatformAuthenticatorAvailable(
    bool* out_available) {
  base::RunLoop loop;
  proxy_->IsUserVerifyingPlatformAuthenticatorAvailable(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_available
,
             bool available) {*out_available = std::move(available);
            loop->Quit();
          },
          &loop,
          out_available));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif