// third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "url/mojom/url.mojom-blink.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-blink.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_VIRTUAL_AUTHENTICATOR_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_VIRTUAL_AUTHENTICATOR_MOJOM_BLINK_JUMBO_H_
#endif


namespace blink {
namespace test {
namespace mojom {
namespace blink {


void VirtualAuthenticatorInterceptorForTesting::GetUniqueId(GetUniqueIdCallback callback) {
  GetForwardingInterface()->GetUniqueId(std::move(callback));
}
void VirtualAuthenticatorInterceptorForTesting::AddRegistration(RegisteredKeyPtr key, AddRegistrationCallback callback) {
  GetForwardingInterface()->AddRegistration(std::move(key), std::move(callback));
}
void VirtualAuthenticatorInterceptorForTesting::GetRegistrations(GetRegistrationsCallback callback) {
  GetForwardingInterface()->GetRegistrations(std::move(callback));
}
void VirtualAuthenticatorInterceptorForTesting::RemoveRegistration(const WTF::Vector<uint8_t>& key_handle, RemoveRegistrationCallback callback) {
  GetForwardingInterface()->RemoveRegistration(std::move(key_handle), std::move(callback));
}
void VirtualAuthenticatorInterceptorForTesting::ClearRegistrations(ClearRegistrationsCallback callback) {
  GetForwardingInterface()->ClearRegistrations(std::move(callback));
}
void VirtualAuthenticatorInterceptorForTesting::GetLargeBlob(const WTF::Vector<uint8_t>& key_handle, GetLargeBlobCallback callback) {
  GetForwardingInterface()->GetLargeBlob(std::move(key_handle), std::move(callback));
}
void VirtualAuthenticatorInterceptorForTesting::SetLargeBlob(const WTF::Vector<uint8_t>& key_handle, const WTF::Vector<uint8_t>& blob, SetLargeBlobCallback callback) {
  GetForwardingInterface()->SetLargeBlob(std::move(key_handle), std::move(blob), std::move(callback));
}
void VirtualAuthenticatorInterceptorForTesting::SetUserVerified(bool verified, SetUserVerifiedCallback callback) {
  GetForwardingInterface()->SetUserVerified(std::move(verified), std::move(callback));
}
VirtualAuthenticatorAsyncWaiter::VirtualAuthenticatorAsyncWaiter(
    VirtualAuthenticator* proxy) : proxy_(proxy) {}

VirtualAuthenticatorAsyncWaiter::~VirtualAuthenticatorAsyncWaiter() = default;

void VirtualAuthenticatorAsyncWaiter::GetUniqueId(
    WTF::String* out_id) {
  base::RunLoop loop;
  proxy_->GetUniqueId(
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::String* out_id
,
             const WTF::String& id) {*out_id = std::move(id);
            loop->Quit();
          },
          &loop,
          out_id));
  loop.Run();
}
void VirtualAuthenticatorAsyncWaiter::AddRegistration(
    RegisteredKeyPtr key, bool* out_added) {
  base::RunLoop loop;
  proxy_->AddRegistration(std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_added
,
             bool added) {*out_added = std::move(added);
            loop->Quit();
          },
          &loop,
          out_added));
  loop.Run();
}
void VirtualAuthenticatorAsyncWaiter::GetRegistrations(
    WTF::Vector<RegisteredKeyPtr>* out_keys) {
  base::RunLoop loop;
  proxy_->GetRegistrations(
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<RegisteredKeyPtr>* out_keys
,
             WTF::Vector<RegisteredKeyPtr> keys) {*out_keys = std::move(keys);
            loop->Quit();
          },
          &loop,
          out_keys));
  loop.Run();
}
void VirtualAuthenticatorAsyncWaiter::RemoveRegistration(
    const WTF::Vector<uint8_t>& key_handle, bool* out_removed) {
  base::RunLoop loop;
  proxy_->RemoveRegistration(std::move(key_handle),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_removed
,
             bool removed) {*out_removed = std::move(removed);
            loop->Quit();
          },
          &loop,
          out_removed));
  loop.Run();
}
void VirtualAuthenticatorAsyncWaiter::ClearRegistrations(
    ) {
  base::RunLoop loop;
  proxy_->ClearRegistrations(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void VirtualAuthenticatorAsyncWaiter::GetLargeBlob(
    const WTF::Vector<uint8_t>& key_handle, base::Optional<WTF::Vector<uint8_t>>* out_blob) {
  base::RunLoop loop;
  proxy_->GetLargeBlob(std::move(key_handle),
      base::BindOnce(
          [](base::RunLoop* loop,
             base::Optional<WTF::Vector<uint8_t>>* out_blob
,
             const base::Optional<WTF::Vector<uint8_t>>& blob) {*out_blob = std::move(blob);
            loop->Quit();
          },
          &loop,
          out_blob));
  loop.Run();
}
void VirtualAuthenticatorAsyncWaiter::SetLargeBlob(
    const WTF::Vector<uint8_t>& key_handle, const WTF::Vector<uint8_t>& blob, bool* out_set) {
  base::RunLoop loop;
  proxy_->SetLargeBlob(std::move(key_handle),std::move(blob),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_set
,
             bool set) {*out_set = std::move(set);
            loop->Quit();
          },
          &loop,
          out_set));
  loop.Run();
}
void VirtualAuthenticatorAsyncWaiter::SetUserVerified(
    bool verified) {
  base::RunLoop loop;
  proxy_->SetUserVerified(std::move(verified),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void VirtualAuthenticatorManagerInterceptorForTesting::CreateAuthenticator(VirtualAuthenticatorOptionsPtr options, CreateAuthenticatorCallback callback) {
  GetForwardingInterface()->CreateAuthenticator(std::move(options), std::move(callback));
}
void VirtualAuthenticatorManagerInterceptorForTesting::GetAuthenticators(GetAuthenticatorsCallback callback) {
  GetForwardingInterface()->GetAuthenticators(std::move(callback));
}
void VirtualAuthenticatorManagerInterceptorForTesting::RemoveAuthenticator(const WTF::String& id, RemoveAuthenticatorCallback callback) {
  GetForwardingInterface()->RemoveAuthenticator(std::move(id), std::move(callback));
}
void VirtualAuthenticatorManagerInterceptorForTesting::ClearAuthenticators(ClearAuthenticatorsCallback callback) {
  GetForwardingInterface()->ClearAuthenticators(std::move(callback));
}
VirtualAuthenticatorManagerAsyncWaiter::VirtualAuthenticatorManagerAsyncWaiter(
    VirtualAuthenticatorManager* proxy) : proxy_(proxy) {}

VirtualAuthenticatorManagerAsyncWaiter::~VirtualAuthenticatorManagerAsyncWaiter() = default;

void VirtualAuthenticatorManagerAsyncWaiter::CreateAuthenticator(
    VirtualAuthenticatorOptionsPtr options, ::mojo::PendingRemote<VirtualAuthenticator>* out_authenticator) {
  base::RunLoop loop;
  proxy_->CreateAuthenticator(std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<VirtualAuthenticator>* out_authenticator
,
             ::mojo::PendingRemote<VirtualAuthenticator> authenticator) {*out_authenticator = std::move(authenticator);
            loop->Quit();
          },
          &loop,
          out_authenticator));
  loop.Run();
}
void VirtualAuthenticatorManagerAsyncWaiter::GetAuthenticators(
    WTF::Vector<::mojo::PendingRemote<VirtualAuthenticator>>* out_authenticators) {
  base::RunLoop loop;
  proxy_->GetAuthenticators(
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<::mojo::PendingRemote<VirtualAuthenticator>>* out_authenticators
,
             WTF::Vector<::mojo::PendingRemote<VirtualAuthenticator>> authenticators) {*out_authenticators = std::move(authenticators);
            loop->Quit();
          },
          &loop,
          out_authenticators));
  loop.Run();
}
void VirtualAuthenticatorManagerAsyncWaiter::RemoveAuthenticator(
    const WTF::String& id, bool* out_removed) {
  base::RunLoop loop;
  proxy_->RemoveAuthenticator(std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_removed
,
             bool removed) {*out_removed = std::move(removed);
            loop->Quit();
          },
          &loop,
          out_removed));
  loop.Run();
}
void VirtualAuthenticatorManagerAsyncWaiter::ClearAuthenticators(
    ) {
  base::RunLoop loop;
  proxy_->ClearAuthenticators(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace test
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif