// third_party/blink/public/mojom/webdatabase/web_database.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webdatabase/web_database.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/webdatabase/web_database.mojom-params-data.h"
#include "third_party/blink/public/mojom/webdatabase/web_database.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webdatabase/web_database.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBDATABASE_WEB_DATABASE_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBDATABASE_WEB_DATABASE_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char WebDatabase::Name_[] = "blink.mojom.WebDatabase";

WebDatabaseProxy::WebDatabaseProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebDatabaseProxy::UpdateSize(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, const ::WTF::String& in_name, int64_t in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabase::UpdateSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabase_UpdateSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabase_UpdateSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in WebDatabase.UpdateSize request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in WebDatabase.UpdateSize request");
  params->size = in_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabase::Name_);
  message.set_method_name("UpdateSize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebDatabaseProxy::CloseImmediately(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, const ::WTF::String& in_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabase::CloseImmediately", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabase_CloseImmediately_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabase_CloseImmediately_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in WebDatabase.CloseImmediately request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in WebDatabase.CloseImmediately request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabase::Name_);
  message.set_method_name("CloseImmediately");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebDatabaseStubDispatch::Accept(
    WebDatabase* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebDatabase_UpdateSize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabase::UpdateSize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabase::UpdateSize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebDatabase_UpdateSize_Params_Data* params =
          reinterpret_cast<internal::WebDatabase_UpdateSize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      ::WTF::String p_name{};
      int64_t p_size{};
      WebDatabase_UpdateSize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success)
        p_size = input_data_view.size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabase::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSize(
std::move(p_origin), 
std::move(p_name), 
std::move(p_size));
      return true;
    }
    case internal::kWebDatabase_CloseImmediately_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabase::CloseImmediately",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabase::CloseImmediately");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebDatabase_CloseImmediately_Params_Data* params =
          reinterpret_cast<internal::WebDatabase_CloseImmediately_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      ::WTF::String p_name{};
      WebDatabase_CloseImmediately_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabase::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseImmediately(
std::move(p_origin), 
std::move(p_name));
      return true;
    }
  }
  return false;
}

// static
bool WebDatabaseStubDispatch::AcceptWithResponder(
    WebDatabase* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebDatabase_UpdateSize_Name: {
      break;
    }
    case internal::kWebDatabase_CloseImmediately_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWebDatabaseValidationInfo[] = {
    {&internal::WebDatabase_UpdateSize_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WebDatabase_CloseImmediately_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebDatabaseRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::WebDatabase::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWebDatabaseValidationInfo);
}

const char WebDatabaseHost::Name_[] = "blink.mojom.WebDatabaseHost";
bool WebDatabaseHost::OpenFile(const ::WTF::String& vfs_file_name, int32_t desired_flags, ::base::File* out_file) {
  NOTREACHED();
  return false;
}
bool WebDatabaseHost::DeleteFile(const ::WTF::String& vfs_file_name, bool sync_dir, int32_t* out_sqlite_error_code) {
  NOTREACHED();
  return false;
}
bool WebDatabaseHost::GetFileAttributes(const ::WTF::String& vfs_file_name, int32_t* out_attributes) {
  NOTREACHED();
  return false;
}
bool WebDatabaseHost::GetFileSize(const ::WTF::String& vfs_file_name, int64_t* out_size) {
  NOTREACHED();
  return false;
}
bool WebDatabaseHost::SetFileSize(const ::WTF::String& vfs_file_name, int64_t expected_size, bool* out_success) {
  NOTREACHED();
  return false;
}
bool WebDatabaseHost::GetSpaceAvailable(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, int64_t* out_space_available) {
  NOTREACHED();
  return false;
}
class WebDatabaseHost_OpenFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_OpenFile_HandleSyncResponse(
      bool* result, ::base::File* out_file)
      : result_(result), out_file_(out_file) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File* out_file_;DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_OpenFile_HandleSyncResponse);
};

class WebDatabaseHost_OpenFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_OpenFile_ForwardToCallback(
      WebDatabaseHost::OpenFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebDatabaseHost::OpenFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_OpenFile_ForwardToCallback);
};
class WebDatabaseHost_DeleteFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_DeleteFile_HandleSyncResponse(
      bool* result, int32_t* out_sqlite_error_code)
      : result_(result), out_sqlite_error_code_(out_sqlite_error_code) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_sqlite_error_code_;DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_DeleteFile_HandleSyncResponse);
};

class WebDatabaseHost_DeleteFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_DeleteFile_ForwardToCallback(
      WebDatabaseHost::DeleteFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebDatabaseHost::DeleteFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_DeleteFile_ForwardToCallback);
};
class WebDatabaseHost_GetFileAttributes_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_GetFileAttributes_HandleSyncResponse(
      bool* result, int32_t* out_attributes)
      : result_(result), out_attributes_(out_attributes) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_attributes_;DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_GetFileAttributes_HandleSyncResponse);
};

class WebDatabaseHost_GetFileAttributes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_GetFileAttributes_ForwardToCallback(
      WebDatabaseHost::GetFileAttributesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebDatabaseHost::GetFileAttributesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_GetFileAttributes_ForwardToCallback);
};
class WebDatabaseHost_GetFileSize_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_GetFileSize_HandleSyncResponse(
      bool* result, int64_t* out_size)
      : result_(result), out_size_(out_size) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int64_t* out_size_;DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_GetFileSize_HandleSyncResponse);
};

class WebDatabaseHost_GetFileSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_GetFileSize_ForwardToCallback(
      WebDatabaseHost::GetFileSizeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebDatabaseHost::GetFileSizeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_GetFileSize_ForwardToCallback);
};
class WebDatabaseHost_SetFileSize_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_SetFileSize_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_SetFileSize_HandleSyncResponse);
};

class WebDatabaseHost_SetFileSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_SetFileSize_ForwardToCallback(
      WebDatabaseHost::SetFileSizeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebDatabaseHost::SetFileSizeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_SetFileSize_ForwardToCallback);
};
class WebDatabaseHost_GetSpaceAvailable_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_GetSpaceAvailable_HandleSyncResponse(
      bool* result, int64_t* out_space_available)
      : result_(result), out_space_available_(out_space_available) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int64_t* out_space_available_;DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_GetSpaceAvailable_HandleSyncResponse);
};

class WebDatabaseHost_GetSpaceAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebDatabaseHost_GetSpaceAvailable_ForwardToCallback(
      WebDatabaseHost::GetSpaceAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebDatabaseHost::GetSpaceAvailableCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_GetSpaceAvailable_ForwardToCallback);
};

WebDatabaseHostProxy::WebDatabaseHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool WebDatabaseHostProxy::OpenFile(
    const ::WTF::String& param_vfs_file_name, int32_t param_desired_flags, ::base::File* out_param_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::WebDatabaseHost::OpenFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vfs_file_name"), param_vfs_file_name, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("desired_flags"), param_desired_flags, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vfs_file_name)::BaseType> vfs_file_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_vfs_file_name, vfs_file_name_fragment);
  params->vfs_file_name.Set(
      vfs_file_name_fragment.is_null() ? nullptr : vfs_file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->vfs_file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vfs_file_name in WebDatabaseHost.OpenFile request");
  params->desired_flags = param_desired_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("OpenFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_OpenFile_HandleSyncResponse(
          &result, out_param_file));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::WebDatabaseHost::OpenFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), out_param_file, 
                        "<value of type ::base::File>");
   });
#endif
  return result;
}

void WebDatabaseHostProxy::OpenFile(
    const ::WTF::String& in_vfs_file_name, int32_t in_desired_flags, OpenFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabaseHost::OpenFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vfs_file_name"), in_vfs_file_name, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("desired_flags"), in_desired_flags, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vfs_file_name)::BaseType> vfs_file_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_vfs_file_name, vfs_file_name_fragment);
  params->vfs_file_name.Set(
      vfs_file_name_fragment.is_null() ? nullptr : vfs_file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->vfs_file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vfs_file_name in WebDatabaseHost.OpenFile request");
  params->desired_flags = in_desired_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("OpenFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_OpenFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool WebDatabaseHostProxy::DeleteFile(
    const ::WTF::String& param_vfs_file_name, bool param_sync_dir, int32_t* out_param_sqlite_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::WebDatabaseHost::DeleteFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vfs_file_name"), param_vfs_file_name, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_dir"), param_sync_dir, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_DeleteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_DeleteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vfs_file_name)::BaseType> vfs_file_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_vfs_file_name, vfs_file_name_fragment);
  params->vfs_file_name.Set(
      vfs_file_name_fragment.is_null() ? nullptr : vfs_file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->vfs_file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vfs_file_name in WebDatabaseHost.DeleteFile request");
  params->sync_dir = param_sync_dir;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("DeleteFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_DeleteFile_HandleSyncResponse(
          &result, out_param_sqlite_error_code));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::WebDatabaseHost::DeleteFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sqlite_error_code"), out_param_sqlite_error_code, 
                        "<value of type int32_t>");
   });
#endif
  return result;
}

void WebDatabaseHostProxy::DeleteFile(
    const ::WTF::String& in_vfs_file_name, bool in_sync_dir, DeleteFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabaseHost::DeleteFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vfs_file_name"), in_vfs_file_name, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_dir"), in_sync_dir, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_DeleteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_DeleteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vfs_file_name)::BaseType> vfs_file_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_vfs_file_name, vfs_file_name_fragment);
  params->vfs_file_name.Set(
      vfs_file_name_fragment.is_null() ? nullptr : vfs_file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->vfs_file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vfs_file_name in WebDatabaseHost.DeleteFile request");
  params->sync_dir = in_sync_dir;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("DeleteFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_DeleteFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool WebDatabaseHostProxy::GetFileAttributes(
    const ::WTF::String& param_vfs_file_name, int32_t* out_param_attributes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::WebDatabaseHost::GetFileAttributes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vfs_file_name"), param_vfs_file_name, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_GetFileAttributes_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_GetFileAttributes_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vfs_file_name)::BaseType> vfs_file_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_vfs_file_name, vfs_file_name_fragment);
  params->vfs_file_name.Set(
      vfs_file_name_fragment.is_null() ? nullptr : vfs_file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->vfs_file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vfs_file_name in WebDatabaseHost.GetFileAttributes request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("GetFileAttributes");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_GetFileAttributes_HandleSyncResponse(
          &result, out_param_attributes));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::WebDatabaseHost::GetFileAttributes", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attributes"), out_param_attributes, 
                        "<value of type int32_t>");
   });
#endif
  return result;
}

void WebDatabaseHostProxy::GetFileAttributes(
    const ::WTF::String& in_vfs_file_name, GetFileAttributesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabaseHost::GetFileAttributes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vfs_file_name"), in_vfs_file_name, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_GetFileAttributes_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_GetFileAttributes_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vfs_file_name)::BaseType> vfs_file_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_vfs_file_name, vfs_file_name_fragment);
  params->vfs_file_name.Set(
      vfs_file_name_fragment.is_null() ? nullptr : vfs_file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->vfs_file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vfs_file_name in WebDatabaseHost.GetFileAttributes request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("GetFileAttributes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_GetFileAttributes_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool WebDatabaseHostProxy::GetFileSize(
    const ::WTF::String& param_vfs_file_name, int64_t* out_param_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::WebDatabaseHost::GetFileSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vfs_file_name"), param_vfs_file_name, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_GetFileSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_GetFileSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vfs_file_name)::BaseType> vfs_file_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_vfs_file_name, vfs_file_name_fragment);
  params->vfs_file_name.Set(
      vfs_file_name_fragment.is_null() ? nullptr : vfs_file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->vfs_file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vfs_file_name in WebDatabaseHost.GetFileSize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("GetFileSize");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_GetFileSize_HandleSyncResponse(
          &result, out_param_size));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::WebDatabaseHost::GetFileSize", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), out_param_size, 
                        "<value of type int64_t>");
   });
#endif
  return result;
}

void WebDatabaseHostProxy::GetFileSize(
    const ::WTF::String& in_vfs_file_name, GetFileSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabaseHost::GetFileSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vfs_file_name"), in_vfs_file_name, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_GetFileSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_GetFileSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vfs_file_name)::BaseType> vfs_file_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_vfs_file_name, vfs_file_name_fragment);
  params->vfs_file_name.Set(
      vfs_file_name_fragment.is_null() ? nullptr : vfs_file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->vfs_file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vfs_file_name in WebDatabaseHost.GetFileSize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("GetFileSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_GetFileSize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool WebDatabaseHostProxy::SetFileSize(
    const ::WTF::String& param_vfs_file_name, int64_t param_expected_size, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::WebDatabaseHost::SetFileSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vfs_file_name"), param_vfs_file_name, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_size"), param_expected_size, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_SetFileSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_SetFileSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vfs_file_name)::BaseType> vfs_file_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_vfs_file_name, vfs_file_name_fragment);
  params->vfs_file_name.Set(
      vfs_file_name_fragment.is_null() ? nullptr : vfs_file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->vfs_file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vfs_file_name in WebDatabaseHost.SetFileSize request");
  params->expected_size = param_expected_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("SetFileSize");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_SetFileSize_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::WebDatabaseHost::SetFileSize", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success, 
                        "<value of type bool>");
   });
#endif
  return result;
}

void WebDatabaseHostProxy::SetFileSize(
    const ::WTF::String& in_vfs_file_name, int64_t in_expected_size, SetFileSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabaseHost::SetFileSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vfs_file_name"), in_vfs_file_name, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_size"), in_expected_size, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_SetFileSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_SetFileSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vfs_file_name)::BaseType> vfs_file_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_vfs_file_name, vfs_file_name_fragment);
  params->vfs_file_name.Set(
      vfs_file_name_fragment.is_null() ? nullptr : vfs_file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->vfs_file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vfs_file_name in WebDatabaseHost.SetFileSize request");
  params->expected_size = in_expected_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("SetFileSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_SetFileSize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool WebDatabaseHostProxy::GetSpaceAvailable(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& param_origin, int64_t* out_param_space_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::WebDatabaseHost::GetSpaceAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), param_origin, 
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_GetSpaceAvailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_GetSpaceAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in WebDatabaseHost.GetSpaceAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("GetSpaceAvailable");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_GetSpaceAvailable_HandleSyncResponse(
          &result, out_param_space_available));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::WebDatabaseHost::GetSpaceAvailable", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("space_available"), out_param_space_available, 
                        "<value of type int64_t>");
   });
#endif
  return result;
}

void WebDatabaseHostProxy::GetSpaceAvailable(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, GetSpaceAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabaseHost::GetSpaceAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_GetSpaceAvailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_GetSpaceAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in WebDatabaseHost.GetSpaceAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("GetSpaceAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebDatabaseHost_GetSpaceAvailable_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebDatabaseHostProxy::Opened(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, const ::WTF::String& in_database_name, const ::WTF::String& in_database_description, int64_t in_estimated_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabaseHost::Opened", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_name"), in_database_name, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_description"), in_database_description, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("estimated_size"), in_estimated_size, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_Opened_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_Opened_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in WebDatabaseHost.Opened request");
  mojo::internal::MessageFragment<
      typename decltype(params->database_name)::BaseType> database_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_database_name, database_name_fragment);
  params->database_name.Set(
      database_name_fragment.is_null() ? nullptr : database_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->database_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null database_name in WebDatabaseHost.Opened request");
  mojo::internal::MessageFragment<
      typename decltype(params->database_description)::BaseType> database_description_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_database_description, database_description_fragment);
  params->database_description.Set(
      database_description_fragment.is_null() ? nullptr : database_description_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->database_description.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null database_description in WebDatabaseHost.Opened request");
  params->estimated_size = in_estimated_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("Opened");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebDatabaseHostProxy::Modified(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, const ::WTF::String& in_database_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabaseHost::Modified", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_name"), in_database_name, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_Modified_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_Modified_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in WebDatabaseHost.Modified request");
  mojo::internal::MessageFragment<
      typename decltype(params->database_name)::BaseType> database_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_database_name, database_name_fragment);
  params->database_name.Set(
      database_name_fragment.is_null() ? nullptr : database_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->database_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null database_name in WebDatabaseHost.Modified request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("Modified");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebDatabaseHostProxy::Closed(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, const ::WTF::String& in_database_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabaseHost::Closed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_name"), in_database_name, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_Closed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_Closed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in WebDatabaseHost.Closed request");
  mojo::internal::MessageFragment<
      typename decltype(params->database_name)::BaseType> database_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_database_name, database_name_fragment);
  params->database_name.Set(
      database_name_fragment.is_null() ? nullptr : database_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->database_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null database_name in WebDatabaseHost.Closed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("Closed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebDatabaseHostProxy::HandleSqliteError(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, const ::WTF::String& in_database_name, int32_t in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebDatabaseHost::HandleSqliteError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_name"), in_database_name, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_HandleSqliteError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_HandleSqliteError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in WebDatabaseHost.HandleSqliteError request");
  mojo::internal::MessageFragment<
      typename decltype(params->database_name)::BaseType> database_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_database_name, database_name_fragment);
  params->database_name.Set(
      database_name_fragment.is_null() ? nullptr : database_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->database_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null database_name in WebDatabaseHost.HandleSqliteError request");
  params->error = in_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("HandleSqliteError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class WebDatabaseHost_OpenFile_ProxyToResponder {
 public:
  static WebDatabaseHost::OpenFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebDatabaseHost_OpenFile_ProxyToResponder> proxy(
        new WebDatabaseHost_OpenFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebDatabaseHost_OpenFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebDatabaseHost_OpenFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebDatabaseHost_OpenFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebDatabaseHost::OpenFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_file);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_OpenFile_ProxyToResponder);
};

bool WebDatabaseHost_OpenFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WebDatabaseHost::OpenFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebDatabaseHost_OpenFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File p_file{};
  WebDatabaseHost_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_file));
  return true;
}

void WebDatabaseHost_OpenFile_ProxyToResponder::Run(
    ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WebDatabaseHost::OpenFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file, 
                        "<value of type ::base::File>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_OpenFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WebDatabaseHost::OpenFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("OpenFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebDatabaseHost_OpenFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<internal::WebDatabaseHost_OpenFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File p_file{};
  WebDatabaseHost_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 0, true);
    return false;
  }
  *out_file_ = std::move(p_file);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class WebDatabaseHost_DeleteFile_ProxyToResponder {
 public:
  static WebDatabaseHost::DeleteFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebDatabaseHost_DeleteFile_ProxyToResponder> proxy(
        new WebDatabaseHost_DeleteFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebDatabaseHost_DeleteFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebDatabaseHost_DeleteFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebDatabaseHost_DeleteFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebDatabaseHost::DeleteFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_sqlite_error_code);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_DeleteFile_ProxyToResponder);
};

bool WebDatabaseHost_DeleteFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WebDatabaseHost::DeleteFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_DeleteFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebDatabaseHost_DeleteFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_sqlite_error_code{};
  WebDatabaseHost_DeleteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_sqlite_error_code = input_data_view.sqlite_error_code();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_sqlite_error_code));
  return true;
}

void WebDatabaseHost_DeleteFile_ProxyToResponder::Run(
    int32_t in_sqlite_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WebDatabaseHost::DeleteFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sqlite_error_code"), in_sqlite_error_code, 
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_DeleteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_DeleteFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->sqlite_error_code = in_sqlite_error_code;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WebDatabaseHost::DeleteFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("DeleteFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebDatabaseHost_DeleteFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_DeleteFile_ResponseParams_Data* params =
      reinterpret_cast<internal::WebDatabaseHost_DeleteFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  int32_t p_sqlite_error_code{};
  WebDatabaseHost_DeleteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_sqlite_error_code = input_data_view.sqlite_error_code();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 1, true);
    return false;
  }
  *out_sqlite_error_code_ = std::move(p_sqlite_error_code);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class WebDatabaseHost_GetFileAttributes_ProxyToResponder {
 public:
  static WebDatabaseHost::GetFileAttributesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebDatabaseHost_GetFileAttributes_ProxyToResponder> proxy(
        new WebDatabaseHost_GetFileAttributes_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebDatabaseHost_GetFileAttributes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebDatabaseHost_GetFileAttributes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebDatabaseHost_GetFileAttributes_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebDatabaseHost::GetFileAttributesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_attributes);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_GetFileAttributes_ProxyToResponder);
};

bool WebDatabaseHost_GetFileAttributes_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WebDatabaseHost::GetFileAttributesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_GetFileAttributes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebDatabaseHost_GetFileAttributes_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_attributes{};
  WebDatabaseHost_GetFileAttributes_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_attributes = input_data_view.attributes();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_attributes));
  return true;
}

void WebDatabaseHost_GetFileAttributes_ProxyToResponder::Run(
    int32_t in_attributes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WebDatabaseHost::GetFileAttributesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attributes"), in_attributes, 
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_GetFileAttributes_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_GetFileAttributes_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->attributes = in_attributes;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WebDatabaseHost::GetFileAttributesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("GetFileAttributes");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebDatabaseHost_GetFileAttributes_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_GetFileAttributes_ResponseParams_Data* params =
      reinterpret_cast<internal::WebDatabaseHost_GetFileAttributes_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  int32_t p_attributes{};
  WebDatabaseHost_GetFileAttributes_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_attributes = input_data_view.attributes();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 2, true);
    return false;
  }
  *out_attributes_ = std::move(p_attributes);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class WebDatabaseHost_GetFileSize_ProxyToResponder {
 public:
  static WebDatabaseHost::GetFileSizeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebDatabaseHost_GetFileSize_ProxyToResponder> proxy(
        new WebDatabaseHost_GetFileSize_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebDatabaseHost_GetFileSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebDatabaseHost_GetFileSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebDatabaseHost_GetFileSize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebDatabaseHost::GetFileSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_size);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_GetFileSize_ProxyToResponder);
};

bool WebDatabaseHost_GetFileSize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WebDatabaseHost::GetFileSizeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_GetFileSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebDatabaseHost_GetFileSize_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_size{};
  WebDatabaseHost_GetFileSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_size = input_data_view.size();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_size));
  return true;
}

void WebDatabaseHost_GetFileSize_ProxyToResponder::Run(
    int64_t in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WebDatabaseHost::GetFileSizeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size, 
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_GetFileSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_GetFileSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->size = in_size;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WebDatabaseHost::GetFileSizeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("GetFileSize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebDatabaseHost_GetFileSize_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_GetFileSize_ResponseParams_Data* params =
      reinterpret_cast<internal::WebDatabaseHost_GetFileSize_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  int64_t p_size{};
  WebDatabaseHost_GetFileSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_size = input_data_view.size();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 3, true);
    return false;
  }
  *out_size_ = std::move(p_size);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class WebDatabaseHost_SetFileSize_ProxyToResponder {
 public:
  static WebDatabaseHost::SetFileSizeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebDatabaseHost_SetFileSize_ProxyToResponder> proxy(
        new WebDatabaseHost_SetFileSize_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebDatabaseHost_SetFileSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebDatabaseHost_SetFileSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebDatabaseHost_SetFileSize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebDatabaseHost::SetFileSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_SetFileSize_ProxyToResponder);
};

bool WebDatabaseHost_SetFileSize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WebDatabaseHost::SetFileSizeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_SetFileSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebDatabaseHost_SetFileSize_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  WebDatabaseHost_SetFileSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void WebDatabaseHost_SetFileSize_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WebDatabaseHost::SetFileSizeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_SetFileSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_SetFileSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WebDatabaseHost::SetFileSizeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("SetFileSize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebDatabaseHost_SetFileSize_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_SetFileSize_ResponseParams_Data* params =
      reinterpret_cast<internal::WebDatabaseHost_SetFileSize_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  WebDatabaseHost_SetFileSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 4, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class WebDatabaseHost_GetSpaceAvailable_ProxyToResponder {
 public:
  static WebDatabaseHost::GetSpaceAvailableCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebDatabaseHost_GetSpaceAvailable_ProxyToResponder> proxy(
        new WebDatabaseHost_GetSpaceAvailable_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebDatabaseHost_GetSpaceAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebDatabaseHost_GetSpaceAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebDatabaseHost_GetSpaceAvailable_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebDatabaseHost::GetSpaceAvailableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_space_available);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebDatabaseHost_GetSpaceAvailable_ProxyToResponder);
};

bool WebDatabaseHost_GetSpaceAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WebDatabaseHost::GetSpaceAvailableCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_GetSpaceAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebDatabaseHost_GetSpaceAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_space_available{};
  WebDatabaseHost_GetSpaceAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_space_available = input_data_view.space_available();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_space_available));
  return true;
}

void WebDatabaseHost_GetSpaceAvailable_ProxyToResponder::Run(
    int64_t in_space_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WebDatabaseHost::GetSpaceAvailableCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("space_available"), in_space_available, 
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebDatabaseHost_GetSpaceAvailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebDatabaseHost_GetSpaceAvailable_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->space_available = in_space_available;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WebDatabaseHost::GetSpaceAvailableCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebDatabaseHost::Name_);
  message.set_method_name("GetSpaceAvailable");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebDatabaseHost_GetSpaceAvailable_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::WebDatabaseHost_GetSpaceAvailable_ResponseParams_Data* params =
      reinterpret_cast<internal::WebDatabaseHost_GetSpaceAvailable_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  int64_t p_space_available{};
  WebDatabaseHost_GetSpaceAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_space_available = input_data_view.space_available();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebDatabaseHost::Name_, 5, true);
    return false;
  }
  *out_space_available_ = std::move(p_space_available);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool WebDatabaseHostStubDispatch::Accept(
    WebDatabaseHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebDatabaseHost_OpenFile_Name: {
      break;
    }
    case internal::kWebDatabaseHost_DeleteFile_Name: {
      break;
    }
    case internal::kWebDatabaseHost_GetFileAttributes_Name: {
      break;
    }
    case internal::kWebDatabaseHost_GetFileSize_Name: {
      break;
    }
    case internal::kWebDatabaseHost_SetFileSize_Name: {
      break;
    }
    case internal::kWebDatabaseHost_GetSpaceAvailable_Name: {
      break;
    }
    case internal::kWebDatabaseHost_Opened_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabaseHost::Opened",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabaseHost::Opened");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebDatabaseHost_Opened_Params_Data* params =
          reinterpret_cast<internal::WebDatabaseHost_Opened_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      ::WTF::String p_database_name{};
      ::WTF::String p_database_description{};
      int64_t p_estimated_size{};
      WebDatabaseHost_Opened_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadDatabaseName(&p_database_name))
        success = false;
      if (success && !input_data_view.ReadDatabaseDescription(&p_database_description))
        success = false;
      if (success)
        p_estimated_size = input_data_view.estimated_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabaseHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Opened(
std::move(p_origin), 
std::move(p_database_name), 
std::move(p_database_description), 
std::move(p_estimated_size));
      return true;
    }
    case internal::kWebDatabaseHost_Modified_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabaseHost::Modified",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabaseHost::Modified");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebDatabaseHost_Modified_Params_Data* params =
          reinterpret_cast<internal::WebDatabaseHost_Modified_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      ::WTF::String p_database_name{};
      WebDatabaseHost_Modified_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadDatabaseName(&p_database_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabaseHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Modified(
std::move(p_origin), 
std::move(p_database_name));
      return true;
    }
    case internal::kWebDatabaseHost_Closed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabaseHost::Closed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabaseHost::Closed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebDatabaseHost_Closed_Params_Data* params =
          reinterpret_cast<internal::WebDatabaseHost_Closed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      ::WTF::String p_database_name{};
      WebDatabaseHost_Closed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadDatabaseName(&p_database_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabaseHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Closed(
std::move(p_origin), 
std::move(p_database_name));
      return true;
    }
    case internal::kWebDatabaseHost_HandleSqliteError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabaseHost::HandleSqliteError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabaseHost::HandleSqliteError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebDatabaseHost_HandleSqliteError_Params_Data* params =
          reinterpret_cast<internal::WebDatabaseHost_HandleSqliteError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      ::WTF::String p_database_name{};
      int32_t p_error{};
      WebDatabaseHost_HandleSqliteError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadDatabaseName(&p_database_name))
        success = false;
      if (success)
        p_error = input_data_view.error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabaseHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleSqliteError(
std::move(p_origin), 
std::move(p_database_name), 
std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool WebDatabaseHostStubDispatch::AcceptWithResponder(
    WebDatabaseHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebDatabaseHost_OpenFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabaseHost::OpenFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabaseHost::OpenFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebDatabaseHost_OpenFile_Params_Data* params =
          reinterpret_cast<
              internal::WebDatabaseHost_OpenFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_vfs_file_name{};
      int32_t p_desired_flags{};
      WebDatabaseHost_OpenFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVfsFileName(&p_vfs_file_name))
        success = false;
      if (success)
        p_desired_flags = input_data_view.desired_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabaseHost::Name_, 0, false);
        return false;
      }
      WebDatabaseHost::OpenFileCallback callback =
          WebDatabaseHost_OpenFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFile(
std::move(p_vfs_file_name), 
std::move(p_desired_flags), std::move(callback));
      return true;
    }
    case internal::kWebDatabaseHost_DeleteFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabaseHost::DeleteFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabaseHost::DeleteFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebDatabaseHost_DeleteFile_Params_Data* params =
          reinterpret_cast<
              internal::WebDatabaseHost_DeleteFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_vfs_file_name{};
      bool p_sync_dir{};
      WebDatabaseHost_DeleteFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVfsFileName(&p_vfs_file_name))
        success = false;
      if (success)
        p_sync_dir = input_data_view.sync_dir();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabaseHost::Name_, 1, false);
        return false;
      }
      WebDatabaseHost::DeleteFileCallback callback =
          WebDatabaseHost_DeleteFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteFile(
std::move(p_vfs_file_name), 
std::move(p_sync_dir), std::move(callback));
      return true;
    }
    case internal::kWebDatabaseHost_GetFileAttributes_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabaseHost::GetFileAttributes",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabaseHost::GetFileAttributes");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebDatabaseHost_GetFileAttributes_Params_Data* params =
          reinterpret_cast<
              internal::WebDatabaseHost_GetFileAttributes_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_vfs_file_name{};
      WebDatabaseHost_GetFileAttributes_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVfsFileName(&p_vfs_file_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabaseHost::Name_, 2, false);
        return false;
      }
      WebDatabaseHost::GetFileAttributesCallback callback =
          WebDatabaseHost_GetFileAttributes_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFileAttributes(
std::move(p_vfs_file_name), std::move(callback));
      return true;
    }
    case internal::kWebDatabaseHost_GetFileSize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabaseHost::GetFileSize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabaseHost::GetFileSize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebDatabaseHost_GetFileSize_Params_Data* params =
          reinterpret_cast<
              internal::WebDatabaseHost_GetFileSize_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_vfs_file_name{};
      WebDatabaseHost_GetFileSize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVfsFileName(&p_vfs_file_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabaseHost::Name_, 3, false);
        return false;
      }
      WebDatabaseHost::GetFileSizeCallback callback =
          WebDatabaseHost_GetFileSize_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFileSize(
std::move(p_vfs_file_name), std::move(callback));
      return true;
    }
    case internal::kWebDatabaseHost_SetFileSize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabaseHost::SetFileSize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabaseHost::SetFileSize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebDatabaseHost_SetFileSize_Params_Data* params =
          reinterpret_cast<
              internal::WebDatabaseHost_SetFileSize_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_vfs_file_name{};
      int64_t p_expected_size{};
      WebDatabaseHost_SetFileSize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVfsFileName(&p_vfs_file_name))
        success = false;
      if (success)
        p_expected_size = input_data_view.expected_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabaseHost::Name_, 4, false);
        return false;
      }
      WebDatabaseHost::SetFileSizeCallback callback =
          WebDatabaseHost_SetFileSize_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFileSize(
std::move(p_vfs_file_name), 
std::move(p_expected_size), std::move(callback));
      return true;
    }
    case internal::kWebDatabaseHost_GetSpaceAvailable_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebDatabaseHost::GetSpaceAvailable",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebDatabaseHost::GetSpaceAvailable");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebDatabaseHost_GetSpaceAvailable_Params_Data* params =
          reinterpret_cast<
              internal::WebDatabaseHost_GetSpaceAvailable_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      WebDatabaseHost_GetSpaceAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebDatabaseHost::Name_, 5, false);
        return false;
      }
      WebDatabaseHost::GetSpaceAvailableCallback callback =
          WebDatabaseHost_GetSpaceAvailable_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSpaceAvailable(
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kWebDatabaseHost_Opened_Name: {
      break;
    }
    case internal::kWebDatabaseHost_Modified_Name: {
      break;
    }
    case internal::kWebDatabaseHost_Closed_Name: {
      break;
    }
    case internal::kWebDatabaseHost_HandleSqliteError_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWebDatabaseHostValidationInfo[] = {
    {&internal::WebDatabaseHost_OpenFile_Params_Data::Validate,
     &internal::WebDatabaseHost_OpenFile_ResponseParams_Data::Validate},
    {&internal::WebDatabaseHost_DeleteFile_Params_Data::Validate,
     &internal::WebDatabaseHost_DeleteFile_ResponseParams_Data::Validate},
    {&internal::WebDatabaseHost_GetFileAttributes_Params_Data::Validate,
     &internal::WebDatabaseHost_GetFileAttributes_ResponseParams_Data::Validate},
    {&internal::WebDatabaseHost_GetFileSize_Params_Data::Validate,
     &internal::WebDatabaseHost_GetFileSize_ResponseParams_Data::Validate},
    {&internal::WebDatabaseHost_SetFileSize_Params_Data::Validate,
     &internal::WebDatabaseHost_SetFileSize_ResponseParams_Data::Validate},
    {&internal::WebDatabaseHost_GetSpaceAvailable_Params_Data::Validate,
     &internal::WebDatabaseHost_GetSpaceAvailable_ResponseParams_Data::Validate},
    {&internal::WebDatabaseHost_Opened_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WebDatabaseHost_Modified_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WebDatabaseHost_Closed_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WebDatabaseHost_HandleSqliteError_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebDatabaseHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::WebDatabaseHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWebDatabaseHostValidationInfo);
}

bool WebDatabaseHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::WebDatabaseHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kWebDatabaseHostValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif