// third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-params-data.h"
#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char FederatedAuthRequest::Name_[] = "blink.mojom.FederatedAuthRequest";

class FederatedAuthRequest_RequestIdToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FederatedAuthRequest_RequestIdToken_ForwardToCallback(
      FederatedAuthRequest::RequestIdTokenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FederatedAuthRequest::RequestIdTokenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FederatedAuthRequest_RequestIdToken_ForwardToCallback);
};

FederatedAuthRequestProxy::FederatedAuthRequestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FederatedAuthRequestProxy::RequestIdToken(
    const ::blink::KURL& in_provider, const WTF::String& in_id_request, RequestIdTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FederatedAuthRequest::RequestIdToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("provider"), in_provider, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id_request"), in_id_request, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFederatedAuthRequest_RequestIdToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_RequestIdToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->provider)::BaseType> provider_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_provider, provider_fragment);
  params->provider.Set(
      provider_fragment.is_null() ? nullptr : provider_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->provider.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null provider in FederatedAuthRequest.RequestIdToken request");
  mojo::internal::MessageFragment<
      typename decltype(params->id_request)::BaseType> id_request_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id_request, id_request_fragment);
  params->id_request.Set(
      id_request_fragment.is_null() ? nullptr : id_request_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id_request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id_request in FederatedAuthRequest.RequestIdToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("RequestIdToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FederatedAuthRequest_RequestIdToken_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class FederatedAuthRequest_RequestIdToken_ProxyToResponder {
 public:
  static FederatedAuthRequest::RequestIdTokenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FederatedAuthRequest_RequestIdToken_ProxyToResponder> proxy(
        new FederatedAuthRequest_RequestIdToken_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FederatedAuthRequest_RequestIdToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FederatedAuthRequest_RequestIdToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FederatedAuthRequest_RequestIdToken_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FederatedAuthRequest::RequestIdTokenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      RequestIdTokenStatus in_status, const WTF::String& in_id_token);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FederatedAuthRequest_RequestIdToken_ProxyToResponder);
};

bool FederatedAuthRequest_RequestIdToken_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FederatedAuthRequest::RequestIdTokenCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FederatedAuthRequest_RequestIdToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FederatedAuthRequest_RequestIdToken_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  RequestIdTokenStatus p_status{};
  WTF::String p_id_token{};
  FederatedAuthRequest_RequestIdToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadIdToken(&p_id_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FederatedAuthRequest::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_id_token));
  return true;
}

void FederatedAuthRequest_RequestIdToken_ProxyToResponder::Run(
    RequestIdTokenStatus in_status, const WTF::String& in_id_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FederatedAuthRequest::RequestIdTokenCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type RequestIdTokenStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id_token"), in_id_token, 
                        "<value of type const WTF::String&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFederatedAuthRequest_RequestIdToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_RequestIdToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::RequestIdTokenStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->id_token)::BaseType> id_token_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id_token, id_token_fragment);
  params->id_token.Set(
      id_token_fragment.is_null() ? nullptr : id_token_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FederatedAuthRequest::RequestIdTokenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("RequestIdToken");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FederatedAuthRequestStubDispatch::Accept(
    FederatedAuthRequest* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFederatedAuthRequest_RequestIdToken_Name: {
      break;
    }
  }
  return false;
}

// static
bool FederatedAuthRequestStubDispatch::AcceptWithResponder(
    FederatedAuthRequest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFederatedAuthRequest_RequestIdToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FederatedAuthRequest::RequestIdToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FederatedAuthRequest::RequestIdToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FederatedAuthRequest_RequestIdToken_Params_Data* params =
          reinterpret_cast<
              internal::FederatedAuthRequest_RequestIdToken_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_provider{};
      WTF::String p_id_request{};
      FederatedAuthRequest_RequestIdToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProvider(&p_provider))
        success = false;
      if (success && !input_data_view.ReadIdRequest(&p_id_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 0, false);
        return false;
      }
      FederatedAuthRequest::RequestIdTokenCallback callback =
          FederatedAuthRequest_RequestIdToken_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestIdToken(
std::move(p_provider), 
std::move(p_id_request), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFederatedAuthRequestValidationInfo[] = {
    {&internal::FederatedAuthRequest_RequestIdToken_Params_Data::Validate,
     &internal::FederatedAuthRequest_RequestIdToken_ResponseParams_Data::Validate},
};

bool FederatedAuthRequestRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::FederatedAuthRequest::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFederatedAuthRequestValidationInfo);
}

bool FederatedAuthRequestResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::FederatedAuthRequest::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFederatedAuthRequestValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif