// third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string RequestIdTokenStatusToString(RequestIdTokenStatus value) {
  switch(value) {
    case RequestIdTokenStatus::kSuccess:
      return "RequestIdTokenStatus::kSuccess";
    case RequestIdTokenStatus::kApprovalDeclined:
      return "RequestIdTokenStatus::kApprovalDeclined";
    case RequestIdTokenStatus::kErrorTooManyRequests:
      return "RequestIdTokenStatus::kErrorTooManyRequests";
    case RequestIdTokenStatus::kErrorWebIdNotSupportedByProvider:
      return "RequestIdTokenStatus::kErrorWebIdNotSupportedByProvider";
    case RequestIdTokenStatus::kErrorFetchingWellKnown:
      return "RequestIdTokenStatus::kErrorFetchingWellKnown";
    case RequestIdTokenStatus::kErrorInvalidWellKnown:
      return "RequestIdTokenStatus::kErrorInvalidWellKnown";
    case RequestIdTokenStatus::kErrorFetchingSignin:
      return "RequestIdTokenStatus::kErrorFetchingSignin";
    case RequestIdTokenStatus::kErrorInvalidSigninResponse:
      return "RequestIdTokenStatus::kErrorInvalidSigninResponse";
    case RequestIdTokenStatus::kError:
      return "RequestIdTokenStatus::kError";
    default:
      return base::StringPrintf("Unknown RequestIdTokenStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, RequestIdTokenStatus value) {
  return os << RequestIdTokenStatusToString(value);
}

namespace internal {


// static
bool FederatedAuthRequest_RequestIdToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FederatedAuthRequest_RequestIdToken_Params_Data* object = static_cast<const FederatedAuthRequest_RequestIdToken_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->provider, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id_request, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_request_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id_request, validation_context,
                                         &id_request_validate_params)) {
    return false;
  }

  return true;
}

FederatedAuthRequest_RequestIdToken_Params_Data::FederatedAuthRequest_RequestIdToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_RequestIdToken_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FederatedAuthRequest_RequestIdToken_ResponseParams_Data* object = static_cast<const FederatedAuthRequest_RequestIdToken_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::RequestIdTokenStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams id_token_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id_token, validation_context,
                                         &id_token_validate_params)) {
    return false;
  }

  return true;
}

FederatedAuthRequest_RequestIdToken_ResponseParams_Data::FederatedAuthRequest_RequestIdToken_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RequestIdTokenStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::RequestIdTokenStatus value) {
  return std::move(context).WriteString(::blink::mojom::RequestIdTokenStatusToString(value));
}

} // namespace perfetto
