// third_party/blink/public/mojom/webid/federated_auth_response.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webid/federated_auth_response.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/webid/federated_auth_response.mojom-params-data.h"
#include "third_party/blink/public/mojom/webid/federated_auth_response.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webid/federated_auth_response.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_RESPONSE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_RESPONSE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char FederatedAuthResponse::Name_[] = "blink.mojom.FederatedAuthResponse";

class FederatedAuthResponse_ProvideIdToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FederatedAuthResponse_ProvideIdToken_ForwardToCallback(
      FederatedAuthResponse::ProvideIdTokenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FederatedAuthResponse::ProvideIdTokenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FederatedAuthResponse_ProvideIdToken_ForwardToCallback);
};

FederatedAuthResponseProxy::FederatedAuthResponseProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FederatedAuthResponseProxy::ProvideIdToken(
    const std::string& in_id_token, ProvideIdTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FederatedAuthResponse::ProvideIdToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id_token"), in_id_token, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFederatedAuthResponse_ProvideIdToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthResponse_ProvideIdToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id_token)::BaseType> id_token_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id_token, id_token_fragment);
  params->id_token.Set(
      id_token_fragment.is_null() ? nullptr : id_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id_token in FederatedAuthResponse.ProvideIdToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthResponse::Name_);
  message.set_method_name("ProvideIdToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FederatedAuthResponse_ProvideIdToken_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class FederatedAuthResponse_ProvideIdToken_ProxyToResponder {
 public:
  static FederatedAuthResponse::ProvideIdTokenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FederatedAuthResponse_ProvideIdToken_ProxyToResponder> proxy(
        new FederatedAuthResponse_ProvideIdToken_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FederatedAuthResponse_ProvideIdToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FederatedAuthResponse_ProvideIdToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FederatedAuthResponse_ProvideIdToken_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FederatedAuthResponse::ProvideIdTokenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ProvideIdTokenStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FederatedAuthResponse_ProvideIdToken_ProxyToResponder);
};

bool FederatedAuthResponse_ProvideIdToken_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FederatedAuthResponse::ProvideIdTokenCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FederatedAuthResponse_ProvideIdToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FederatedAuthResponse_ProvideIdToken_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ProvideIdTokenStatus p_status{};
  FederatedAuthResponse_ProvideIdToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FederatedAuthResponse::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void FederatedAuthResponse_ProvideIdToken_ProxyToResponder::Run(
    ProvideIdTokenStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FederatedAuthResponse::ProvideIdTokenCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ProvideIdTokenStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFederatedAuthResponse_ProvideIdToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthResponse_ProvideIdToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ProvideIdTokenStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FederatedAuthResponse::ProvideIdTokenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthResponse::Name_);
  message.set_method_name("ProvideIdToken");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FederatedAuthResponseStubDispatch::Accept(
    FederatedAuthResponse* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFederatedAuthResponse_ProvideIdToken_Name: {
      break;
    }
  }
  return false;
}

// static
bool FederatedAuthResponseStubDispatch::AcceptWithResponder(
    FederatedAuthResponse* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFederatedAuthResponse_ProvideIdToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FederatedAuthResponse::ProvideIdToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FederatedAuthResponse::ProvideIdToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FederatedAuthResponse_ProvideIdToken_Params_Data* params =
          reinterpret_cast<
              internal::FederatedAuthResponse_ProvideIdToken_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_id_token{};
      FederatedAuthResponse_ProvideIdToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdToken(&p_id_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthResponse::Name_, 0, false);
        return false;
      }
      FederatedAuthResponse::ProvideIdTokenCallback callback =
          FederatedAuthResponse_ProvideIdToken_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProvideIdToken(
std::move(p_id_token), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFederatedAuthResponseValidationInfo[] = {
    {&internal::FederatedAuthResponse_ProvideIdToken_Params_Data::Validate,
     &internal::FederatedAuthResponse_ProvideIdToken_ResponseParams_Data::Validate},
};

bool FederatedAuthResponseRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FederatedAuthResponse::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFederatedAuthResponseValidationInfo);
}

bool FederatedAuthResponseResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FederatedAuthResponse::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFederatedAuthResponseValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif