// third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string PointerTypeToString(PointerType value) {
  switch(value) {
    case PointerType::kPointerNone:
      return "PointerType::{kPointerNone, kPointerFirstType}";
    case PointerType::kPointerCoarseType:
      return "PointerType::kPointerCoarseType";
    case PointerType::kPointerFineType:
      return "PointerType::kPointerFineType";
    default:
      return base::StringPrintf("Unknown PointerType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PointerType value) {
  return os << PointerTypeToString(value);
}

std::string HoverTypeToString(HoverType value) {
  switch(value) {
    case HoverType::kHoverNone:
      return "HoverType::{kHoverNone, kHoverFirstType}";
    case HoverType::kHoverHoverType:
      return "HoverType::kHoverHoverType";
    default:
      return base::StringPrintf("Unknown HoverType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, HoverType value) {
  return os << HoverTypeToString(value);
}

std::string EditingBehaviorToString(EditingBehavior value) {
  switch(value) {
    case EditingBehavior::kEditingMacBehavior:
      return "EditingBehavior::kEditingMacBehavior";
    case EditingBehavior::kEditingWindowsBehavior:
      return "EditingBehavior::kEditingWindowsBehavior";
    case EditingBehavior::kEditingUnixBehavior:
      return "EditingBehavior::kEditingUnixBehavior";
    case EditingBehavior::kEditingAndroidBehavior:
      return "EditingBehavior::kEditingAndroidBehavior";
    case EditingBehavior::kEditingChromeOSBehavior:
      return "EditingBehavior::kEditingChromeOSBehavior";
    default:
      return base::StringPrintf("Unknown EditingBehavior value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, EditingBehavior value) {
  return os << EditingBehaviorToString(value);
}

std::string ImageAnimationPolicyToString(ImageAnimationPolicy value) {
  switch(value) {
    case ImageAnimationPolicy::kImageAnimationPolicyAllowed:
      return "ImageAnimationPolicy::kImageAnimationPolicyAllowed";
    case ImageAnimationPolicy::kImageAnimationPolicyAnimateOnce:
      return "ImageAnimationPolicy::kImageAnimationPolicyAnimateOnce";
    case ImageAnimationPolicy::kImageAnimationPolicyNoAnimation:
      return "ImageAnimationPolicy::kImageAnimationPolicyNoAnimation";
    default:
      return base::StringPrintf("Unknown ImageAnimationPolicy value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ImageAnimationPolicy value) {
  return os << ImageAnimationPolicyToString(value);
}

std::string ViewportStyleToString(ViewportStyle value) {
  switch(value) {
    case ViewportStyle::kDefault:
      return "ViewportStyle::kDefault";
    case ViewportStyle::kMobile:
      return "ViewportStyle::kMobile";
    case ViewportStyle::kTelevision:
      return "ViewportStyle::{kTelevision, kLast}";
    default:
      return base::StringPrintf("Unknown ViewportStyle value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ViewportStyle value) {
  return os << ViewportStyleToString(value);
}

std::string AutoplayPolicyToString(AutoplayPolicy value) {
  switch(value) {
    case AutoplayPolicy::kNoUserGestureRequired:
      return "AutoplayPolicy::kNoUserGestureRequired";
    case AutoplayPolicy::kUserGestureRequired:
      return "AutoplayPolicy::kUserGestureRequired";
    case AutoplayPolicy::kDocumentUserActivationRequired:
      return "AutoplayPolicy::kDocumentUserActivationRequired";
    default:
      return base::StringPrintf("Unknown AutoplayPolicy value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, AutoplayPolicy value) {
  return os << AutoplayPolicyToString(value);
}

std::string EffectiveConnectionTypeToString(EffectiveConnectionType value) {
  switch(value) {
    case EffectiveConnectionType::kEffectiveConnectionUnknownType:
      return "EffectiveConnectionType::kEffectiveConnectionUnknownType";
    case EffectiveConnectionType::kEffectiveConnectionOfflineType:
      return "EffectiveConnectionType::kEffectiveConnectionOfflineType";
    case EffectiveConnectionType::kEffectiveConnectionSlow2GType:
      return "EffectiveConnectionType::kEffectiveConnectionSlow2GType";
    case EffectiveConnectionType::kEffectiveConnection2GType:
      return "EffectiveConnectionType::kEffectiveConnection2GType";
    case EffectiveConnectionType::kEffectiveConnection3GType:
      return "EffectiveConnectionType::kEffectiveConnection3GType";
    case EffectiveConnectionType::kEffectiveConnection4GType:
      return "EffectiveConnectionType::kEffectiveConnection4GType";
    case EffectiveConnectionType::kEffectiveConnectionTypeLast:
      return "EffectiveConnectionType::kEffectiveConnectionTypeLast";
    default:
      return base::StringPrintf("Unknown EffectiveConnectionType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, EffectiveConnectionType value) {
  return os << EffectiveConnectionTypeToString(value);
}

namespace internal {


// static
bool WebPreferences_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 288, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebPreferences_Data* object = static_cast<const WebPreferences_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->standard_font_family_map, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams standard_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->standard_font_family_map, validation_context,
                                         &standard_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fixed_font_family_map, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fixed_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->fixed_font_family_map, validation_context,
                                         &fixed_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serif_font_family_map, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams serif_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->serif_font_family_map, validation_context,
                                         &serif_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sans_serif_font_family_map, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sans_serif_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->sans_serif_font_family_map, validation_context,
                                         &sans_serif_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cursive_font_family_map, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cursive_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->cursive_font_family_map, validation_context,
                                         &cursive_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fantasy_font_family_map, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fantasy_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->fantasy_font_family_map, validation_context,
                                         &fantasy_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pictograph_font_family_map, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams pictograph_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->pictograph_font_family_map, validation_context,
                                         &pictograph_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_encoding, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams default_encoding_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->default_encoding, validation_context,
                                         &default_encoding_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::PointerType_Data
        ::Validate(object->primary_pointer_type, validation_context))
    return false;


  if (!::blink::mojom::internal::HoverType_Data
        ::Validate(object->primary_hover_type, validation_context))
    return false;


  if (!::blink::mojom::internal::EditingBehavior_Data
        ::Validate(object->editing_behavior, validation_context))
    return false;


  if (!::blink::mojom::internal::ViewportStyle_Data
        ::Validate(object->viewport_style, validation_context))
    return false;


  if (!::blink::mojom::internal::V8CacheOptions_Data
        ::Validate(object->v8_cache_options, validation_context))
    return false;


  if (!::blink::mojom::internal::ImageAnimationPolicy_Data
        ::Validate(object->animation_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_background_color, 97, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_background_color_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_background_color, validation_context,
                                         &text_track_background_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_text_color, 98, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_text_color_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_text_color, validation_context,
                                         &text_track_text_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_text_size, 99, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_text_size_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_text_size, validation_context,
                                         &text_track_text_size_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_text_shadow, 100, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_text_shadow_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_text_shadow, validation_context,
                                         &text_track_text_shadow_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_font_family, 101, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_font_family_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_font_family, validation_context,
                                         &text_track_font_family_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_font_style, 102, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_font_style_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_font_style, validation_context,
                                         &text_track_font_style_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_font_variant, 103, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_font_variant_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_font_variant, validation_context,
                                         &text_track_font_variant_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_window_color, 104, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_window_color_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_window_color, validation_context,
                                         &text_track_window_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_window_padding, 105, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_window_padding_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_window_padding, validation_context,
                                         &text_track_window_padding_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_window_radius, 106, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_window_radius_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_window_radius, validation_context,
                                         &text_track_window_radius_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_app_scope, 112, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->web_app_scope, validation_context))
    return false;


  if (!::blink::mojom::internal::AutoplayPolicy_Data
        ::Validate(object->autoplay_policy, validation_context))
    return false;


  if (!::blink::mojom::internal::PreferredColorScheme_Data
        ::Validate(object->preferred_color_scheme, validation_context))
    return false;


  if (!::blink::mojom::internal::PreferredContrast_Data
        ::Validate(object->preferred_contrast, validation_context))
    return false;


  if (!::blink::mojom::internal::EffectiveConnectionType_Data
        ::Validate(object->low_priority_iframes_threshold, validation_context))
    return false;


  if (!::blink::mojom::internal::EffectiveConnectionType_Data
        ::Validate(object->network_quality_estimator_web_holdback, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lazy_frame_loading_distance_thresholds_px, 128, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams lazy_frame_loading_distance_thresholds_px_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->lazy_frame_loading_distance_thresholds_px, validation_context,
                                         &lazy_frame_loading_distance_thresholds_px_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lazy_image_loading_distance_thresholds_px, 129, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams lazy_image_loading_distance_thresholds_px_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->lazy_image_loading_distance_thresholds_px, validation_context,
                                         &lazy_image_loading_distance_thresholds_px_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lazy_image_first_k_fully_load, 130, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams lazy_image_first_k_fully_load_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->lazy_image_first_k_fully_load, validation_context,
                                         &lazy_image_first_k_fully_load_validate_params)) {
    return false;
  }

  return true;
}

WebPreferences_Data::WebPreferences_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PointerType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::PointerType value) {
  return std::move(context).WriteString(::blink::mojom::PointerTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::HoverType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::HoverType value) {
  return std::move(context).WriteString(::blink::mojom::HoverTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::EditingBehavior>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::EditingBehavior value) {
  return std::move(context).WriteString(::blink::mojom::EditingBehaviorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ImageAnimationPolicy>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ImageAnimationPolicy value) {
  return std::move(context).WriteString(::blink::mojom::ImageAnimationPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ViewportStyle>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ViewportStyle value) {
  return std::move(context).WriteString(::blink::mojom::ViewportStyleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AutoplayPolicy>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::AutoplayPolicy value) {
  return std::move(context).WriteString(::blink::mojom::AutoplayPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::EffectiveConnectionType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::EffectiveConnectionType value) {
  return std::move(context).WriteString(::blink::mojom::EffectiveConnectionTypeToString(value));
}

} // namespace perfetto
