// third_party/blink/public/mojom/worker/shared_worker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/worker/shared_worker.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char SharedWorker::Name_[] = "blink.mojom.SharedWorker";

SharedWorkerProxy::SharedWorkerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedWorkerProxy::Connect(
    int32_t in_connection_id, ::blink::MessagePortDescriptor in_message_port) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorker::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection_id"), in_connection_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message_port"), in_message_port, 
                        "<value of type ::blink::MessagePortDescriptor>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSharedWorker_Connect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorker_Connect_Params_Data> params(
          message);
  params.Allocate();
  params->connection_id = in_connection_id;
  mojo::internal::MessageFragment<
      typename decltype(params->message_port)::BaseType> message_port_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MessagePortDescriptorDataView>(
      in_message_port, message_port_fragment);
  params->message_port.Set(
      message_port_fragment.is_null() ? nullptr : message_port_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message_port.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message_port in SharedWorker.Connect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorker::Name_);
  message.set_method_name("Connect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerProxy::Terminate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SharedWorker::Terminate");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSharedWorker_Terminate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorker_Terminate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorker::Name_);
  message.set_method_name("Terminate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SharedWorkerStubDispatch::Accept(
    SharedWorker* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSharedWorker_Connect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorker::Connect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorker::Connect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorker_Connect_Params_Data* params =
          reinterpret_cast<internal::SharedWorker_Connect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_connection_id{};
      ::blink::MessagePortDescriptor p_message_port{};
      SharedWorker_Connect_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_connection_id = input_data_view.connection_id();
      if (success && !input_data_view.ReadMessagePort(&p_message_port))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorker::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(
std::move(p_connection_id), 
std::move(p_message_port));
      return true;
    }
    case internal::kSharedWorker_Terminate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorker::Terminate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorker::Terminate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorker_Terminate_Params_Data* params =
          reinterpret_cast<internal::SharedWorker_Terminate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SharedWorker_Terminate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorker::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Terminate();
      return true;
    }
  }
  return false;
}

// static
bool SharedWorkerStubDispatch::AcceptWithResponder(
    SharedWorker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSharedWorker_Connect_Name: {
      break;
    }
    case internal::kSharedWorker_Terminate_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSharedWorkerValidationInfo[] = {
    {internal::kSharedWorker_Connect_Name,
     {&internal::SharedWorker_Connect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSharedWorker_Terminate_Name,
     {&internal::SharedWorker_Terminate_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SharedWorkerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SharedWorker::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSharedWorkerValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif