// ui/accessibility/ax_enums.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/accessibility/ax_enums.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/ax_enums.mojom-params-data.h"
namespace ax {
namespace mojom {

std::string EventToString(Event value) {
  switch(value) {
    case Event::kNone:
      return "Event::kNone";
    case Event::kActiveDescendantChanged:
      return "Event::kActiveDescendantChanged";
    case Event::kAlert:
      return "Event::kAlert";
    case Event::kAriaAttributeChanged:
      return "Event::kAriaAttributeChanged";
    case Event::kAutocorrectionOccured:
      return "Event::kAutocorrectionOccured";
    case Event::kBlur:
      return "Event::kBlur";
    case Event::kCheckedStateChanged:
      return "Event::kCheckedStateChanged";
    case Event::kChildrenChanged:
      return "Event::kChildrenChanged";
    case Event::kClicked:
      return "Event::kClicked";
    case Event::kControlsChanged:
      return "Event::kControlsChanged";
    case Event::kDocumentSelectionChanged:
      return "Event::kDocumentSelectionChanged";
    case Event::kDocumentTitleChanged:
      return "Event::kDocumentTitleChanged";
    case Event::kEndOfTest:
      return "Event::kEndOfTest";
    case Event::kExpandedChanged:
      return "Event::kExpandedChanged";
    case Event::kFocus:
      return "Event::kFocus";
    case Event::kFocusAfterMenuClose:
      return "Event::kFocusAfterMenuClose";
    case Event::kFocusContext:
      return "Event::kFocusContext";
    case Event::kHide:
      return "Event::kHide";
    case Event::kHitTestResult:
      return "Event::kHitTestResult";
    case Event::kHover:
      return "Event::kHover";
    case Event::kImageFrameUpdated:
      return "Event::kImageFrameUpdated";
    case Event::kLayoutComplete:
      return "Event::kLayoutComplete";
    case Event::kLiveRegionCreated:
      return "Event::kLiveRegionCreated";
    case Event::kLiveRegionChanged:
      return "Event::kLiveRegionChanged";
    case Event::kLoadComplete:
      return "Event::kLoadComplete";
    case Event::kLoadStart:
      return "Event::kLoadStart";
    case Event::kLocationChanged:
      return "Event::kLocationChanged";
    case Event::kMediaStartedPlaying:
      return "Event::kMediaStartedPlaying";
    case Event::kMediaStoppedPlaying:
      return "Event::kMediaStoppedPlaying";
    case Event::kMenuEnd:
      return "Event::kMenuEnd";
    case Event::kMenuListValueChanged:
      return "Event::kMenuListValueChanged";
    case Event::kMenuPopupEnd:
      return "Event::kMenuPopupEnd";
    case Event::kMenuPopupStart:
      return "Event::kMenuPopupStart";
    case Event::kMenuStart:
      return "Event::kMenuStart";
    case Event::kMouseCanceled:
      return "Event::kMouseCanceled";
    case Event::kMouseDragged:
      return "Event::kMouseDragged";
    case Event::kMouseMoved:
      return "Event::kMouseMoved";
    case Event::kMousePressed:
      return "Event::kMousePressed";
    case Event::kMouseReleased:
      return "Event::kMouseReleased";
    case Event::kRowCollapsed:
      return "Event::kRowCollapsed";
    case Event::kRowCountChanged:
      return "Event::kRowCountChanged";
    case Event::kRowExpanded:
      return "Event::kRowExpanded";
    case Event::kScrollPositionChanged:
      return "Event::kScrollPositionChanged";
    case Event::kScrolledToAnchor:
      return "Event::kScrolledToAnchor";
    case Event::kSelectedChildrenChanged:
      return "Event::kSelectedChildrenChanged";
    case Event::kSelection:
      return "Event::kSelection";
    case Event::kSelectionAdd:
      return "Event::kSelectionAdd";
    case Event::kSelectionRemove:
      return "Event::kSelectionRemove";
    case Event::kShow:
      return "Event::kShow";
    case Event::kStateChanged:
      return "Event::kStateChanged";
    case Event::kTextChanged:
      return "Event::kTextChanged";
    case Event::kTextSelectionChanged:
      return "Event::kTextSelectionChanged";
    case Event::kTooltipClosed:
      return "Event::kTooltipClosed";
    case Event::kTooltipOpened:
      return "Event::kTooltipOpened";
    case Event::kTreeChanged:
      return "Event::kTreeChanged";
    case Event::kValueChanged:
      return "Event::kValueChanged";
    case Event::kWindowActivated:
      return "Event::kWindowActivated";
    case Event::kWindowDeactivated:
      return "Event::kWindowDeactivated";
    case Event::kWindowVisibilityChanged:
      return "Event::kWindowVisibilityChanged";
    default:
      return base::StringPrintf("Unknown Event value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Event value) {
  return os << EventToString(value);
}

std::string RoleToString(Role value) {
  switch(value) {
    case Role::kNone:
      return "Role::kNone";
    case Role::kAbbr:
      return "Role::kAbbr";
    case Role::kAlert:
      return "Role::kAlert";
    case Role::kAlertDialog:
      return "Role::kAlertDialog";
    case Role::kAnchor:
      return "Role::kAnchor";
    case Role::kApplication:
      return "Role::kApplication";
    case Role::kArticle:
      return "Role::kArticle";
    case Role::kAudio:
      return "Role::kAudio";
    case Role::kBanner:
      return "Role::kBanner";
    case Role::kBlockquote:
      return "Role::kBlockquote";
    case Role::kButton:
      return "Role::kButton";
    case Role::kCanvas:
      return "Role::kCanvas";
    case Role::kCaption:
      return "Role::kCaption";
    case Role::kCaret:
      return "Role::kCaret";
    case Role::kCell:
      return "Role::kCell";
    case Role::kCheckBox:
      return "Role::kCheckBox";
    case Role::kClient:
      return "Role::kClient";
    case Role::kCode:
      return "Role::kCode";
    case Role::kColorWell:
      return "Role::kColorWell";
    case Role::kColumn:
      return "Role::kColumn";
    case Role::kColumnHeader:
      return "Role::kColumnHeader";
    case Role::kComboBoxGrouping:
      return "Role::kComboBoxGrouping";
    case Role::kComboBoxMenuButton:
      return "Role::kComboBoxMenuButton";
    case Role::kComplementary:
      return "Role::kComplementary";
    case Role::kComment:
      return "Role::kComment";
    case Role::kContentDeletion:
      return "Role::kContentDeletion";
    case Role::kContentInsertion:
      return "Role::kContentInsertion";
    case Role::kContentInfo:
      return "Role::kContentInfo";
    case Role::kDate:
      return "Role::kDate";
    case Role::kDateTime:
      return "Role::kDateTime";
    case Role::kDefinition:
      return "Role::kDefinition";
    case Role::kDescriptionList:
      return "Role::kDescriptionList";
    case Role::kDescriptionListDetail:
      return "Role::kDescriptionListDetail";
    case Role::kDescriptionListTerm:
      return "Role::kDescriptionListTerm";
    case Role::kDesktop:
      return "Role::kDesktop";
    case Role::kDetails:
      return "Role::kDetails";
    case Role::kDialog:
      return "Role::kDialog";
    case Role::kDirectory:
      return "Role::kDirectory";
    case Role::kDisclosureTriangle:
      return "Role::kDisclosureTriangle";
    case Role::kDocAbstract:
      return "Role::kDocAbstract";
    case Role::kDocAcknowledgments:
      return "Role::kDocAcknowledgments";
    case Role::kDocAfterword:
      return "Role::kDocAfterword";
    case Role::kDocAppendix:
      return "Role::kDocAppendix";
    case Role::kDocBackLink:
      return "Role::kDocBackLink";
    case Role::kDocBiblioEntry:
      return "Role::kDocBiblioEntry";
    case Role::kDocBibliography:
      return "Role::kDocBibliography";
    case Role::kDocBiblioRef:
      return "Role::kDocBiblioRef";
    case Role::kDocChapter:
      return "Role::kDocChapter";
    case Role::kDocColophon:
      return "Role::kDocColophon";
    case Role::kDocConclusion:
      return "Role::kDocConclusion";
    case Role::kDocCover:
      return "Role::kDocCover";
    case Role::kDocCredit:
      return "Role::kDocCredit";
    case Role::kDocCredits:
      return "Role::kDocCredits";
    case Role::kDocDedication:
      return "Role::kDocDedication";
    case Role::kDocEndnote:
      return "Role::kDocEndnote";
    case Role::kDocEndnotes:
      return "Role::kDocEndnotes";
    case Role::kDocEpigraph:
      return "Role::kDocEpigraph";
    case Role::kDocEpilogue:
      return "Role::kDocEpilogue";
    case Role::kDocErrata:
      return "Role::kDocErrata";
    case Role::kDocExample:
      return "Role::kDocExample";
    case Role::kDocFootnote:
      return "Role::kDocFootnote";
    case Role::kDocForeword:
      return "Role::kDocForeword";
    case Role::kDocGlossary:
      return "Role::kDocGlossary";
    case Role::kDocGlossRef:
      return "Role::kDocGlossRef";
    case Role::kDocIndex:
      return "Role::kDocIndex";
    case Role::kDocIntroduction:
      return "Role::kDocIntroduction";
    case Role::kDocNoteRef:
      return "Role::kDocNoteRef";
    case Role::kDocNotice:
      return "Role::kDocNotice";
    case Role::kDocPageBreak:
      return "Role::kDocPageBreak";
    case Role::kDocPageFooter:
      return "Role::kDocPageFooter";
    case Role::kDocPageHeader:
      return "Role::kDocPageHeader";
    case Role::kDocPageList:
      return "Role::kDocPageList";
    case Role::kDocPart:
      return "Role::kDocPart";
    case Role::kDocPreface:
      return "Role::kDocPreface";
    case Role::kDocPrologue:
      return "Role::kDocPrologue";
    case Role::kDocPullquote:
      return "Role::kDocPullquote";
    case Role::kDocQna:
      return "Role::kDocQna";
    case Role::kDocSubtitle:
      return "Role::kDocSubtitle";
    case Role::kDocTip:
      return "Role::kDocTip";
    case Role::kDocToc:
      return "Role::kDocToc";
    case Role::kDocument:
      return "Role::kDocument";
    case Role::kEmbeddedObject:
      return "Role::kEmbeddedObject";
    case Role::kEmphasis:
      return "Role::kEmphasis";
    case Role::kFeed:
      return "Role::kFeed";
    case Role::kFigcaption:
      return "Role::kFigcaption";
    case Role::kFigure:
      return "Role::kFigure";
    case Role::kFooter:
      return "Role::kFooter";
    case Role::kFooterAsNonLandmark:
      return "Role::kFooterAsNonLandmark";
    case Role::kForm:
      return "Role::kForm";
    case Role::kGenericContainer:
      return "Role::kGenericContainer";
    case Role::kGraphicsDocument:
      return "Role::kGraphicsDocument";
    case Role::kGraphicsObject:
      return "Role::kGraphicsObject";
    case Role::kGraphicsSymbol:
      return "Role::kGraphicsSymbol";
    case Role::kGrid:
      return "Role::kGrid";
    case Role::kGroup:
      return "Role::kGroup";
    case Role::kHeader:
      return "Role::kHeader";
    case Role::kHeaderAsNonLandmark:
      return "Role::kHeaderAsNonLandmark";
    case Role::kHeading:
      return "Role::kHeading";
    case Role::kIframe:
      return "Role::kIframe";
    case Role::kIframePresentational:
      return "Role::kIframePresentational";
    case Role::kIgnored:
      return "Role::kIgnored";
    case Role::kImage:
      return "Role::kImage";
    case Role::kImageMap:
      return "Role::kImageMap";
    case Role::kImeCandidate:
      return "Role::kImeCandidate";
    case Role::kInlineTextBox:
      return "Role::kInlineTextBox";
    case Role::kInputTime:
      return "Role::kInputTime";
    case Role::kKeyboard:
      return "Role::kKeyboard";
    case Role::kLabelText:
      return "Role::kLabelText";
    case Role::kLayoutTable:
      return "Role::kLayoutTable";
    case Role::kLayoutTableCell:
      return "Role::kLayoutTableCell";
    case Role::kLayoutTableRow:
      return "Role::kLayoutTableRow";
    case Role::kLegend:
      return "Role::kLegend";
    case Role::kLineBreak:
      return "Role::kLineBreak";
    case Role::kLink:
      return "Role::kLink";
    case Role::kList:
      return "Role::kList";
    case Role::kListBox:
      return "Role::kListBox";
    case Role::kListBoxOption:
      return "Role::kListBoxOption";
    case Role::kListGrid:
      return "Role::kListGrid";
    case Role::kListItem:
      return "Role::kListItem";
    case Role::kListMarker:
      return "Role::kListMarker";
    case Role::kLog:
      return "Role::kLog";
    case Role::kMain:
      return "Role::kMain";
    case Role::kMark:
      return "Role::kMark";
    case Role::kMarquee:
      return "Role::kMarquee";
    case Role::kMath:
      return "Role::kMath";
    case Role::kMenu:
      return "Role::kMenu";
    case Role::kMenuBar:
      return "Role::kMenuBar";
    case Role::kMenuItem:
      return "Role::kMenuItem";
    case Role::kMenuItemCheckBox:
      return "Role::kMenuItemCheckBox";
    case Role::kMenuItemRadio:
      return "Role::kMenuItemRadio";
    case Role::kMenuListOption:
      return "Role::kMenuListOption";
    case Role::kMenuListPopup:
      return "Role::kMenuListPopup";
    case Role::kMeter:
      return "Role::kMeter";
    case Role::kNavigation:
      return "Role::kNavigation";
    case Role::kNote:
      return "Role::kNote";
    case Role::kPane:
      return "Role::kPane";
    case Role::kParagraph:
      return "Role::kParagraph";
    case Role::kPdfActionableHighlight:
      return "Role::kPdfActionableHighlight";
    case Role::kPdfRoot:
      return "Role::kPdfRoot";
    case Role::kPluginObject:
      return "Role::kPluginObject";
    case Role::kPopUpButton:
      return "Role::kPopUpButton";
    case Role::kPortal:
      return "Role::kPortal";
    case Role::kPre:
      return "Role::kPre";
    case Role::kPresentational:
      return "Role::kPresentational";
    case Role::kProgressIndicator:
      return "Role::kProgressIndicator";
    case Role::kRadioButton:
      return "Role::kRadioButton";
    case Role::kRadioGroup:
      return "Role::kRadioGroup";
    case Role::kRegion:
      return "Role::kRegion";
    case Role::kRootWebArea:
      return "Role::kRootWebArea";
    case Role::kRow:
      return "Role::kRow";
    case Role::kRowGroup:
      return "Role::kRowGroup";
    case Role::kRowHeader:
      return "Role::kRowHeader";
    case Role::kRuby:
      return "Role::kRuby";
    case Role::kRubyAnnotation:
      return "Role::kRubyAnnotation";
    case Role::kScrollBar:
      return "Role::kScrollBar";
    case Role::kScrollView:
      return "Role::kScrollView";
    case Role::kSearch:
      return "Role::kSearch";
    case Role::kSearchBox:
      return "Role::kSearchBox";
    case Role::kSection:
      return "Role::kSection";
    case Role::kSlider:
      return "Role::kSlider";
    case Role::kSpinButton:
      return "Role::kSpinButton";
    case Role::kSplitter:
      return "Role::kSplitter";
    case Role::kStaticText:
      return "Role::kStaticText";
    case Role::kStatus:
      return "Role::kStatus";
    case Role::kStrong:
      return "Role::kStrong";
    case Role::kSuggestion:
      return "Role::kSuggestion";
    case Role::kSvgRoot:
      return "Role::kSvgRoot";
    case Role::kSwitch:
      return "Role::kSwitch";
    case Role::kTab:
      return "Role::kTab";
    case Role::kTabList:
      return "Role::kTabList";
    case Role::kTabPanel:
      return "Role::kTabPanel";
    case Role::kTable:
      return "Role::kTable";
    case Role::kTableHeaderContainer:
      return "Role::kTableHeaderContainer";
    case Role::kTerm:
      return "Role::kTerm";
    case Role::kTextField:
      return "Role::kTextField";
    case Role::kTextFieldWithComboBox:
      return "Role::kTextFieldWithComboBox";
    case Role::kTime:
      return "Role::kTime";
    case Role::kTimer:
      return "Role::kTimer";
    case Role::kTitleBar:
      return "Role::kTitleBar";
    case Role::kToggleButton:
      return "Role::kToggleButton";
    case Role::kToolbar:
      return "Role::kToolbar";
    case Role::kTooltip:
      return "Role::kTooltip";
    case Role::kTree:
      return "Role::kTree";
    case Role::kTreeGrid:
      return "Role::kTreeGrid";
    case Role::kTreeItem:
      return "Role::kTreeItem";
    case Role::kUnknown:
      return "Role::kUnknown";
    case Role::kVideo:
      return "Role::kVideo";
    case Role::kWebView:
      return "Role::kWebView";
    case Role::kWindow:
      return "Role::kWindow";
    default:
      return base::StringPrintf("Unknown Role value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Role value) {
  return os << RoleToString(value);
}

std::string StateToString(State value) {
  switch(value) {
    case State::kNone:
      return "State::kNone";
    case State::kAutofillAvailable:
      return "State::kAutofillAvailable";
    case State::kCollapsed:
      return "State::kCollapsed";
    case State::kDefault:
      return "State::kDefault";
    case State::kEditable:
      return "State::kEditable";
    case State::kExpanded:
      return "State::kExpanded";
    case State::kFocusable:
      return "State::kFocusable";
    case State::kHorizontal:
      return "State::kHorizontal";
    case State::kHovered:
      return "State::kHovered";
    case State::kIgnored:
      return "State::kIgnored";
    case State::kInvisible:
      return "State::kInvisible";
    case State::kLinked:
      return "State::kLinked";
    case State::kMultiline:
      return "State::kMultiline";
    case State::kMultiselectable:
      return "State::kMultiselectable";
    case State::kProtected:
      return "State::kProtected";
    case State::kRequired:
      return "State::kRequired";
    case State::kRichlyEditable:
      return "State::kRichlyEditable";
    case State::kVertical:
      return "State::kVertical";
    case State::kVisited:
      return "State::kVisited";
    default:
      return base::StringPrintf("Unknown State value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, State value) {
  return os << StateToString(value);
}

std::string ActionToString(Action value) {
  switch(value) {
    case Action::kNone:
      return "Action::kNone";
    case Action::kAnnotatePageImages:
      return "Action::kAnnotatePageImages";
    case Action::kBlur:
      return "Action::kBlur";
    case Action::kClearAccessibilityFocus:
      return "Action::kClearAccessibilityFocus";
    case Action::kCollapse:
      return "Action::kCollapse";
    case Action::kCustomAction:
      return "Action::kCustomAction";
    case Action::kDecrement:
      return "Action::kDecrement";
    case Action::kDoDefault:
      return "Action::kDoDefault";
    case Action::kExpand:
      return "Action::kExpand";
    case Action::kFocus:
      return "Action::kFocus";
    case Action::kGetImageData:
      return "Action::kGetImageData";
    case Action::kGetTextLocation:
      return "Action::kGetTextLocation";
    case Action::kHideTooltip:
      return "Action::kHideTooltip";
    case Action::kHitTest:
      return "Action::kHitTest";
    case Action::kIncrement:
      return "Action::kIncrement";
    case Action::kInternalInvalidateTree:
      return "Action::kInternalInvalidateTree";
    case Action::kLoadInlineTextBoxes:
      return "Action::kLoadInlineTextBoxes";
    case Action::kReplaceSelectedText:
      return "Action::kReplaceSelectedText";
    case Action::kScrollBackward:
      return "Action::kScrollBackward";
    case Action::kScrollDown:
      return "Action::kScrollDown";
    case Action::kScrollForward:
      return "Action::kScrollForward";
    case Action::kScrollLeft:
      return "Action::kScrollLeft";
    case Action::kScrollRight:
      return "Action::kScrollRight";
    case Action::kScrollUp:
      return "Action::kScrollUp";
    case Action::kScrollToMakeVisible:
      return "Action::kScrollToMakeVisible";
    case Action::kScrollToPoint:
      return "Action::kScrollToPoint";
    case Action::kSetAccessibilityFocus:
      return "Action::kSetAccessibilityFocus";
    case Action::kSetScrollOffset:
      return "Action::kSetScrollOffset";
    case Action::kSetSelection:
      return "Action::kSetSelection";
    case Action::kSetSequentialFocusNavigationStartingPoint:
      return "Action::kSetSequentialFocusNavigationStartingPoint";
    case Action::kSetValue:
      return "Action::kSetValue";
    case Action::kShowContextMenu:
      return "Action::kShowContextMenu";
    case Action::kSignalEndOfTest:
      return "Action::kSignalEndOfTest";
    case Action::kShowTooltip:
      return "Action::kShowTooltip";
    default:
      return base::StringPrintf("Unknown Action value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Action value) {
  return os << ActionToString(value);
}

std::string ActionFlagsToString(ActionFlags value) {
  switch(value) {
    case ActionFlags::kNone:
      return "ActionFlags::kNone";
    case ActionFlags::kRequestImages:
      return "ActionFlags::kRequestImages";
    case ActionFlags::kRequestInlineTextBoxes:
      return "ActionFlags::kRequestInlineTextBoxes";
    default:
      return base::StringPrintf("Unknown ActionFlags value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ActionFlags value) {
  return os << ActionFlagsToString(value);
}

std::string ScrollAlignmentToString(ScrollAlignment value) {
  switch(value) {
    case ScrollAlignment::kNone:
      return "ScrollAlignment::kNone";
    case ScrollAlignment::kScrollAlignmentCenter:
      return "ScrollAlignment::kScrollAlignmentCenter";
    case ScrollAlignment::kScrollAlignmentTop:
      return "ScrollAlignment::kScrollAlignmentTop";
    case ScrollAlignment::kScrollAlignmentBottom:
      return "ScrollAlignment::kScrollAlignmentBottom";
    case ScrollAlignment::kScrollAlignmentLeft:
      return "ScrollAlignment::kScrollAlignmentLeft";
    case ScrollAlignment::kScrollAlignmentRight:
      return "ScrollAlignment::kScrollAlignmentRight";
    case ScrollAlignment::kScrollAlignmentClosestEdge:
      return "ScrollAlignment::kScrollAlignmentClosestEdge";
    default:
      return base::StringPrintf("Unknown ScrollAlignment value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ScrollAlignment value) {
  return os << ScrollAlignmentToString(value);
}

std::string ScrollBehaviorToString(ScrollBehavior value) {
  switch(value) {
    case ScrollBehavior::kNone:
      return "ScrollBehavior::kNone";
    case ScrollBehavior::kDoNotScrollIfVisible:
      return "ScrollBehavior::kDoNotScrollIfVisible";
    case ScrollBehavior::kScrollIfVisible:
      return "ScrollBehavior::kScrollIfVisible";
    default:
      return base::StringPrintf("Unknown ScrollBehavior value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ScrollBehavior value) {
  return os << ScrollBehaviorToString(value);
}

std::string DefaultActionVerbToString(DefaultActionVerb value) {
  switch(value) {
    case DefaultActionVerb::kNone:
      return "DefaultActionVerb::kNone";
    case DefaultActionVerb::kActivate:
      return "DefaultActionVerb::kActivate";
    case DefaultActionVerb::kCheck:
      return "DefaultActionVerb::kCheck";
    case DefaultActionVerb::kClick:
      return "DefaultActionVerb::kClick";
    case DefaultActionVerb::kClickAncestor:
      return "DefaultActionVerb::kClickAncestor";
    case DefaultActionVerb::kJump:
      return "DefaultActionVerb::kJump";
    case DefaultActionVerb::kOpen:
      return "DefaultActionVerb::kOpen";
    case DefaultActionVerb::kPress:
      return "DefaultActionVerb::kPress";
    case DefaultActionVerb::kSelect:
      return "DefaultActionVerb::kSelect";
    case DefaultActionVerb::kUncheck:
      return "DefaultActionVerb::kUncheck";
    default:
      return base::StringPrintf("Unknown DefaultActionVerb value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DefaultActionVerb value) {
  return os << DefaultActionVerbToString(value);
}

std::string MutationToString(Mutation value) {
  switch(value) {
    case Mutation::kNone:
      return "Mutation::kNone";
    case Mutation::kNodeCreated:
      return "Mutation::kNodeCreated";
    case Mutation::kSubtreeCreated:
      return "Mutation::kSubtreeCreated";
    case Mutation::kNodeChanged:
      return "Mutation::kNodeChanged";
    case Mutation::kNodeRemoved:
      return "Mutation::kNodeRemoved";
    default:
      return base::StringPrintf("Unknown Mutation value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Mutation value) {
  return os << MutationToString(value);
}

std::string StringAttributeToString(StringAttribute value) {
  switch(value) {
    case StringAttribute::kNone:
      return "StringAttribute::kNone";
    case StringAttribute::kAccessKey:
      return "StringAttribute::kAccessKey";
    case StringAttribute::kAriaInvalidValue:
      return "StringAttribute::kAriaInvalidValue";
    case StringAttribute::kAutoComplete:
      return "StringAttribute::kAutoComplete";
    case StringAttribute::kCheckedStateDescription:
      return "StringAttribute::kCheckedStateDescription";
    case StringAttribute::kChildTreeId:
      return "StringAttribute::kChildTreeId";
    case StringAttribute::kClassName:
      return "StringAttribute::kClassName";
    case StringAttribute::kContainerLiveRelevant:
      return "StringAttribute::kContainerLiveRelevant";
    case StringAttribute::kContainerLiveStatus:
      return "StringAttribute::kContainerLiveStatus";
    case StringAttribute::kDescription:
      return "StringAttribute::kDescription";
    case StringAttribute::kDisplay:
      return "StringAttribute::kDisplay";
    case StringAttribute::kFontFamily:
      return "StringAttribute::kFontFamily";
    case StringAttribute::kHtmlTag:
      return "StringAttribute::kHtmlTag";
    case StringAttribute::kImageAnnotation:
      return "StringAttribute::kImageAnnotation";
    case StringAttribute::kImageDataUrl:
      return "StringAttribute::kImageDataUrl";
    case StringAttribute::kInnerHtml:
      return "StringAttribute::kInnerHtml";
    case StringAttribute::kInputType:
      return "StringAttribute::kInputType";
    case StringAttribute::kKeyShortcuts:
      return "StringAttribute::kKeyShortcuts";
    case StringAttribute::kLanguage:
      return "StringAttribute::kLanguage";
    case StringAttribute::kName:
      return "StringAttribute::kName";
    case StringAttribute::kLiveRelevant:
      return "StringAttribute::kLiveRelevant";
    case StringAttribute::kLiveStatus:
      return "StringAttribute::kLiveStatus";
    case StringAttribute::kPlaceholder:
      return "StringAttribute::kPlaceholder";
    case StringAttribute::kRole:
      return "StringAttribute::kRole";
    case StringAttribute::kRoleDescription:
      return "StringAttribute::kRoleDescription";
    case StringAttribute::kTooltip:
      return "StringAttribute::kTooltip";
    case StringAttribute::kUrl:
      return "StringAttribute::kUrl";
    case StringAttribute::kValue:
      return "StringAttribute::kValue";
    case StringAttribute::kVirtualContent:
      return "StringAttribute::kVirtualContent";
    default:
      return base::StringPrintf("Unknown StringAttribute value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, StringAttribute value) {
  return os << StringAttributeToString(value);
}

std::string IntAttributeToString(IntAttribute value) {
  switch(value) {
    case IntAttribute::kNone:
      return "IntAttribute::kNone";
    case IntAttribute::kDefaultActionVerb:
      return "IntAttribute::kDefaultActionVerb";
    case IntAttribute::kScrollX:
      return "IntAttribute::kScrollX";
    case IntAttribute::kScrollXMin:
      return "IntAttribute::kScrollXMin";
    case IntAttribute::kScrollXMax:
      return "IntAttribute::kScrollXMax";
    case IntAttribute::kScrollY:
      return "IntAttribute::kScrollY";
    case IntAttribute::kScrollYMin:
      return "IntAttribute::kScrollYMin";
    case IntAttribute::kScrollYMax:
      return "IntAttribute::kScrollYMax";
    case IntAttribute::kTextSelStart:
      return "IntAttribute::kTextSelStart";
    case IntAttribute::kTextSelEnd:
      return "IntAttribute::kTextSelEnd";
    case IntAttribute::kAriaColumnCount:
      return "IntAttribute::kAriaColumnCount";
    case IntAttribute::kAriaCellColumnIndex:
      return "IntAttribute::kAriaCellColumnIndex";
    case IntAttribute::kAriaCellColumnSpan:
      return "IntAttribute::kAriaCellColumnSpan";
    case IntAttribute::kAriaRowCount:
      return "IntAttribute::kAriaRowCount";
    case IntAttribute::kAriaCellRowIndex:
      return "IntAttribute::kAriaCellRowIndex";
    case IntAttribute::kAriaCellRowSpan:
      return "IntAttribute::kAriaCellRowSpan";
    case IntAttribute::kTableRowCount:
      return "IntAttribute::kTableRowCount";
    case IntAttribute::kTableColumnCount:
      return "IntAttribute::kTableColumnCount";
    case IntAttribute::kTableHeaderId:
      return "IntAttribute::kTableHeaderId";
    case IntAttribute::kTableRowIndex:
      return "IntAttribute::kTableRowIndex";
    case IntAttribute::kTableRowHeaderId:
      return "IntAttribute::kTableRowHeaderId";
    case IntAttribute::kTableColumnIndex:
      return "IntAttribute::kTableColumnIndex";
    case IntAttribute::kTableColumnHeaderId:
      return "IntAttribute::kTableColumnHeaderId";
    case IntAttribute::kTableCellColumnIndex:
      return "IntAttribute::kTableCellColumnIndex";
    case IntAttribute::kTableCellColumnSpan:
      return "IntAttribute::kTableCellColumnSpan";
    case IntAttribute::kTableCellRowIndex:
      return "IntAttribute::kTableCellRowIndex";
    case IntAttribute::kTableCellRowSpan:
      return "IntAttribute::kTableCellRowSpan";
    case IntAttribute::kSortDirection:
      return "IntAttribute::kSortDirection";
    case IntAttribute::kHierarchicalLevel:
      return "IntAttribute::kHierarchicalLevel";
    case IntAttribute::kNameFrom:
      return "IntAttribute::kNameFrom";
    case IntAttribute::kDescriptionFrom:
      return "IntAttribute::kDescriptionFrom";
    case IntAttribute::kActivedescendantId:
      return "IntAttribute::kActivedescendantId";
    case IntAttribute::kErrormessageId:
      return "IntAttribute::kErrormessageId";
    case IntAttribute::kInPageLinkTargetId:
      return "IntAttribute::kInPageLinkTargetId";
    case IntAttribute::kMemberOfId:
      return "IntAttribute::kMemberOfId";
    case IntAttribute::kNextOnLineId:
      return "IntAttribute::kNextOnLineId";
    case IntAttribute::kPopupForId:
      return "IntAttribute::kPopupForId";
    case IntAttribute::kPreviousOnLineId:
      return "IntAttribute::kPreviousOnLineId";
    case IntAttribute::kRestriction:
      return "IntAttribute::kRestriction";
    case IntAttribute::kSetSize:
      return "IntAttribute::kSetSize";
    case IntAttribute::kPosInSet:
      return "IntAttribute::kPosInSet";
    case IntAttribute::kColorValue:
      return "IntAttribute::kColorValue";
    case IntAttribute::kAriaCurrentState:
      return "IntAttribute::kAriaCurrentState";
    case IntAttribute::kBackgroundColor:
      return "IntAttribute::kBackgroundColor";
    case IntAttribute::kColor:
      return "IntAttribute::kColor";
    case IntAttribute::kHasPopup:
      return "IntAttribute::kHasPopup";
    case IntAttribute::kImageAnnotationStatus:
      return "IntAttribute::kImageAnnotationStatus";
    case IntAttribute::kInvalidState:
      return "IntAttribute::kInvalidState";
    case IntAttribute::kCheckedState:
      return "IntAttribute::kCheckedState";
    case IntAttribute::kListStyle:
      return "IntAttribute::kListStyle";
    case IntAttribute::kTextAlign:
      return "IntAttribute::kTextAlign";
    case IntAttribute::kTextDirection:
      return "IntAttribute::kTextDirection";
    case IntAttribute::kTextPosition:
      return "IntAttribute::kTextPosition";
    case IntAttribute::kTextStyle:
      return "IntAttribute::kTextStyle";
    case IntAttribute::kTextOverlineStyle:
      return "IntAttribute::kTextOverlineStyle";
    case IntAttribute::kTextStrikethroughStyle:
      return "IntAttribute::kTextStrikethroughStyle";
    case IntAttribute::kTextUnderlineStyle:
      return "IntAttribute::kTextUnderlineStyle";
    case IntAttribute::kPreviousFocusId:
      return "IntAttribute::kPreviousFocusId";
    case IntAttribute::kNextFocusId:
      return "IntAttribute::kNextFocusId";
    case IntAttribute::kDropeffect:
      return "IntAttribute::kDropeffect";
    case IntAttribute::kDOMNodeId:
      return "IntAttribute::kDOMNodeId";
    default:
      return base::StringPrintf("Unknown IntAttribute value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, IntAttribute value) {
  return os << IntAttributeToString(value);
}

std::string FloatAttributeToString(FloatAttribute value) {
  switch(value) {
    case FloatAttribute::kNone:
      return "FloatAttribute::kNone";
    case FloatAttribute::kValueForRange:
      return "FloatAttribute::kValueForRange";
    case FloatAttribute::kMinValueForRange:
      return "FloatAttribute::kMinValueForRange";
    case FloatAttribute::kMaxValueForRange:
      return "FloatAttribute::kMaxValueForRange";
    case FloatAttribute::kStepValueForRange:
      return "FloatAttribute::kStepValueForRange";
    case FloatAttribute::kFontSize:
      return "FloatAttribute::kFontSize";
    case FloatAttribute::kFontWeight:
      return "FloatAttribute::kFontWeight";
    case FloatAttribute::kTextIndent:
      return "FloatAttribute::kTextIndent";
    default:
      return base::StringPrintf("Unknown FloatAttribute value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FloatAttribute value) {
  return os << FloatAttributeToString(value);
}

std::string BoolAttributeToString(BoolAttribute value) {
  switch(value) {
    case BoolAttribute::kNone:
      return "BoolAttribute::kNone";
    case BoolAttribute::kBusy:
      return "BoolAttribute::kBusy";
    case BoolAttribute::kEditableRoot:
      return "BoolAttribute::kEditableRoot";
    case BoolAttribute::kContainerLiveAtomic:
      return "BoolAttribute::kContainerLiveAtomic";
    case BoolAttribute::kContainerLiveBusy:
      return "BoolAttribute::kContainerLiveBusy";
    case BoolAttribute::kLiveAtomic:
      return "BoolAttribute::kLiveAtomic";
    case BoolAttribute::kModal:
      return "BoolAttribute::kModal";
    case BoolAttribute::kUpdateLocationOnly:
      return "BoolAttribute::kUpdateLocationOnly";
    case BoolAttribute::kCanvasHasFallback:
      return "BoolAttribute::kCanvasHasFallback";
    case BoolAttribute::kScrollable:
      return "BoolAttribute::kScrollable";
    case BoolAttribute::kClickable:
      return "BoolAttribute::kClickable";
    case BoolAttribute::kClipsChildren:
      return "BoolAttribute::kClipsChildren";
    case BoolAttribute::kNotUserSelectableStyle:
      return "BoolAttribute::kNotUserSelectableStyle";
    case BoolAttribute::kSelected:
      return "BoolAttribute::kSelected";
    case BoolAttribute::kSelectedFromFocus:
      return "BoolAttribute::kSelectedFromFocus";
    case BoolAttribute::kSupportsTextLocation:
      return "BoolAttribute::kSupportsTextLocation";
    case BoolAttribute::kGrabbed:
      return "BoolAttribute::kGrabbed";
    case BoolAttribute::kIsLineBreakingObject:
      return "BoolAttribute::kIsLineBreakingObject";
    case BoolAttribute::kIsPageBreakingObject:
      return "BoolAttribute::kIsPageBreakingObject";
    case BoolAttribute::kHasAriaAttribute:
      return "BoolAttribute::kHasAriaAttribute";
    case BoolAttribute::kTouchPassthrough:
      return "BoolAttribute::kTouchPassthrough";
    default:
      return base::StringPrintf("Unknown BoolAttribute value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, BoolAttribute value) {
  return os << BoolAttributeToString(value);
}

std::string IntListAttributeToString(IntListAttribute value) {
  switch(value) {
    case IntListAttribute::kNone:
      return "IntListAttribute::kNone";
    case IntListAttribute::kIndirectChildIds:
      return "IntListAttribute::kIndirectChildIds";
    case IntListAttribute::kControlsIds:
      return "IntListAttribute::kControlsIds";
    case IntListAttribute::kDetailsIds:
      return "IntListAttribute::kDetailsIds";
    case IntListAttribute::kDescribedbyIds:
      return "IntListAttribute::kDescribedbyIds";
    case IntListAttribute::kFlowtoIds:
      return "IntListAttribute::kFlowtoIds";
    case IntListAttribute::kLabelledbyIds:
      return "IntListAttribute::kLabelledbyIds";
    case IntListAttribute::kRadioGroupIds:
      return "IntListAttribute::kRadioGroupIds";
    case IntListAttribute::kMarkerTypes:
      return "IntListAttribute::kMarkerTypes";
    case IntListAttribute::kMarkerStarts:
      return "IntListAttribute::kMarkerStarts";
    case IntListAttribute::kMarkerEnds:
      return "IntListAttribute::kMarkerEnds";
    case IntListAttribute::kCharacterOffsets:
      return "IntListAttribute::kCharacterOffsets";
    case IntListAttribute::kCachedLineStarts:
      return "IntListAttribute::kCachedLineStarts";
    case IntListAttribute::kWordStarts:
      return "IntListAttribute::kWordStarts";
    case IntListAttribute::kWordEnds:
      return "IntListAttribute::kWordEnds";
    case IntListAttribute::kCustomActionIds:
      return "IntListAttribute::kCustomActionIds";
    default:
      return base::StringPrintf("Unknown IntListAttribute value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, IntListAttribute value) {
  return os << IntListAttributeToString(value);
}

std::string StringListAttributeToString(StringListAttribute value) {
  switch(value) {
    case StringListAttribute::kNone:
      return "StringListAttribute::kNone";
    case StringListAttribute::kCustomActionDescriptions:
      return "StringListAttribute::kCustomActionDescriptions";
    default:
      return base::StringPrintf("Unknown StringListAttribute value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, StringListAttribute value) {
  return os << StringListAttributeToString(value);
}

std::string ListStyleToString(ListStyle value) {
  switch(value) {
    case ListStyle::kNone:
      return "ListStyle::kNone";
    case ListStyle::kCircle:
      return "ListStyle::kCircle";
    case ListStyle::kDisc:
      return "ListStyle::kDisc";
    case ListStyle::kImage:
      return "ListStyle::kImage";
    case ListStyle::kNumeric:
      return "ListStyle::kNumeric";
    case ListStyle::kSquare:
      return "ListStyle::kSquare";
    case ListStyle::kOther:
      return "ListStyle::kOther";
    default:
      return base::StringPrintf("Unknown ListStyle value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ListStyle value) {
  return os << ListStyleToString(value);
}

std::string MarkerTypeToString(MarkerType value) {
  switch(value) {
    case MarkerType::kNone:
      return "MarkerType::kNone";
    case MarkerType::kSpelling:
      return "MarkerType::kSpelling";
    case MarkerType::kGrammar:
      return "MarkerType::kGrammar";
    case MarkerType::kTextMatch:
      return "MarkerType::kTextMatch";
    case MarkerType::kActiveSuggestion:
      return "MarkerType::kActiveSuggestion";
    case MarkerType::kSuggestion:
      return "MarkerType::kSuggestion";
    default:
      return base::StringPrintf("Unknown MarkerType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MarkerType value) {
  return os << MarkerTypeToString(value);
}

std::string MoveDirectionToString(MoveDirection value) {
  switch(value) {
    case MoveDirection::kNone:
      return "MoveDirection::kNone";
    case MoveDirection::kBackward:
      return "MoveDirection::kBackward";
    case MoveDirection::kForward:
      return "MoveDirection::kForward";
    default:
      return base::StringPrintf("Unknown MoveDirection value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MoveDirection value) {
  return os << MoveDirectionToString(value);
}

std::string CommandToString(Command value) {
  switch(value) {
    case Command::kNone:
      return "Command::kNone";
    case Command::kClearSelection:
      return "Command::kClearSelection";
    case Command::kDelete:
      return "Command::kDelete";
    case Command::kDictate:
      return "Command::kDictate";
    case Command::kExtendSelection:
      return "Command::kExtendSelection";
    case Command::kFormat:
      return "Command::kFormat";
    case Command::kHistory:
      return "Command::kHistory";
    case Command::kInsert:
      return "Command::kInsert";
    case Command::kMarker:
      return "Command::kMarker";
    case Command::kMoveSelection:
      return "Command::kMoveSelection";
    case Command::kSetSelection:
      return "Command::kSetSelection";
    default:
      return base::StringPrintf("Unknown Command value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Command value) {
  return os << CommandToString(value);
}

std::string InputEventTypeToString(InputEventType value) {
  switch(value) {
    case InputEventType::kNone:
      return "InputEventType::kNone";
    case InputEventType::kInsertText:
      return "InputEventType::kInsertText";
    case InputEventType::kInsertLineBreak:
      return "InputEventType::kInsertLineBreak";
    case InputEventType::kInsertParagraph:
      return "InputEventType::kInsertParagraph";
    case InputEventType::kInsertOrderedList:
      return "InputEventType::kInsertOrderedList";
    case InputEventType::kInsertUnorderedList:
      return "InputEventType::kInsertUnorderedList";
    case InputEventType::kInsertHorizontalRule:
      return "InputEventType::kInsertHorizontalRule";
    case InputEventType::kInsertFromPaste:
      return "InputEventType::kInsertFromPaste";
    case InputEventType::kInsertFromDrop:
      return "InputEventType::kInsertFromDrop";
    case InputEventType::kInsertFromYank:
      return "InputEventType::kInsertFromYank";
    case InputEventType::kInsertTranspose:
      return "InputEventType::kInsertTranspose";
    case InputEventType::kInsertReplacementText:
      return "InputEventType::kInsertReplacementText";
    case InputEventType::kInsertCompositionText:
      return "InputEventType::kInsertCompositionText";
    case InputEventType::kDeleteWordBackward:
      return "InputEventType::kDeleteWordBackward";
    case InputEventType::kDeleteWordForward:
      return "InputEventType::kDeleteWordForward";
    case InputEventType::kDeleteSoftLineBackward:
      return "InputEventType::kDeleteSoftLineBackward";
    case InputEventType::kDeleteSoftLineForward:
      return "InputEventType::kDeleteSoftLineForward";
    case InputEventType::kDeleteHardLineBackward:
      return "InputEventType::kDeleteHardLineBackward";
    case InputEventType::kDeleteHardLineForward:
      return "InputEventType::kDeleteHardLineForward";
    case InputEventType::kDeleteContentBackward:
      return "InputEventType::kDeleteContentBackward";
    case InputEventType::kDeleteContentForward:
      return "InputEventType::kDeleteContentForward";
    case InputEventType::kDeleteByCut:
      return "InputEventType::kDeleteByCut";
    case InputEventType::kDeleteByDrag:
      return "InputEventType::kDeleteByDrag";
    case InputEventType::kHistoryUndo:
      return "InputEventType::kHistoryUndo";
    case InputEventType::kHistoryRedo:
      return "InputEventType::kHistoryRedo";
    case InputEventType::kFormatBold:
      return "InputEventType::kFormatBold";
    case InputEventType::kFormatItalic:
      return "InputEventType::kFormatItalic";
    case InputEventType::kFormatUnderline:
      return "InputEventType::kFormatUnderline";
    case InputEventType::kFormatStrikeThrough:
      return "InputEventType::kFormatStrikeThrough";
    case InputEventType::kFormatSuperscript:
      return "InputEventType::kFormatSuperscript";
    case InputEventType::kFormatSubscript:
      return "InputEventType::kFormatSubscript";
    case InputEventType::kFormatJustifyCenter:
      return "InputEventType::kFormatJustifyCenter";
    case InputEventType::kFormatJustifyFull:
      return "InputEventType::kFormatJustifyFull";
    case InputEventType::kFormatJustifyRight:
      return "InputEventType::kFormatJustifyRight";
    case InputEventType::kFormatJustifyLeft:
      return "InputEventType::kFormatJustifyLeft";
    case InputEventType::kFormatIndent:
      return "InputEventType::kFormatIndent";
    case InputEventType::kFormatOutdent:
      return "InputEventType::kFormatOutdent";
    case InputEventType::kFormatRemove:
      return "InputEventType::kFormatRemove";
    case InputEventType::kFormatSetBlockTextDirection:
      return "InputEventType::kFormatSetBlockTextDirection";
    default:
      return base::StringPrintf("Unknown InputEventType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, InputEventType value) {
  return os << InputEventTypeToString(value);
}

std::string TextBoundaryToString(TextBoundary value) {
  switch(value) {
    case TextBoundary::kNone:
      return "TextBoundary::kNone";
    case TextBoundary::kCharacter:
      return "TextBoundary::kCharacter";
    case TextBoundary::kFormat:
      return "TextBoundary::kFormat";
    case TextBoundary::kLineEnd:
      return "TextBoundary::kLineEnd";
    case TextBoundary::kLineStart:
      return "TextBoundary::kLineStart";
    case TextBoundary::kLineStartOrEnd:
      return "TextBoundary::kLineStartOrEnd";
    case TextBoundary::kObject:
      return "TextBoundary::kObject";
    case TextBoundary::kPageEnd:
      return "TextBoundary::kPageEnd";
    case TextBoundary::kPageStart:
      return "TextBoundary::kPageStart";
    case TextBoundary::kPageStartOrEnd:
      return "TextBoundary::kPageStartOrEnd";
    case TextBoundary::kParagraphEnd:
      return "TextBoundary::kParagraphEnd";
    case TextBoundary::kParagraphStart:
      return "TextBoundary::kParagraphStart";
    case TextBoundary::kParagraphStartOrEnd:
      return "TextBoundary::kParagraphStartOrEnd";
    case TextBoundary::kSentenceEnd:
      return "TextBoundary::kSentenceEnd";
    case TextBoundary::kSentenceStart:
      return "TextBoundary::kSentenceStart";
    case TextBoundary::kSentenceStartOrEnd:
      return "TextBoundary::kSentenceStartOrEnd";
    case TextBoundary::kWebPage:
      return "TextBoundary::kWebPage";
    case TextBoundary::kWordEnd:
      return "TextBoundary::kWordEnd";
    case TextBoundary::kWordStart:
      return "TextBoundary::kWordStart";
    case TextBoundary::kWordStartOrEnd:
      return "TextBoundary::kWordStartOrEnd";
    default:
      return base::StringPrintf("Unknown TextBoundary value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TextBoundary value) {
  return os << TextBoundaryToString(value);
}

std::string TextAlignToString(TextAlign value) {
  switch(value) {
    case TextAlign::kNone:
      return "TextAlign::kNone";
    case TextAlign::kLeft:
      return "TextAlign::kLeft";
    case TextAlign::kRight:
      return "TextAlign::kRight";
    case TextAlign::kCenter:
      return "TextAlign::kCenter";
    case TextAlign::kJustify:
      return "TextAlign::kJustify";
    default:
      return base::StringPrintf("Unknown TextAlign value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TextAlign value) {
  return os << TextAlignToString(value);
}

std::string WritingDirectionToString(WritingDirection value) {
  switch(value) {
    case WritingDirection::kNone:
      return "WritingDirection::kNone";
    case WritingDirection::kLtr:
      return "WritingDirection::kLtr";
    case WritingDirection::kRtl:
      return "WritingDirection::kRtl";
    case WritingDirection::kTtb:
      return "WritingDirection::kTtb";
    case WritingDirection::kBtt:
      return "WritingDirection::kBtt";
    default:
      return base::StringPrintf("Unknown WritingDirection value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, WritingDirection value) {
  return os << WritingDirectionToString(value);
}

std::string TextPositionToString(TextPosition value) {
  switch(value) {
    case TextPosition::kNone:
      return "TextPosition::kNone";
    case TextPosition::kSubscript:
      return "TextPosition::kSubscript";
    case TextPosition::kSuperscript:
      return "TextPosition::kSuperscript";
    default:
      return base::StringPrintf("Unknown TextPosition value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TextPosition value) {
  return os << TextPositionToString(value);
}

std::string TextStyleToString(TextStyle value) {
  switch(value) {
    case TextStyle::kBold:
      return "TextStyle::kBold";
    case TextStyle::kItalic:
      return "TextStyle::kItalic";
    case TextStyle::kUnderline:
      return "TextStyle::kUnderline";
    case TextStyle::kLineThrough:
      return "TextStyle::kLineThrough";
    case TextStyle::kOverline:
      return "TextStyle::kOverline";
    case TextStyle::kNone:
      return "TextStyle::kNone";
    default:
      return base::StringPrintf("Unknown TextStyle value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TextStyle value) {
  return os << TextStyleToString(value);
}

std::string TextDecorationStyleToString(TextDecorationStyle value) {
  switch(value) {
    case TextDecorationStyle::kNone:
      return "TextDecorationStyle::kNone";
    case TextDecorationStyle::kDotted:
      return "TextDecorationStyle::kDotted";
    case TextDecorationStyle::kDashed:
      return "TextDecorationStyle::kDashed";
    case TextDecorationStyle::kSolid:
      return "TextDecorationStyle::kSolid";
    case TextDecorationStyle::kDouble:
      return "TextDecorationStyle::kDouble";
    case TextDecorationStyle::kWavy:
      return "TextDecorationStyle::kWavy";
    default:
      return base::StringPrintf("Unknown TextDecorationStyle value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TextDecorationStyle value) {
  return os << TextDecorationStyleToString(value);
}

std::string AriaCurrentStateToString(AriaCurrentState value) {
  switch(value) {
    case AriaCurrentState::kNone:
      return "AriaCurrentState::kNone";
    case AriaCurrentState::kFalse:
      return "AriaCurrentState::kFalse";
    case AriaCurrentState::kTrue:
      return "AriaCurrentState::kTrue";
    case AriaCurrentState::kPage:
      return "AriaCurrentState::kPage";
    case AriaCurrentState::kStep:
      return "AriaCurrentState::kStep";
    case AriaCurrentState::kLocation:
      return "AriaCurrentState::kLocation";
    case AriaCurrentState::kDate:
      return "AriaCurrentState::kDate";
    case AriaCurrentState::kTime:
      return "AriaCurrentState::kTime";
    default:
      return base::StringPrintf("Unknown AriaCurrentState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, AriaCurrentState value) {
  return os << AriaCurrentStateToString(value);
}

std::string HasPopupToString(HasPopup value) {
  switch(value) {
    case HasPopup::kFalse:
      return "HasPopup::{kFalse, kNone}";
    case HasPopup::kTrue:
      return "HasPopup::kTrue";
    case HasPopup::kMenu:
      return "HasPopup::kMenu";
    case HasPopup::kListbox:
      return "HasPopup::kListbox";
    case HasPopup::kTree:
      return "HasPopup::kTree";
    case HasPopup::kGrid:
      return "HasPopup::kGrid";
    case HasPopup::kDialog:
      return "HasPopup::kDialog";
    default:
      return base::StringPrintf("Unknown HasPopup value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, HasPopup value) {
  return os << HasPopupToString(value);
}

std::string InvalidStateToString(InvalidState value) {
  switch(value) {
    case InvalidState::kNone:
      return "InvalidState::kNone";
    case InvalidState::kFalse:
      return "InvalidState::kFalse";
    case InvalidState::kTrue:
      return "InvalidState::kTrue";
    case InvalidState::kOther:
      return "InvalidState::kOther";
    default:
      return base::StringPrintf("Unknown InvalidState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, InvalidState value) {
  return os << InvalidStateToString(value);
}

std::string RestrictionToString(Restriction value) {
  switch(value) {
    case Restriction::kNone:
      return "Restriction::kNone";
    case Restriction::kReadOnly:
      return "Restriction::kReadOnly";
    case Restriction::kDisabled:
      return "Restriction::kDisabled";
    default:
      return base::StringPrintf("Unknown Restriction value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Restriction value) {
  return os << RestrictionToString(value);
}

std::string CheckedStateToString(CheckedState value) {
  switch(value) {
    case CheckedState::kNone:
      return "CheckedState::kNone";
    case CheckedState::kFalse:
      return "CheckedState::kFalse";
    case CheckedState::kTrue:
      return "CheckedState::kTrue";
    case CheckedState::kMixed:
      return "CheckedState::kMixed";
    default:
      return base::StringPrintf("Unknown CheckedState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CheckedState value) {
  return os << CheckedStateToString(value);
}

std::string SortDirectionToString(SortDirection value) {
  switch(value) {
    case SortDirection::kNone:
      return "SortDirection::kNone";
    case SortDirection::kUnsorted:
      return "SortDirection::kUnsorted";
    case SortDirection::kAscending:
      return "SortDirection::kAscending";
    case SortDirection::kDescending:
      return "SortDirection::kDescending";
    case SortDirection::kOther:
      return "SortDirection::kOther";
    default:
      return base::StringPrintf("Unknown SortDirection value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SortDirection value) {
  return os << SortDirectionToString(value);
}

std::string NameFromToString(NameFrom value) {
  switch(value) {
    case NameFrom::kNone:
      return "NameFrom::kNone";
    case NameFrom::kUninitialized:
      return "NameFrom::kUninitialized";
    case NameFrom::kAttribute:
      return "NameFrom::kAttribute";
    case NameFrom::kAttributeExplicitlyEmpty:
      return "NameFrom::kAttributeExplicitlyEmpty";
    case NameFrom::kCaption:
      return "NameFrom::kCaption";
    case NameFrom::kContents:
      return "NameFrom::kContents";
    case NameFrom::kPlaceholder:
      return "NameFrom::kPlaceholder";
    case NameFrom::kRelatedElement:
      return "NameFrom::kRelatedElement";
    case NameFrom::kTitle:
      return "NameFrom::kTitle";
    case NameFrom::kValue:
      return "NameFrom::kValue";
    default:
      return base::StringPrintf("Unknown NameFrom value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, NameFrom value) {
  return os << NameFromToString(value);
}

std::string DescriptionFromToString(DescriptionFrom value) {
  switch(value) {
    case DescriptionFrom::kNone:
      return "DescriptionFrom::kNone";
    case DescriptionFrom::kUninitialized:
      return "DescriptionFrom::kUninitialized";
    case DescriptionFrom::kAttribute:
      return "DescriptionFrom::kAttribute";
    case DescriptionFrom::kContents:
      return "DescriptionFrom::kContents";
    case DescriptionFrom::kRelatedElement:
      return "DescriptionFrom::kRelatedElement";
    case DescriptionFrom::kTitle:
      return "DescriptionFrom::kTitle";
    default:
      return base::StringPrintf("Unknown DescriptionFrom value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DescriptionFrom value) {
  return os << DescriptionFromToString(value);
}

std::string EventFromToString(EventFrom value) {
  switch(value) {
    case EventFrom::kNone:
      return "EventFrom::kNone";
    case EventFrom::kUser:
      return "EventFrom::kUser";
    case EventFrom::kPage:
      return "EventFrom::kPage";
    case EventFrom::kAction:
      return "EventFrom::kAction";
    default:
      return base::StringPrintf("Unknown EventFrom value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, EventFrom value) {
  return os << EventFromToString(value);
}

std::string GestureToString(Gesture value) {
  switch(value) {
    case Gesture::kNone:
      return "Gesture::kNone";
    case Gesture::kClick:
      return "Gesture::kClick";
    case Gesture::kSwipeLeft1:
      return "Gesture::kSwipeLeft1";
    case Gesture::kSwipeUp1:
      return "Gesture::kSwipeUp1";
    case Gesture::kSwipeRight1:
      return "Gesture::kSwipeRight1";
    case Gesture::kSwipeDown1:
      return "Gesture::kSwipeDown1";
    case Gesture::kSwipeLeft2:
      return "Gesture::kSwipeLeft2";
    case Gesture::kSwipeUp2:
      return "Gesture::kSwipeUp2";
    case Gesture::kSwipeRight2:
      return "Gesture::kSwipeRight2";
    case Gesture::kSwipeDown2:
      return "Gesture::kSwipeDown2";
    case Gesture::kSwipeLeft3:
      return "Gesture::kSwipeLeft3";
    case Gesture::kSwipeUp3:
      return "Gesture::kSwipeUp3";
    case Gesture::kSwipeRight3:
      return "Gesture::kSwipeRight3";
    case Gesture::kSwipeDown3:
      return "Gesture::kSwipeDown3";
    case Gesture::kSwipeLeft4:
      return "Gesture::kSwipeLeft4";
    case Gesture::kSwipeUp4:
      return "Gesture::kSwipeUp4";
    case Gesture::kSwipeRight4:
      return "Gesture::kSwipeRight4";
    case Gesture::kSwipeDown4:
      return "Gesture::kSwipeDown4";
    case Gesture::kTap2:
      return "Gesture::kTap2";
    case Gesture::kTap3:
      return "Gesture::kTap3";
    case Gesture::kTap4:
      return "Gesture::kTap4";
    case Gesture::kTouchExplore:
      return "Gesture::kTouchExplore";
    default:
      return base::StringPrintf("Unknown Gesture value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Gesture value) {
  return os << GestureToString(value);
}

std::string TextAffinityToString(TextAffinity value) {
  switch(value) {
    case TextAffinity::kNone:
      return "TextAffinity::kNone";
    case TextAffinity::kDownstream:
      return "TextAffinity::kDownstream";
    case TextAffinity::kUpstream:
      return "TextAffinity::kUpstream";
    default:
      return base::StringPrintf("Unknown TextAffinity value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TextAffinity value) {
  return os << TextAffinityToString(value);
}

std::string TreeOrderToString(TreeOrder value) {
  switch(value) {
    case TreeOrder::kNone:
      return "TreeOrder::kNone";
    case TreeOrder::kUndefined:
      return "TreeOrder::kUndefined";
    case TreeOrder::kBefore:
      return "TreeOrder::kBefore";
    case TreeOrder::kEqual:
      return "TreeOrder::kEqual";
    case TreeOrder::kAfter:
      return "TreeOrder::kAfter";
    default:
      return base::StringPrintf("Unknown TreeOrder value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TreeOrder value) {
  return os << TreeOrderToString(value);
}

std::string AXTreeIDTypeToString(AXTreeIDType value) {
  switch(value) {
    case AXTreeIDType::kUnknown:
      return "AXTreeIDType::kUnknown";
    case AXTreeIDType::kToken:
      return "AXTreeIDType::kToken";
    default:
      return base::StringPrintf("Unknown AXTreeIDType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, AXTreeIDType value) {
  return os << AXTreeIDTypeToString(value);
}

std::string ImageAnnotationStatusToString(ImageAnnotationStatus value) {
  switch(value) {
    case ImageAnnotationStatus::kNone:
      return "ImageAnnotationStatus::kNone";
    case ImageAnnotationStatus::kWillNotAnnotateDueToScheme:
      return "ImageAnnotationStatus::kWillNotAnnotateDueToScheme";
    case ImageAnnotationStatus::kIneligibleForAnnotation:
      return "ImageAnnotationStatus::kIneligibleForAnnotation";
    case ImageAnnotationStatus::kEligibleForAnnotation:
      return "ImageAnnotationStatus::kEligibleForAnnotation";
    case ImageAnnotationStatus::kSilentlyEligibleForAnnotation:
      return "ImageAnnotationStatus::kSilentlyEligibleForAnnotation";
    case ImageAnnotationStatus::kAnnotationPending:
      return "ImageAnnotationStatus::kAnnotationPending";
    case ImageAnnotationStatus::kAnnotationSucceeded:
      return "ImageAnnotationStatus::kAnnotationSucceeded";
    case ImageAnnotationStatus::kAnnotationEmpty:
      return "ImageAnnotationStatus::kAnnotationEmpty";
    case ImageAnnotationStatus::kAnnotationAdult:
      return "ImageAnnotationStatus::kAnnotationAdult";
    case ImageAnnotationStatus::kAnnotationProcessFailed:
      return "ImageAnnotationStatus::kAnnotationProcessFailed";
    default:
      return base::StringPrintf("Unknown ImageAnnotationStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ImageAnnotationStatus value) {
  return os << ImageAnnotationStatusToString(value);
}

std::string DropeffectToString(Dropeffect value) {
  switch(value) {
    case Dropeffect::kNone:
      return "Dropeffect::kNone";
    case Dropeffect::kCopy:
      return "Dropeffect::kCopy";
    case Dropeffect::kExecute:
      return "Dropeffect::kExecute";
    case Dropeffect::kLink:
      return "Dropeffect::kLink";
    case Dropeffect::kMove:
      return "Dropeffect::kMove";
    case Dropeffect::kPopup:
      return "Dropeffect::kPopup";
    default:
      return base::StringPrintf("Unknown Dropeffect value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Dropeffect value) {
  return os << DropeffectToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ax

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Event>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::Event value) {
  return std::move(context).WriteString(::ax::mojom::EventToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Role>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::Role value) {
  return std::move(context).WriteString(::ax::mojom::RoleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::State>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::State value) {
  return std::move(context).WriteString(::ax::mojom::StateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Action>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::Action value) {
  return std::move(context).WriteString(::ax::mojom::ActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::ActionFlags>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::ActionFlags value) {
  return std::move(context).WriteString(::ax::mojom::ActionFlagsToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::ScrollAlignment>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::ScrollAlignment value) {
  return std::move(context).WriteString(::ax::mojom::ScrollAlignmentToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::ScrollBehavior>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::ScrollBehavior value) {
  return std::move(context).WriteString(::ax::mojom::ScrollBehaviorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::DefaultActionVerb>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::DefaultActionVerb value) {
  return std::move(context).WriteString(::ax::mojom::DefaultActionVerbToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Mutation>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::Mutation value) {
  return std::move(context).WriteString(::ax::mojom::MutationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::StringAttribute>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::StringAttribute value) {
  return std::move(context).WriteString(::ax::mojom::StringAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::IntAttribute>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::IntAttribute value) {
  return std::move(context).WriteString(::ax::mojom::IntAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::FloatAttribute>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::FloatAttribute value) {
  return std::move(context).WriteString(::ax::mojom::FloatAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::BoolAttribute>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::BoolAttribute value) {
  return std::move(context).WriteString(::ax::mojom::BoolAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::IntListAttribute>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::IntListAttribute value) {
  return std::move(context).WriteString(::ax::mojom::IntListAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::StringListAttribute>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::StringListAttribute value) {
  return std::move(context).WriteString(::ax::mojom::StringListAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::ListStyle>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::ListStyle value) {
  return std::move(context).WriteString(::ax::mojom::ListStyleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::MarkerType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::MarkerType value) {
  return std::move(context).WriteString(::ax::mojom::MarkerTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::MoveDirection>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::MoveDirection value) {
  return std::move(context).WriteString(::ax::mojom::MoveDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Command>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::Command value) {
  return std::move(context).WriteString(::ax::mojom::CommandToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::InputEventType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::InputEventType value) {
  return std::move(context).WriteString(::ax::mojom::InputEventTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextBoundary>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::TextBoundary value) {
  return std::move(context).WriteString(::ax::mojom::TextBoundaryToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextAlign>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::TextAlign value) {
  return std::move(context).WriteString(::ax::mojom::TextAlignToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::WritingDirection>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::WritingDirection value) {
  return std::move(context).WriteString(::ax::mojom::WritingDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextPosition>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::TextPosition value) {
  return std::move(context).WriteString(::ax::mojom::TextPositionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextStyle>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::TextStyle value) {
  return std::move(context).WriteString(::ax::mojom::TextStyleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextDecorationStyle>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::TextDecorationStyle value) {
  return std::move(context).WriteString(::ax::mojom::TextDecorationStyleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::AriaCurrentState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::AriaCurrentState value) {
  return std::move(context).WriteString(::ax::mojom::AriaCurrentStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::HasPopup>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::HasPopup value) {
  return std::move(context).WriteString(::ax::mojom::HasPopupToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::InvalidState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::InvalidState value) {
  return std::move(context).WriteString(::ax::mojom::InvalidStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Restriction>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::Restriction value) {
  return std::move(context).WriteString(::ax::mojom::RestrictionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::CheckedState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::CheckedState value) {
  return std::move(context).WriteString(::ax::mojom::CheckedStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::SortDirection>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::SortDirection value) {
  return std::move(context).WriteString(::ax::mojom::SortDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::NameFrom>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::NameFrom value) {
  return std::move(context).WriteString(::ax::mojom::NameFromToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::DescriptionFrom>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::DescriptionFrom value) {
  return std::move(context).WriteString(::ax::mojom::DescriptionFromToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::EventFrom>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::EventFrom value) {
  return std::move(context).WriteString(::ax::mojom::EventFromToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Gesture>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::Gesture value) {
  return std::move(context).WriteString(::ax::mojom::GestureToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextAffinity>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::TextAffinity value) {
  return std::move(context).WriteString(::ax::mojom::TextAffinityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TreeOrder>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::TreeOrder value) {
  return std::move(context).WriteString(::ax::mojom::TreeOrderToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::AXTreeIDType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::AXTreeIDType value) {
  return std::move(context).WriteString(::ax::mojom::AXTreeIDTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::ImageAnnotationStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::ImageAnnotationStatus value) {
  return std::move(context).WriteString(::ax::mojom::ImageAnnotationStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Dropeffect>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ax::mojom::Dropeffect value) {
  return std::move(context).WriteString(::ax::mojom::DropeffectToString(value));
}

} // namespace perfetto
