// ui/accessibility/mojom/ax_action_data.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/accessibility/mojom/ax_action_data.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_action_data.mojom-params-data.h"
namespace ax {
namespace mojom {

namespace internal {


// static
bool AXActionData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AXActionData_Data* object = static_cast<const AXActionData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::ax::mojom::internal::Action_Data
        ::Validate(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->target_tree_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->target_tree_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_extension_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams source_extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->source_extension_id, validation_context,
                                         &source_extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_rect, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_point, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_point, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 14, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }


  if (!::ax::mojom::internal::Event_Data
        ::Validate(object->hit_test_event_to_fire, validation_context))
    return false;


  if (!::ax::mojom::internal::ScrollAlignment_Data
        ::Validate(object->horizontal_scroll_alignment, validation_context))
    return false;


  if (!::ax::mojom::internal::ScrollAlignment_Data
        ::Validate(object->vertical_scroll_alignment, validation_context))
    return false;


  if (!::ax::mojom::internal::ScrollBehavior_Data
        ::Validate(object->scroll_behavior, validation_context))
    return false;

  return true;
}

AXActionData_Data::AXActionData_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ax
