// ui/accessibility/mojom/ax_assistant_structure.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/accessibility/mojom/ax_assistant_structure.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_assistant_structure.mojom-params-data.h"
namespace ax {
namespace mojom {

namespace internal {


// static
bool AssistantTree_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AssistantTree_Data* object = static_cast<const AssistantTree_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nodes, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams nodes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->nodes, validation_context,
                                         &nodes_validate_params)) {
    return false;
  }

  return true;
}

AssistantTree_Data::AssistantTree_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AssistantNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AssistantNode_Data* object = static_cast<const AssistantNode_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->children_indices, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams children_indices_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->children_indices, validation_context,
                                         &children_indices_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->selection, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->class_name, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams class_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->class_name, validation_context,
                                         &class_name_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams role_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->role, validation_context,
                                         &role_validate_params)) {
    return false;
  }

  return true;
}

AssistantNode_Data::AssistantNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AssistantExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AssistantExtra_Data* object = static_cast<const AssistantExtra_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds_pixel, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds_pixel, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  return true;
}

AssistantExtra_Data::AssistantExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AssistantStructure_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AssistantStructure_Data* object = static_cast<const AssistantStructure_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->assistant_tree, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->assistant_extra, validation_context))
    return false;

  return true;
}

AssistantStructure_Data::AssistantStructure_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ax
