// ui/accessibility/mojom/ax_assistant_structure.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_assistant_structure.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/accessibility/mojom/ax_assistant_structure.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_assistant_structure.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_assistant_structure.mojom-import-headers.h"


#ifndef UI_ACCESSIBILITY_MOJOM_AX_ASSISTANT_STRUCTURE_MOJOM_JUMBO_H_
#define UI_ACCESSIBILITY_MOJOM_AX_ASSISTANT_STRUCTURE_MOJOM_JUMBO_H_
#endif
namespace ax {
namespace mojom {
AssistantTree::AssistantTree()
    : nodes() {}

AssistantTree::AssistantTree(
    std::vector<::std::unique_ptr<::ui::AssistantNode>> nodes_in)
    : nodes(std::move(nodes_in)) {}

AssistantTree::~AssistantTree() = default;

void AssistantTree::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nodes"), this->nodes, 
      "<value of type std::vector<::std::unique_ptr<::ui::AssistantNode>>>");
}

bool AssistantTree::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AssistantNode::AssistantNode()
    : children_indices(),
      rect(),
      text(),
      text_size(),
      color(),
      bgcolor(),
      bold(),
      italic(),
      underline(),
      line_through(),
      selection(),
      class_name(),
      role() {}

AssistantNode::AssistantNode(
    std::vector<int32_t> children_indices_in,
    const ::gfx::Rect& rect_in,
    const ::base::string16& text_in,
    float text_size_in,
    uint32_t color_in,
    uint32_t bgcolor_in,
    bool bold_in,
    bool italic_in,
    bool underline_in,
    bool line_through_in,
    const base::Optional<::gfx::Range>& selection_in,
    const std::string& class_name_in,
    const base::Optional<std::string>& role_in)
    : children_indices(std::move(children_indices_in)),
      rect(std::move(rect_in)),
      text(std::move(text_in)),
      text_size(std::move(text_size_in)),
      color(std::move(color_in)),
      bgcolor(std::move(bgcolor_in)),
      bold(std::move(bold_in)),
      italic(std::move(italic_in)),
      underline(std::move(underline_in)),
      line_through(std::move(line_through_in)),
      selection(std::move(selection_in)),
      class_name(std::move(class_name_in)),
      role(std::move(role_in)) {}

AssistantNode::~AssistantNode() = default;

void AssistantNode::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children_indices"), this->children_indices, 
      "<value of type const std::vector<int32_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect"), this->rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_size"), this->text_size, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bgcolor"), this->bgcolor, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bold"), this->bold, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "italic"), this->italic, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "underline"), this->underline, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "line_through"), this->line_through, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection"), this->selection, 
      "<value of type const base::Optional<::gfx::Range>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "class_name"), this->class_name, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "role"), this->role, 
      "<value of type const base::Optional<std::string>&>");
}

bool AssistantNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AssistantExtra::AssistantExtra()
    : url(),
      bounds_pixel(),
      title() {}

AssistantExtra::AssistantExtra(
    const ::GURL& url_in,
    const ::gfx::Rect& bounds_pixel_in,
    const ::base::string16& title_in)
    : url(std::move(url_in)),
      bounds_pixel(std::move(bounds_pixel_in)),
      title(std::move(title_in)) {}

AssistantExtra::~AssistantExtra() = default;

void AssistantExtra::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds_pixel"), this->bounds_pixel, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title, 
      "<value of type const ::base::string16&>");
}

bool AssistantExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AssistantStructure::AssistantStructure()
    : assistant_tree(),
      assistant_extra() {}

AssistantStructure::AssistantStructure(
    ::std::unique_ptr<::ui::AssistantTree> assistant_tree_in,
    AssistantExtraPtr assistant_extra_in)
    : assistant_tree(std::move(assistant_tree_in)),
      assistant_extra(std::move(assistant_extra_in)) {}

AssistantStructure::~AssistantStructure() = default;

void AssistantStructure::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "assistant_tree"), this->assistant_tree, 
      "<value of type ::std::unique_ptr<::ui::AssistantTree>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "assistant_extra"), this->assistant_extra, 
      "<value of type AssistantExtraPtr>");
}

bool AssistantStructure::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace ax

namespace mojo {


// static
bool StructTraits<::ax::mojom::AssistantTree::DataView, ::ax::mojom::AssistantTreePtr>::Read(
    ::ax::mojom::AssistantTree::DataView input,
    ::ax::mojom::AssistantTreePtr* output) {
  bool success = true;
  ::ax::mojom::AssistantTreePtr result(::ax::mojom::AssistantTree::New());
  
      if (success && !input.ReadNodes(&result->nodes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ax::mojom::AssistantNode::DataView, ::ax::mojom::AssistantNodePtr>::Read(
    ::ax::mojom::AssistantNode::DataView input,
    ::ax::mojom::AssistantNodePtr* output) {
  bool success = true;
  ::ax::mojom::AssistantNodePtr result(::ax::mojom::AssistantNode::New());
  
      if (success && !input.ReadChildrenIndices(&result->children_indices))
        success = false;
      if (success && !input.ReadRect(&result->rect))
        success = false;
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success)
        result->text_size = input.text_size();
      if (success)
        result->color = input.color();
      if (success)
        result->bgcolor = input.bgcolor();
      if (success)
        result->bold = input.bold();
      if (success)
        result->italic = input.italic();
      if (success)
        result->underline = input.underline();
      if (success)
        result->line_through = input.line_through();
      if (success && !input.ReadSelection(&result->selection))
        success = false;
      if (success && !input.ReadClassName(&result->class_name))
        success = false;
      if (success && !input.ReadRole(&result->role))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ax::mojom::AssistantExtra::DataView, ::ax::mojom::AssistantExtraPtr>::Read(
    ::ax::mojom::AssistantExtra::DataView input,
    ::ax::mojom::AssistantExtraPtr* output) {
  bool success = true;
  ::ax::mojom::AssistantExtraPtr result(::ax::mojom::AssistantExtra::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadBoundsPixel(&result->bounds_pixel))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ax::mojom::AssistantStructure::DataView, ::ax::mojom::AssistantStructurePtr>::Read(
    ::ax::mojom::AssistantStructure::DataView input,
    ::ax::mojom::AssistantStructurePtr* output) {
  bool success = true;
  ::ax::mojom::AssistantStructurePtr result(::ax::mojom::AssistantStructure::New());
  
      if (success && !input.ReadAssistantTree(&result->assistant_tree))
        success = false;
      if (success && !input.ReadAssistantExtra(&result->assistant_extra))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif