// ui/accessibility/mojom/ax_event.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_event.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/accessibility/mojom/ax_event.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_event.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_BLINK_JUMBO_H_
#define UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_BLINK_JUMBO_H_
#endif
namespace ax {
namespace mojom {
namespace blink {
AXEvent::AXEvent()
    : event_type(),
      id(),
      event_from(),
      event_from_action(),
      event_intents(),
      action_request_id() {}

AXEvent::AXEvent(
    ::ax::mojom::blink::Event event_type_in,
    int32_t id_in,
    ::ax::mojom::blink::EventFrom event_from_in,
    ::ax::mojom::blink::Action event_from_action_in,
    WTF::Vector<::ax::mojom::blink::EventIntentPtr> event_intents_in,
    int32_t action_request_id_in)
    : event_type(std::move(event_type_in)),
      id(std::move(id_in)),
      event_from(std::move(event_from_in)),
      event_from_action(std::move(event_from_action_in)),
      event_intents(std::move(event_intents_in)),
      action_request_id(std::move(action_request_id_in)) {}

AXEvent::~AXEvent() = default;

void AXEvent::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_type"), this->event_type, 
      "<value of type ::ax::mojom::blink::Event>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_from"), this->event_from, 
      "<value of type ::ax::mojom::blink::EventFrom>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_from_action"), this->event_from_action, 
      "<value of type ::ax::mojom::blink::Action>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_intents"), this->event_intents, 
      "<value of type WTF::Vector<::ax::mojom::blink::EventIntentPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action_request_id"), this->action_request_id, 
      "<value of type int32_t>");
}

bool AXEvent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace ax

namespace mojo {


// static
bool StructTraits<::ax::mojom::blink::AXEvent::DataView, ::ax::mojom::blink::AXEventPtr>::Read(
    ::ax::mojom::blink::AXEvent::DataView input,
    ::ax::mojom::blink::AXEventPtr* output) {
  bool success = true;
  ::ax::mojom::blink::AXEventPtr result(::ax::mojom::blink::AXEvent::New());
  
      if (success && !input.ReadEventType(&result->event_type))
        success = false;
      if (success)
        result->id = input.id();
      if (success && !input.ReadEventFrom(&result->event_from))
        success = false;
      if (success && !input.ReadEventFromAction(&result->event_from_action))
        success = false;
      if (success && !input.ReadEventIntents(&result->event_intents))
        success = false;
      if (success)
        result->action_request_id = input.action_request_id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif