// ui/accessibility/mojom/ax_node_data.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/accessibility/mojom/ax_node_data.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_node_data.mojom-params-data.h"
namespace ax {
namespace mojom {

namespace internal {


// static
bool AXNodeData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AXNodeData_Data* object = static_cast<const AXNodeData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::ax::mojom::internal::Role_Data
        ::Validate(object->role, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->string_attributes, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams string_attributes_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::StringAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->string_attributes, validation_context,
                                         &string_attributes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->int_attributes, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams int_attributes_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::IntAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->int_attributes, validation_context,
                                         &int_attributes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->float_attributes, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams float_attributes_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::FloatAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->float_attributes, validation_context,
                                         &float_attributes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bool_attributes, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams bool_attributes_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::BoolAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->bool_attributes, validation_context,
                                         &bool_attributes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intlist_attributes, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams intlist_attributes_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::IntListAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->intlist_attributes, validation_context,
                                         &intlist_attributes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stringlist_attributes, 10, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams stringlist_attributes_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::StringListAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr))));
  if (!mojo::internal::ValidateContainer(object->stringlist_attributes, validation_context,
                                         &stringlist_attributes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->html_attributes, 11, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams html_attributes_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->html_attributes, validation_context,
                                         &html_attributes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->child_ids, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams child_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->child_ids, validation_context,
                                         &child_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_bounds, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_bounds, validation_context))
    return false;

  return true;
}

AXNodeData_Data::AXNodeData_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ax
