// ui/accessibility/mojom/ax_node_data.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_node_data.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/accessibility/mojom/ax_node_data.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_node_data.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_node_data.mojom-import-headers.h"


#ifndef UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_JUMBO_H_
#define UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_JUMBO_H_
#endif
namespace ax {
namespace mojom {
AXNodeData::AXNodeData()
    : id(),
      role(),
      state(),
      actions(),
      string_attributes(),
      int_attributes(),
      float_attributes(),
      bool_attributes(),
      intlist_attributes(),
      stringlist_attributes(),
      html_attributes(),
      child_ids(),
      relative_bounds() {}

AXNodeData::AXNodeData(
    int32_t id_in,
    ::ax::mojom::Role role_in,
    uint32_t state_in,
    uint64_t actions_in,
    const base::flat_map<::ax::mojom::StringAttribute, std::string>& string_attributes_in,
    const base::flat_map<::ax::mojom::IntAttribute, int32_t>& int_attributes_in,
    const base::flat_map<::ax::mojom::FloatAttribute, float>& float_attributes_in,
    const base::flat_map<::ax::mojom::BoolAttribute, bool>& bool_attributes_in,
    const base::flat_map<::ax::mojom::IntListAttribute, std::vector<int32_t>>& intlist_attributes_in,
    const base::flat_map<::ax::mojom::StringListAttribute, std::vector<std::string>>& stringlist_attributes_in,
    const base::flat_map<std::string, std::string>& html_attributes_in,
    std::vector<int32_t> child_ids_in,
    const ::ui::AXRelativeBounds& relative_bounds_in)
    : id(std::move(id_in)),
      role(std::move(role_in)),
      state(std::move(state_in)),
      actions(std::move(actions_in)),
      string_attributes(std::move(string_attributes_in)),
      int_attributes(std::move(int_attributes_in)),
      float_attributes(std::move(float_attributes_in)),
      bool_attributes(std::move(bool_attributes_in)),
      intlist_attributes(std::move(intlist_attributes_in)),
      stringlist_attributes(std::move(stringlist_attributes_in)),
      html_attributes(std::move(html_attributes_in)),
      child_ids(std::move(child_ids_in)),
      relative_bounds(std::move(relative_bounds_in)) {}

AXNodeData::~AXNodeData() = default;

void AXNodeData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "role"), this->role, 
      "<value of type ::ax::mojom::Role>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "actions"), this->actions, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "string_attributes"), this->string_attributes, 
      "<value of type const base::flat_map<::ax::mojom::StringAttribute, std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "int_attributes"), this->int_attributes, 
      "<value of type const base::flat_map<::ax::mojom::IntAttribute, int32_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "float_attributes"), this->float_attributes, 
      "<value of type const base::flat_map<::ax::mojom::FloatAttribute, float>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bool_attributes"), this->bool_attributes, 
      "<value of type const base::flat_map<::ax::mojom::BoolAttribute, bool>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "intlist_attributes"), this->intlist_attributes, 
      "<value of type const base::flat_map<::ax::mojom::IntListAttribute, std::vector<int32_t>>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringlist_attributes"), this->stringlist_attributes, 
      "<value of type const base::flat_map<::ax::mojom::StringListAttribute, std::vector<std::string>>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "html_attributes"), this->html_attributes, 
      "<value of type const base::flat_map<std::string, std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "child_ids"), this->child_ids, 
      "<value of type const std::vector<int32_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_bounds"), this->relative_bounds, 
      "<value of type const ::ui::AXRelativeBounds&>");
}

bool AXNodeData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace ax

namespace mojo {


// static
bool StructTraits<::ax::mojom::AXNodeData::DataView, ::ax::mojom::AXNodeDataPtr>::Read(
    ::ax::mojom::AXNodeData::DataView input,
    ::ax::mojom::AXNodeDataPtr* output) {
  bool success = true;
  ::ax::mojom::AXNodeDataPtr result(::ax::mojom::AXNodeData::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadRole(&result->role))
        success = false;
      if (success)
        result->state = input.state();
      if (success)
        result->actions = input.actions();
      if (success && !input.ReadStringAttributes(&result->string_attributes))
        success = false;
      if (success && !input.ReadIntAttributes(&result->int_attributes))
        success = false;
      if (success && !input.ReadFloatAttributes(&result->float_attributes))
        success = false;
      if (success && !input.ReadBoolAttributes(&result->bool_attributes))
        success = false;
      if (success && !input.ReadIntlistAttributes(&result->intlist_attributes))
        success = false;
      if (success && !input.ReadStringlistAttributes(&result->stringlist_attributes))
        success = false;
      if (success && !input.ReadHtmlAttributes(&result->html_attributes))
        success = false;
      if (success && !input.ReadChildIds(&result->child_ids))
        success = false;
      if (success && !input.ReadRelativeBounds(&result->relative_bounds))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif