// ui/accessibility/mojom/ax_tree_data.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/accessibility/mojom/ax_tree_data.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_tree_data.mojom-params-data.h"
namespace ax {
namespace mojom {

namespace internal {


// static
bool AXTreeData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 128, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AXTreeData_Data* object = static_cast<const AXTreeData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->tree_id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->parent_tree_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->parent_tree_id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->focused_tree_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->focused_tree_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->doctype, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams doctype_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->doctype, validation_context,
                                         &doctype_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mimetype, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams mimetype_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mimetype, validation_context,
                                         &mimetype_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams title_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }


  if (!::ax::mojom::internal::TextAffinity_Data
        ::Validate(object->sel_anchor_affinity, validation_context))
    return false;


  if (!::ax::mojom::internal::TextAffinity_Data
        ::Validate(object->sel_focus_affinity, validation_context))
    return false;

  return true;
}

AXTreeData_Data::AXTreeData_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ax
