// ui/accessibility/mojom/ax_tree_update.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_tree_update.mojom-params-data.h"
namespace ax {
namespace mojom {

namespace internal {


// static
bool AXTreeUpdate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AXTreeUpdate_Data* object = static_cast<const AXTreeUpdate_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tree_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tree_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nodes, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams nodes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->nodes, validation_context,
                                         &nodes_validate_params)) {
    return false;
  }


  if (!::ax::mojom::internal::EventFrom_Data
        ::Validate(object->event_from, validation_context))
    return false;


  if (!::ax::mojom::internal::Action_Data
        ::Validate(object->event_from_action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_intents, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_intents_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_intents, validation_context,
                                         &event_intents_validate_params)) {
    return false;
  }

  return true;
}

AXTreeUpdate_Data::AXTreeUpdate_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ax
